/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.runtime;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.xsemantics.runtime.RuleEnvironmentEntry;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RuleEnvironment {
    protected Map<Object, Object> environment = new LinkedHashMap<Object, Object>();
    protected RuleEnvironment next = null;

    public RuleEnvironment(RuleEnvironment e) {
        this.environment = e == null ? new LinkedHashMap<Object, Object>() : new LinkedHashMap<Object, Object>(e.getEnvironment());
    }

    public RuleEnvironment() {
    }

    public RuleEnvironment(RuleEnvironmentEntry environmentEntry) {
        this.add(environmentEntry);
    }

    public RuleEnvironment(RuleEnvironment firstComponent, RuleEnvironment secondComponent) {
        this(firstComponent);
        this.environment.putAll(secondComponent.getEnvironment());
    }

    public Map<Object, Object> getEnvironment() {
        return this.environment;
    }

    public RuleEnvironment getNext() {
        return this.next;
    }

    public void setNext(RuleEnvironment next) {
        this.next = next;
    }

    public void setNext(RuleEnvironmentEntry runtimeEnvironmentEntry) {
        RuleEnvironment next2 = new RuleEnvironment();
        this.setNext(next2);
        next2.add(runtimeEnvironmentEntry);
    }

    public void add(RuleEnvironmentEntry runtimeEnvironmentEntry) {
        this.add(runtimeEnvironmentEntry.getLeft(), runtimeEnvironmentEntry.getRight());
    }

    public boolean add(Object o1, Object o2) {
        return this.add(o1, o2, false);
    }

    public boolean add(Object o1, Object o2, boolean checkExist) {
        if (checkExist && this.environment.containsKey(o1)) {
            return false;
        }
        this.environment.put(o1, o2);
        return true;
    }

    public Object get(Object key) {
        Object object = this.environment.get(key);
        if (object == null && this.next != null) {
            return this.next.get(key);
        }
        return object;
    }

    public void increment(RuleEnvironment ruleEnvironment) {
        if (ruleEnvironment != null) {
            this.environment.putAll(ruleEnvironment.getEnvironment());
        }
    }

    public void increment(RuleEnvironmentEntry runtimeEnvironmentEntry) {
        this.increment(runtimeEnvironmentEntry.getLeft(), runtimeEnvironmentEntry.getRight());
    }

    public void increment(Object o1, Object o2) {
        this.add(o1, o2);
    }

    public void decrement(RuleEnvironment ruleEnvironment) {
        if (ruleEnvironment != null) {
            this.environment.keySet().removeAll(ruleEnvironment.getEnvironment().keySet());
        }
    }

    public void decrement(Object o1) {
        this.environment.remove(o1);
    }

    public boolean union(RuleEnvironment ruleEnvironment) {
        if (ruleEnvironment == null) {
            return true;
        }
        Set<Map.Entry<Object, Object>> entrySet = ruleEnvironment.getEnvironment().entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (this.union(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean union(RuleEnvironmentEntry runtimeEnvironmentEntry) {
        return this.union(runtimeEnvironmentEntry.getLeft(), runtimeEnvironmentEntry.getRight());
    }

    public boolean union(Object o1, Object o2) {
        return this.add(o1, o2, true);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(IterableExtensions.join((Iterable)IterableExtensions.map(this.getEnvironment().entrySet(), (Functions.Function1)new Functions.Function1<Map.Entry<Object, Object>, String>(){

            public String apply(Map.Entry<Object, Object> p) {
                return p.getKey() + " -> " + p.getValue();
            }
        }), (CharSequence)", "));
        if (this.next != null) {
            buffer.append(" :: [");
            buffer.append(this.next.toString());
            buffer.append("]");
        }
        return buffer.toString();
    }

    public boolean isEmpty() {
        return this.environment.isEmpty();
    }

    public int size() {
        return this.environment.size();
    }

    public void clear() {
        this.environment.clear();
    }

    public Set<Object> keySet() {
        return this.environment.keySet();
    }

    public Collection<Object> values() {
        return this.environment.values();
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.environment.entrySet();
    }

    public boolean equals(Object o) {
        if (o instanceof RuleEnvironment) {
            return this.environment.equals(((RuleEnvironment)o).getEnvironment());
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.environment.hashCode();
    }
}

