/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.InfoFilesUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.NewModuleInfoWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewModuleInfoWizard
extends Wizard
implements INewWizard {
    private static final String TRUE = "true";
    private NewModuleInfoWizardPage fPage;
    private static final String MODULE_INFO_JAVA_FILENAME = "module-info.java";
    private IPackageFragmentRoot fTargetPkgFragmentRoot;
    private IPackageFragmentRoot[] fPackageFragmentRoots;
    private IJavaProject fProject;

    public NewModuleInfoWizard(IJavaProject project, IPackageFragmentRoot[] packageFragmentRoots, IPackageFragmentRoot targetPkgFragmentRoot) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWMODULE);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.NewModuleInfoWizard_title);
        this.fProject = project;
        this.fPackageFragmentRoots = packageFragmentRoots;
        if (targetPkgFragmentRoot != null) {
            this.fTargetPkgFragmentRoot = targetPkgFragmentRoot;
        } else if (this.fPackageFragmentRoots != null && this.fPackageFragmentRoots.length > 0) {
            this.fTargetPkgFragmentRoot = this.fPackageFragmentRoots[0];
        }
    }

    public void addPages() {
        super.addPages();
        if (this.fPage == null) {
            this.fPage = new NewModuleInfoWizardPage();
            this.fPage.setWizard((IWizard)this);
            this.fPage.init(this.fProject);
        }
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        IStatus status = this.fPage.getModuleNameStatus();
        int severity = status.getSeverity();
        if ((severity == 0 || severity == 2 || severity == 1) && this.fProject != null && this.fTargetPkgFragmentRoot != null && this.fPackageFragmentRoots != null && this.fPackageFragmentRoots.length > 0) {
            try {
                this.createAndOpenFile(this.fTargetPkgFragmentRoot, this.fPackageFragmentRoots);
                new Job(Messages.format(NewWizardMessages.NewModuleInfoWizard_updateProject_job, this.fProject.getElementName())){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            NewModuleInfoWizard.this.convertClasspathToModulePath(monitor);
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return true;
    }

    private void createAndOpenFile(IPackageFragmentRoot targetPkgFragmentRoot, IPackageFragmentRoot[] packageFragmentRoots) throws CoreException {
        this.createModuleInfoJava(targetPkgFragmentRoot, packageFragmentRoots);
        IFile file = ((IFolder)targetPkgFragmentRoot.getCorrespondingResource()).getFile(MODULE_INFO_JAVA_FILENAME);
        if (file.exists()) {
            BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)JavaPlugin.getActiveWorkbenchWindow());
            this.openFile(file);
        }
    }

    private void openFile(final IFile file) {
        Display display;
        final IWorkbenchPage activePage = JavaPlugin.getActivePage();
        if (activePage != null && (display = this.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        JavaPlugin.log(e);
                    }
                }
            });
        }
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void createModuleInfoJava(IPackageFragmentRoot targetPkgFragmentRoot, IPackageFragmentRoot[] packageFragmentRoots) throws CoreException {
        String fileContent = this.getModuleInfoFileContent(packageFragmentRoots);
        IPackageFragment defaultPkg = targetPkgFragmentRoot.getPackageFragment("");
        InfoFilesUtil.createInfoJavaFile(MODULE_INFO_JAVA_FILENAME, fileContent.toString(), defaultPkg, (IProgressMonitor)new NullProgressMonitor());
    }

    private String getModuleInfoFileContent(IPackageFragmentRoot[] packageFragmentRoots) throws CoreException {
        int n;
        HashSet<String> exportedPackages = new HashSet<String>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots;
        int n2 = packageFragmentRoots.length;
        int n3 = 0;
        while (n3 < n2) {
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n3];
            IJavaElement[] iJavaElementArray = packageFragmentRoot.getChildren();
            int n4 = iJavaElementArray.length;
            n = 0;
            while (n < n4) {
                IPackageFragment pkgFragment;
                IJavaElement child = iJavaElementArray[n];
                if (child instanceof IPackageFragment && !(pkgFragment = (IPackageFragment)child).isDefaultPackage() && pkgFragment.getCompilationUnits().length != 0) {
                    exportedPackages.add(pkgFragment.getElementName());
                }
                ++n;
            }
            ++n3;
        }
        String[] requiredModules = JavaCore.getReferencedModules((IJavaProject)this.fProject);
        String moduleName = this.fPage.getModuleNameText();
        StringBuilder fileContent = new StringBuilder();
        fileContent.append("module ");
        fileContent.append(moduleName);
        fileContent.append(" {");
        for (String exportedPkg : exportedPackages) {
            fileContent.append("exports ");
            fileContent.append(exportedPkg);
            fileContent.append(";");
        }
        String[] stringArray = requiredModules;
        n = requiredModules.length;
        int n5 = 0;
        while (n5 < n) {
            String requiredModule = stringArray[n5];
            fileContent.append("requires ");
            fileContent.append(requiredModule);
            fileContent.append(';');
            ++n5;
        }
        fileContent.append('}');
        return fileContent.toString();
    }

    private void convertClasspathToModulePath(IProgressMonitor monitor) throws JavaModelException {
        boolean changed = false;
        IClasspathEntry[] rawClasspath = this.fProject.getRawClasspath();
        int i = 0;
        while (i < rawClasspath.length) {
            IClasspathEntry entry = rawClasspath[i];
            switch (entry.getEntryKind()) {
                case 1: 
                case 2: {
                    IClasspathAttribute[] newAttributes = this.addModuleAttributeIfNeeded(entry.getExtraAttributes());
                    if (newAttributes == null) break;
                    rawClasspath[i] = this.addAttributes(entry, newAttributes);
                    changed = true;
                }
            }
            ++i;
        }
        if (changed) {
            this.fProject.setRawClasspath(rawClasspath, monitor);
        }
    }

    private IClasspathAttribute[] addModuleAttributeIfNeeded(IClasspathAttribute[] extraAttributes) {
        int j = 0;
        while (j < extraAttributes.length) {
            IClasspathAttribute classpathAttribute = extraAttributes[j];
            if ("module".equals(classpathAttribute.getName())) {
                if (TRUE.equals(classpathAttribute.getValue())) {
                    return null;
                }
                extraAttributes[j] = JavaCore.newClasspathAttribute((String)"module", (String)TRUE);
                return extraAttributes;
            }
            ++j;
        }
        extraAttributes = Arrays.copyOf(extraAttributes, extraAttributes.length + 1);
        extraAttributes[extraAttributes.length - 1] = JavaCore.newClasspathAttribute((String)"module", (String)TRUE);
        return extraAttributes;
    }

    private IClasspathEntry addAttributes(IClasspathEntry entry, IClasspathAttribute[] extraAttributes) {
        switch (entry.getEntryKind()) {
            case 1: {
                return JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])extraAttributes, (boolean)entry.isExported());
            }
            case 2: {
                return JavaCore.newProjectEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (boolean)entry.combineAccessRules(), (IClasspathAttribute[])extraAttributes, (boolean)entry.isExported());
            }
        }
        return entry;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

