/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.ui.navigation;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public class URIBasedStorage
extends PlatformObject
implements IEncodedStorage {
    private final URI uri;

    public URIBasedStorage(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public InputStream getContents() throws CoreException {
        try {
            return URIConverter.INSTANCE.createInputStream(this.uri);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.n4js.ts.ui", "Cannot load " + this.getFullPath(), (Throwable)e));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof URIBasedStorage)) {
            return false;
        }
        URIBasedStorage other = (URIBasedStorage)((Object)obj);
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public IPath getFullPath() {
        return new Path(this.uri.path());
    }

    public String getName() {
        return this.uri.lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String getCharset() throws CoreException {
        return Charsets.UTF_8.name();
    }
}

