/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.n4js.smith.ui.ActiveEditorChangeListener;
import org.eclipse.n4js.transpiler.sourcemap.MappingEntry;
import org.eclipse.n4js.transpiler.sourcemap.SourceMap;
import org.eclipse.n4js.transpiler.sourcemap.SourceMapFileLocator;
import org.eclipse.n4js.validation.helper.FunctionValidationHelper;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.part.ViewPart;

public class SourceMapView
extends ViewPart {
    private static final String GEN_EXT = "js";
    private static final String MAP_EXT = "map";
    private static final String N4JS_EXT = "n4js";
    private static final int FILENAME_LENGTH = 36;
    private CTabFolder tabsOrg;
    private LinkedHashMap<File, StyledText> textOrgs;
    private StyledText textGen;
    private StyledText textMappings;
    private StyledText textMapFile;
    private StyledText textMessages;
    private IEditorPart activeEditor;
    private Color colorBgMapped;
    private Color colorBgMarked;
    private Font font;
    @Inject
    private SourceMapFileLocator sourceMapFileLocator;
    private SourceMap sourceMap;
    private final Map<MappingEntry, Integer> mappingEntriesByIndex = new HashMap<MappingEntry, Integer>();
    private final List<MappingEntry> mappingEntriesAsList = new ArrayList<MappingEntry>();
    private final Map<StyledText, Point> textMarkers = new HashMap<StyledText, Point>();
    private ActiveEditorChangeListener activeEditorChangeListener;

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        this.font = new Font((Device)parent.getDisplay(), "Courier New", 12, 0);
        this.colorBgMapped = new Color((Device)display, 255, 248, 217);
        this.colorBgMarked = new Color((Device)display, 255, 183, 219);
        SashForm sashFilesAndMapping = new SashForm(parent, 512);
        SashForm sashGenAndOrgFiles = new SashForm((Composite)sashFilesAndMapping, 256);
        this.textGen = this.createText((Composite)sashGenAndOrgFiles, true);
        this.addTextSelectionListerners(this.textGen, (FunctionValidationHelper.TripleConsumer<StyledText, Integer, Integer>)((FunctionValidationHelper.TripleConsumer)(t, genLine, genColumn) -> {
            if (this.sourceMap != null) {
                MappingEntry entry = this.sourceMap.findMappingForGenPosition(genLine.intValue(), genColumn.intValue());
                this.markMapping((StyledText)t, entry);
            }
        }));
        this.tabsOrg = new CTabFolder((Composite)sashGenAndOrgFiles, 2048);
        this.textOrgs = new LinkedHashMap();
        TabFolder tabFolder = new TabFolder((Composite)sashFilesAndMapping, 2048);
        TabItem tabMappings = new TabItem(tabFolder, 0);
        tabMappings.setText("Mappings");
        this.textMappings = this.createText((Composite)tabFolder, true);
        this.addTextSelectionListerners(this.textMappings, (FunctionValidationHelper.TripleConsumer<StyledText, Integer, Integer>)((FunctionValidationHelper.TripleConsumer)(t, line, c) -> {
            if (line >= this.mappingEntriesByIndex.size()) {
                return;
            }
            MappingEntry entry = this.mappingEntriesAsList.get((int)line);
            this.markMapping((StyledText)t, entry);
        }));
        tabMappings.setControl((Control)this.textMappings);
        TabItem tabMapFile = new TabItem(tabFolder, 0);
        tabMapFile.setText("Map-File");
        this.textMapFile = this.createText((Composite)tabFolder, true);
        tabMapFile.setControl((Control)this.textMapFile);
        TabItem tabMessages = new TabItem(tabFolder, 0);
        tabMessages.setText("Messages");
        this.textMessages = this.createText((Composite)tabFolder, false);
        tabMessages.setControl((Control)this.textMessages);
        this.activeEditorChangeListener = new ActiveEditorChangeListener(this::updateActiveEditor);
        this.getSite().getPage().addPartListener((IPartListener)this.activeEditorChangeListener);
    }

    private void addTextSelectionListerners(final StyledText text, final FunctionValidationHelper.TripleConsumer<StyledText, Integer, Integer> selectorFunction) {
        text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                try {
                    if (text.isFocusControl()) {
                        int offset = text.getOffsetAtLocation(new Point(e.x, e.y));
                        int line = text.getLineAtOffset(offset);
                        int column = offset - text.getOffsetAtLine(line);
                        selectorFunction.accept((Object)text, (Object)line, (Object)column);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        text.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                if (text.isFocusControl()) {
                    int offset = event.caretOffset;
                    int line = text.getLineAtOffset(offset);
                    int column = offset - text.getOffsetAtLine(line);
                    selectorFunction.accept((Object)text, (Object)line, (Object)column);
                }
            }
        });
    }

    public void dispose() {
        if (this.activeEditorChangeListener != null) {
            this.getSite().getPage().removePartListener((IPartListener)this.activeEditorChangeListener);
            this.activeEditorChangeListener = null;
        }
        this.font.dispose();
        this.colorBgMapped.dispose();
        this.colorBgMarked.dispose();
    }

    private StyledText createText(Composite parent, boolean nonPropFont) {
        StyledText text = new StyledText(parent, 2818);
        if (nonPropFont) {
            text.setFont(this.font);
        }
        return text;
    }

    private void log(String s) {
        this.textMessages.append("\n" + s);
    }

    private void updateActiveEditor(IEditorPart editorPart) {
        if (editorPart != this.activeEditor && editorPart != null && editorPart.getEditorInput() instanceof IFileEditorInput) {
            this.activeEditor = editorPart;
            IFileEditorInput fei = (IFileEditorInput)this.activeEditor.getEditorInput();
            this.activeEditor = editorPart;
            this.reset();
            IFile editorFile = fei.getFile();
            String editorFileExt = editorFile.getFileExtension().toLowerCase();
            Path path = Paths.get(editorFile.getLocation().toFile().toURI());
            if (MAP_EXT.equals(editorFileExt)) {
                this.log("Found map file in editor, try to resolve original and generated code.");
                try {
                    this.resolveFromMap(path);
                }
                catch (Exception ex) {
                    this.log("Error reading map file " + editorFile + ": " + ex);
                }
            } else if (GEN_EXT.equals(editorFileExt)) {
                this.log("Found javascript file in editor, try to resolve map file and original code.");
                try {
                    this.resolveFromGen(path);
                }
                catch (Exception ex) {
                    this.log("Error resolving from generated file: " + ex);
                }
            } else if (N4JS_EXT.equals(editorFileExt)) {
                this.log("Found n4js file in editor, try to resolve map file and generated code.");
                try {
                    this.resolveFromSrc(path);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.log("Error reading source file " + editorFile + ": " + ex);
                }
            }
        }
    }

    private void resolveFromSrc(Path path) throws Exception {
        File file = this.sourceMapFileLocator.resolveSourceMapFromSrc(path);
        if (file == null) {
            return;
        }
        this.resolveFromMap(file.toPath());
    }

    private void resolveFromGen(Path path) throws Exception {
        File file = this.sourceMapFileLocator.resolveSourceMapFromGen(path);
        if (file == null) {
            return;
        }
        this.resolveFromMap(file.toPath());
    }

    private void resolveFromMap(Path path) throws Exception {
        File mapFile = path.toFile();
        String s = this.readFile(mapFile);
        this.textMapFile.setText(s);
        this.sourceMap = SourceMap.loadAndResolve((Path)path);
        StringBuffer strb = new StringBuffer();
        String genShort = this.sourceMap.getResolvedFile().getFileName().toString();
        if (genShort.length() > 36) {
            genShort = "\u2026" + genShort.substring(genShort.length() - 36 - 1);
        }
        for (MappingEntry mappingEntry : this.sourceMap.getGenMappings()) {
            String srcShort;
            this.mappingEntriesByIndex.put(mappingEntry, this.mappingEntriesByIndex.size());
            this.mappingEntriesAsList.add(mappingEntry);
            if (strb.length() > 0) {
                strb.append("\n");
            }
            if ((srcShort = (String)this.sourceMap.sources.get(mappingEntry.srcIndex)).length() > 36) {
                srcShort = "\u2026" + srcShort.substring(srcShort.length() - 36 - 1);
            }
            strb.append(String.format("%1$-3s:%2$03d:%3$03d -> %4$-3s:%5$03d:%6$03d)", genShort, mappingEntry.genLine + 1, mappingEntry.genColumn + 1, srcShort, mappingEntry.srcLine + 1, mappingEntry.srcColumn + 1));
        }
        this.textMappings.setText(strb.toString());
        File file = this.sourceMap.getResolvedFile().toFile();
        s = this.readFile(file);
        this.textGen.setText(s);
        for (Path srcPath : this.sourceMap.getResolvedSources()) {
            this.addOrg(srcPath.toFile());
        }
        for (MappingEntry mappingEntry : this.sourceMap.getGenMappings()) {
            this.highlightMapping(mappingEntry);
        }
    }

    private void highlightMapping(MappingEntry entry) {
        this.styleMappedTextGen(null, entry, false);
        this.styleMappedTextOrg(null, entry, false);
    }

    private void reset() {
        CTabItem[] items;
        this.textGen.setText("");
        this.textMapFile.setText("");
        this.textMappings.setText("");
        this.textMessages.setText("");
        for (StyledText t : this.textOrgs.values()) {
            t.dispose();
        }
        CTabItem[] cTabItemArray = items = this.tabsOrg.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.textOrgs.clear();
        this.sourceMap = null;
        this.mappingEntriesByIndex.clear();
        this.mappingEntriesAsList.clear();
        this.textMarkers.clear();
    }

    private void addOrg(File file) throws IOException {
        String code;
        File canFile = file.getCanonicalFile();
        if (this.textOrgs.containsKey(canFile)) {
            return;
        }
        try {
            code = this.readFile(canFile);
        }
        catch (Exception e) {
            this.log("Error loading original file " + file + ": " + e);
            return;
        }
        CTabItem tabItem = new CTabItem(this.tabsOrg, 0);
        StyledText text = this.createText((Composite)this.tabsOrg, true);
        text.setText(code);
        tabItem.setControl((Control)text);
        tabItem.setText(file.getName());
        this.textOrgs.put(canFile, text);
        this.tabsOrg.setSelection(this.tabsOrg.getItemCount() - 1);
        this.addTextSelectionListerners(text, (FunctionValidationHelper.TripleConsumer<StyledText, Integer, Integer>)((FunctionValidationHelper.TripleConsumer)(t, srcLine, srcColumn) -> {
            if (this.sourceMap != null) {
                int srcIndex = 0;
                for (Map.Entry<File, StyledText> e : this.textOrgs.entrySet()) {
                    if (e.getValue() == t) break;
                    ++srcIndex;
                }
                if (srcIndex >= this.textOrgs.size()) {
                    return;
                }
                MappingEntry entry = this.sourceMap.findMappingForSrcPosition(srcIndex, srcLine.intValue(), srcColumn.intValue());
                this.markMapping(text, entry);
            }
        }));
    }

    private String readFile(File file) throws Exception {
        FileInputStream in = new FileInputStream(file);
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStreamReader reader = new InputStreamReader((InputStream)in, Charsets.UTF_8);){
            return CharStreams.toString((Readable)reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setFocus() {
    }

    private void markMapping(StyledText textEmittingEvent, MappingEntry entry) {
        for (Map.Entry<StyledText, Point> e : this.textMarkers.entrySet()) {
            SourceMapView.doStyleText(e.getKey(), e.getKey() == this.textMappings ? null : this.colorBgMapped, e.getValue().x, e.getValue().y);
        }
        this.textMarkers.clear();
        this.styleMappedTextGen(textEmittingEvent, entry, true);
        this.styleMappedTextOrg(textEmittingEvent, entry, true);
        this.styleMapping(textEmittingEvent, entry, true);
    }

    private void styleMappedTextOrg(StyledText textEmittingEvent, MappingEntry entry, boolean mark) {
        if (entry != null) {
            int srcOffset;
            Path srcPath = (Path)this.sourceMap.getResolvedSources().get(entry.srcIndex);
            StyledText text = this.textOrgs.get(srcPath.normalize().toFile());
            int srcOffsetEnd = srcOffset = text.getOffsetAtLine(entry.srcLine) + entry.srcColumn;
            int length = this.sourceMap.computeLengthSrc(entry);
            srcOffsetEnd = length >= 0 ? (srcOffsetEnd += length) : (entry.srcLine + 1 >= text.getLineCount() ? text.getCharCount() : text.getOffsetAtLine(entry.srcLine + 1) - 1);
            this.styleText(text, srcOffset, srcOffsetEnd, mark);
            if (mark && text != textEmittingEvent) {
                text.setSelection(srcOffset);
            }
        } else {
            StyledText text = (StyledText)this.tabsOrg.getSelection().getControl();
            this.styleText(text, 0, 0, mark);
        }
    }

    private void styleMappedTextGen(StyledText textEmittingEvent, MappingEntry entry, boolean mark) {
        if (entry != null) {
            int genOffset;
            int genOffsetEnd = genOffset = this.textGen.getOffsetAtLine(entry.genLine) + entry.genColumn;
            int length = this.sourceMap.computeLengthGen(entry);
            genOffsetEnd = length >= 0 ? (genOffsetEnd += length) : this.textGen.getOffsetAtLine(entry.genLine + 1) - 1;
            this.styleText(this.textGen, genOffset, genOffsetEnd, mark);
            if (mark && this.textGen != textEmittingEvent) {
                this.textGen.setSelection(genOffset);
            }
        } else {
            this.styleText(this.textGen, 0, 0, mark);
        }
    }

    private void styleMapping(StyledText textEmittingEvent, MappingEntry entry, boolean mark) {
        int mapIndex;
        if (entry != null && (mapIndex = this.mappingEntriesByIndex.get(entry).intValue()) >= 0) {
            int mapOffset = this.textMappings.getOffsetAtLine(mapIndex);
            int mapOffsetEnd = mapIndex < this.mappingEntriesByIndex.size() - 1 ? this.textMappings.getOffsetAtLine(mapIndex + 1) - 1 : this.textMappings.getText().length() - 1;
            this.styleText(this.textMappings, mapOffset, mapOffsetEnd, mark);
            if (mark && this.textGen != textEmittingEvent) {
                this.textMappings.setSelection(mapOffset);
            }
            return;
        }
        this.styleText(this.textMappings, 0, 0, mark);
    }

    private void styleText(StyledText text, int start, int end, boolean mark) {
        Color color;
        Color color2 = color = mark ? this.colorBgMarked : this.colorBgMapped;
        if (start <= end) {
            SourceMapView.doStyleText(text, color, start, end);
            if (mark) {
                this.textMarkers.put(text, new Point(start, end));
            }
        }
    }

    private static void doStyleText(StyledText text, Color colorBackground, int start, int end) {
        int max = text.getCharCount();
        if (end >= max) {
            end = max - 1;
        }
        if (start < 0 || end < 0 || start > end || end - start == 0) {
            return;
        }
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = end - start;
        styleRange.background = colorBackground;
        text.setStyleRange(styleRange);
    }
}

