/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.runtime;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.Result2;
import org.eclipse.xsemantics.runtime.Result3;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xsemantics.runtime.RuleEnvironmentEntry;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xsemantics.runtime.StringRepresentation;
import org.eclipse.xsemantics.runtime.XsemanticsCache;
import org.eclipse.xsemantics.runtime.XsemanticsProvider;
import org.eclipse.xsemantics.runtime.internal.PatchedPolymorphicDispatcher;
import org.eclipse.xtext.util.PolymorphicDispatcher;

public class XsemanticsRuntimeSystem {
    protected static final int INDEX_OF_RULE_PARAMETERS = 2;
    protected static final int INDEX_OF_AUX_PARAMETERS = 1;
    @Inject
    protected StringRepresentation stringRepresentation;
    @Inject
    private Provider<XsemanticsCache> cacheProvider;
    private XsemanticsCache cache = null;

    public XsemanticsCache getCache() {
        if (this.cache == null) {
            this.cache = (XsemanticsCache)this.cacheProvider.get();
        }
        return this.cache;
    }

    protected <T> T getFromCache(String methodName, RuleEnvironment environment, RuleApplicationTrace trace, XsemanticsProvider<T> provider, Object ... elements) {
        return this.getCache().get(methodName, environment, trace, provider, elements);
    }

    protected Predicate<Method> getPredicate(String methodName, int numOfArgs) {
        return PolymorphicDispatcher.Predicates.forName((String)methodName, (int)numOfArgs);
    }

    protected <T> PolymorphicDispatcher<T> buildPolymorphicDispatcher(final String methodName, int numOfArgs) {
        return new PatchedPolymorphicDispatcher<T>(Collections.singletonList(this), this.getPredicate(methodName, numOfArgs)){

            protected T handleNoSuchMethod(Object ... params) {
                throw XsemanticsRuntimeSystem.this.noSuchMethodException(methodName, params);
            }
        };
    }

    protected <T> PolymorphicDispatcher<Result<T>> buildPolymorphicDispatcher1(String methodName, int numOfArgs, final String judgmentSymbol, final String ... relationSymbols) {
        return new PatchedPolymorphicDispatcher<Result<T>>(Collections.singletonList(this), this.getPredicate(methodName, numOfArgs)){

            protected Result<T> handleNoSuchMethod(Object ... params) {
                throw XsemanticsRuntimeSystem.this.noSuchMethodException(judgmentSymbol, Arrays.asList(relationSymbols), params);
            }
        };
    }

    protected <F, S> PolymorphicDispatcher<Result2<F, S>> buildPolymorphicDispatcher2(String methodName, int numOfArgs, final String judgmentSymbol, final String ... relationSymbols) {
        return new PatchedPolymorphicDispatcher<Result2<F, S>>(Collections.singletonList(this), this.getPredicate(methodName, numOfArgs)){

            protected Result2<F, S> handleNoSuchMethod(Object ... params) {
                throw XsemanticsRuntimeSystem.this.noSuchMethodException(judgmentSymbol, Arrays.asList(relationSymbols), params);
            }
        };
    }

    protected <F, S, T> PolymorphicDispatcher<Result3<F, S, T>> buildPolymorphicDispatcher3(String methodName, int numOfArgs, final String judgmentSymbol, final String ... relationSymbols) {
        return new PatchedPolymorphicDispatcher<Result3<F, S, T>>(Collections.singletonList(this), this.getPredicate(methodName, numOfArgs)){

            protected Result3<F, S, T> handleNoSuchMethod(Object ... params) {
                throw XsemanticsRuntimeSystem.this.noSuchMethodException(judgmentSymbol, Arrays.asList(relationSymbols), params);
            }
        };
    }

    public boolean isResultAssignableTo(Object result, Class<?> destinationClass) {
        if (result == null) {
            return true;
        }
        return destinationClass.isAssignableFrom(result.getClass());
    }

    public void checkAssignableTo(Object result, Class<?> destinationClass) {
        if (!this.isResultAssignableTo(result, destinationClass)) {
            throw this.newRuleFailedException(String.valueOf(this.stringRep(result)) + " cannot be assigned to " + this.stringRep(destinationClass));
        }
    }

    public void checkParamsNotNull(Object ... objects) {
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            this.checkNotNull(object);
            ++i;
        }
    }

    public void checkNotNull(Object object) {
        if (object == null) {
            throw this.newRuleFailedException("passed null object to system");
        }
    }

    public String stringRep(Object object) {
        return this.stringRepresentation.string(object);
    }

    protected String stringRepForEnv(RuleEnvironment ruleEnvironment) {
        if (ruleEnvironment == null) {
            return "[]";
        }
        return this.stringRepresentation.string(ruleEnvironment);
    }

    protected String stringRepForParams(Object[] params, Iterable<String> relationSymbols) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = relationSymbols.iterator();
        int i = 2;
        while (i < params.length) {
            builder.append(this.stringRep(params[i]));
            if (it.hasNext()) {
                builder.append(" " + it.next() + " ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String stringRepForParams(Object[] params) {
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i < params.length) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(this.stringRep(params[i]));
            ++i;
        }
        return builder.toString();
    }

    protected RuleFailedException noSuchMethodException(String judgmentSymbol, Iterable<String> relationSymbols, Object ... params) {
        return this.newRuleFailedException("cannot find a rule for " + judgmentSymbol + " " + this.stringRepForParams(params, relationSymbols));
    }

    protected RuleFailedException noSuchMethodException(String name, Object ... params) {
        return this.newRuleFailedException("cannot find an implementation for " + name + "(" + this.stringRepForParams(params) + ")");
    }

    public void sneakyThrowRuleFailedException(Exception e) {
        throw this.extractRuleFailedException(e);
    }

    public void sneakyThrowRuleFailedException(String message) {
        throw this.newRuleFailedException(message, null, new ErrorInformation[0]);
    }

    public void throwForExplicitFail() {
        throw this.newRuleFailedException();
    }

    public void throwForExplicitFail(String message, ErrorInformation errorInformation) {
        RuleFailedException ex = this.newRuleFailedException(message);
        ex.addErrorInformation(errorInformation);
        throw ex;
    }

    public void throwRuleFailedException(String message, String issue, Throwable t, ErrorInformation ... errorInformations) {
        throw this.newRuleFailedException(message, issue, t, errorInformations);
    }

    public RuleFailedException newRuleFailedException() {
        return this.createRuleFailedException(null, null, null);
    }

    public RuleFailedException newRuleFailedException(Throwable t) {
        return this.createRuleFailedException(t.toString(), null, t);
    }

    public RuleFailedException newRuleFailedException(String message) {
        return this.createRuleFailedException(message, null, null);
    }

    public RuleFailedException newRuleFailedException(String message, String issue, ErrorInformation ... errorInformations) {
        return this.newRuleFailedException(message, issue, (Throwable)null, errorInformations);
    }

    public RuleFailedException newRuleFailedException(String message, String issue, Throwable t, ErrorInformation ... errorInformations) {
        RuleFailedException ruleFailedException = this.createRuleFailedException(this.failed(message), issue, t);
        ruleFailedException.addErrorInformations(errorInformations);
        return ruleFailedException;
    }

    protected RuleFailedException createRuleFailedException(String message, String issue, Throwable t) {
        return new RuleFailedException(message, issue, t);
    }

    public RuleFailedException extractRuleFailedException(Exception e) {
        if (e instanceof WrappedException) {
            WrappedException wrappedException = (WrappedException)e;
            Exception exception = wrappedException.exception();
            if (exception instanceof RuleFailedException) {
                return (RuleFailedException)exception;
            }
        } else if (e instanceof RuleFailedException) {
            return (RuleFailedException)e;
        }
        return this.newRuleFailedException(e);
    }

    protected <T> Result<T> resultForFailure(Exception e) {
        return new Result(this.extractRuleFailedException(e));
    }

    protected <F, S> Result2<F, S> resultForFailure2(Exception e) {
        return new Result2(this.extractRuleFailedException(e));
    }

    protected <F, S, T> Result3<F, S, T> resultForFailure3(Exception e) {
        return new Result3(this.extractRuleFailedException(e));
    }

    protected String failed(String message) {
        return "failed: " + this.trimIfNotNull(message);
    }

    protected String trimIfNotNull(String message) {
        return message != null ? message.trim() : message;
    }

    protected String ruleName(String ruleName) {
        return String.valueOf(this.trimIfNotNull(ruleName)) + ": ";
    }

    protected String auxFunName(String ruleName) {
        return this.trimIfNotNull(ruleName);
    }

    public void addToTrace(RuleApplicationTrace ruleApplicationTrace, Provider<? extends Object> traceElementProvider) {
        if (ruleApplicationTrace != null) {
            ruleApplicationTrace.addToTrace(traceElementProvider.get());
        }
    }

    public RuleApplicationTrace newTrace(RuleApplicationTrace ruleApplicationTrace) {
        if (ruleApplicationTrace != null) {
            return new RuleApplicationTrace();
        }
        return null;
    }

    public void addAsSubtrace(RuleApplicationTrace ruleApplicationTrace, RuleApplicationTrace subTrace) {
        if (ruleApplicationTrace != null) {
            ruleApplicationTrace.addAsSubtrace(subTrace);
        }
    }

    public <T> T env(RuleEnvironment environment, Object key, Class<? extends T> clazz) throws RuleFailedException {
        return this.environmentAccess(environment, key, clazz);
    }

    public <T> T environmentAccess(RuleEnvironment environment, Object key, Class<? extends T> clazz) throws RuleFailedException {
        if (environment == null) {
            throw this.newRuleFailedException("access to null environment");
        }
        Object value = environment.get(key);
        if (value == null) {
            throw this.newRuleFailedException("no mapping in the environment for: " + this.stringRep(key));
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        throw this.newRuleFailedException("mapped value " + this.stringRep(value) + " cannot be assigned to " + this.stringRep(clazz));
    }

    public <T extends EObject> T clone(T eObject) {
        return (T)EcoreUtil.copy(eObject);
    }

    public RuleEnvironment emptyEnvironment() {
        return new RuleEnvironment();
    }

    public RuleEnvironment environmentEntry(Object key, Object value) {
        return new RuleEnvironment(new RuleEnvironmentEntry(key, value));
    }

    public RuleEnvironment environmentComposition(RuleEnvironment environment, RuleEnvironment environment2) {
        if (environment == null) {
            return new RuleEnvironment(environment2);
        }
        return new RuleEnvironment(environment, environment2);
    }

    public <T> List<T> getAll(EObject eObject, EStructuralFeature mainFeature, EStructuralFeature extendFeature, Class<? extends T> clazz) {
        LinkedList list = new LinkedList();
        if (eObject != null) {
            this.addToList(list, eObject.eGet(mainFeature), clazz);
            List<EObject> nodesInRelation = this.getAllNodesInRelation(eObject, extendFeature);
            for (EObject object : nodesInRelation) {
                this.addToList(list, object.eGet(mainFeature), clazz);
            }
        }
        return list;
    }

    public List<EObject> getAllNodesInRelation(EObject eObject, EStructuralFeature extendFeature) {
        LinkedList<EObject> nodes = new LinkedList<EObject>();
        HashSet<EObject> seen = new HashSet<EObject>();
        this.getAllNodesInRelation(eObject, extendFeature, nodes, seen);
        return nodes;
    }

    protected void getAllNodesInRelation(EObject eObject, EStructuralFeature extendFeature, List<EObject> nodes, Set<EObject> seen) {
        if (eObject != null) {
            List<Object> objectsToFollow = this.getList(eObject.eGet(extendFeature));
            for (Object object : objectsToFollow) {
                EObject toFollow = this.getEObject(object);
                if (toFollow == null || seen.contains(toFollow)) continue;
                seen.add(toFollow);
                nodes.add(toFollow);
                this.getAllNodesInRelation(toFollow, extendFeature, nodes, seen);
            }
        }
    }

    public List<Object> getList(Object object) {
        if (object == null) {
            return Lists.newArrayList();
        }
        if (object instanceof List) {
            return (List)object;
        }
        return Lists.newArrayList((Object[])new Object[]{object});
    }

    public EObject getEObject(Object object) {
        if (object instanceof EObject) {
            return (EObject)object;
        }
        return null;
    }

    public <T> void addToList(List<T> list, Object o, Class<? extends T> clazz) {
        if (o == null) {
            return;
        }
        if (o instanceof List) {
            List objectList = (List)o;
            for (Object object : objectList) {
                this.addToList(list, object, clazz);
            }
        } else if (clazz.isAssignableFrom(o.getClass())) {
            list.add(o);
        }
    }
}

