/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.runtime.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.SimpleCache;

public class PatchedPolymorphicDispatcher<RT>
extends PolymorphicDispatcher<RT> {
    private static final Logger log = Logger.getLogger(PolymorphicDispatcher.class);
    private final List<? extends Object> targets;
    private final Predicate<Method> methodFilter;
    private Collection<PolymorphicDispatcher.MethodDesc> methods;
    private final PolymorphicDispatcher.ErrorHandler<RT> handler;
    private final SimpleCache<List<Class<?>>, List<PolymorphicDispatcher.MethodDesc>> cache = new SimpleCache(new Function<List<Class<?>>, List<PolymorphicDispatcher.MethodDesc>>(){

        public List<PolymorphicDispatcher.MethodDesc> apply(List<Class<?>> paramTypes) {
            ArrayList<PolymorphicDispatcher.MethodDesc> result = new ArrayList<PolymorphicDispatcher.MethodDesc>();
            block0: for (PolymorphicDispatcher.MethodDesc methodDesc : PatchedPolymorphicDispatcher.this.methods) {
                if (!methodDesc.isInvokeable(paramTypes)) continue;
                if (result.isEmpty()) {
                    result.add(methodDesc);
                    continue;
                }
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    PolymorphicDispatcher.MethodDesc next = (PolymorphicDispatcher.MethodDesc)it.next();
                    int compare = PatchedPolymorphicDispatcher.this.compare(next, methodDesc);
                    if (compare < 0) {
                        it.remove();
                        continue;
                    }
                    if (compare > 0) continue block0;
                }
                result.add(methodDesc);
            }
            return result;
        }
    });

    public PatchedPolymorphicDispatcher(List<? extends Object> targets, Predicate<Method> methodFilter) {
        this((List<Object>)targets, methodFilter, (PolymorphicDispatcher.ErrorHandler<RT>)new PolymorphicDispatcher.DefaultErrorHandler());
    }

    public PatchedPolymorphicDispatcher(List<? extends Object> targets, Predicate<Method> methodFilter, PolymorphicDispatcher.ErrorHandler<RT> handler) {
        super(Collections.emptyList(), methodFilter, handler);
        this.targets = targets;
        this.methodFilter = methodFilter;
        this.handler = handler;
        this.methods = this.getCandidateMethods();
    }

    protected int compare(PolymorphicDispatcher.MethodDesc o1, PolymorphicDispatcher.MethodDesc o2) {
        Class[] paramTypes2;
        Class[] paramTypes1 = o1.getParameterTypes();
        if (paramTypes1.length > (paramTypes2 = o2.getParameterTypes()).length) {
            return 1;
        }
        if (paramTypes2.length > paramTypes1.length) {
            return -1;
        }
        int i = 0;
        while (i < paramTypes1.length) {
            Class class1 = paramTypes1[i];
            Class class2 = paramTypes2[i];
            if (!class1.equals(class2)) {
                if (class1.isAssignableFrom(class2) || Void.class.equals((Object)class2)) {
                    return -1;
                }
                if (class2.isAssignableFrom(class1) || Void.class.equals((Object)class1)) {
                    return 1;
                }
            }
            ++i;
        }
        if (!o1.getDeclaringClass().equals(o2.getDeclaringClass())) {
            if (o1.getDeclaringClass().isAssignableFrom(o2.getDeclaringClass())) {
                return 1;
            }
            if (o2.getDeclaringClass().isAssignableFrom(o1.getDeclaringClass())) {
                return -1;
            }
        }
        int compareTo = Integer.valueOf(this.targets.indexOf(o2.getTarget())).compareTo(this.targets.indexOf(o1.getTarget()));
        return compareTo;
    }

    public RT invoke(Object ... params) {
        PolymorphicDispatcher.MethodNameFilter filter;
        if (this.methodFilter instanceof PolymorphicDispatcher.MethodNameFilter && (params.length < (filter = (PolymorphicDispatcher.MethodNameFilter)this.methodFilter).getMinParams() || params.length > filter.getMaxParams())) {
            throw new IllegalArgumentException("Wrong number of arguments. Expected " + filter.getMinParams() + " to " + filter.getMaxParams() + ".");
        }
        List result = (List)this.cache.get(this.getTypes(params));
        if (result.size() > 1) {
            return (RT)this.handleAmbigousMethods(result, params);
        }
        if (result.isEmpty()) {
            return (RT)this.handleNoSuchMethod(params);
        }
        try {
            PolymorphicDispatcher.MethodDesc current = (PolymorphicDispatcher.MethodDesc)result.get(0);
            current.getMethod().setAccessible(true);
            return (RT)current.getMethod().invoke(current.getTarget(), params);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            return (RT)this.handler.handle(params, e.getTargetException());
        }
        catch (IllegalArgumentException e) {
            return (RT)this.handler.handle(params, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return (RT)this.handler.handle(params, (Throwable)e);
        }
    }

    private List<Class<?>> getTypes(Object[] params) {
        ArrayList result = new ArrayList(params.length);
        int i = 0;
        while (i < params.length) {
            if (params[i] != null) {
                result.add(params[i].getClass());
            } else {
                result.add(this.getDefaultClass(i));
            }
            ++i;
        }
        return result;
    }

    private Collection<PolymorphicDispatcher.MethodDesc> getCandidateMethods() {
        ArrayList<PolymorphicDispatcher.MethodDesc> cachedDescriptors = new ArrayList<PolymorphicDispatcher.MethodDesc>();
        for (Object object : this.targets) {
            Class<?> current = object.getClass();
            while (current != Object.class) {
                Method[] methods;
                Method[] methodArray = methods = current.getDeclaredMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (this.methodFilter.apply((Object)method)) {
                        cachedDescriptors.add(this.createMethodDesc(object, method));
                    }
                    ++n2;
                }
                current = current.getSuperclass();
            }
        }
        return cachedDescriptors;
    }
}

