/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.es.transform.AsyncAwaitTransformation;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.PromisifyHelper;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@TransformationDependency.ExcludesBefore(value={AsyncAwaitTransformation.class})
public class ExpressionTransformation
extends Transformation {
    @Inject
    private ResourceNameComputer resourceNameComputer;
    @Inject
    private PromisifyHelper promisifyHelper;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<Expression> _function = it -> this.transformExpression((Expression)it);
        this.collectNodes((EObject)this.getState().im, Expression.class, true).forEach(_function);
    }

    private void _transformExpression(Expression relExpr) {
    }

    private void _transformExpression(CastExpression castExpr) {
        this.replace((Expression)castExpr, castExpr.getExpression());
    }

    private void _transformExpression(RelationalExpression relExpr) {
        boolean _tripleEquals;
        RelationalOperator _op = relExpr.getOp();
        boolean bl = _tripleEquals = _op == RelationalOperator.INSTANCEOF;
        if (_tripleEquals) {
            Expression rhs = relExpr.getRhs();
            IdentifiableElement _xifexpression = null;
            if (rhs instanceof IdentifierRef_IM) {
                _xifexpression = ((IdentifierRef_IM)rhs).getOriginalTargetOfRewiredTarget();
            }
            IdentifiableElement rhsType = _xifexpression;
            ParameterizedCallExpression _xifexpression_1 = null;
            if (rhsType instanceof TInterface) {
                ParameterizedCallExpression _xblockexpression = null;
                SymbolTableEntryInternal $implementsSTE = this.steFor_$implements();
                String fqn = this.resourceNameComputer.getFullyQualifiedTypeName_WITH_LEGACY_SUPPORT((Type)rhsType);
                _xifexpression_1 = _xblockexpression = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)$implementsSTE), (Expression[])new Expression[]{relExpr.getLhs(), TranspilerBuilderBlocks._StringLiteral((String)fqn)});
            } else {
                ParameterizedCallExpression _xifexpression_2 = null;
                if (rhsType instanceof TClass) {
                    _xifexpression_2 = null;
                } else {
                    ParameterizedCallExpression _xblockexpression_1 = null;
                    SymbolTableEntryInternal $instanceofSTE = this.steFor_$instanceof();
                    _xifexpression_2 = _xblockexpression_1 = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)$instanceofSTE), (Expression[])new Expression[]{relExpr.getLhs(), relExpr.getRhs()});
                }
                _xifexpression_1 = _xifexpression_2;
            }
            ParameterizedCallExpression replacement = _xifexpression_1;
            if (replacement != null) {
                this.replace((Expression)relExpr, (Expression)replacement);
            }
        }
    }

    private void _transformExpression(AwaitExpression awaitExpr) {
        AwaitExpression awaitExprOrig = (AwaitExpression)this.getState().tracer.getOriginalASTNodeOfSameType((EObject)awaitExpr, false);
        boolean _isAutoPromisify = this.promisifyHelper.isAutoPromisify(awaitExprOrig);
        if (_isAutoPromisify) {
            Expression _expression = awaitExpr.getExpression();
            ParameterizedCallExpression callExpr = (ParameterizedCallExpression)_expression;
            ParameterizedCallExpression replacement = this.promisify(callExpr);
            this.replace((Expression)callExpr, (Expression)replacement);
        }
    }

    private void _transformExpression(PromisifyExpression promiExpr) {
        Expression _expression = promiExpr.getExpression();
        ParameterizedCallExpression callExpr = (ParameterizedCallExpression)_expression;
        ParameterizedCallExpression replacement = this.promisify(callExpr);
        this.replace((Expression)promiExpr, (Expression)replacement);
    }

    private ParameterizedCallExpression promisify(ParameterizedCallExpression callExpr) {
        IdentifiableElement originalTarget;
        SymbolTableEntry targetSTE;
        Expression target = callExpr.getTarget();
        SymbolTableEntry _switchResult = null;
        boolean _matched = false;
        if (target instanceof ParameterizedPropertyAccessExpression_IM) {
            _matched = true;
            _switchResult = ((ParameterizedPropertyAccessExpression_IM)target).getProperty_IM();
        }
        if (!_matched && target instanceof IdentifierRef_IM) {
            _matched = true;
            _switchResult = ((IdentifierRef_IM)target).getId_IM();
        }
        if ((targetSTE = _switchResult) instanceof SymbolTableEntryOriginal && (originalTarget = ((SymbolTableEntryOriginal)targetSTE).getOriginalTarget()) instanceof TFunction) {
            ParameterizedTypeRef _createTypeRef = TypeUtils.createTypeRef((Type)((Type)originalTarget), (TypeArgument[])new TypeArgument[0]);
            FunctionTypeRef originalTargetTypeRef = (FunctionTypeRef)_createTypeRef;
            TypeRef returnTypeRef = this.promisifyHelper.extractPromisifiedReturnType(this.getState().G, (FunctionTypeExprOrRef)originalTargetTypeRef);
            boolean _isUndefined = TypeUtils.isUndefined((TypeArgument)((TypeArgument)IterableExtensions.head((Iterable)IterableExtensions.drop((Iterable)returnTypeRef.getTypeArgs(), (int)1))));
            boolean hasErrorValue = !_isUndefined;
            boolean hasMoreThan1SuccessValue = RuleEnvironmentExtensions.isIterableN((RuleEnvironment)this.getState().G, (EObject)((EObject)IterableExtensions.head((Iterable)returnTypeRef.getTypeArgs())));
            if (target instanceof ParameterizedPropertyAccessExpression_IM && ((SymbolTableEntryOriginal)targetSTE).getOriginalTarget() instanceof TMethod) {
                Functions.Function1 _function = it -> TranspilerBuilderBlocks._ArrayElement((boolean)it.isSpread(), (Expression)it.getExpression());
                return TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_$n4promisifyMethod()), (Expression[])new Expression[]{((ParameterizedPropertyAccessExpression_IM)target).getTarget(), TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)targetSTE), TranspilerBuilderBlocks._ArrLit((ArrayElement[])((ArrayElement[])Conversions.unwrapArray((Object)ListExtensions.map((List)callExpr.getArguments(), (Functions.Function1)_function), ArrayElement.class))), TranspilerBuilderBlocks._BooleanLiteral((boolean)hasMoreThan1SuccessValue), TranspilerBuilderBlocks._BooleanLiteral((!hasErrorValue ? 1 : 0) != 0)});
            }
            Functions.Function1 _function_1 = it -> TranspilerBuilderBlocks._ArrayElement((boolean)it.isSpread(), (Expression)it.getExpression());
            return TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_$n4promisifyFunction()), (Expression[])new Expression[]{callExpr.getTarget(), TranspilerBuilderBlocks._ArrLit((ArrayElement[])((ArrayElement[])Conversions.unwrapArray((Object)ListExtensions.map((List)callExpr.getArguments(), (Functions.Function1)_function_1), ArrayElement.class))), TranspilerBuilderBlocks._BooleanLiteral((boolean)hasMoreThan1SuccessValue), TranspilerBuilderBlocks._BooleanLiteral((!hasErrorValue ? 1 : 0) != 0)});
        }
        return callExpr;
    }

    private void transformExpression(Expression awaitExpr) {
        if (awaitExpr instanceof AwaitExpression) {
            this._transformExpression((AwaitExpression)awaitExpr);
            return;
        }
        if (awaitExpr instanceof CastExpression) {
            this._transformExpression((CastExpression)awaitExpr);
            return;
        }
        if (awaitExpr instanceof PromisifyExpression) {
            this._transformExpression((PromisifyExpression)awaitExpr);
            return;
        }
        if (awaitExpr instanceof RelationalExpression) {
            this._transformExpression((RelationalExpression)awaitExpr);
            return;
        }
        if (awaitExpr != null) {
            this._transformExpression(awaitExpr);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(awaitExpr).toString());
    }
}

