/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4jsx;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.N4JSScopeProvider;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.TypeSystemHelper;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ReactHelper {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private IResourceScopeCache resourceScopeCacheHelper;
    @Inject
    private IScopeProvider scopeProvider;
    public static final String REACT_PROJECT_ID = "react";
    public static final String REACT_COMPONENT = "Component";
    public static final String REACT_ELEMENT = "Element";
    public static final String REACT_NAMESPACE_NAME = StringExtensions.toFirstUpper((String)"react");
    public static final String REACT_ELEMENT_FACTORY_FUNCTION_NAME = "createElement";
    private static final String REACT_KEY = "KEY__react";

    public TModule getJsxBackendModule(Resource resource) {
        String key = "KEY__react.TMODULE";
        Provider _function = () -> {
            IScope scope = ((N4JSScopeProvider)this.scopeProvider).getScopeForImplicitImports((N4JSResource)resource);
            Iterable matchingDescriptions = scope.getElements(QualifiedName.create((String)REACT_PROJECT_ID));
            Functions.Function1 _function_1 = desc -> {
                if (desc == null) {
                    return null;
                }
                EObject _resolve = EcoreUtil2.resolve((EObject)desc.getEObjectOrProxy(), (Resource)resource);
                return (TModule)_resolve;
            };
            Functions.Function1 _function_2 = module -> this.isValidReactModule((TModule)module);
            return (TModule)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)matchingDescriptions, (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        };
        return (TModule)this.resourceScopeCacheHelper.get((Object)"KEY__react.TMODULE", resource, _function);
    }

    public String getJsxBackendNamespaceName() {
        return REACT_NAMESPACE_NAME;
    }

    public String getJsxBackendElementFactoryFunctionName() {
        return REACT_ELEMENT_FACTORY_FUNCTION_NAME;
    }

    public TypeRef getJsxElementBindingType(JSXElement jsxElem) {
        Expression expr = jsxElem.getJsxElementName().getExpression();
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)expr);
        Result<TypeRef> exprResult = this.ts.type(G, (TypableElement)expr);
        boolean _failed = exprResult.failed();
        if (_failed) {
            return null;
        }
        return (TypeRef)exprResult.getValue();
    }

    public TFunction getJsxBackendElementFactoryFunction(Resource resource) {
        TModule module = this.getJsxBackendModule(resource);
        if (module != null) {
            return this.lookUpReactElementFactoryFunction(module);
        }
        return null;
    }

    public TClassifier lookUpReactElement(EObject context) {
        TClassifier reactElement = this.lookUpReactClassifier(context, REACT_ELEMENT);
        return reactElement;
    }

    public TClassifier lookUpReactComponent(EObject context) {
        TClassifier reactComponent = this.lookUpReactClassifier(context, REACT_COMPONENT);
        return reactComponent;
    }

    public TypeRef getPropsType(JSXElement jsxElem) {
        TypeRef exprTypeRef = this.getJsxElementBindingType(jsxElem);
        if (exprTypeRef == null) {
            return null;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)jsxElem);
        if (exprTypeRef instanceof TypeTypeRef && ((TypeTypeRef)exprTypeRef).isConstructorRef()) {
            Type tclass = this.tsh.getStaticType(G, (TypeTypeRef)exprTypeRef);
            TClassifier tComponentClassifier = this.lookUpReactClassifier((EObject)jsxElem, REACT_COMPONENT);
            if (tComponentClassifier == null || tComponentClassifier.getTypeVars().isEmpty()) {
                return null;
            }
            TypeVariable reactComponentProps = (TypeVariable)tComponentClassifier.getTypeVars().get(0);
            this.tsh.addSubstitutions(G, (TypeRef)TypeUtils.createTypeRef((Type)tclass, (TypeArgument[])new TypeArgument[0]));
            TypeRef reactComponentPropsTypeRef = this.ts.substTypeVariablesInTypeRef(G, (TypeRef)TypeUtils.createTypeRef((Type)reactComponentProps, (TypeArgument[])new TypeArgument[0]));
            return reactComponentPropsTypeRef;
        }
        if (exprTypeRef instanceof FunctionTypeExprOrRef) {
            boolean _greaterThan;
            int _length = ((Object[])Conversions.unwrapArray((Object)((FunctionTypeExprOrRef)exprTypeRef).getFpars(), Object.class)).length;
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                TFormalParameter tPropsParam = (TFormalParameter)((FunctionTypeExprOrRef)exprTypeRef).getFpars().get(0);
                return tPropsParam.getTypeRef();
            }
        }
        return null;
    }

    public TypeRef typeRefOfFieldOrGetter(TMember member, TypeRef context) {
        if (member instanceof TField || member instanceof TGetter) {
            return this.ts.tau((TypableElement)member, context);
        }
        String _plus = member + " must be either a TField or TGetter";
        throw new IllegalArgumentException(_plus);
    }

    private TClassifier lookUpReactClassifier(EObject context, String reactClassifierName) {
        Resource resource = context.eResource();
        String key = "KEY__react." + reactClassifierName;
        Provider _function = () -> {
            TModule tModule = this.getJsxBackendModule(resource);
            if (tModule == null) {
                return null;
            }
            Functions.Function1 _function_1 = it -> {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)reactClassifierName);
            };
            TClassifier tClassifier = (TClassifier)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)tModule.getTopLevelTypes(), TClassifier.class), (Functions.Function1)_function_1);
            return tClassifier;
        };
        return (TClassifier)this.resourceScopeCacheHelper.get((Object)key, resource, _function);
    }

    private TFunction lookUpReactElementFactoryFunction(TModule module) {
        if (module != null) {
            EList _topLevelTypes = module.getTopLevelTypes();
            for (Type currTopLevelType : _topLevelTypes) {
                if (!(currTopLevelType instanceof TFunction) || !REACT_ELEMENT_FACTORY_FUNCTION_NAME.equals(currTopLevelType.getName())) continue;
                return (TFunction)currTopLevelType;
            }
        }
        return null;
    }

    private boolean isValidReactModule(TModule module) {
        TFunction _lookUpReactElementFactoryFunction = this.lookUpReactElementFactoryFunction(module);
        return _lookUpReactElementFactoryFunction != null;
    }
}

