/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.compileTime.CompileTimeValue;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xsemantics.runtime.Result;

public final class ASTMetaInfoCache {
    private final N4JSResource resource;
    private final boolean hasBrokenAST;
    private final Map<TypableElement, Result<TypeRef>> actualTypes = new HashMap<TypableElement, Result<TypeRef>>();
    private final Map<ParameterizedCallExpression, List<TypeRef>> inferredTypeArgs = new HashMap<ParameterizedCallExpression, List<TypeRef>>();
    private final Map<Expression, CompileTimeValue> compileTimeValue = new HashMap<Expression, CompileTimeValue>();
    private final Map<VariableDeclaration, List<EObject>> localVariableReferences = new HashMap<VariableDeclaration, List<EObject>>();
    final Set<EObject> forwardProcessedSubTrees = new LinkedHashSet<EObject>();
    final Set<EObject> astNodesCurrentlyBeingTyped = new LinkedHashSet<EObject>();
    final Queue<EObject> postponedSubTrees = new LinkedList<EObject>();
    final List<FunctionOrFieldAccessor> potentialContainersOfLocalArgumentsVariable = new LinkedList<FunctionOrFieldAccessor>();

    ASTMetaInfoCache(N4JSResource resource, boolean hasBrokenAST) {
        this.resource = resource;
        this.hasBrokenAST = hasBrokenAST;
    }

    public N4JSResource getResource() {
        return this.resource;
    }

    public boolean hasBrokenAST() {
        return this.hasBrokenAST;
    }

    public Result<TypeRef> getTypeFailSafe(TypableElement astNode) {
        return this.actualTypes.get(astNode);
    }

    public Result<TypeRef> getType(TypableElement astNode) {
        Result<TypeRef> result = this.getTypeFailSafe(astNode);
        if (result == null) {
            if (this.resource.isFullyProcessed() && this.resource.getPostProcessingThrowable() != null) {
                return new Result((Object)TypeRefsFactory.eINSTANCE.createUnknownTypeRef());
            }
            throw (IllegalStateException)UtilN4.reportError((Throwable)new IllegalStateException("cache miss: no actual type in cache for AST node: " + astNode + " in resource: " + this.resource.getURI()));
        }
        return result;
    }

    void storeType(TypableElement astNode, TypeRef actualType) {
        this.storeType(astNode, (Result<TypeRef>)new Result((Object)actualType));
    }

    void storeType(TypableElement astNode, Result<TypeRef> actualType) {
        if (!this.isPostProcessing()) {
            throw new IllegalStateException("attempt to store type in cache while post-processing not in progress");
        }
        if (actualType == null) {
            throw new IllegalArgumentException("actualType may not be null");
        }
        if (astNode.eResource() != this.resource) {
            throw new IllegalArgumentException("astNode must be from this resource");
        }
        if (this.actualTypes.put(astNode, actualType) != null) {
            throw (IllegalStateException)UtilN4.reportError((Throwable)new IllegalStateException("cache collision: multiple actual types put into cache for AST node: " + astNode + " in resource: " + this.resource.getURI()));
        }
    }

    public List<TypeRef> getInferredTypeArgs(ParameterizedCallExpression callExpr) {
        return this.inferredTypeArgs.get(callExpr);
    }

    void storeInferredTypeArgs(ParameterizedCallExpression callExpr, List<TypeRef> typeArgs) {
        if (!this.isPostProcessing()) {
            throw new IllegalStateException("attempt to store inferred type arguments in cache while post-processing not in progress");
        }
        if (callExpr.eResource() != this.resource) {
            throw new IllegalArgumentException("astNode must be from this resource");
        }
        this.inferredTypeArgs.put(callExpr, Collections.unmodifiableList(new ArrayList<TypeRef>(typeArgs)));
    }

    public CompileTimeValue getCompileTimeValue(Expression expr) {
        return this.compileTimeValue.get(expr);
    }

    void storeCompileTimeValue(Expression expr, CompileTimeValue evalResult) {
        if (!this.isPostProcessing()) {
            throw new IllegalStateException("attempt to store compile-time value in cache while post-processing not in progress");
        }
        if (expr.eResource() != this.resource) {
            throw new IllegalArgumentException("astNode must be from this resource");
        }
        if (this.compileTimeValue.put(expr, evalResult) != null) {
            throw (IllegalStateException)UtilN4.reportError((Throwable)new IllegalStateException("cache collision: multiple evaluation results put into cache for AST node: " + expr + " in resource: " + this.resource.getURI()));
        }
    }

    public List<EObject> getLocalVariableReferences(VariableDeclaration varDecl) {
        List<EObject> references = this.localVariableReferences.get(varDecl);
        if (references != null) {
            return Collections.unmodifiableList(references);
        }
        return Collections.emptyList();
    }

    void storeLocalVariableReference(VariableDeclaration varDecl, EObject sourceNode) {
        if (varDecl.eResource() != this.resource) {
            throw new IllegalArgumentException("astNode must be from this resource");
        }
        if (this.localVariableReferences.containsKey(varDecl)) {
            List<EObject> references = this.localVariableReferences.get(varDecl);
            references.add(sourceNode);
        } else {
            ArrayList<EObject> references = new ArrayList<EObject>();
            references.add(sourceNode);
            this.localVariableReferences.put(varDecl, references);
        }
    }

    void clearTemporaryData() {
        this.forwardProcessedSubTrees.clear();
        this.astNodesCurrentlyBeingTyped.clear();
        this.postponedSubTrees.clear();
        this.potentialContainersOfLocalArgumentsVariable.clear();
    }

    boolean isPostProcessing() {
        return this.resource.isPostProcessing();
    }

    boolean isFullyProcessed() {
        return this.resource.isFullyProcessed();
    }
}

