/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.postprocessing.AbstractPolyProcessor;
import org.eclipse.n4js.postprocessing.PolyProcessor;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
class PolyProcessor_CallExpression
extends AbstractPolyProcessor {
    @Inject
    private PolyProcessor polyProcessor;
    @Inject
    private N4JSTypeSystem ts;

    PolyProcessor_CallExpression() {
    }

    TypeRef processCallExpression(RuleEnvironment G, ParameterizedCallExpression callExpr, TypeRef expectedTypeRef, InferenceContext infCtx, ASTMetaInfoCache cache) {
        boolean isPoly;
        Expression target = callExpr.getTarget();
        TypeRef targetTypeRef = (TypeRef)this.ts.type(G, (TypableElement)target).getValue();
        if (!(targetTypeRef instanceof FunctionTypeExprOrRef)) {
            return TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
        }
        FunctionTypeExprOrRef fteor = (FunctionTypeExprOrRef)targetTypeRef;
        boolean bl = isPoly = fteor.isGeneric() && callExpr.getTypeArgs().size() < fteor.getTypeVars().size();
        if (!isPoly) {
            TypeRef result = (TypeRef)this.ts.type(G, (TypableElement)callExpr).getValue();
            return result;
        }
        LinkedHashMap typeParam2infVar = CollectionLiterals.newLinkedHashMap();
        EList _typeVars = fteor.getTypeVars();
        for (TypeVariable typeParam : _typeVars) {
            typeParam2infVar.put(typeParam, infCtx.newInferenceVariable());
        }
        this.processParameters(G, cache, infCtx, callExpr, fteor, typeParam2infVar);
        TypeRef resultTypeRefRaw = fteor.getReturnTypeRef();
        TypeRef resultTypeRef = this.subst(resultTypeRefRaw, G, typeParam2infVar);
        Consumer<Optional<Map<InferenceVariable, TypeRef>>> _function = solution -> this.handleOnSolved(G, cache, callExpr, resultTypeRef, typeParam2infVar, (Optional<Map<InferenceVariable, TypeRef>>)solution);
        infCtx.onSolved(_function);
        return resultTypeRef;
    }

    private void processParameters(RuleEnvironment G, ASTMetaInfoCache cache, InferenceContext infCtx, ParameterizedCallExpression callExpr, FunctionTypeExprOrRef fteor, Map<TypeVariable, InferenceVariable> typeParam2infVar) {
        EList funcTypeVars = fteor.getTypeVars();
        for (TypeVariable currTypeVar : funcTypeVars) {
            TypeRef _typeVariableImplicitUpperBound;
            TypeRef _elvis = null;
            TypeRef _typeVarUpperBound = fteor.getTypeVarUpperBound(currTypeVar);
            _elvis = _typeVarUpperBound != null ? _typeVarUpperBound : (_typeVariableImplicitUpperBound = N4JSLanguageUtils.getTypeVariableImplicitUpperBound(G));
            TypeRef currUB = _elvis;
            ParameterizedTypeRef leftTypeRef = TypeUtils.createTypeRef((Type)currTypeVar, (TypeArgument[])new TypeArgument[0]);
            TypeRef leftTypeRefSubst = this.subst((TypeRef)leftTypeRef, G, typeParam2infVar);
            TypeRef rightTypeRef = currUB;
            TypeRef rightTypeRefSubst = this.subst(rightTypeRef, G, typeParam2infVar);
            infCtx.addConstraint((TypeArgument)leftTypeRefSubst, (TypeArgument)rightTypeRefSubst, Variance.CO);
        }
        int argsSize = callExpr.getArguments().size();
        int i = 0;
        while (i < argsSize) {
            Argument _get = (Argument)callExpr.getArguments().get(i);
            Expression _expression = null;
            if (_get != null) {
                _expression = _get.getExpression();
            }
            Expression arg = _expression;
            TFormalParameter curr_fpar = fteor.getFparForArgIdx(i);
            if (arg != null && curr_fpar != null) {
                TypeRef fparTypeRef = curr_fpar.getTypeRef();
                TypeRef fparTypeRefSubst = this.subst(fparTypeRef, G, typeParam2infVar);
                TypeRef argType = this.polyProcessor.processExpr(G, arg, fparTypeRefSubst, infCtx, cache);
                if (argType != null) {
                    infCtx.addConstraint((TypeArgument)fparTypeRefSubst, (TypeArgument)argType, Variance.CONTRA);
                }
            } else if (arg != null) {
                this.polyProcessor.processExpr(G, arg, null, infCtx, cache);
            }
            ++i;
        }
    }

    private void handleOnSolved(RuleEnvironment G, ASTMetaInfoCache cache, ParameterizedCallExpression callExpr, TypeRef resultTypeRef, Map<TypeVariable, InferenceVariable> typeParam2infVar, Optional<Map<InferenceVariable, TypeRef>> solution) {
        boolean _isPresent = solution.isPresent();
        if (_isPresent) {
            cache.storeType((TypableElement)callExpr, this.applySolution(resultTypeRef, G, (Map)solution.get()));
            Functions.Function1 _function = it -> (TypeRef)((Map)solution.get()).get(it);
            List inferredTypeArgs = IterableExtensions.toList((Iterable)IterableExtensions.map(typeParam2infVar.values(), (Functions.Function1)_function));
            cache.storeInferredTypeArgs(callExpr, inferredTypeArgs);
        } else {
            HashMap fakeSolution = CollectionLiterals.newHashMap();
            Set<Map.Entry<TypeVariable, InferenceVariable>> _entrySet = typeParam2infVar.entrySet();
            for (Map.Entry<TypeVariable, InferenceVariable> e : _entrySet) {
                fakeSolution.put(e.getValue(), TypeUtils.createTypeRef((Type)((Type)e.getKey()), (TypeArgument[])new TypeArgument[0]));
            }
            cache.storeType((TypableElement)callExpr, this.applySolution(resultTypeRef, G, fakeSolution));
            cache.storeInferredTypeArgs(callExpr, Collections.unmodifiableList(CollectionLiterals.newArrayList()));
        }
        EList _arguments = callExpr.getArguments();
        for (Argument arg : _arguments) {
            TypeRef exprType;
            Expression expr;
            Expression _expression = null;
            if (arg != null) {
                _expression = arg.getExpression();
            }
            if ((expr = _expression) == null || (exprType = this.getFinalResultTypeOfNestedPolyExpression(expr)) == null) continue;
            cache.storeType((TypableElement)arg, exprType);
        }
    }
}

