/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.postprocessing.AbstractPolyProcessor;
import org.eclipse.n4js.postprocessing.AbstractProcessor;
import org.eclipse.n4js.postprocessing.PolyProcessor;
import org.eclipse.n4js.ts.typeRefs.DeferredTypeRef;
import org.eclipse.n4js.ts.typeRefs.OptionalFieldStrategy;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.Versionable;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TStructGetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TStructuralType;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.TypeSystemHelper;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
class PolyProcessor_ObjectLiteral
extends AbstractPolyProcessor {
    @Inject
    private PolyProcessor polyProcessor;
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;

    PolyProcessor_ObjectLiteral() {
    }

    TypeRef processObjectLiteral(RuleEnvironment G, ObjectLiteral objLit, TypeRef expectedTypeRef, InferenceContext infCtx, ASTMetaInfoCache cache) {
        boolean _not;
        boolean _isPoly = this.isPoly((Expression)objLit);
        boolean bl = _not = !_isPoly;
        if (_not) {
            TypeRef result = (TypeRef)this.ts.type(G, (TypableElement)objLit).getValue();
            return result;
        }
        boolean haveUsableExpectedType = expectedTypeRef != null && (expectedTypeRef.isUseSiteStructuralTyping() || expectedTypeRef.isDefSiteStructuralTyping());
        boolean quickMode = !haveUsableExpectedType && !TypeUtils.isInferenceVariable((TypeRef)expectedTypeRef);
        ArrayList tMembers = CollectionLiterals.newArrayList();
        ArrayList props2InfVarOrFallbackType = CollectionLiterals.newArrayList();
        this.processProperties(G, cache, infCtx, objLit, tMembers, quickMode, props2InfVarOrFallbackType);
        this.linkGetterSetterPairs(infCtx, tMembers, quickMode);
        ParameterizedTypeRefStructural resultTypeRef = TypeUtils.createParameterizedTypeRefStructural((Type)RuleEnvironmentExtensions.objectType(G), (TypingStrategy)TypingStrategy.STRUCTURAL, (TStructMember[])((TStructMember[])Conversions.unwrapArray((Object)tMembers, TStructMember.class)));
        resultTypeRef.setASTNodeOptionalFieldStrategy(OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL);
        Consumer<Optional<Map<InferenceVariable, TypeRef>>> _function = solution -> this.handleOnSolved(G, cache, infCtx, objLit, quickMode, props2InfVarOrFallbackType, (Optional<Map<InferenceVariable, TypeRef>>)solution);
        infCtx.onSolved(_function);
        return resultTypeRef;
    }

    private void processProperties(RuleEnvironment G, ASTMetaInfoCache cache, InferenceContext infCtx, ObjectLiteral objLit, List<TStructMember> tMembers, boolean quickMode, List<Pair<PropertyAssignment, ? extends Versionable>> props2InfVarOrFallbackType) {
        EList _propertyAssignments = objLit.getPropertyAssignments();
        for (PropertyAssignment pa : _propertyAssignments) {
            boolean _isPoly;
            boolean _tripleNotEquals;
            if (pa == null) continue;
            TStructMember tMember = null;
            TStructMember _definedMember = pa.getDefinedMember();
            boolean bl = _tripleNotEquals = _definedMember != null;
            if (_tripleNotEquals) {
                tMember = (TStructMember)TypeUtils.copy((EObject)pa.getDefinedMember());
                tMembers.add(tMember);
            }
            if (!(_isPoly = this.isPoly((EObject)pa)) || tMember instanceof TMethod) continue;
            this.processNonMethodProperties(G, cache, infCtx, tMember, pa, quickMode, props2InfVarOrFallbackType);
        }
    }

    private void processNonMethodProperties(RuleEnvironment G, ASTMetaInfoCache cache, InferenceContext infCtx, TStructMember tMember, PropertyAssignment propAssignm, boolean quickMode, List<Pair<PropertyAssignment, ? extends Versionable>> props2InfVarOrFallbackType) {
        if (tMember != null) {
            TypeRef originalMemberType = this.getTypeOfMember((TMember)tMember);
            String _name = propAssignm.eClass().getName();
            String _plus = "type of " + _name;
            String _plus_1 = String.valueOf(_plus) + " in TModule should be a DeferredTypeRef";
            AbstractProcessor.assertTrueIfRigid(cache, _plus_1, originalMemberType instanceof DeferredTypeRef);
            if (!(originalMemberType instanceof DeferredTypeRef)) {
                return;
            }
        }
        if (!quickMode) {
            InferenceVariable iv = infCtx.newInferenceVariable();
            if (tMember != null) {
                this.setTypeOfMember((TMember)tMember, (TypeRef)TypeUtils.createTypeRef((Type)iv, (TypeArgument[])new TypeArgument[0]));
            }
            if (propAssignm instanceof PropertyNameValuePair) {
                boolean _tripleNotEquals;
                Expression _expression = ((PropertyNameValuePair)propAssignm).getExpression();
                boolean bl = _tripleNotEquals = _expression != null;
                if (_tripleNotEquals) {
                    TypeRef exprTypeRef = this.polyProcessor.processExpr(G, ((PropertyNameValuePair)propAssignm).getExpression(), (TypeRef)TypeUtils.createTypeRef((Type)iv, (TypeArgument[])new TypeArgument[0]), infCtx, cache);
                    infCtx.addConstraint((TypeArgument)exprTypeRef, (TypeArgument)TypeUtils.createTypeRef((Type)iv, (TypeArgument[])new TypeArgument[0]), Variance.CO);
                }
            }
            Pair _mappedTo = Pair.of((Object)propAssignm, (Object)iv);
            props2InfVarOrFallbackType.add((Pair<PropertyAssignment, ? extends Versionable>)_mappedTo);
        } else {
            ParameterizedTypeRef _anyTypeRef;
            TypeRef _declaredTypeOfOtherAccessorInPair;
            TypeRef _elvis;
            ParameterizedTypeRef _switchResult = null;
            boolean _matched = false;
            if (propAssignm instanceof PropertyNameValuePair) {
                boolean _tripleNotEquals_1;
                Expression _expression_1 = ((PropertyNameValuePair)propAssignm).getExpression();
                boolean bl = _tripleNotEquals_1 = _expression_1 != null;
                if (_tripleNotEquals_1) {
                    _matched = true;
                    _switchResult = this.polyProcessor.processExpr(G, ((PropertyNameValuePair)propAssignm).getExpression(), null, infCtx, cache);
                }
            }
            if (!_matched && propAssignm instanceof PropertyGetterDeclaration) {
                _matched = true;
                _elvis = null;
                _declaredTypeOfOtherAccessorInPair = this.getDeclaredTypeOfOtherAccessorInPair((org.eclipse.n4js.n4JS.FieldAccessor)propAssignm);
                if (_declaredTypeOfOtherAccessorInPair != null) {
                    _elvis = _declaredTypeOfOtherAccessorInPair;
                } else {
                    _anyTypeRef = RuleEnvironmentExtensions.anyTypeRef(G);
                    _elvis = _anyTypeRef;
                }
                _switchResult = _elvis;
            }
            if (!_matched && propAssignm instanceof PropertySetterDeclaration) {
                _matched = true;
                _elvis = null;
                _declaredTypeOfOtherAccessorInPair = this.getDeclaredTypeOfOtherAccessorInPair((org.eclipse.n4js.n4JS.FieldAccessor)propAssignm);
                if (_declaredTypeOfOtherAccessorInPair != null) {
                    _elvis = _declaredTypeOfOtherAccessorInPair;
                } else {
                    _anyTypeRef = RuleEnvironmentExtensions.anyTypeRef(G);
                    _elvis = _anyTypeRef;
                }
                _switchResult = _elvis;
            }
            if (!_matched) {
                _switchResult = RuleEnvironmentExtensions.anyTypeRef(G);
            }
            ParameterizedTypeRef fallbackType = _switchResult;
            if (tMember != null) {
                this.setTypeOfMember((TMember)tMember, (TypeRef)TypeUtils.copy((EObject)fallbackType));
            }
            Pair _mappedTo_1 = Pair.of((Object)propAssignm, (Object)fallbackType);
            props2InfVarOrFallbackType.add((Pair<PropertyAssignment, ? extends Versionable>)_mappedTo_1);
        }
    }

    private TypeRef getDeclaredTypeOfOtherAccessorInPair(org.eclipse.n4js.n4JS.FieldAccessor accAST) {
        FieldAccessor otherPair = this.findOtherAccessorInPair(accAST.getDefinedAccessor());
        EObject _astElement = null;
        if (otherPair != null) {
            _astElement = otherPair.getAstElement();
        }
        org.eclipse.n4js.n4JS.FieldAccessor otherPairAST = (org.eclipse.n4js.n4JS.FieldAccessor)_astElement;
        TypeRef _declaredTypeRef = null;
        if (otherPairAST != null) {
            _declaredTypeRef = otherPairAST.getDeclaredTypeRef();
        }
        TypeRef declTypeRef = _declaredTypeRef;
        return declTypeRef;
    }

    private FieldAccessor findOtherAccessorInPair(FieldAccessor acc) {
        EObject type;
        boolean _tripleNotEquals;
        String _name = null;
        if (acc != null) {
            _name = acc.getName();
        }
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals && (type = acc.eContainer()) instanceof ContainerType) {
            boolean lookForWriteAccess = acc instanceof TGetter;
            TMember result = ((ContainerType)type).findOwnedMember(acc.getName(), lookForWriteAccess, acc.isStatic());
            if (result instanceof FieldAccessor) {
                return (FieldAccessor)result;
            }
        }
        return null;
    }

    private void linkGetterSetterPairs(InferenceContext infCtx, List<TStructMember> tMembers, boolean quickMode) {
        if (!quickMode) {
            for (TStructMember tMember : tMembers) {
                FieldAccessor tOtherInPair;
                if (!(tMember instanceof TStructGetter) || (tOtherInPair = this.findOtherAccessorInPair((FieldAccessor)tMember)) == null) continue;
                TypeRef typeGetter = this.getTypeOfMember((TMember)tMember);
                TypeRef typeSetter = this.getTypeOfMember((TMember)tOtherInPair);
                if (!TypeUtils.isInferenceVariable((TypeRef)typeGetter) && !TypeUtils.isInferenceVariable((TypeRef)typeSetter)) continue;
                infCtx.addConstraint((TypeArgument)typeGetter, (TypeArgument)typeSetter, Variance.CO);
            }
        }
    }

    private void handleOnSolved(RuleEnvironment G, ASTMetaInfoCache cache, InferenceContext infCtx, ObjectLiteral objLit, boolean quickMode, List<? extends Pair<PropertyAssignment, ? extends Versionable>> props2InfVarOrFallbackType, Optional<Map<InferenceVariable, TypeRef>> solution) {
        for (Pair<PropertyAssignment, ? extends Versionable> pair : props2InfVarOrFallbackType) {
            PropertyAssignment propAssignm = (PropertyAssignment)pair.getKey();
            TStructMember memberInTModule = propAssignm.getDefinedMember();
            if (memberInTModule == null) continue;
            TypeRef memberType = this.getMemberType(G, solution, quickMode, pair);
            TypeRef memberTypeSane = this.tsh.sanitizeTypeOfVariableFieldProperty(G, (TypeArgument)memberType);
            Procedures.Procedure0 _function = () -> this.setTypeOfMember((TMember)memberInTModule, (TypeRef)TypeUtils.copy((EObject)memberTypeSane));
            EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{memberInTModule});
        }
        Type type = objLit.getDefinedType();
        ParameterizedTypeRefStructural resultFinal = TypeUtils.createParameterizedTypeRefStructural((Type)RuleEnvironmentExtensions.objectType(G), (TypingStrategy)TypingStrategy.STRUCTURAL, (TStructuralType)((TStructuralType)type));
        resultFinal.setASTNodeOptionalFieldStrategy(OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL);
        cache.storeType((TypableElement)objLit, (TypeRef)resultFinal);
        EList _propertyAssignments = objLit.getPropertyAssignments();
        for (PropertyAssignment currAss : _propertyAssignments) {
            boolean _tripleNotEquals;
            TStructMember _definedMember = currAss.getDefinedMember();
            boolean bl = _tripleNotEquals = _definedMember != null;
            if (_tripleNotEquals) {
                if (currAss instanceof PropertyMethodDeclaration) {
                    cache.storeType((TypableElement)currAss, (TypeRef)TypeUtils.createTypeRef((Type)((PropertyMethodDeclaration)currAss).getDefinedMember(), (TypeArgument[])new TypeArgument[0]));
                    continue;
                }
                cache.storeType((TypableElement)currAss, (TypeRef)TypeUtils.copy((EObject)this.getTypeOfMember((TMember)currAss.getDefinedMember())));
                continue;
            }
            cache.storeType((TypableElement)currAss, (TypeRef)TypeRefsFactory.eINSTANCE.createUnknownTypeRef());
        }
    }

    private TypeRef getMemberType(RuleEnvironment G, Optional<Map<InferenceVariable, TypeRef>> solution, boolean quickMode, Pair<PropertyAssignment, ? extends Versionable> prop2InfVarOrFallbackType) {
        Object memberType = null;
        PropertyAssignment propAssignm = (PropertyAssignment)prop2InfVarOrFallbackType.getKey();
        boolean _isPresent = solution.isPresent();
        if (_isPresent) {
            if (quickMode) {
                Versionable _value = (Versionable)prop2InfVarOrFallbackType.getValue();
                TypeRef fallbackType = (TypeRef)_value;
                memberType = propAssignm instanceof PropertyNameValuePair ? this.getFinalResultTypeOfNestedPolyExpression(((PropertyNameValuePair)propAssignm).getExpression()) : this.applySolution((TypeRef)TypeUtils.copy((EObject)fallbackType), G, (Map)solution.get());
            } else {
                Versionable _value_1 = (Versionable)prop2InfVarOrFallbackType.getValue();
                InferenceVariable infVar = (InferenceVariable)_value_1;
                TypeRef fromSolution = (TypeRef)((Map)solution.get()).get(infVar);
                if (propAssignm instanceof PropertyNameValuePair) {
                    TypeRef _xifexpression = null;
                    Expression _expression = ((PropertyNameValuePair)propAssignm).getExpression();
                    _xifexpression = _expression instanceof ObjectLiteral ? this.getFinalResultTypeOfNestedPolyExpression(((PropertyNameValuePair)propAssignm).getExpression()) : null;
                    TypeRef fromCache = _xifexpression;
                    memberType = fromCache != null && this.ts.equaltypeSucceeded(G, (TypeArgument)fromCache, (TypeArgument)fromSolution) ? fromCache : fromSolution;
                } else {
                    memberType = fromSolution;
                }
            }
        } else {
            memberType = propAssignm instanceof PropertyNameValuePair ? this.getFinalResultTypeOfNestedPolyExpression(((PropertyNameValuePair)propAssignm).getExpression()) : RuleEnvironmentExtensions.anyTypeRef(G);
        }
        return memberType;
    }
}

