/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.JSXElementName;
import org.eclipse.n4js.n4JS.JSXPropertyAttribute;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.MemberAccess;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4FieldAccessor;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableEnvironmentElement;
import org.eclipse.n4js.n4JS.extensions.SourceElementExtensions;
import org.eclipse.n4js.n4idl.scoping.FailedToInferContextVersionWrappingScope;
import org.eclipse.n4js.n4idl.scoping.MigrationScopeHelper;
import org.eclipse.n4js.n4idl.scoping.N4IDLVersionAwareScope;
import org.eclipse.n4js.n4idl.scoping.NonVersionAwareContextScope;
import org.eclipse.n4js.n4idl.versioning.MigrationUtils;
import org.eclipse.n4js.n4idl.versioning.VersionHelper;
import org.eclipse.n4js.n4idl.versioning.VersionUtils;
import org.eclipse.n4js.n4jsx.ReactHelper;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.IContentAssistScopeProvider;
import org.eclipse.n4js.scoping.TopLevelElementsCollector;
import org.eclipse.n4js.scoping.accessModifiers.MemberVisibilityChecker;
import org.eclipse.n4js.scoping.accessModifiers.VisibilityAwareCtorScope;
import org.eclipse.n4js.scoping.imports.ImportedElementsScopingHelper;
import org.eclipse.n4js.scoping.members.MemberScopingHelper;
import org.eclipse.n4js.scoping.utils.DynamicPseudoScope;
import org.eclipse.n4js.scoping.utils.LocallyKnownTypesScopingHelper;
import org.eclipse.n4js.scoping.utils.MainModuleAwareSelectableBasedScope;
import org.eclipse.n4js.scoping.utils.N4JSTypesScopeFilter;
import org.eclipse.n4js.scoping.utils.ProjectImportEnablingScope;
import org.eclipse.n4js.scoping.utils.ScopesHelper;
import org.eclipse.n4js.ts.scoping.ValidatingScope;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TStructMethod;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeDefs;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.EObjectDescriptionHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.validation.ValidatorMessageHelper;
import org.eclipse.n4js.xtext.scoping.FilteringScope;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractScopeProvider;
import org.eclipse.xtext.scoping.impl.IDelegatingScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class N4JSScopeProvider
extends AbstractScopeProvider
implements IDelegatingScopeProvider,
IContentAssistScopeProvider {
    public static final String NAMED_DELEGATE = "org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.delegate";
    @Inject
    private IResourceScopeCache cache;
    @Inject
    @Named(value="org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.delegate")
    private IScopeProvider delegate;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private N4JSModel n4jsModel;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    @Extension
    private N4JSTypesScopeFilter _n4JSTypesScopeFilter;
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private MemberScopingHelper memberScopingHelper;
    @Inject
    @Extension
    private LocallyKnownTypesScopingHelper locallyKnownTypesScopingHelper;
    @Inject
    @Extension
    private ImportedElementsScopingHelper _importedElementsScopingHelper;
    @Inject
    @Extension
    private SourceElementExtensions _sourceElementExtensions;
    @Inject
    private EObjectDescriptionHelper descriptionsHelper;
    @Inject
    @Extension
    private ReactHelper _reactHelper;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;
    @Inject
    private MemberVisibilityChecker checker;
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private TopLevelElementsCollector topLevelElementCollector;
    @Inject
    private ScopesHelper scopesHelper;
    @Inject
    private VersionHelper versionHelper;
    @Inject
    private ValidatorMessageHelper messageHelper;
    @Inject
    private MigrationScopeHelper migrationScopeHelper;

    protected IScope delegateGetScope(EObject context, EReference reference) {
        return this.delegate.getScope(context, reference);
    }

    public IScopeProvider getDelegate() {
        return this.delegate;
    }

    public IScope getScope(EObject context, EReference reference) {
        try {
            ResourceType resourceType = ResourceType.getResourceType(context);
            if (resourceType != null) {
                switch (resourceType) {
                    case N4JSX: {
                        return this.getN4JSXScope(context, reference);
                    }
                    case JSX: {
                        return this.getN4JSXScope(context, reference);
                    }
                    case N4IDL: {
                        return this.getN4IDLScope(context, reference);
                    }
                }
                return this.getN4JSScope(context, reference);
            }
            return this.getN4JSScope(context, reference);
        }
        catch (Throwable _t) {
            if (_t instanceof Error) {
                Error ex = (Error)_t;
                if (context != null && context.eResource().getErrors().isEmpty()) {
                    throw ex;
                }
            } else {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return IScope.NULLSCOPE;
        }
    }

    public IScope getN4JSScope(EObject context, EReference reference) {
        IScope maybeScopeShortcut = this.getScopeByShortcut(context, reference);
        if (maybeScopeShortcut != IScope.NULLSCOPE) {
            return maybeScopeShortcut;
        }
        return this.getScopeForContext(context, reference);
    }

    private IScope getScopeByShortcut(EObject context, EReference reference) {
        ModuleNamespaceVirtualType namespace;
        boolean _equals = Objects.equal((Object)reference, (Object)TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE);
        if (_equals && context instanceof ParameterizedTypeRef && (namespace = ((ParameterizedTypeRef)context).getAstNamespace()) != null) {
            return this.createScopeForNamespaceAccess(namespace, context);
        }
        if (Objects.equal((Object)reference, (Object)TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE) || Objects.equal((Object)reference, (Object)TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__AST_NAMESPACE)) {
            IScope _typeScope = this.getTypeScope(context, false);
            Predicate _typesFilterCriteria = this._n4JSTypesScopeFilter.getTypesFilterCriteria(context, reference);
            return new ValidatingScope(_typeScope, _typesFilterCriteria);
        }
        EClass _eReferenceType = reference.getEReferenceType();
        boolean _equals_1 = Objects.equal((Object)_eReferenceType, (Object)N4JSPackage.Literals.LABELLED_STATEMENT);
        if (_equals_1) {
            return this.scope_LabelledStatement(context);
        }
        return IScope.NULLSCOPE;
    }

    private IScope getScopeForContext(EObject context, EReference reference) {
        boolean _matched = false;
        if (context instanceof ImportDeclaration) {
            _matched = true;
            return this.scope_ImportedModule((ImportDeclaration)context, reference);
        }
        if (!_matched && context instanceof NamedImportSpecifier) {
            _matched = true;
            return this.scope_ImportedElement((NamedImportSpecifier)context, reference);
        }
        if (!_matched && context instanceof IdentifierRef) {
            _matched = true;
            return this.scope_IdentifierRef_id((IdentifierRef)context, reference);
        }
        if (!_matched && context instanceof ParameterizedPropertyAccessExpression) {
            _matched = true;
            return this.scope_PropertyAccessExpression_property((ParameterizedPropertyAccessExpression)context, reference);
        }
        if (!_matched && context instanceof N4FieldAccessor) {
            _matched = true;
            return Scopes.scopeFor((Iterable)((N4ClassifierDefinition)EcoreUtil2.getContainerOfType((EObject)context, N4ClassifierDefinition.class)).getOwnedFields());
        }
        return IScope.NULLSCOPE;
    }

    @Override
    public IScope getScopeForContentAssist(EObject context, EReference reference) {
        IScope scope = this.getScope(context, reference);
        if (scope == IScope.NULLSCOPE) {
            boolean _equals = Objects.equal((Object)reference, (Object)N4JSPackage.Literals.IMPORT_DECLARATION__MODULE);
            if (_equals) {
                return this.scope_ImportedAndCurrentModule(context, reference);
            }
            boolean _matched = false;
            if (context instanceof Script) {
                _matched = true;
                return this.scope_EObject_id(context, reference);
            }
            if (!_matched && context instanceof N4TypeDeclaration) {
                _matched = true;
                return this.scope_EObject_id(context, reference);
            }
            if (!_matched && context instanceof VariableDeclaration) {
                _matched = true;
                return this.scope_EObject_id(context, reference);
            }
            if (!_matched && context instanceof Statement) {
                _matched = true;
                return this.scope_EObject_id(context, reference);
            }
            if (!_matched && context instanceof NewExpression) {
                _matched = true;
                return this.scope_EObject_id(context, reference);
            }
            if (!_matched && context instanceof ParameterizedCallExpression) {
                _matched = true;
                return this.scope_EObject_id(context, reference);
            }
            if (!_matched && context instanceof Argument) {
                _matched = true;
                return this.scope_EObject_id(context, reference);
            }
            if (!_matched && context instanceof Expression) {
                _matched = true;
                return this.scope_EObject_id(context, reference);
            }
        }
        return scope;
    }

    public IScope getScopeForImplicitImports(N4JSResource resource) {
        return this.scope_ImportedModule(resource, (com.google.common.base.Optional<ImportDeclaration>)com.google.common.base.Optional.absent());
    }

    private IScope scope_LabelledStatement(EObject context) {
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)context);
        IScope parent = this.getAllLabels((Script)_rootContainer);
        HashSet names = CollectionLiterals.newHashSet();
        ArrayList elements = CollectionLiterals.newArrayList();
        EObject current = context;
        while (current != null) {
            boolean _matched = false;
            if (current instanceof LabelledStatement) {
                _matched = true;
                boolean _add = names.add(((LabelledStatement)current).getName());
                if (_add) {
                    IEObjectDescription _create = EObjectDescription.create((String)((LabelledStatement)current).getName(), (EObject)current);
                    elements.add(_create);
                }
            }
            current = current.eContainer();
        }
        boolean _isEmpty = elements.isEmpty();
        if (_isEmpty) {
            return parent;
        }
        SimpleScope result = new SimpleScope(parent, (Iterable)elements);
        return result;
    }

    private IScope getAllLabels(Script script) {
        return Scopes.scopeFor((Iterable)IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)script.eAllContents(), LabelledStatement.class)));
    }

    private IScope scope_ImportedModule(ImportDeclaration importDeclaration, EReference reference) {
        Resource _eResource = importDeclaration.eResource();
        N4JSResource resource = (N4JSResource)_eResource;
        IScope projectImportEnabledScope = this.scope_ImportedModule(resource, (com.google.common.base.Optional<ImportDeclaration>)com.google.common.base.Optional.of((Object)importDeclaration));
        Predicate _function = it -> {
            boolean _isDescriptionOfModuleWith;
            boolean _xifexpression = false;
            _xifexpression = it == null ? false : !(_isDescriptionOfModuleWith = this.descriptionsHelper.isDescriptionOfModuleWith((IEObjectDescription)it, (EObject)importDeclaration));
            return _xifexpression;
        };
        return new FilteringScope(projectImportEnabledScope, _function);
    }

    private IScope scope_ImportedModule(N4JSResource resource, com.google.common.base.Optional<ImportDeclaration> importDeclaration) {
        EReference reference = N4JSPackage.eINSTANCE.getImportDeclaration_Module();
        IScope initialScope = this.scope_ImportedAndCurrentModule((EObject)resource.getScript(), reference);
        IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions((Resource)resource);
        IScope delegateMainModuleAwareScope = MainModuleAwareSelectableBasedScope.createMainModuleAwareScope(initialScope, (ISelectable)resourceDescriptions, reference.getEReferenceType());
        IScope projectImportEnabledScope = ProjectImportEnablingScope.create(this.n4jsCore, this.n4jsModel, (Resource)resource, importDeclaration, initialScope, delegateMainModuleAwareScope);
        return projectImportEnabledScope;
    }

    private IScope scope_ImportedAndCurrentModule(EObject importDeclaration, EReference reference) {
        return this.delegateGetScope(importDeclaration, reference);
    }

    protected IScope scope_ImportedElement(NamedImportSpecifier specifier, EReference reference) {
        ImportDeclaration declaration = (ImportDeclaration)EcoreUtil2.getContainerOfType((EObject)specifier, ImportDeclaration.class);
        return this.scope_AllTopLevelElementsFromModule(declaration.getModule(), (EObject)declaration);
    }

    private IScope scope_IdentifierRef_id(IdentifierRef identifierRef, EReference ref) {
        VariableEnvironmentElement vee = this.ancestor((EObject)identifierRef, VariableEnvironmentElement.class);
        IScope scope = this.getLexicalEnvironmentScope(vee, (EObject)identifierRef, ref);
        EObject _eContainer = identifierRef.eContainer();
        if (_eContainer instanceof NewExpression) {
            EObject _eContainer_1 = identifierRef.eContainer();
            NewExpression newExpr = (NewExpression)_eContainer_1;
            VisibilityAwareCtorScope vacs = new VisibilityAwareCtorScope(scope, this.checker, this.containerTypesHelper, newExpr);
            return vacs;
        }
        return this.getLexicalEnvironmentScope(vee, (EObject)identifierRef, ref);
    }

    private IScope scope_EObject_id(EObject obj, EReference ref) {
        VariableEnvironmentElement _xifexpression = null;
        _xifexpression = obj instanceof VariableEnvironmentElement ? (VariableEnvironmentElement)obj : this.ancestor(obj, VariableEnvironmentElement.class);
        VariableEnvironmentElement vee = _xifexpression;
        return this.getLexicalEnvironmentScope(vee, obj, ref);
    }

    private IScope getLexicalEnvironmentScope(VariableEnvironmentElement vee, EObject context, EReference ref) {
        if (vee == null) {
            return IScope.NULLSCOPE;
        }
        Pair _mappedTo = Pair.of((Object)"scope_IdentifierRef_id", (Object)vee);
        Provider _function = () -> this.buildLexicalEnvironmentScope(vee, context, ref);
        return (IScope)this.cache.get((Object)_mappedTo, vee.eResource(), _function);
    }

    private IScope buildLexicalEnvironmentScope(VariableEnvironmentElement vee, EObject context, EReference reference) {
        ArrayList scopeLists = CollectionLiterals.newArrayList();
        this.collectLexialEnvironmentsScopeLists(vee, scopeLists);
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)vee);
        Script script = (Script)_rootContainer;
        IScope baseScope = this.getScriptBaseScope(script, context, reference);
        IScope scope = this._importedElementsScopingHelper.getImportedIdentifiables(baseScope, script);
        List _reverseView = ListExtensions.reverseView((List)scopeLists);
        for (Iterable scopeList : _reverseView) {
            scope = this.scopesHelper.mapBasedScopeFor(context, scope, scopeList);
        }
        return scope;
    }

    private IScope getScriptBaseScope(Script script, EObject context, EReference ref) {
        IScope globalScope = this.delegate.getScope((EObject)script, ref);
        boolean _activateDynamicPseudoScope = this.jsVariantHelper.activateDynamicPseudoScope(context);
        if (_activateDynamicPseudoScope) {
            return new DynamicPseudoScope(globalScope);
        }
        return globalScope;
    }

    private List<Iterable<IEObjectDescription>> collectLexialEnvironmentsScopeLists(VariableEnvironmentElement vee, List<Iterable<IEObjectDescription>> result) {
        List<Iterable<IEObjectDescription>> _xblockexpression = null;
        result.add(Scopes.scopedElementsFor(this._sourceElementExtensions.collectVisibleIdentifiableElements(vee)));
        result.add(Scopes.scopedElementsFor(this._sourceElementExtensions.collectLocalArguments(vee)));
        VariableEnvironmentElement parent = this.ancestor((EObject)vee, VariableEnvironmentElement.class);
        List<Iterable<IEObjectDescription>> _xifexpression = null;
        if (parent != null) {
            _xifexpression = this.collectLexialEnvironmentsScopeLists(parent, result);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private IScope scope_AllTopLevelElementsFromModule(TModule importedModule, EObject context) {
        if (importedModule == null) {
            return IScope.NULLSCOPE;
        }
        IScope topLevelElementsScope = this.scopesHelper.mapBasedScopeFor((EObject)importedModule, IScope.NULLSCOPE, this.topLevelElementCollector.getTopLevelElements(importedModule, context.eResource()));
        if (!this.jsVariantHelper.allowVersionedTypes(context) && this.jsVariantHelper.allowVersionedTypes((EObject)importedModule)) {
            return new NonVersionAwareContextScope(topLevelElementsScope, false, this.messageHelper);
        }
        return topLevelElementsScope;
    }

    private IScope scope_PropertyAccessExpression_property(ParameterizedPropertyAccessExpression propertyAccess, EReference ref) {
        IdentifiableElement id;
        Expression receiver = propertyAccess.getTarget();
        if (receiver instanceof IdentifierRef && (id = ((IdentifierRef)receiver).getId()) instanceof ModuleNamespaceVirtualType) {
            return this.createScopeForNamespaceAccess((ModuleNamespaceVirtualType)id, (EObject)propertyAccess);
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)propertyAccess);
        TypeRef typeRefRaw = (TypeRef)this.ts.type(G, (TypableElement)receiver).getValue();
        TypeRef _xifexpression = null;
        _xifexpression = typeRefRaw != null ? (TypeRef)this.ts.upperBound(G, (TypeArgument)typeRefRaw).getValue() : null;
        TypeRef typeRef = _xifexpression;
        boolean staticAccess = typeRef instanceof TypeTypeRef;
        TypingStrategy _typingStrategy = typeRef.getTypingStrategy();
        boolean structFieldInitMode = _typingStrategy == TypingStrategy.STRUCTURAL_FIELD_INITIALIZER;
        boolean checkVisibility = true;
        return this.memberScopingHelper.createMemberScope(typeRef, (MemberAccess)propertyAccess, true, staticAccess, structFieldInitMode);
    }

    private IScope createScopeForNamespaceAccess(ModuleNamespaceVirtualType namespace, EObject context) {
        TModule module = namespace.getModule();
        IScope _xifexpression = null;
        if (module != null && !module.eIsProxy()) {
            _xifexpression = this.scope_AllTopLevelElementsFromModule(module, context);
        } else {
            Object _xifexpression_1 = null;
            boolean _eIsProxy = namespace.eIsProxy();
            _xifexpression_1 = _eIsProxy ? new DynamicPseudoScope() : IScope.NULLSCOPE;
            _xifexpression = _xifexpression_1;
        }
        IScope result = _xifexpression;
        if (namespace.isDeclaredDynamic() && !(result instanceof DynamicPseudoScope)) {
            return new DynamicPseudoScope(result);
        }
        return result;
    }

    public IScope getTypeScope(EObject context, boolean fromStaticContext) {
        boolean _matched = false;
        if (context instanceof Script) {
            _matched = true;
            return this.locallyKnownTypesScopingHelper.scopeWithLocallyKnownTypes((Script)context, this.delegate);
        }
        if (!_matched && context instanceof TModule) {
            _matched = true;
            EObject _astElement = ((TModule)context).getAstElement();
            return this.locallyKnownTypesScopingHelper.scopeWithLocallyKnownTypes((Script)_astElement, this.delegate);
        }
        if (!_matched && context instanceof N4FieldDeclaration) {
            _matched = true;
            boolean isStaticContext = ((N4FieldDeclaration)context).isStatic();
            return this.getTypeScope(((N4FieldDeclaration)context).eContainer(), isStaticContext);
        }
        if (!_matched && context instanceof N4FieldAccessor) {
            _matched = true;
            boolean isStaticContext = ((N4FieldAccessor)context).isStatic();
            return this.getTypeScope(((N4FieldAccessor)context).eContainer(), isStaticContext);
        }
        if (!_matched && context instanceof TypeDefiningElement) {
            _matched = true;
            boolean isStaticContext = context instanceof N4MemberDeclaration && ((N4MemberDeclaration)context).isStatic();
            IScope parent = this.getTypeScope(((TypeDefiningElement)context).eContainer(), isStaticContext);
            if (context instanceof N4ClassDeclaration && (N4JSLanguageUtils.isPolyfill((AnnotableElement)context) || N4JSLanguageUtils.isStaticPolyfill((AnnotableElement)context))) {
                TClass _definedTypeAsClass = ((N4ClassDeclaration)context).getDefinedTypeAsClass();
                ParameterizedTypeRef _superClassRef = null;
                if (_definedTypeAsClass != null) {
                    _superClassRef = _definedTypeAsClass.getSuperClassRef();
                }
                Type _declaredType = null;
                if (_superClassRef != null) {
                    _declaredType = _superClassRef.getDeclaredType();
                }
                Type filledType = _declaredType;
                return this.locallyKnownTypesScopingHelper.scopeWithTypeAndItsTypeVariables(parent, filledType, fromStaticContext);
            }
            return this.locallyKnownTypesScopingHelper.scopeWithTypeAndItsTypeVariables(parent, ((TypeDefiningElement)context).getDefinedType(), fromStaticContext);
        }
        if (!_matched && context instanceof TStructMethod) {
            _matched = true;
            IScope parent = this.getTypeScope(((TStructMethod)context).eContainer(), fromStaticContext);
            return this.locallyKnownTypesScopingHelper.scopeWithTypeVarsOfTStructMethod(parent, (TStructMethod)context);
        }
        if (!_matched && context instanceof FunctionTypeExpression) {
            _matched = true;
            IScope parent = this.getTypeScope(((FunctionTypeExpression)context).eContainer(), fromStaticContext);
            return this.locallyKnownTypesScopingHelper.scopeWithTypeVarsOfFunctionTypeExpression(parent, (FunctionTypeExpression)context);
        }
        if (!_matched && context instanceof TypeDefs) {
            _matched = true;
            return BuiltInTypeScope.get((ResourceSet)((TypeDefs)context).eResource().getResourceSet());
        }
        EObject container = context.eContainer();
        if (container instanceof N4ClassDeclaration && (N4JSLanguageUtils.isPolyfill((AnnotableElement)container) || N4JSLanguageUtils.isStaticPolyfill((AnnotableElement)container))) {
            boolean _tripleEquals;
            boolean _contains = ((N4ClassDeclaration)container).getTypeVars().contains((Object)context);
            if (_contains) {
                IScope parent = this.getTypeScope(context.eContainer(), false);
                return this.locallyKnownTypesScopingHelper.scopeWithTypeAndItsTypeVariables(parent, ((N4ClassDeclaration)container).getDefinedType(), fromStaticContext);
            }
            ParameterizedTypeRef _superClassRef = ((N4ClassDeclaration)container).getSuperClassRef();
            boolean bl = _tripleEquals = _superClassRef == context;
            if (_tripleEquals) {
                Script script = (Script)EcoreUtil2.getContainerOfType((EObject)container, Script.class);
                IScope parent_1 = this.locallyKnownTypesScopingHelper.scopeWithLocallyKnownTypesForPolyfillSuperRef(script, this.delegate, ((N4ClassDeclaration)container).getDefinedType());
                return parent_1;
            }
        }
        return this.getTypeScope(container, fromStaticContext);
    }

    private <T extends EObject> T ancestor(EObject obj, Class<T> ancestorType) {
        if (obj == null) {
            return null;
        }
        return (T)EcoreUtil2.getContainerOfType((EObject)obj.eContainer(), ancestorType);
    }

    private IScope getN4IDLScope(EObject context, EReference reference) {
        boolean _not;
        IScope contextVersionScope = this.getN4IDLContextVersionScope(context, reference);
        boolean _isVersionAwareContext = VersionUtils.isVersionAwareContext(context);
        boolean bl = _not = !_isVersionAwareContext;
        if (_not) {
            return new NonVersionAwareContextScope(contextVersionScope, true, this.messageHelper);
        }
        Optional<FunctionDeclaration> migrationDeclaration = MigrationUtils.getMigrationDeclaration(context);
        boolean _isPresent = migrationDeclaration.isPresent();
        if (_isPresent) {
            if (context instanceof IdentifierRef && MigrationUtils.isMigrateCallIdentifier((IdentifierRef)context)) {
                EObject _eContainer = context.eContainer();
                ParameterizedCallExpression callExpression = (ParameterizedCallExpression)_eContainer;
                return this.migrationScopeHelper.migrationsScope((List<Argument>)callExpression.getArguments(), context);
            }
            return this.migrationScopeHelper.migrationContextAwareScope(migrationDeclaration.get(), contextVersionScope);
        }
        return contextVersionScope;
    }

    private IScope getN4IDLContextVersionScope(EObject context, EReference reference) {
        IScope scope = this.getN4JSScope(context, reference);
        boolean _equals = Objects.equal((Object)scope, (Object)IScope.NULLSCOPE);
        if (_equals) {
            return scope;
        }
        if (reference == TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE || reference == N4JSPackage.Literals.IDENTIFIER_REF__ID) {
            com.google.common.base.Optional<Integer> contextVersion = this.versionHelper.computeMaximumVersion(context);
            Integer _or = (Integer)contextVersion.or((Object)Integer.MAX_VALUE);
            N4IDLVersionAwareScope versionAwareScope = new N4IDLVersionAwareScope(scope, _or);
            boolean _isPresent = contextVersion.isPresent();
            if (_isPresent) {
                return versionAwareScope;
            }
            return new FailedToInferContextVersionWrappingScope(scope);
        }
        return scope;
    }

    private IScope getN4JSXScope(EObject context, EReference reference) {
        IScope jsxPropertyAttributeScope = this.getJSXPropertyAttributeScope(context, reference);
        if (jsxPropertyAttributeScope != IScope.NULLSCOPE) {
            return jsxPropertyAttributeScope;
        }
        IScope jsxElementScope = this.getJSXElementScope(context, reference);
        if (jsxElementScope != IScope.NULLSCOPE) {
            return jsxElementScope;
        }
        return this.getN4JSScope(context, reference);
    }

    private IScope getJSXPropertyAttributeScope(EObject context, EReference reference) {
        boolean _equals = Objects.equal((Object)reference, (Object)N4JSPackage.Literals.JSX_PROPERTY_ATTRIBUTE__PROPERTY);
        if (_equals && context instanceof JSXPropertyAttribute) {
            EObject _eContainer = ((JSXPropertyAttribute)context).eContainer();
            JSXElement jsxElem = (JSXElement)_eContainer;
            TypeRef propsTypeRef = this._reactHelper.getPropsType(jsxElem);
            boolean checkVisibility = true;
            boolean staticAccess = false;
            boolean structFieldInitMode = false;
            if (propsTypeRef != null) {
                IScope memberScope = this.memberScopingHelper.createMemberScope(propsTypeRef, (MemberAccess)context, true, false, false);
                return new DynamicPseudoScope(memberScope);
            }
            IScope scope = this.getN4JSScope(context, reference);
            return new DynamicPseudoScope(scope);
        }
        return IScope.NULLSCOPE;
    }

    private IScope getJSXElementScope(EObject context, EReference reference) {
        boolean _tripleEquals;
        JSXElementName _containerOfType = (JSXElementName)EcoreUtil2.getContainerOfType((EObject)context, JSXElementName.class);
        boolean bl = _tripleEquals = _containerOfType == null;
        if (_tripleEquals) {
            return IScope.NULLSCOPE;
        }
        IScope scope = this.getN4JSScope(context, reference);
        return new DynamicPseudoScope(scope);
    }
}

