/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.postprocessing.ASTMetaInfoUtils;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeVariableMapping;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.utils.TypeCompareHelper;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.TypeSystemHelperStrategy;
import org.eclipse.n4js.utils.RecursionGuard;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;

public class GenericsComputer
extends TypeSystemHelperStrategy {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    @Extension
    private TypeCompareHelper _typeCompareHelper;

    public void addSubstitutions(RuleEnvironment G, TypeRef typeRef) {
        Type declType = typeRef.getDeclaredType();
        if (typeRef instanceof BoundThisTypeRef) {
            this.addSubstitutions(G, (TypeRef)((BoundThisTypeRef)typeRef).getActualThisTypeRef());
        } else if (declType instanceof TypeVariable) {
            TypeRef currBound = ((TypeVariable)declType).getDeclaredUpperBound();
            if (currBound != null) {
                this.addSubstitutions(G, currBound);
            }
        } else if (declType instanceof TClassifier) {
            ArrayList<TypeRef> _collectSuperTypeRefs = this.collectSuperTypeRefs(typeRef);
            for (TypeRef currBaseType : _collectSuperTypeRefs) {
                this.primAddSubstitutions(G, currBaseType);
            }
        } else {
            this.primAddSubstitutions(G, typeRef);
        }
    }

    private void primAddSubstitutions(RuleEnvironment G, TypeRef typeRef) {
        if (typeRef instanceof ParameterizedTypeRef) {
            Type gen;
            boolean _not;
            boolean _isEmpty = ((ParameterizedTypeRef)typeRef).getTypeArgs().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not && (gen = ((ParameterizedTypeRef)typeRef).getDeclaredType()) instanceof ContainerType) {
                Iterator varIter = ((ContainerType)gen).getTypeVars().iterator();
                EList _typeArgs = ((ParameterizedTypeRef)typeRef).getTypeArgs();
                for (TypeArgument typeArg : _typeArgs) {
                    boolean _hasNext = varIter.hasNext();
                    if (!_hasNext) continue;
                    TypeVariable typeVar = (TypeVariable)varIter.next();
                    this.addSubstitution(G, typeVar, typeArg);
                }
            }
            if (typeRef instanceof StructuralTypeRef) {
                this.restorePostponedSubstitutionsFrom(G, (StructuralTypeRef)typeRef);
            }
        }
    }

    private boolean addSubstitution(RuleEnvironment G, TypeVariable typeVar, TypeArgument typeArg) {
        Object currSubstitute;
        boolean _xblockexpression = false;
        TypeArgument actualTypeArg = typeArg;
        while (RuleEnvironmentExtensions.hasSubstitutionFor(G, actualTypeArg)) {
            TypeRef actualTypeArgCasted = (TypeRef)actualTypeArg;
            Object fromEnv = G.getEnvironment().get(actualTypeArgCasted.getDeclaredType());
            TypeRef _xifexpression = null;
            _xifexpression = fromEnv instanceof TypeRef ? TypeUtils.mergeTypeModifiers((TypeRef)((TypeRef)fromEnv), (TypeRef)actualTypeArgCasted) : (TypeRef)fromEnv;
            actualTypeArg = _xifexpression;
        }
        if (actualTypeArg instanceof Wildcard) {
            actualTypeArg = TypeUtils.captureWildcard((TypeVariable)typeVar, (TypeArgument)actualTypeArg);
        }
        if ((currSubstitute = G.get((Object)typeVar)) == typeVar) {
            currSubstitute = null;
        }
        _xblockexpression = G.add((Object)typeVar, this.mergeTypeArgs(currSubstitute, actualTypeArg));
        return _xblockexpression;
    }

    private Object mergeTypeArgs(Object ... typeArgs) {
        boolean _greaterEqualsThan;
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList();
        Object[] objectArray = typeArgs;
        int n = typeArgs.length;
        int n2 = 0;
        while (n2 < n) {
            Object currTypeArg = objectArray[n2];
            List _xifexpression = null;
            _xifexpression = currTypeArg instanceof Collection ? (List)currTypeArg : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{currTypeArg}));
            List l = _xifexpression;
            for (Object currO : l) {
                if (currO == null || this.typeRefAwareContains(result, currO)) continue;
                result.add(currO);
            }
            ++n2;
        }
        ArrayList _xifexpression = null;
        int _size = result.size();
        boolean bl = _greaterEqualsThan = _size >= 2;
        if (_greaterEqualsThan) {
            _xifexpression = result;
        } else {
            Object _xifexpression_1 = null;
            int _size_1 = result.size();
            boolean _tripleEquals = _size_1 == 1;
            _xifexpression_1 = _tripleEquals ? result.get(0) : null;
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private boolean typeRefAwareContains(Collection<?> l, Object o) {
        if (o instanceof TypeRef) {
            for (Object currO : l) {
                boolean _tripleEquals;
                if (!(currO instanceof TypeRef)) continue;
                int _compare = this._typeCompareHelper.compare((TypeArgument)currO, (TypeArgument)o);
                boolean bl = _tripleEquals = _compare == 0;
                if (!_tripleEquals) continue;
                return true;
            }
            return false;
        }
        return l.contains(o);
    }

    private ArrayList<TypeRef> collectSuperTypeRefs(TypeRef typeRef) {
        ArrayList result = CollectionLiterals.newArrayList();
        RecursionGuard _recursionGuard = new RecursionGuard();
        this.primCollectSuperTypeRefs(typeRef, result, (RecursionGuard<TypeRef>)_recursionGuard);
        return result;
    }

    private void primCollectSuperTypeRefs(TypeRef typeRef, List<? super TypeRef> addHere, RecursionGuard<TypeRef> guard) {
        boolean _tryNext = guard.tryNext((Object)typeRef);
        if (_tryNext) {
            addHere.add((TypeRef)typeRef);
            Type _declaredType = null;
            if (typeRef != null) {
                _declaredType = typeRef.getDeclaredType();
            }
            Iterable<ParameterizedTypeRef> _allSuperTypes = this.getAllSuperTypes(_declaredType);
            for (ParameterizedTypeRef currSuperTypeRef : _allSuperTypes) {
                this.primCollectSuperTypeRefs((TypeRef)currSuperTypeRef, addHere, guard);
            }
            guard.done((Object)typeRef);
        }
    }

    private Iterable<ParameterizedTypeRef> getAllSuperTypes(Type type) {
        Object _switchResult = null;
        boolean _matched = false;
        if (type instanceof TClass) {
            boolean _tripleNotEquals;
            _matched = true;
            List _xifexpression = null;
            ParameterizedTypeRef _superClassRef = ((TClass)type).getSuperClassRef();
            boolean bl = _tripleNotEquals = _superClassRef != null;
            if (_tripleNotEquals) {
                ParameterizedTypeRef _superClassRef_1 = ((TClass)type).getSuperClassRef();
                _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ParameterizedTypeRef[]{_superClassRef_1}));
            } else {
                _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
            EList _implementedInterfaceRefs = ((TClass)type).getImplementedInterfaceRefs();
            _switchResult = Iterables.concat(_xifexpression, (Iterable)_implementedInterfaceRefs);
        }
        if (!_matched && type instanceof TInterface) {
            _matched = true;
            _switchResult = ((TInterface)type).getSuperInterfaceRefs();
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _switchResult;
    }

    public void addSubstitutions(RuleEnvironment G, ParameterizedPropertyAccessExpression paExpr) {
        IdentifiableElement prop;
        boolean _isParameterized = paExpr.isParameterized();
        if (_isParameterized && (prop = paExpr.getProperty()) instanceof Type) {
            RuleEnvironmentExtensions.addTypeMappings(G, (List<? extends TypeVariable>)((Type)prop).getTypeVars(), (List<? extends TypeArgument>)paExpr.getTypeArgs());
        }
    }

    public void addSubstitutions(RuleEnvironment G, ParameterizedCallExpression callExpr, TypeRef targetTypeRef) {
        if (G == null || callExpr == null) {
            return;
        }
        TypeRef _xifexpression = null;
        if (targetTypeRef != null) {
            _xifexpression = targetTypeRef;
        } else {
            RuleEnvironment _ruleEnvironment = new RuleEnvironment(G);
            _xifexpression = (TypeRef)this.ts.type(_ruleEnvironment, (TypableElement)callExpr.getTarget()).getValue();
        }
        TypeRef actualTargetTypeRef = _xifexpression;
        if (!(actualTargetTypeRef instanceof FunctionTypeExprOrRef)) {
            return;
        }
        FunctionTypeExprOrRef F = (FunctionTypeExprOrRef)actualTargetTypeRef;
        TypeRef _returnTypeRef = F.getReturnTypeRef();
        if (_returnTypeRef instanceof StructuralTypeRef) {
            TypeRef _returnTypeRef_1 = F.getReturnTypeRef();
            this.restorePostponedSubstitutionsFrom(G, (StructuralTypeRef)_returnTypeRef_1);
        }
        EList _fpars = F.getFpars();
        for (TFormalParameter currFpar : _fpars) {
            TypeRef _typeRef = currFpar.getTypeRef();
            if (!(_typeRef instanceof StructuralTypeRef)) continue;
            TypeRef _typeRef_1 = currFpar.getTypeRef();
            this.restorePostponedSubstitutionsFrom(G, (StructuralTypeRef)_typeRef_1);
        }
        boolean _isGeneric = F.isGeneric();
        if (_isGeneric) {
            Object _xifexpression_1 = null;
            boolean _isParameterized = callExpr.isParameterized();
            if (_isParameterized) {
                _xifexpression_1 = callExpr.getTypeArgs();
            } else {
                List<Object> _elvis = null;
                List<TypeRef> _inferredTypeArgs = ASTMetaInfoUtils.getInferredTypeArgs(callExpr);
                _elvis = _inferredTypeArgs != null ? _inferredTypeArgs : Collections.unmodifiableList(CollectionLiterals.newArrayList());
                _xifexpression_1 = _elvis;
            }
            EList typeArgs = _xifexpression_1;
            RuleEnvironmentExtensions.addTypeMappings(G, (List<? extends TypeVariable>)F.getTypeVars(), (List<? extends TypeArgument>)typeArgs);
        }
    }

    public TypeRef substTypeVariablesInStructuralMembers(RuleEnvironment G, StructuralTypeRef typeRef) {
        int _size_1;
        boolean _tripleEquals;
        if (typeRef.getStructuralMembers().isEmpty() && typeRef.getPostponedSubstitutions().isEmpty()) {
            return (TypeRef)typeRef;
        }
        StructuralTypeRef result = (StructuralTypeRef)TypeUtils.copy((EObject)typeRef);
        int _size = result.getGenStructuralMembers().size();
        boolean bl = _tripleEquals = _size == (_size_1 = result.getStructuralMembers().size());
        if (_tripleEquals) {
            Consumer<TStructMember> _function = member -> {
                ArrayList l = CollectionLiterals.newArrayList();
                TreeIterator iter = member.eAllContents();
                while (iter.hasNext()) {
                    EObject obj = (EObject)iter.next();
                    if (!(obj instanceof TypeArgument)) continue;
                    l.add((TypeArgument)obj);
                    iter.prune();
                }
                Consumer<TypeArgument> _function_1 = ta -> {
                    TypeArgument taSubst = (TypeArgument)this.ts.substTypeVariables(G, (TypeArgument)ta).getValue();
                    if (taSubst != null && taSubst != ta) {
                        EcoreUtil.replace((EObject)ta, (EObject)taSubst);
                    }
                };
                l.forEach(_function_1);
            };
            result.getGenStructuralMembers().forEach(_function);
        } else {
            this.storePostponedSubstitutionsIn(G, result);
        }
        return (TypeRef)result;
    }

    public void storePostponedSubstitutionsIn(RuleEnvironment G, StructuralTypeRef typeRef) {
        Set typeVarsInMembers = TypeUtils.getTypeVarsInStructMembers((StructuralTypeRef)typeRef);
        Predicate<TypeVariable> _function = currVar -> typeRef.hasPostponedSubstitutionFor(currVar);
        typeVarsInMembers.removeIf(_function);
        ArrayList bindings = CollectionLiterals.newArrayList();
        for (TypeVariable currVar2 : typeVarsInMembers) {
            Object currArg = G.get((Object)currVar2);
            if (!(currArg instanceof TypeArgument)) continue;
            TypeArgument currArgCpy = (TypeArgument)TypeUtils.copy((EObject)((TypeArgument)currArg));
            if (currArgCpy instanceof StructuralTypeRef) {
                this.storePostponedSubstitutionsIn(G, (StructuralTypeRef)currArgCpy);
            }
            TypeVariableMapping _createTypeVariableMapping = TypeUtils.createTypeVariableMapping((TypeVariable)currVar2, (TypeArgument)currArgCpy);
            bindings.add(_createTypeVariableMapping);
        }
        EList _postponedSubstitutions = typeRef.getPostponedSubstitutions();
        Iterables.addAll((Collection)_postponedSubstitutions, (Iterable)bindings);
        EList _postponedSubstitutions_1 = typeRef.getPostponedSubstitutions();
        for (TypeVariableMapping tvmapping : _postponedSubstitutions_1) {
            TypeArgument typeArgSubst = (TypeArgument)this.ts.substTypeVariables(G, tvmapping.getTypeArg()).getValue();
            if (typeArgSubst == null || typeArgSubst == tvmapping.getTypeArg()) continue;
            tvmapping.setTypeArg(typeArgSubst);
        }
    }

    public void restorePostponedSubstitutionsFrom(RuleEnvironment G, StructuralTypeRef typeRef) {
        Consumer<TypeVariableMapping> _function = currMapping -> G.add((Object)currMapping.getTypeVar(), (Object)TypeUtils.copy((EObject)currMapping.getTypeArg()));
        typeRef.getPostponedSubstitutions().forEach(_function);
    }

    TypeRef bindTypeVariables(RuleEnvironment G, TypeRef typeRef) {
        ParameterizedTypeRef _switchResult = null;
        boolean _matched = false;
        if (typeRef instanceof FunctionTypeRef) {
            _matched = true;
            return typeRef;
        }
        if (!_matched && typeRef instanceof ParameterizedTypeRef) {
            _matched = true;
            ParameterizedTypeRef _xifexpression = null;
            Type _declaredType = ((ParameterizedTypeRef)typeRef).getDeclaredType();
            if (_declaredType instanceof TypeVariable) {
                Object _get = G.get((Object)((ParameterizedTypeRef)typeRef).getDeclaredType());
                TypeRef boundType = (TypeRef)_get;
                return boundType;
            }
            ParameterizedTypeRef _xifexpression_1 = null;
            boolean _isGeneric = ((ParameterizedTypeRef)typeRef).getDeclaredType().isGeneric();
            if (_isGeneric) {
                ParameterizedTypeRef ptr = (ParameterizedTypeRef)TypeUtils.copy((EObject)((ParameterizedTypeRef)typeRef));
                int i = 0;
                while (i < ((ParameterizedTypeRef)typeRef).getDeclaredType().getTypeVars().size()) {
                    TypeVariable typeVar = (TypeVariable)((ParameterizedTypeRef)typeRef).getDeclaredType().getTypeVars().get(i);
                    Object _get_1 = G.get((Object)typeVar);
                    TypeRef boundType_1 = (TypeRef)_get_1;
                    if (boundType_1 != null) {
                        ptr.getTypeArgs().set(i, (Object)((TypeArgument)TypeUtils.copy((EObject)boundType_1)));
                    }
                    ++i;
                }
                return ptr;
            }
            _switchResult = _xifexpression = (_xifexpression_1 = (ParameterizedTypeRef)typeRef);
        }
        if (!_matched) {
            return typeRef;
        }
        return _switchResult;
    }
}

