/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.postprocessing.TypeProcessor;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.TypeSystemHelper;
import org.eclipse.n4js.xsemantics.InternalTypeSystem;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.EcoreUtil2;

@Singleton
public class N4JSTypeSystem {
    @Inject
    private InternalTypeSystem ts_internal;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private TypeProcessor typeProcessor;

    public Result<TypeRef> type(RuleEnvironment G, TypableElement element) {
        return this.typeProcessor.getType(G, null, element);
    }

    public Result<TypeRef> expectedTypeIn(RuleEnvironment G, EObject container, Expression expression) {
        return this.ts_internal.expectedTypeIn(G, container, expression);
    }

    public Result<Boolean> subtype(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        return this.ts_internal.subtype(G, left, right);
    }

    public boolean subtypeSucceeded(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        return this.ts_internal.subtypeSucceeded(G, left, right);
    }

    public Result<Boolean> supertype(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        return this.ts_internal.supertype(G, left, right);
    }

    public Result<Boolean> equaltype(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        return this.ts_internal.equaltype(G, left, right);
    }

    public boolean equaltypeSucceeded(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        return this.ts_internal.equaltypeSucceeded(G, left, right);
    }

    public Result<TypeRef> upperBound(RuleEnvironment G, TypeArgument typeArgument) {
        return this.ts_internal.upperBound(G, typeArgument);
    }

    public Result<TypeRef> lowerBound(RuleEnvironment G, TypeArgument typeArgument) {
        return this.ts_internal.lowerBound(G, typeArgument);
    }

    public TypeRef substTypeVariablesInTypeRef(RuleEnvironment G, TypeRef typeRef) {
        return (TypeRef)this.substTypeVariables(G, (TypeArgument)typeRef).getValue();
    }

    public Result<TypeArgument> substTypeVariables(RuleEnvironment G, TypeArgument typeArgument) {
        return this.ts_internal.substTypeVariables(G, typeArgument);
    }

    public Result<TypeRef> thisTypeRef(RuleEnvironment G, EObject location) {
        return this.ts_internal.thisTypeRef(G, location);
    }

    public TypeRef tau(TypableElement element) {
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)element);
        return (TypeRef)this.type(G, element).getValue();
    }

    public TypeRef tau(TypableElement element, TypeRef context) {
        RuleEnvironment G = this.createRuleEnvironmentForContext(context, element != null ? element.eResource() : null);
        return this.tau(element, G);
    }

    public TypeRef tau(TypableElement element, EObject astNodeForContext) {
        TypeDefiningElement tde = (TypeDefiningElement)EcoreUtil2.getContainerOfType((EObject)astNodeForContext, TypeDefiningElement.class);
        ParameterizedTypeRef context = null;
        if (tde != null) {
            context = TypeUtils.createTypeRef((Type)tde.getDefinedType(), (TypeArgument[])new TypeArgument[0]);
        }
        return this.tau(element, (TypeRef)context);
    }

    public TypeRef tau(TypableElement element, RuleEnvironment G) {
        Result<TypeRef> result = this.type(G, element);
        TypeRef value = (TypeRef)result.getValue();
        if (value != null) {
            TypeRef substValue = this.substTypeVariablesInTypeRef(G, value);
            return substValue;
        }
        return null;
    }

    public RuleEnvironment createRuleEnvironmentForContext(TypeRef context, Resource resource) {
        return this.createRuleEnvironmentForContext(context, context, resource);
    }

    public RuleEnvironment createRuleEnvironmentForContext(TypeRef contextTypeVariableBindings, TypeRef contextThisBinding, Resource resource) {
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment(resource);
        if (contextTypeVariableBindings != null) {
            this.tsh.addSubstitutions(G, contextTypeVariableBindings);
        }
        if (contextThisBinding instanceof ParameterizedTypeRef && contextThisBinding.getDeclaredType() instanceof TClassifier) {
            RuleEnvironmentExtensions.addThisType(G, contextThisBinding);
        }
        return G;
    }

    public TypeRef resolveType(RuleEnvironment G, TypeArgument typeArgument) {
        return this.tsh.resolveType(G, typeArgument);
    }

    public TypeRef createSimplifiedUnion(List<TypeRef> typeRefs, Resource resource) {
        if (typeRefs.size() > 1 && resource != null) {
            return this.tsh.createUnionType(RuleEnvironmentExtensions.newRuleEnvironment(resource), typeRefs.toArray(new TypeRef[typeRefs.size()]));
        }
        if (typeRefs.size() == 1) {
            return (TypeRef)TypeUtils.copyIfContained((EObject)typeRefs.get(0));
        }
        return null;
    }

    public TypeRef createSimplifiedIntersection(List<TypeRef> typeRefs, Resource resource) {
        if (typeRefs.size() > 1 && resource != null) {
            return this.tsh.createIntersectionType(RuleEnvironmentExtensions.newRuleEnvironment(resource), typeRefs.toArray(new TypeRef[typeRefs.size()]));
        }
        if (typeRefs.size() == 1) {
            return (TypeRef)TypeUtils.copyIfContained((EObject)typeRefs.get(0));
        }
        return null;
    }
}

