/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.OptionalFieldStrategy;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeCompareUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.StructuralTypingResult;
import org.eclipse.n4js.typesystem.TypeSystemHelperStrategy;
import org.eclipse.n4js.typesystem.constraints.TypeConstraint;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.StructuralMembersPredicates;
import org.eclipse.n4js.utils.StructuralMembersTriple;
import org.eclipse.n4js.utils.StructuralMembersTripleIterator;
import org.eclipse.n4js.utils.StructuralTypesHelper;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
public class StructuralTypingComputer
extends TypeSystemHelperStrategy {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private N4JSElementKeywordProvider keywordProvider;
    @Inject
    private StructuralTypesHelper structuralTypesHelper;

    public StructuralTypingResult isStructuralSubtype(RuleEnvironment G, TypeRef left, TypeRef right) {
        boolean _subtypeSucceeded;
        TypingStrategy rightStrategy = right.getTypingStrategy();
        TypingStrategy leftStrategy = left.getTypingStrategy();
        if ((left.getDeclaredType() instanceof TN4Classifier || left.getDeclaredType() instanceof TypeVariable) && left.getTypingStrategy() == right.getTypingStrategy() && TypingStrategy.STRUCTURAL_FIELD_INITIALIZER != leftStrategy && TypingStrategy.STRUCTURAL_FIELD_INITIALIZER != rightStrategy && left.getDeclaredType() == right.getDeclaredType() && left.getStructuralMembers().isEmpty() && right.getStructuralMembers().isEmpty() && left.getTypeArgs().isEmpty()) {
            return StructuralTypingResult.result(left, right, CollectionLiterals.emptyList(), CollectionLiterals.emptyList());
        }
        if (!right.isUseSiteStructuralTyping() && right.isDefSiteStructuralTyping() && (_subtypeSucceeded = this.ts.subtypeSucceeded(G, (TypeArgument)left, (TypeArgument)RuleEnvironmentExtensions.n4ObjectTypeRef(G)))) {
            String _typeRefAsString = right.getTypeRefAsString();
            String _plus = "All N4Objects must explicitly extend/implement definition site structural type " + _typeRefAsString;
            String _plus_1 = String.valueOf(_plus) + ".";
            return StructuralTypingResult.failureDefSiteWithN4Object(_plus_1);
        }
        StructuralTypingResult primitiveSubtypingResult = this.isPrimitiveStructuralSubtype(G, left, right);
        if (primitiveSubtypingResult != null) {
            return primitiveSubtypingResult;
        }
        boolean _isStructuralSubtypingInProgressFor = this.isStructuralSubtypingInProgressFor(G, left, right);
        if (_isStructuralSubtypingInProgressFor) {
            return StructuralTypingResult.result(left, right, CollectionLiterals.emptyList(), CollectionLiterals.emptyList());
        }
        RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(G);
        this.rememberStructuralSubtypingInProgressFor(G2, left, right);
        StructTypingInfo info = new StructTypingInfo(G2, left, right, leftStrategy, rightStrategy);
        StructuralMembersTripleIterator iter = this.structuralTypesHelper.getMembersTripleIterator(G2, left, right, true);
        while (iter.hasNext()) {
            this.checkMembers(left, iter.next(), info);
        }
        return StructuralTypingResult.result(left, right, info.missingMembers, info.wrongMembers);
    }

    public StructuralTypingResult isPrimitiveStructuralSubtype(RuleEnvironment G, TypeRef leftRaw, TypeRef right) {
        TypeRef left = this.changeStringBasedEnumToString(G, leftRaw);
        Type _declaredType = right.getDeclaredType();
        boolean rightIsPrimitive = _declaredType instanceof PrimitiveType;
        Type _declaredType_1 = left.getDeclaredType();
        boolean leftIsPrimitive = _declaredType_1 instanceof PrimitiveType;
        if (rightIsPrimitive && !leftIsPrimitive) {
            String _typeRefAsString = leftRaw.getTypeRefAsString();
            String _plus = String.valueOf(_typeRefAsString) + " is not a subtype of ";
            String _typeRefAsString_1 = right.getTypeRefAsString();
            String _plus_1 = String.valueOf(_plus) + _typeRefAsString_1;
            return StructuralTypingResult.failure(_plus_1);
        }
        if (leftIsPrimitive && !rightIsPrimitive) {
            String _typeRefAsString_2 = leftRaw.getTypeRefAsString();
            String _plus_2 = String.valueOf(_typeRefAsString_2) + " is not a subtype of ";
            String _typeRefAsString_3 = right.getTypeRefAsString();
            String _plus_3 = String.valueOf(_plus_2) + _typeRefAsString_3;
            return StructuralTypingResult.failure(_plus_3);
        }
        if (leftIsPrimitive && rightIsPrimitive) {
            Type _declaredType_3;
            boolean _tripleEquals;
            StructuralTypingResult _xifexpression = null;
            Type _declaredType_2 = left.getDeclaredType();
            boolean bl = _tripleEquals = _declaredType_2 == (_declaredType_3 = right.getDeclaredType());
            if (_tripleEquals) {
                _xifexpression = StructuralTypingResult.success();
            } else {
                String _typeRefAsString_4 = leftRaw.getTypeRefAsString();
                String _plus_4 = String.valueOf(_typeRefAsString_4) + " is not a subtype of ";
                String _typeRefAsString_5 = right.getTypeRefAsString();
                String _plus_5 = String.valueOf(_plus_4) + _typeRefAsString_5;
                _xifexpression = StructuralTypingResult.failure(_plus_5);
            }
            return _xifexpression;
        }
        return null;
    }

    private TypeRef changeStringBasedEnumToString(RuleEnvironment G, TypeRef typeRef) {
        Type declType = typeRef.getDeclaredType();
        if (declType instanceof TEnum && AnnotationDefinition.STRING_BASED.hasAnnotation((TAnnotableElement)declType)) {
            return RuleEnvironmentExtensions.stringTypeRef(G);
        }
        return typeRef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkMembers(TypeRef leftTypeRef, StructuralMembersTriple triple, StructTypingInfo info) {
        TMember leftMember = triple.getLeft();
        TMember rightMember = triple.getRight();
        FieldAccessor leftOtherAccessor = triple.getLeftOtherAccessor();
        TypingStrategy leftStrategy = info.leftStrategy;
        TypingStrategy rightStrategy = info.rightStrategy;
        this.checkMembers(leftTypeRef, leftMember, rightMember, info, rightStrategy);
        if (rightStrategy != null) {
            switch (rightStrategy) {
                case STRUCTURAL_READ_ONLY_FIELDS: {
                    boolean handleOptionality = N4JSLanguageUtils.isOptionalityLessRestrictedOrEqual(leftTypeRef.getASTNodeOptionalFieldStrategy(), OptionalFieldStrategy.GETTERS_OPTIONAL);
                    if (rightMember.isOptional()) {
                        if (!rightMember.isOptional()) return;
                        if (handleOptionality) {
                            return;
                        }
                    }
                    boolean bl = true;
                    boolean memberNecessary = bl;
                    if (!memberNecessary) return;
                    if (StructuralMembersPredicates.READABLE_FIELDS_PREDICATE.apply((Object)rightMember) == false) return;
                    if (TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS == leftStrategy && !StructuralMembersPredicates.GETTERS_PREDICATE.apply((Object)leftMember).booleanValue() && !StructuralMembersPredicates.GETTERS_PREDICATE.apply((Object)leftOtherAccessor).booleanValue()) {
                        String _name = rightMember.getName();
                        String _plus = String.valueOf(_name) + " failed: readable field requires a getter in subtype.";
                        info.wrongMembers.add(_plus);
                        return;
                    }
                    if (StructuralMembersPredicates.READABLE_FIELDS_PREDICATE.apply((Object)leftMember) != false) return;
                    if (StructuralMembersPredicates.READABLE_FIELDS_PREDICATE.apply((Object)leftOtherAccessor) != false) return;
                    String _name_1 = rightMember.getName();
                    String _plus_1 = String.valueOf(_name_1) + " failed: readable field requires a readable field or a getter in subtype.";
                    info.wrongMembers.add(_plus_1);
                    return;
                }
                case STRUCTURAL_WRITE_ONLY_FIELDS: {
                    if (StructuralMembersPredicates.WRITABLE_FIELDS_PREDICATE.apply((Object)rightMember) == false) return;
                    if (Objects.equal((Object)leftTypeRef.getASTNodeOptionalFieldStrategy(), (Object)OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL)) return;
                    if (!(TypingStrategy.STRUCTURAL_READ_ONLY_FIELDS != leftStrategy && TypingStrategy.STRUCTURAL_FIELD_INITIALIZER != leftStrategy || StructuralMembersPredicates.SETTERS_PREDICATE.apply((Object)leftMember).booleanValue() || StructuralMembersPredicates.SETTERS_PREDICATE.apply((Object)leftOtherAccessor).booleanValue())) {
                        String _name_2 = rightMember.getName();
                        String _plus_2 = String.valueOf(_name_2) + " failed: writable field requires a setter in subtype.";
                        info.wrongMembers.add(_plus_2);
                        return;
                    }
                    if (StructuralMembersPredicates.WRITABLE_FIELDS_PREDICATE.apply((Object)leftMember) != false) return;
                    if (StructuralMembersPredicates.WRITABLE_FIELDS_PREDICATE.apply((Object)leftOtherAccessor) != false) return;
                    String _name_3 = rightMember.getName();
                    String _plus_3 = String.valueOf(_name_3) + " failed: writable field requires a writable field or a setter in subtype.";
                    info.wrongMembers.add(_plus_3);
                    return;
                }
                case STRUCTURAL_FIELD_INITIALIZER: {
                    if (StructuralMembersPredicates.WRITABLE_FIELDS_PREDICATE.apply((Object)rightMember) == false) return;
                    if (!this.isMandatoryField(rightMember)) return;
                    if (TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS == leftStrategy && !StructuralMembersPredicates.GETTERS_PREDICATE.apply((Object)leftMember).booleanValue() && !StructuralMembersPredicates.GETTERS_PREDICATE.apply((Object)leftOtherAccessor).booleanValue()) {
                        String _name_4 = rightMember.getName();
                        String _plus_4 = String.valueOf(_name_4) + " failed: non-optional writable field requires a getter in subtype.";
                        info.wrongMembers.add(_plus_4);
                        return;
                    }
                    if (StructuralMembersPredicates.READABLE_FIELDS_PREDICATE.apply((Object)leftMember) != false) return;
                    if (StructuralMembersPredicates.READABLE_FIELDS_PREDICATE.apply((Object)leftOtherAccessor).booleanValue()) {
                        return;
                    }
                    boolean bl = true;
                    boolean _not = bl;
                    if (!_not) return;
                    String _name_5 = rightMember.getName();
                    String _plus_5 = String.valueOf(_name_5) + " failed: non-optional writable field requires a readable field or a getter in subtype.";
                    info.wrongMembers.add(_plus_5);
                    return;
                }
                default: {
                    if (TypingStrategy.STRUCTURAL_READ_ONLY_FIELDS == leftStrategy || TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS == leftStrategy || TypingStrategy.STRUCTURAL_FIELD_INITIALIZER == leftStrategy) {
                        Boolean _apply;
                        boolean _matched = false;
                        boolean _isWriteableField = N4JSLanguageUtils.isWriteableField(rightMember);
                        if (_isWriteableField) {
                            boolean _not_1;
                            _matched = true;
                            boolean _isGetterSetterPair = this.isGetterSetterPair(leftMember, (TMember)leftOtherAccessor);
                            boolean bl = _not_1 = !_isGetterSetterPair;
                            if (_not_1) {
                                String _name_6 = rightMember.getName();
                                String _plus_6 = String.valueOf(_name_6) + " failed: writable field requires a getter/setter pair in subtype.";
                                info.wrongMembers.add(_plus_6);
                            }
                        }
                        if (!_matched && (_apply = StructuralMembersPredicates.READABLE_FIELDS_PREDICATE.apply((Object)rightMember)).booleanValue()) {
                            boolean _not_2;
                            _matched = true;
                            boolean bl = _not_2 = StructuralMembersPredicates.GETTERS_PREDICATE.apply((Object)leftMember) == false && StructuralMembersPredicates.GETTERS_PREDICATE.apply((Object)leftOtherAccessor) == false;
                            if (_not_2) {
                                String _name_7 = rightMember.getName();
                                String _plus_7 = String.valueOf(_name_7) + " failed: read-only field requires a getter in subtype.";
                                info.wrongMembers.add(_plus_7);
                            }
                        }
                        if (_matched) return;
                        Boolean _apply_1 = StructuralMembersPredicates.SETTERS_PREDICATE.apply((Object)rightMember);
                        if (_apply_1 == false) return;
                        _matched = true;
                        if (StructuralMembersPredicates.SETTERS_PREDICATE.apply((Object)leftMember) != false) return;
                        if (StructuralMembersPredicates.SETTERS_PREDICATE.apply((Object)leftOtherAccessor).booleanValue()) {
                            return;
                        }
                        boolean bl = true;
                        boolean _not_3 = bl;
                        if (!_not_3) return;
                        String _name_8 = rightMember.getName();
                        String _plus_8 = String.valueOf(_name_8) + " failed: setter requires a setter in subtype.";
                        info.wrongMembers.add(_plus_8);
                        return;
                    }
                    if (!N4JSLanguageUtils.isWriteableField(rightMember)) return;
                    if (!(leftMember instanceof FieldAccessor)) return;
                    if (!(leftOtherAccessor instanceof TSetter)) {
                        OptionalFieldStrategy _aSTNodeOptionalFieldStrategy = leftTypeRef.getASTNodeOptionalFieldStrategy();
                        if (Objects.equal((Object)_aSTNodeOptionalFieldStrategy, (Object)OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL)) {
                            return;
                        }
                        boolean bl = true;
                        boolean _notEquals = bl;
                        if (!_notEquals) return;
                        if (leftMember instanceof TSetter && rightMember.isOptional() && Objects.equal((Object)leftTypeRef.getASTNodeOptionalFieldStrategy(), (Object)OptionalFieldStrategy.GETTERS_OPTIONAL)) {
                            return;
                        }
                        boolean bl2 = false;
                        boolean isSpecialCaseOfDispensableGetterForOptionalField = bl2;
                        if (isSpecialCaseOfDispensableGetterForOptionalField) return;
                        String _xifexpression = null;
                        _xifexpression = leftMember instanceof TGetter && rightMember.isOptional() ? "optional writable field requires at least a setter in subtype." : "writable field requires a field or a getter/setter pair in subtype.";
                        String msgSpecial = _xifexpression;
                        String _name_9 = rightMember.getName();
                        String _plus_9 = String.valueOf(_name_9) + " failed: ";
                        String _plus_10 = String.valueOf(_plus_9) + msgSpecial;
                        info.wrongMembers.add(_plus_10);
                        return;
                    }
                    this.checkMembers(leftTypeRef, (TMember)leftOtherAccessor, rightMember, info, rightStrategy);
                    return;
                }
            }
        } else if (TypingStrategy.STRUCTURAL_READ_ONLY_FIELDS == leftStrategy || TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS == leftStrategy || TypingStrategy.STRUCTURAL_FIELD_INITIALIZER == leftStrategy) {
            Boolean _apply;
            boolean _matched = false;
            boolean _isWriteableField = N4JSLanguageUtils.isWriteableField(rightMember);
            if (_isWriteableField) {
                boolean _not_1;
                _matched = true;
                boolean _isGetterSetterPair = this.isGetterSetterPair(leftMember, (TMember)leftOtherAccessor);
                boolean bl = _not_1 = !_isGetterSetterPair;
                if (_not_1) {
                    String _name_6 = rightMember.getName();
                    String _plus_6 = String.valueOf(_name_6) + " failed: writable field requires a getter/setter pair in subtype.";
                    info.wrongMembers.add(_plus_6);
                }
            }
            if (!_matched && (_apply = StructuralMembersPredicates.READABLE_FIELDS_PREDICATE.apply((Object)rightMember)).booleanValue()) {
                boolean _not_2;
                _matched = true;
                boolean bl = _not_2 = StructuralMembersPredicates.GETTERS_PREDICATE.apply((Object)leftMember) == false && StructuralMembersPredicates.GETTERS_PREDICATE.apply((Object)leftOtherAccessor) == false;
                if (_not_2) {
                    String _name_7 = rightMember.getName();
                    String _plus_7 = String.valueOf(_name_7) + " failed: read-only field requires a getter in subtype.";
                    info.wrongMembers.add(_plus_7);
                }
            }
            if (_matched) return;
            Boolean _apply_1 = StructuralMembersPredicates.SETTERS_PREDICATE.apply((Object)rightMember);
            if (_apply_1 == false) return;
            _matched = true;
            if (StructuralMembersPredicates.SETTERS_PREDICATE.apply((Object)leftMember) != false) return;
            if (StructuralMembersPredicates.SETTERS_PREDICATE.apply((Object)leftOtherAccessor).booleanValue()) {
                return;
            }
            boolean bl = true;
            boolean _not_3 = bl;
            if (!_not_3) return;
            String _name_8 = rightMember.getName();
            String _plus_8 = String.valueOf(_name_8) + " failed: setter requires a setter in subtype.";
            info.wrongMembers.add(_plus_8);
            return;
        } else {
            if (!N4JSLanguageUtils.isWriteableField(rightMember)) return;
            if (!(leftMember instanceof FieldAccessor)) return;
            if (!(leftOtherAccessor instanceof TSetter)) {
                OptionalFieldStrategy _aSTNodeOptionalFieldStrategy = leftTypeRef.getASTNodeOptionalFieldStrategy();
                if (Objects.equal((Object)_aSTNodeOptionalFieldStrategy, (Object)OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL)) {
                    return;
                }
                boolean bl = true;
                boolean _notEquals = bl;
                if (!_notEquals) return;
                if (leftMember instanceof TSetter && rightMember.isOptional() && Objects.equal((Object)leftTypeRef.getASTNodeOptionalFieldStrategy(), (Object)OptionalFieldStrategy.GETTERS_OPTIONAL)) {
                    return;
                }
                boolean bl3 = false;
                boolean isSpecialCaseOfDispensableGetterForOptionalField = bl3;
                if (isSpecialCaseOfDispensableGetterForOptionalField) return;
                String _xifexpression = null;
                _xifexpression = leftMember instanceof TGetter && rightMember.isOptional() ? "optional writable field requires at least a setter in subtype." : "writable field requires a field or a getter/setter pair in subtype.";
                String msgSpecial = _xifexpression;
                String _name_9 = rightMember.getName();
                String _plus_9 = String.valueOf(_name_9) + " failed: ";
                String _plus_10 = String.valueOf(_plus_9) + msgSpecial;
                info.wrongMembers.add(_plus_10);
                return;
            } else {
                this.checkMembers(leftTypeRef, (TMember)leftOtherAccessor, rightMember, info, rightStrategy);
            }
        }
    }

    private boolean isGetterSetterPair(TMember firstLeft, TMember secondLeft) {
        return !(StructuralMembersPredicates.GETTERS_PREDICATE.apply((Object)firstLeft) == false && StructuralMembersPredicates.GETTERS_PREDICATE.apply((Object)secondLeft) == false || StructuralMembersPredicates.SETTERS_PREDICATE.apply((Object)secondLeft) == false && StructuralMembersPredicates.SETTERS_PREDICATE.apply((Object)secondLeft) == false);
    }

    private void checkMembers(TypeRef leftTypeRef, TMember left, TMember right, StructTypingInfo info, TypingStrategy rightStrategy) {
        RuleEnvironment G = info.G;
        if (left == null) {
            boolean _memberIsMissing = this.memberIsMissing(leftTypeRef, right, info);
            if (_memberIsMissing) {
                String _keyword = this.keywordProvider.keyword((EObject)right, rightStrategy);
                String _plus = String.valueOf(_keyword) + " ";
                String _name = right.getName();
                String _plus_1 = String.valueOf(_plus) + _name;
                info.missingMembers.add(_plus_1);
            }
        } else {
            Pair<TypeArgument, TypeArgument> mtypes = this.getMemberTypes(left, right, info);
            Result<Boolean> subtypeResult = null;
            if (left.isOptional() && !right.isOptional()) {
                String _name_1 = left.getName();
                String _plus_2 = String.valueOf(_name_1) + " failed: non-optional member requires a corresponding non-optional member in the structural subtype.";
                info.missingMembers.add(_plus_2);
            } else if (N4JSLanguageUtils.isWriteableField(right) && left instanceof TField) {
                if (N4JSLanguageUtils.isReadOnlyField(left) && TypingStrategy.STRUCTURAL_FIELD_INITIALIZER != rightStrategy && TypingStrategy.STRUCTURAL_READ_ONLY_FIELDS != rightStrategy) {
                    String _name_2 = right.getName();
                    String _plus_3 = String.valueOf(_name_2) + " failed: field is read-only.";
                    info.wrongMembers.add(_plus_3);
                } else {
                    subtypeResult = this.ts.equaltype(G, (TypeArgument)mtypes.getKey(), (TypeArgument)mtypes.getValue());
                }
            } else {
                subtypeResult = right instanceof TSetter || left instanceof TSetter ? this.ts.supertype(G, (TypeArgument)mtypes.getKey(), (TypeArgument)mtypes.getValue()) : this.ts.subtype(G, (TypeArgument)mtypes.getKey(), (TypeArgument)mtypes.getValue());
            }
            if (subtypeResult != null && subtypeResult.failed()) {
                String _name_3 = right.getName();
                String _plus_4 = String.valueOf(_name_3) + " ";
                String _message = subtypeResult.getRuleFailedException().getMessage();
                String _plus_5 = String.valueOf(_plus_4) + _message;
                info.wrongMembers.add(_plus_5);
            }
        }
    }

    public TypeConstraint reduceMembers(TypeRef leftTypeRef, TMember left, TMember right, Variance variance, StructTypingInfo info) {
        if (variance == Variance.CONTRA) {
            return this.reduceMembers(leftTypeRef, right, left, Variance.CO, info);
        }
        if (left == null) {
            boolean _memberIsMissing = this.memberIsMissing(leftTypeRef, right, info);
            if (_memberIsMissing) {
                return TypeConstraint.FALSE;
            }
            return TypeConstraint.TRUE;
        }
        Pair<TypeArgument, TypeArgument> mtypes = this.getMemberTypes(left, right, info);
        if (left.isOptional() && !right.isOptional()) {
            return TypeConstraint.FALSE;
        }
        if (N4JSLanguageUtils.isWriteableField(right) && left instanceof TField) {
            if (N4JSLanguageUtils.isReadOnlyField(left) && TypingStrategy.STRUCTURAL_FIELD_INITIALIZER != info.rightStrategy && TypingStrategy.STRUCTURAL_READ_ONLY_FIELDS != info.rightStrategy) {
                return TypeConstraint.FALSE;
            }
            TypeArgument _key = (TypeArgument)mtypes.getKey();
            TypeArgument _value = (TypeArgument)mtypes.getValue();
            return new TypeConstraint(_key, _value, Variance.INV);
        }
        if (right instanceof TSetter || left instanceof TSetter) {
            TypeArgument _key_1 = (TypeArgument)mtypes.getKey();
            TypeArgument _value_1 = (TypeArgument)mtypes.getValue();
            Variance _inverse = variance.inverse();
            return new TypeConstraint(_key_1, _value_1, _inverse);
        }
        TypeArgument _key_2 = (TypeArgument)mtypes.getKey();
        TypeArgument _value_2 = (TypeArgument)mtypes.getValue();
        return new TypeConstraint(_key_2, _value_2, variance);
    }

    private boolean memberIsMissing(TypeRef leftTypeRef, TMember right, StructTypingInfo info) {
        TClassifier _objectType;
        boolean _tripleEquals;
        boolean rightMemberIsOptional = this.rightMemberIsOptional(leftTypeRef, right, info.rightStrategy);
        if (rightMemberIsOptional) {
            return false;
        }
        ContainerType _containingType = null;
        if (right != null) {
            _containingType = right.getContainingType();
        }
        boolean bl = _tripleEquals = _containingType == (_objectType = RuleEnvironmentExtensions.objectType(info.G));
        return !_tripleEquals;
    }

    private boolean rightMemberIsOptional(TypeRef leftTypeRef, TMember right, TypingStrategy rightStrategy) {
        OptionalFieldStrategy leftOptionalStrategy = leftTypeRef.getASTNodeOptionalFieldStrategy();
        boolean _switchResult = false;
        if (rightStrategy != null) {
            switch (rightStrategy) {
                case STRUCTURAL: 
                case STRUCTURAL_FIELDS: {
                    boolean _not;
                    boolean _xifexpression = false;
                    boolean _isOptional = right.isOptional();
                    boolean bl = _not = !_isOptional;
                    _xifexpression = _not ? false : Objects.equal((Object)leftOptionalStrategy, (Object)OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL) || right instanceof TGetter && N4JSLanguageUtils.isOptionalityLessRestrictedOrEqual(leftOptionalStrategy, OptionalFieldStrategy.GETTERS_OPTIONAL);
                    _switchResult = _xifexpression;
                    break;
                }
                case STRUCTURAL_WRITE_ONLY_FIELDS: {
                    _switchResult = right.isOptional() && Objects.equal((Object)leftOptionalStrategy, (Object)OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL);
                    break;
                }
                case STRUCTURAL_READ_ONLY_FIELDS: {
                    _switchResult = right.isOptional() && N4JSLanguageUtils.isOptionalityLessRestrictedOrEqual(leftOptionalStrategy, OptionalFieldStrategy.GETTERS_OPTIONAL);
                    break;
                }
                case STRUCTURAL_FIELD_INITIALIZER: {
                    _switchResult = right.isOptional() && N4JSLanguageUtils.isOptionalityLessRestrictedOrEqual(leftOptionalStrategy, OptionalFieldStrategy.GETTERS_OPTIONAL) || this.isInitializedField(right) || this.isOptionalSetter(right);
                    break;
                }
                default: {
                    _switchResult = false;
                    break;
                }
            }
        } else {
            _switchResult = false;
        }
        boolean rightMemberIsOptional = _switchResult;
        return rightMemberIsOptional;
    }

    private void rememberStructuralSubtypingInProgressFor(RuleEnvironment G, TypeRef left, TypeRef right) {
        TypeCompareUtils.SemanticEqualsWrapper _wrap = this.wrap(left);
        TypeCompareUtils.SemanticEqualsWrapper _wrap_1 = this.wrap(right);
        Pair _mappedTo = Pair.of((Object)_wrap, (Object)_wrap_1);
        Pair _mappedTo_1 = Pair.of((Object)"StructuralTypingComputer", (Object)_mappedTo);
        G.add((Object)_mappedTo_1, (Object)Boolean.TRUE);
    }

    private boolean isStructuralSubtypingInProgressFor(RuleEnvironment G, TypeRef left, TypeRef right) {
        TypeCompareUtils.SemanticEqualsWrapper _wrap_1;
        TypeCompareUtils.SemanticEqualsWrapper _wrap = this.wrap(left);
        Pair _mappedTo = Pair.of((Object)_wrap, (Object)(_wrap_1 = this.wrap(right)));
        Pair _mappedTo_1 = Pair.of((Object)"StructuralTypingComputer", (Object)_mappedTo);
        Object _get = G.get((Object)_mappedTo_1);
        return _get != null;
    }

    private TypeCompareUtils.SemanticEqualsWrapper wrap(TypeRef typeRef) {
        return new TypeCompareUtils.SemanticEqualsWrapper(typeRef);
    }

    private Pair<TypeArgument, TypeArgument> getMemberTypes(TMember leftMember, TMember rightMember, StructTypingInfo info) {
        RuleEnvironment G = info.G;
        TypeRef typeLeftRaw = (TypeRef)this.ts.type(G, (TypableElement)leftMember).getValue();
        TypeRef typeRightRaw = (TypeRef)this.ts.type(G, (TypableElement)rightMember).getValue();
        RuleEnvironment G_left = RuleEnvironmentExtensions.wrap(G);
        RuleEnvironment G_right = RuleEnvironmentExtensions.wrap(G);
        this._typeSystemHelper.addSubstitutions(G_left, info.left);
        this._typeSystemHelper.addSubstitutions(G_right, info.right);
        ArrayList reopen = CollectionLiterals.newArrayList();
        this.collectExistentialTypeRefs(G_right, (List<? super ExistentialTypeRef>)reopen);
        TypeArgument typeLeft = (TypeArgument)this.ts.substTypeVariables(G_left, (TypeArgument)typeLeftRaw).getValue();
        TypeArgument typeRight = (TypeArgument)this.ts.substTypeVariables(G_right, (TypeArgument)typeRightRaw).getValue();
        Consumer<ExistentialTypeRef> _function = it -> RuleEnvironmentExtensions.addExistentialTypeToBeReopened(G, it);
        reopen.forEach(_function);
        return Pair.of((Object)typeLeft, (Object)typeRight);
    }

    private void collectExistentialTypeRefs(RuleEnvironment G, List<? super ExistentialTypeRef> addHere) {
        RuleEnvironment next = G;
        while (next != null) {
            Set _entrySet = next.entrySet();
            for (Map.Entry entry : _entrySet) {
                Object key = entry.getKey();
                if (!(key instanceof TypeVariable)) continue;
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    for (Object currValue : (Collection)value) {
                        if (!(currValue instanceof TypeRef)) continue;
                        this.collectExistentialTypeRefs((TypeRef)currValue, addHere);
                    }
                    continue;
                }
                if (!(value instanceof TypeRef)) continue;
                this.collectExistentialTypeRefs((TypeRef)value, addHere);
            }
            next = G.getNext();
        }
    }

    private void collectExistentialTypeRefs(TypeRef typeRef, List<? super ExistentialTypeRef> addHere) {
        if (typeRef instanceof ExistentialTypeRef) {
            addHere.add((ExistentialTypeRef)((ExistentialTypeRef)typeRef));
        } else {
            addHere.addAll(EcoreUtil2.getAllContentsOfType((EObject)typeRef, ExistentialTypeRef.class));
        }
    }

    private boolean isMandatoryField(TMember it) {
        return it != null && !it.isOptional() && !this.isInitializedField(it) && !this.isOptionalSetter(it);
    }

    private boolean isInitializedField(TMember it) {
        boolean _xifexpression = false;
        _xifexpression = it instanceof TField ? ((TField)it).isHasExpression() : false;
        return _xifexpression;
    }

    private boolean isOptionalSetter(TMember it) {
        return it instanceof TSetter && AnnotationDefinition.PROVIDES_INITIALZER.hasAnnotation((TAnnotableElement)it);
    }

    @Data
    public static class StructTypingInfo {
        private final RuleEnvironment G;
        private final TypeRef left;
        private final TypeRef right;
        private final TypingStrategy leftStrategy;
        private final TypingStrategy rightStrategy;
        private final List<String> missingMembers = CollectionLiterals.newArrayList();
        private final List<String> wrongMembers = CollectionLiterals.newArrayList();

        public StructTypingInfo(RuleEnvironment G, TypeRef left, TypeRef right, TypingStrategy leftStrategy, TypingStrategy rightStrategy) {
            this.G = G;
            this.left = left;
            this.right = right;
            this.leftStrategy = leftStrategy;
            this.rightStrategy = rightStrategy;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.G == null ? 0 : this.G.hashCode());
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            result = 31 * result + (this.leftStrategy == null ? 0 : this.leftStrategy.hashCode());
            result = 31 * result + (this.rightStrategy == null ? 0 : this.rightStrategy.hashCode());
            result = 31 * result + (this.missingMembers == null ? 0 : this.missingMembers.hashCode());
            result = 31 * result + (this.wrongMembers == null ? 0 : this.wrongMembers.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StructTypingInfo other = (StructTypingInfo)obj;
            if (this.G == null ? other.G != null : !this.G.equals((Object)other.G)) {
                return false;
            }
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.right == null ? other.right != null : !this.right.equals(other.right)) {
                return false;
            }
            if (this.leftStrategy == null ? other.leftStrategy != null : !this.leftStrategy.equals((Object)other.leftStrategy)) {
                return false;
            }
            if (this.rightStrategy == null ? other.rightStrategy != null : !this.rightStrategy.equals((Object)other.rightStrategy)) {
                return false;
            }
            if (this.missingMembers == null ? other.missingMembers != null : !this.missingMembers.equals(other.missingMembers)) {
                return false;
            }
            return !(this.wrongMembers == null ? other.wrongMembers != null : !this.wrongMembers.equals(other.wrongMembers));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("G", (Object)this.G);
            b.add("left", (Object)this.left);
            b.add("right", (Object)this.right);
            b.add("leftStrategy", (Object)this.leftStrategy);
            b.add("rightStrategy", (Object)this.rightStrategy);
            b.add("missingMembers", this.missingMembers);
            b.add("wrongMembers", this.wrongMembers);
            return b.toString();
        }

        @Pure
        public RuleEnvironment getG() {
            return this.G;
        }

        @Pure
        public TypeRef getLeft() {
            return this.left;
        }

        @Pure
        public TypeRef getRight() {
            return this.right;
        }

        @Pure
        public TypingStrategy getLeftStrategy() {
            return this.leftStrategy;
        }

        @Pure
        public TypingStrategy getRightStrategy() {
            return this.rightStrategy;
        }

        @Pure
        public List<String> getMissingMembers() {
            return this.missingMembers;
        }

        @Pure
        public List<String> getWrongMembers() {
            return this.wrongMembers;
        }
    }
}

