/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.n4idl.versioning.N4IDLVersionResolver;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeExtensions;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.DerivationComputer;
import org.eclipse.n4js.typesystem.ExpectedTypeComputer;
import org.eclipse.n4js.typesystem.GenericsComputer;
import org.eclipse.n4js.typesystem.JoinComputer;
import org.eclipse.n4js.typesystem.MeetComputer;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.SimplifyComputer;
import org.eclipse.n4js.typesystem.StructuralTypingComputer;
import org.eclipse.n4js.typesystem.StructuralTypingResult;
import org.eclipse.n4js.typesystem.SubtypeComputer;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.Log;
import org.eclipse.n4js.utils.StructuralTypesHelper;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
@Log
public class TypeSystemHelper {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private N4IDLVersionResolver versionResolver;
    @Inject
    private DerivationComputer derivationComputer;
    @Inject
    private GenericsComputer genericsComputer;
    @Inject
    private SimplifyComputer simplifyComputer;
    @Inject
    private JoinComputer joinComputer;
    @Inject
    private MeetComputer meetComputer;
    @Inject
    private SubtypeComputer subtypeComputer;
    @Inject
    private ExpectedTypeComputer expectedTypeCompuer;
    @Inject
    private StructuralTypingComputer structuralTypingComputer;
    @Inject
    private StructuralTypesHelper structuralTypesHelper;
    private static final Logger logger = Logger.getLogger(TypeSystemHelper.class);

    public StructuralTypesHelper getStructuralTypesHelper() {
        return this.structuralTypesHelper;
    }

    public StructuralTypingComputer getStructuralTypingComputer() {
        return this.structuralTypingComputer;
    }

    public FunctionTypeExpression createSubstitutionOfFunctionTypeExprOrRef(RuleEnvironment G, FunctionTypeExprOrRef F) {
        return this.derivationComputer.createSubstitutionOfFunctionTypeExprOrRef(G, F);
    }

    public FunctionTypeExpression createUpperBoundOfFunctionTypeExprOrRef(RuleEnvironment G, FunctionTypeExprOrRef F) {
        return this.derivationComputer.createUpperBoundOfFunctionTypeExprOrRef(G, F);
    }

    public FunctionTypeExpression createLowerBoundOfFunctionTypeExprOrRef(RuleEnvironment G, FunctionTypeExprOrRef F) {
        return this.derivationComputer.createLowerBoundOfFunctionTypeExprOrRef(G, F);
    }

    public void addSubstitutions(RuleEnvironment G, TypeRef typeRef) {
        this.genericsComputer.addSubstitutions(G, typeRef);
    }

    public void addSubstitutions(RuleEnvironment G, ParameterizedCallExpression callExpr, TypeRef targetTypeRef) {
        this.genericsComputer.addSubstitutions(G, callExpr, targetTypeRef);
    }

    public void addSubstitutions(RuleEnvironment G, ParameterizedPropertyAccessExpression accessExpr) {
        this.genericsComputer.addSubstitutions(G, accessExpr);
    }

    public TypeRef substTypeVariablesInStructuralMembers(RuleEnvironment G, StructuralTypeRef typeRef) {
        return this.genericsComputer.substTypeVariablesInStructuralMembers(G, typeRef);
    }

    public void storePostponedSubstitutionsIn(RuleEnvironment G, StructuralTypeRef typeRef) {
        this.genericsComputer.storePostponedSubstitutionsIn(G, typeRef);
    }

    public void restorePostponedSubstitutionsFrom(RuleEnvironment G, StructuralTypeRef typeRef) {
        this.genericsComputer.restorePostponedSubstitutionsFrom(G, typeRef);
    }

    public TypeRef createUnionType(RuleEnvironment G, TypeRef ... elements) {
        return this.simplifyComputer.createUnionType(G, elements);
    }

    public TypeRef createIntersectionType(RuleEnvironment G, TypeRef ... elements) {
        return this.simplifyComputer.createIntersectionType(G, elements);
    }

    public <T extends ComposedTypeRef> TypeRef simplify(RuleEnvironment G, T composedType) {
        return this.simplifyComputer.simplify(G, composedType);
    }

    public List<TypeRef> getSimplifiedTypeRefs(RuleEnvironment G, ComposedTypeRef composedType) {
        return this.simplifyComputer.getSimplifiedTypeRefs(G, composedType);
    }

    public TypeRef join(RuleEnvironment G, TypeRef ... typeRefs) {
        return this.joinComputer.join(G, Arrays.asList(typeRefs));
    }

    public TypeRef join(RuleEnvironment G, Iterable<? extends TypeRef> typeRefsToJoin) {
        return this.joinComputer.join(G, typeRefsToJoin);
    }

    public TypeRef meet(RuleEnvironment G, TypeRef ... typeRefs) {
        return this.meetComputer.meet(G, Arrays.asList(typeRefs));
    }

    public TypeRef meet(RuleEnvironment G, Iterable<? extends TypeRef> typeRefs) {
        return this.meetComputer.meet(G, typeRefs);
    }

    public boolean isSubtypeFunction(RuleEnvironment G, FunctionTypeExprOrRef left, FunctionTypeExprOrRef right) {
        return this.subtypeComputer.isSubtypeFunction(G, left, right);
    }

    public StructuralTypingResult isStructuralSubtype(RuleEnvironment G, TypeRef left, TypeRef right) {
        return this.structuralTypingComputer.isStructuralSubtype(G, left, right);
    }

    public TypeRef getExpectedTypeOfReturnValueExpression(RuleEnvironment G, Expression returnValueExpr) {
        return this.expectedTypeCompuer.getExpectedTypeOfReturnValueExpression(G, returnValueExpr);
    }

    public TypeRef getExpectedTypeOfYieldValueExpression(RuleEnvironment G, YieldExpression yieldExpr, TypeRef exprTypeRef) {
        return this.expectedTypeCompuer.getExpectedTypeOfYieldValueExpression(G, yieldExpr, exprTypeRef);
    }

    public TypeRef getExpectedTypeOfFunctionOrFieldAccessor(RuleEnvironment G, FunctionOrFieldAccessor fofa) {
        return this.expectedTypeCompuer.getExpectedTypeOfFunctionOrFieldAccessor(G, fofa);
    }

    public TypeRef resolveType(RuleEnvironment G, TypeArgument typeArg) {
        TypeRef _xifexpression = null;
        if (typeArg != null) {
            _xifexpression = (TypeRef)this.ts.upperBound(G, typeArg).getValue();
        }
        TypeRef typeRef = _xifexpression;
        TypeRef _xifexpression_1 = null;
        if (typeRef != null) {
            _xifexpression_1 = TypeUtils.resolveTypeVariable((TypeRef)typeRef);
        }
        typeRef = _xifexpression_1;
        return typeRef;
    }

    public boolean allEqualType(RuleEnvironment G, TypeRef ... typeRefs) {
        int len = ((List)Conversions.doWrapArray((Object)typeRefs)).size();
        if (len >= 2) {
            TypeRef firstRef = (TypeRef)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)typeRefs)));
            int i = 1;
            while (i < len) {
                boolean _not;
                boolean _equaltypeSucceeded = this.ts.equaltypeSucceeded(G, (TypeArgument)firstRef, (TypeArgument)typeRefs[i]);
                boolean bl = _not = !_equaltypeSucceeded;
                if (_not) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public TypeRef sanitizeTypeOfVariableFieldProperty(RuleEnvironment G, TypeArgument typeRaw) {
        if (typeRaw == null || typeRaw instanceof UnknownTypeRef) {
            return RuleEnvironmentExtensions.anyTypeRef(G);
        }
        TypeRef typeUB = (TypeRef)this.ts.upperBound(G, typeRaw).getValue();
        Type declType = typeUB.getDeclaredType();
        if (declType == RuleEnvironmentExtensions.undefinedType(G) || declType == RuleEnvironmentExtensions.nullType(G) || declType == RuleEnvironmentExtensions.voidType(G)) {
            return RuleEnvironmentExtensions.anyTypeRef(G);
        }
        return typeUB;
    }

    public Iterator<ReturnStatement> returnStatements(FunctionDefinition definition) {
        Predicate _function = it -> !(it instanceof Expression) && !(it instanceof FunctionDefinition);
        Functions.Function1 _function_1 = it -> {
            Expression _expression = it.getExpression();
            return _expression != null;
        };
        return IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)EcoreUtilN4.getAllContentsFiltered((EObject)definition, (Predicate)_function), ReturnStatement.class), (Functions.Function1)_function_1);
    }

    public TypeRef makeDynamic(TypeRef typeRef) {
        boolean _not;
        boolean _isDynamic = typeRef.isDynamic();
        boolean bl = _not = !_isDynamic;
        if (_not && typeRef instanceof ParameterizedTypeRef) {
            ParameterizedTypeRef dyn = (ParameterizedTypeRef)TypeUtils.copyIfContained((EObject)((ParameterizedTypeRef)typeRef));
            dyn.setDynamic(true);
            return dyn;
        }
        return typeRef;
    }

    public static TypeRef declaredThisType(IdentifiableElement type) {
        TypeRef _switchResult = null;
        boolean _matched = false;
        if (type instanceof TFunction) {
            _matched = true;
            _switchResult = ((TFunction)type).getDeclaredThisType();
        }
        if (!_matched && type instanceof TGetter) {
            _matched = true;
            _switchResult = ((TGetter)type).getDeclaredThisType();
        }
        if (!_matched && type instanceof TSetter) {
            _matched = true;
            _switchResult = ((TSetter)type).getDeclaredThisType();
        }
        if (!_matched && type instanceof FunctionTypeExprOrRef) {
            _matched = true;
            _switchResult = ((FunctionTypeExprOrRef)type).getDeclaredThisType();
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public static boolean isStringBasedEnumeration(TEnum tEnum) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)AnnotationDefinition.STRING_BASED.name);
        };
        return IterableExtensions.exists((Iterable)tEnum.getAnnotations(), (Functions.Function1)_function);
    }

    public TypeRef bindAndSubstituteThisTypeRef(RuleEnvironment G, EObject location, TypeRef typeRef) {
        TypeRef boundThisTypeRef = (TypeRef)this.ts.thisTypeRef(G, location).getValue();
        RuleEnvironment localG = RuleEnvironmentExtensions.wrap(G);
        RuleEnvironmentExtensions.addThisType(localG, boundThisTypeRef);
        TypeArgument _value = (TypeArgument)this.ts.substTypeVariables(localG, (TypeArgument)typeRef).getValue();
        return (TypeRef)_value;
    }

    public boolean isCallable(RuleEnvironment G, TypeRef typeRef) {
        boolean _isClassConstructorFunction = this.isClassConstructorFunction(G, typeRef);
        if (_isClassConstructorFunction) {
            boolean _tripleNotEquals;
            TMethod _callableClassConstructorFunction = this.getCallableClassConstructorFunction(G, typeRef);
            boolean bl = _tripleNotEquals = _callableClassConstructorFunction != null;
            return _tripleNotEquals;
        }
        Type _declaredType = typeRef.getDeclaredType();
        if (_declaredType instanceof TFunction) {
            return true;
        }
        if (typeRef instanceof FunctionTypeExprOrRef) {
            return true;
        }
        boolean _subtypeSucceeded = this.ts.subtypeSucceeded(G, (TypeArgument)typeRef, (TypeArgument)RuleEnvironmentExtensions.structuralFunctionTypeRef(G));
        if (_subtypeSucceeded) {
            return true;
        }
        boolean _subtypeSucceeded_1 = this.ts.subtypeSucceeded(G, (TypeArgument)typeRef, (TypeArgument)RuleEnvironmentExtensions.functionTypeRef(G));
        if (_subtypeSucceeded_1) {
            return true;
        }
        return typeRef.isDynamic() && this.ts.subtypeSucceeded(G, (TypeArgument)RuleEnvironmentExtensions.functionTypeRef(G), (TypeArgument)typeRef);
    }

    public boolean isClassConstructorFunction(RuleEnvironment G, TypeRef typeRef) {
        Type cls;
        boolean _isConstructor_1;
        TFunction ft;
        boolean _isConstructor;
        Type declaredType = typeRef.getDeclaredType();
        if (declaredType instanceof TMethod && (_isConstructor = ((TMethod)declaredType).isConstructor())) {
            return true;
        }
        if (typeRef instanceof FunctionTypeExprOrRef && (ft = ((FunctionTypeExprOrRef)typeRef).getFunctionType()) instanceof TMethod && (_isConstructor_1 = ((TMethod)ft).isConstructor())) {
            return true;
        }
        return typeRef instanceof TypeTypeRef && ((cls = this.getStaticType(G, (TypeTypeRef)typeRef)) instanceof TClass || cls instanceof TObjectPrototype);
    }

    public TMethod getCallableClassConstructorFunction(RuleEnvironment G, TypeRef typeRef) {
        Type cls;
        boolean _isConstructor_1;
        TFunction ft;
        boolean _isConstructor;
        ContainerType type = null;
        Type declaredType = typeRef.getDeclaredType();
        if (declaredType instanceof TMethod && (_isConstructor = ((TMethod)declaredType).isConstructor())) {
            type = ((TMethod)declaredType).getContainingType();
        }
        if (typeRef instanceof FunctionTypeExprOrRef && (ft = ((FunctionTypeExprOrRef)typeRef).getFunctionType()) instanceof TMethod && (_isConstructor_1 = ((TMethod)ft).isConstructor())) {
            type = ((TMethod)ft).getContainingType();
        }
        if (typeRef instanceof TypeTypeRef && ((cls = this.getStaticType(G, (TypeTypeRef)typeRef)) instanceof TClass || cls instanceof TObjectPrototype)) {
            type = cls;
        }
        if (type instanceof ContainerType) {
            return type.getCallableCtor();
        }
        return null;
    }

    public Type getStaticType(RuleEnvironment G, TypeTypeRef ctorTypeRef) {
        TypeRef _staticTypeRef = this.getStaticTypeRef(G, ctorTypeRef);
        Type _declaredType = null;
        if (_staticTypeRef != null) {
            _declaredType = _staticTypeRef.getDeclaredType();
        }
        return _declaredType;
    }

    public TypeRef getStaticTypeRef(RuleEnvironment G, TypeTypeRef ctorTypeRef) {
        TypeArgument typeArg = ctorTypeRef.getTypeArg();
        while (typeArg instanceof Wildcard || typeArg instanceof ExistentialTypeRef || typeArg instanceof BoundThisTypeRef) {
            typeArg = (TypeArgument)this.ts.upperBound(G, typeArg).getValue();
        }
        return (TypeRef)typeArg;
    }

    public TypeRef createTypeRefFromStaticType(RuleEnvironment G, TypeTypeRef ctr, TypeArgument ... typeArgs) {
        TypeRef typeRef = this.getStaticTypeRef(G, ctr);
        Type type = typeRef.getDeclaredType();
        if (type != null) {
            TypeRef resultTypeRef = TypeExtensions.ref((Type)type, (TypeArgument[])typeArgs);
            return this.versionResolver.resolveVersion(resultTypeRef, typeRef);
        }
        return TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
    }

    public List<TypeRef> getSubtypesOnly(RuleEnvironment G, TypeRef ... typeRefs) {
        LinkedList<TypeRef> intersectTRs = new LinkedList<TypeRef>();
        TypeRef[] typeRefArray = typeRefs;
        int n = typeRefs.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _not;
            TypeRef s = typeRefArray[n2];
            Functions.Function1 _function = it -> this.ts.subtypeSucceeded(G, (TypeArgument)it, (TypeArgument)s);
            boolean _exists = IterableExtensions.exists(intersectTRs, (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (_not) {
                Predicate _function_1 = it -> this.ts.subtypeSucceeded(G, (TypeArgument)s, (TypeArgument)it);
                Iterables.removeIf(intersectTRs, (Predicate)_function_1);
                intersectTRs.add(s);
            }
            ++n2;
        }
        return intersectTRs;
    }

    public List<TypeRef> getSuperTypesOnly(RuleEnvironment G, TypeRef ... typeRefs) {
        LinkedList<TypeRef> unionTRs = new LinkedList<TypeRef>();
        TypeRef[] typeRefArray = typeRefs;
        int n = typeRefs.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _not;
            TypeRef s = typeRefArray[n2];
            Functions.Function1 _function = it -> this.ts.subtypeSucceeded(G, (TypeArgument)s, (TypeArgument)it);
            boolean _exists = IterableExtensions.exists(unionTRs, (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (_not) {
                Predicate _function_1 = it -> this.ts.subtypeSucceeded(G, (TypeArgument)s, (TypeArgument)it);
                Iterables.removeIf(unionTRs, (Predicate)_function_1);
                unionTRs.add(s);
            }
            ++n2;
        }
        return unionTRs;
    }

    public TypeRef getActualGeneratorReturnType(RuleEnvironment G, Expression expr) {
        BuiltInTypeScope scope;
        TypeRef actualReturnTypeRef;
        boolean _isGenerator;
        EObject _eContainer = null;
        if (expr != null) {
            _eContainer = expr.eContainer();
        }
        FunctionDefinition funDef = (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)_eContainer, FunctionDefinition.class);
        RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(G);
        TypeRef myThisTypeRef = (TypeRef)this.ts.thisTypeRef(G, (EObject)expr).getValue();
        RuleEnvironmentExtensions.addThisType(G2, myThisTypeRef);
        if (funDef == null || !funDef.isGenerator()) {
            return null;
        }
        Type tFun = funDef.getDefinedType();
        if (tFun instanceof TFunction && (_isGenerator = TypeUtils.isGenerator((TypeRef)(actualReturnTypeRef = ((TFunction)tFun).getReturnTypeRef()), (BuiltInTypeScope)(scope = RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope)))) {
            return actualReturnTypeRef;
        }
        return TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
    }

    public TypeRef getGeneratorTYield(RuleEnvironment G, TypeRef generatorTypeRef) {
        TypeArgument yieldTypeArg;
        boolean _tripleEquals;
        TypeRef yieldTypeRef = null;
        int _length = ((Object[])Conversions.unwrapArray((Object)generatorTypeRef.getTypeArgs(), Object.class)).length;
        boolean bl = _tripleEquals = _length == 3;
        if (_tripleEquals && (yieldTypeArg = (TypeArgument)generatorTypeRef.getTypeArgs().get(0)) != null) {
            yieldTypeRef = (TypeRef)this.ts.upperBound(G, yieldTypeArg).getValue();
        }
        return yieldTypeRef;
    }

    public TypeRef getGeneratorTReturn(RuleEnvironment G, TypeRef generatorTypeRef) {
        TypeArgument returnTypeArg;
        boolean _tripleEquals;
        TypeRef returnTypeRef = null;
        int _length = ((Object[])Conversions.unwrapArray((Object)generatorTypeRef.getTypeArgs(), Object.class)).length;
        boolean bl = _tripleEquals = _length == 3;
        if (_tripleEquals && (returnTypeArg = (TypeArgument)generatorTypeRef.getTypeArgs().get(1)) != null) {
            returnTypeRef = (TypeRef)this.ts.upperBound(G, returnTypeArg).getValue();
        }
        return returnTypeRef;
    }

    public TypeRef getGeneratorTNext(RuleEnvironment G, TypeRef generatorTypeRef) {
        TypeArgument nextTypeArg;
        boolean _tripleEquals;
        TypeRef nextTypeRef = null;
        int _length = ((Object[])Conversions.unwrapArray((Object)generatorTypeRef.getTypeArgs(), Object.class)).length;
        boolean bl = _tripleEquals = _length == 3;
        if (_tripleEquals && (nextTypeArg = (TypeArgument)generatorTypeRef.getTypeArgs().get(2)) != null) {
            nextTypeRef = (TypeRef)this.ts.upperBound(G, nextTypeArg).getValue();
        }
        return nextTypeRef;
    }

    public TypeRef getIterableTypeArg(RuleEnvironment G, TypeRef iterableTypeRef) {
        TypeArgument nextTypeArg;
        boolean _tripleEquals;
        TypeRef typeRef = null;
        int _length = ((Object[])Conversions.unwrapArray((Object)iterableTypeRef.getTypeArgs(), Object.class)).length;
        boolean bl = _tripleEquals = _length == 1;
        if (_tripleEquals && (nextTypeArg = (TypeArgument)iterableTypeRef.getTypeArgs().get(0)) != null) {
            typeRef = (TypeRef)this.ts.upperBound(G, nextTypeArg).getValue();
        }
        return typeRef;
    }
}

