/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import java.util.Objects;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructuralType;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.AndFunction1;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class StructuralMembersPredicates {
    public static final AndFunction1<TMember> MEMBERS_PREDICATE = AndFunction1.conjunctionOf(it -> {
        boolean _isConstructor = it.isConstructor();
        return !_isConstructor;
    }, (Functions.Function1[])new Functions.Function1[0]);
    public static final AndFunction1<TMember> FIELDS_PREDICATE = AndFunction1.conjunctionOf(it -> it instanceof TField || it instanceof FieldAccessor, (Functions.Function1[])new Functions.Function1[0]);
    public static final AndFunction1<TMember> READABLE_FIELDS_PREDICATE = AndFunction1.conjunctionOf(it -> it instanceof TField && it.isReadable() || it instanceof TGetter, (Functions.Function1[])new Functions.Function1[0]);
    public static final AndFunction1<TMember> WRITABLE_FIELDS_PREDICATE = AndFunction1.conjunctionOf(it -> {
        boolean _xifexpression = false;
        _xifexpression = it instanceof TField ? ((TField)it).isWriteable() || ((TField)it).isFinal() && !((TField)it).isHasExpression() : it instanceof TSetter;
        return _xifexpression;
    }, (Functions.Function1[])new Functions.Function1[0]);
    public static final AndFunction1<TMember> GETTERS_PREDICATE = AndFunction1.conjunctionOf(it -> it instanceof TGetter, (Functions.Function1[])new Functions.Function1[0]);
    public static final AndFunction1<TMember> SETTERS_PREDICATE = AndFunction1.conjunctionOf(it -> it instanceof TSetter, (Functions.Function1[])new Functions.Function1[0]);

    public static AndFunction1<TMember> createBaseStructuralMembersPredicate(RuleEnvironment it) {
        BaseStructuralMembersPredicate _baseStructuralMembersPredicate = new BaseStructuralMembersPredicate(it);
        return AndFunction1.conjunctionOf((Functions.Function1)_baseStructuralMembersPredicate, (Functions.Function1[])new Functions.Function1[0]);
    }

    private static class BaseStructuralMembersPredicate
    implements Functions.Function1<TMember, Boolean> {
        private final RuleEnvironment G;
        private final Type n4ObjectType;
        private final TMember object__proto__;

        private BaseStructuralMembersPredicate(RuleEnvironment G) {
            this.G = G;
            this.n4ObjectType = (Type)Objects.requireNonNull(RuleEnvironmentExtensions.n4ObjectType(G));
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                return com.google.common.base.Objects.equal((Object)_name, (Object)"__proto__");
            };
            this.object__proto__ = Objects.requireNonNull((TMember)IterableExtensions.findFirst((Iterable)RuleEnvironmentExtensions.objectType(G).getOwnedMembers(), (Functions.Function1)_function));
        }

        public Boolean apply(TMember it) {
            boolean _not;
            boolean _hasStructuralTypeContainer = this.hasStructuralTypeContainer(it);
            boolean bl = _not = !_hasStructuralTypeContainer;
            if (_not) {
                boolean _not_1;
                boolean _isPublicVisible = this.isPublicVisible(it);
                boolean bl2 = _not_1 = !_isPublicVisible;
                if (_not_1) {
                    return false;
                }
                boolean _hasN4ObjectTypeContainer = this.hasN4ObjectTypeContainer(it);
                if (_hasN4ObjectTypeContainer) {
                    return false;
                }
                boolean _isStatic = it.isStatic();
                if (_isStatic) {
                    return false;
                }
                if (it == this.object__proto__) {
                    return false;
                }
            }
            return true;
        }

        private boolean hasStructuralTypeContainer(TMember it) {
            ContainerType _containingType = it.getContainingType();
            return _containingType instanceof TStructuralType;
        }

        private boolean hasN4ObjectTypeContainer(TMember it) {
            ContainerType _containingType = it.getContainingType();
            return _containingType == this.n4ObjectType;
        }

        private boolean isPublicVisible(TMember it) {
            int _compareTo = MemberAccessModifier.PUBLIC_INTERNAL.compareTo((Enum)it.getMemberAccessModifier());
            return _compareTo <= 0;
        }
    }
}

