/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.ArrayBindingPattern;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.BindingPattern;
import org.eclipse.n4js.n4JS.BindingProperty;
import org.eclipse.n4js.n4JS.DestructNode;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.ObjectBindingPattern;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertyNameValuePairSingleName;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.DestructureHelper;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class N4JSDestructureValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private DestructureHelper destructureHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkNoEmptyPattern_Binding(BindingPattern pattern) {
        boolean isEmpty;
        boolean _switchResult = false;
        boolean _matched = false;
        if (pattern instanceof ArrayBindingPattern) {
            _matched = true;
            _switchResult = ((ArrayBindingPattern)pattern).getElements().isEmpty();
        }
        if (!_matched && pattern instanceof ObjectBindingPattern) {
            _matched = true;
            _switchResult = ((ObjectBindingPattern)pattern).getProperties().isEmpty();
        }
        if (isEmpty = _switchResult) {
            String message = IssueCodes.getMessageForDESTRUCT_EMPTY_PATTERN();
            this.addIssue(message, (EObject)pattern, "DESTRUCT_EMPTY_PATTERN");
        }
    }

    @Check
    public void checkNoEmptyPattern_Assignment(AssignmentExpression expr) {
        boolean _isTopOfDestructuringAssignment = DestructureUtils.isTopOfDestructuringAssignment((EObject)expr);
        if (_isTopOfDestructuringAssignment) {
            boolean empty;
            Expression lhs = expr.getLhs();
            boolean _switchResult = false;
            boolean _matched = false;
            if (lhs instanceof ArrayLiteral) {
                _matched = true;
                _switchResult = ((ArrayLiteral)lhs).getElements().isEmpty();
            }
            if (!_matched && lhs instanceof ObjectLiteral) {
                _matched = true;
                _switchResult = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)((ObjectLiteral)lhs).getPropertyAssignments(), PropertyNameValuePair.class));
            }
            if (empty = _switchResult) {
                String message = IssueCodes.getMessageForDESTRUCT_EMPTY_PATTERN();
                this.addIssue(message, (EObject)lhs, "DESTRUCT_EMPTY_PATTERN");
            }
        }
    }

    @Check
    public void checkTypesInDestructPatternInVariableBinding(VariableBinding binding) {
        this.internal_checkDestructPattern(DestructNode.unify((VariableBinding)binding), (EObject)binding);
    }

    @Check
    public void checkTypesInDestructPatternInAssignmentExpression(AssignmentExpression expr) {
        this.internal_checkDestructPattern(DestructNode.unify((AssignmentExpression)expr), (EObject)expr);
    }

    @Check
    public void checkTypesInDestructPatternInForInOfStatement(ForStatement stmnt) {
        this.internal_checkDestructPattern(DestructNode.unify((ForStatement)stmnt), (EObject)stmnt);
    }

    private void internal_checkDestructPattern(DestructNode rootNode, EObject contextObject) {
        if (rootNode == null) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment(contextObject);
        HashMap valueTypePerNode = CollectionLiterals.newHashMap();
        this.destructureHelper.buildValueTypesMap(G, rootNode, valueTypePerNode, contextObject);
        this.internal_checkDestructNode(G, null, rootNode, null, valueTypePerNode, contextObject);
    }

    private void internal_checkDestructNode(RuleEnvironment G, DestructNode parentNode, DestructNode node, IScope parentMemberScope, Map<DestructNode, TypeRef> valueTypePerNode, EObject contextObject) {
        TypeRef valueTypeRef;
        boolean isValid;
        boolean bl = isValid = this.holdsValidPropertyAccessInDestructNode(G, parentNode, node, parentMemberScope, valueTypePerNode) && this.holdsCorrectTypeInDestructNode(G, parentNode, node, valueTypePerNode);
        if (isValid && node.getNestedNodes() != null && !((List)Conversions.doWrapArray((Object)node.getNestedNodes())).isEmpty() && (valueTypeRef = valueTypePerNode.get(node)) != null) {
            DestructNode[] _nestedNodes;
            IScope memberScope = this.createMemberScope(node, valueTypeRef, contextObject);
            DestructNode[] destructNodeArray = _nestedNodes = node.getNestedNodes();
            int n = _nestedNodes.length;
            int n2 = 0;
            while (n2 < n) {
                DestructNode childNode = destructNodeArray[n2];
                if (childNode != null) {
                    this.internal_checkDestructNode(G, node, childNode, memberScope, valueTypePerNode, contextObject);
                }
                ++n2;
            }
        }
    }

    private boolean holdsValidPropertyAccessInDestructNode(RuleEnvironment G, DestructNode parentNode, DestructNode node, IScope parentMemberScope, Map<DestructNode, TypeRef> valueTypePerNode) {
        if (node.getPropName() != null && parentMemberScope != null) {
            boolean _greaterThan;
            StringBuffer errMsg = new StringBuffer();
            TypeRef propTypeRef = this.destructureHelper.getPropertyTypeForNode(G, valueTypePerNode.get(parentNode), parentMemberScope, node.getPropName(), errMsg);
            int _length = errMsg.length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                String msg = IssueCodes.getMessageForDESTRUCT_PROP_WITH_ERROR(node.getPropName(), UtilN4.trimSuffix((String)errMsg.toString().trim(), (String[])new String[]{"."}));
                Pair astNodeOfPropName = node.getEObjectAndFeatureForPropName();
                this.addIssue(msg, (EObject)astNodeOfPropName.getKey(), (EStructuralFeature)astNodeOfPropName.getValue(), "DESTRUCT_PROP_WITH_ERROR", new String[0]);
                return false;
            }
            if (propTypeRef == null) {
                TypeRef _get = valueTypePerNode.get(parentNode);
                String _typeRefAsString = null;
                if (_get != null) {
                    _typeRefAsString = _get.getTypeRefAsString();
                }
                String msg_1 = IssueCodes.getMessageForDESTRUCT_PROP_MISSING(node.getPropName(), _typeRefAsString);
                Pair astNodeOfPropName_1 = node.getEObjectAndFeatureForPropName();
                this.addIssue(msg_1, (EObject)astNodeOfPropName_1.getKey(), (EStructuralFeature)astNodeOfPropName_1.getValue(), "DESTRUCT_PROP_MISSING", new String[0]);
                return false;
            }
        }
        return true;
    }

    private boolean holdsCorrectTypeInDestructNode(RuleEnvironment G, DestructNode parentNode, DestructNode node, Map<DestructNode, TypeRef> valueTypePerNode) {
        TypeRef valueTypeRef = valueTypePerNode.get(node);
        if (valueTypeRef == null) {
            return true;
        }
        if (node.getVarDecl() != null || node.getVarRef() != null) {
            if (node.getVarDecl() == null || node.getVarDecl().getDeclaredTypeRef() != null) {
                boolean _tripleNotEquals;
                TypeRef _xifexpression = null;
                VariableDeclaration _varDecl = node.getVarDecl();
                boolean bl = _tripleNotEquals = _varDecl != null;
                if (_tripleNotEquals) {
                    _xifexpression = (TypeRef)this.ts.type(G, (TypableElement)node.getVarDecl()).getValue();
                } else {
                    boolean _tripleNotEquals_1;
                    TypeRef _xifexpression_1 = null;
                    IdentifierRef _varRef = node.getVarRef();
                    boolean bl2 = _tripleNotEquals_1 = _varRef != null;
                    if (_tripleNotEquals_1) {
                        _xifexpression_1 = (TypeRef)this.ts.type(G, (TypableElement)node.getVarRef()).getValue();
                    }
                    _xifexpression = _xifexpression_1;
                }
                TypeRef variableTypeRef = _xifexpression;
                if (variableTypeRef != null) {
                    Result<Boolean> result;
                    boolean _failed;
                    boolean _tripleNotEquals_2;
                    Expression _defaultExpr = node.getDefaultExpr();
                    boolean bl3 = _tripleNotEquals_2 = _defaultExpr != null;
                    if (_tripleNotEquals_2) {
                        boolean isOfCorrectType;
                        TypeRef defaultExprTypeRef = (TypeRef)this.ts.type(G, (TypableElement)node.getDefaultExpr()).getValue();
                        boolean _xifexpression_2 = false;
                        if (defaultExprTypeRef != null) {
                            _xifexpression_2 = this.ts.subtypeSucceeded(G, (TypeArgument)defaultExprTypeRef, (TypeArgument)variableTypeRef);
                        }
                        if (!(isOfCorrectType = _xifexpression_2)) {
                            return false;
                        }
                    }
                    if (_failed = (result = this.ts.subtype(G, (TypeArgument)valueTypeRef, (TypeArgument)variableTypeRef)).failed()) {
                        boolean _tripleNotEquals_3;
                        String _elvis = null;
                        String _elvis_1 = null;
                        VariableDeclaration _varDecl_1 = node.getVarDecl();
                        String _name = null;
                        if (_varDecl_1 != null) {
                            _name = _varDecl_1.getName();
                        }
                        if (_name != null) {
                            _elvis_1 = _name;
                        } else {
                            IdentifierRef _varRef_1 = node.getVarRef();
                            IdentifiableElement _id = null;
                            if (_varRef_1 != null) {
                                _id = _varRef_1.getId();
                            }
                            String _name_1 = null;
                            if (_id != null) {
                                _name_1 = _id.getName();
                            }
                            _elvis_1 = _name_1;
                        }
                        _elvis = _elvis_1 != null ? _elvis_1 : "<unnamed>";
                        String varName = _elvis;
                        String _xifexpression_3 = null;
                        boolean _isPositional = node.isPositional();
                        if (_isPositional) {
                            int _indexOf = ((List)Conversions.doWrapArray((Object)parentNode.getNestedNodes())).indexOf(node);
                            _xifexpression_3 = "at index " + Integer.valueOf(_indexOf);
                        } else {
                            String _propName = node.getPropName();
                            String _plus = "of property '" + _propName;
                            _xifexpression_3 = String.valueOf(_plus) + "'";
                        }
                        String elemDesc = _xifexpression_3;
                        String tsMsg = UtilN4.trimSuffix((String)UtilN4.trimPrefix((String)result.getRuleFailedException().getMessage(), (String[])new String[]{"failed: "}), (String[])new String[]{"."});
                        String msg = IssueCodes.getMessageForDESTRUCT_TYPE_ERROR_VAR(varName, elemDesc, tsMsg);
                        VariableDeclaration _varDecl_2 = node.getVarDecl();
                        boolean bl4 = _tripleNotEquals_3 = _varDecl_2 != null;
                        if (_tripleNotEquals_3) {
                            this.addIssue(msg, (EObject)node.getVarDecl(), (EStructuralFeature)TypesPackage.eINSTANCE.getIdentifiableElement_Name(), "DESTRUCT_TYPE_ERROR_VAR", new String[0]);
                        } else {
                            this.addIssue(msg, (EObject)node.getVarRef(), "DESTRUCT_TYPE_ERROR_VAR");
                        }
                        return false;
                    }
                }
            }
        } else {
            boolean _tripleNotEquals_4;
            DestructNode[] _nestedNodes = node.getNestedNodes();
            boolean bl = _tripleNotEquals_4 = _nestedNodes != null;
            if (_tripleNotEquals_4) {
                boolean isPositional = DestructNode.arePositional((DestructNode[])node.getNestedNodes());
                ParameterizedTypeRef _xifexpression_4 = null;
                _xifexpression_4 = isPositional ? RuleEnvironmentExtensions.iterableTypeRef(G, new TypeArgument[]{TypeRefsFactory.eINSTANCE.createWildcard()}) : RuleEnvironmentExtensions.objectTypeRef(G);
                ParameterizedTypeRef expectedTypeRef = _xifexpression_4;
                Result<Boolean> result_1 = this.ts.subtype(G, (TypeArgument)this.autoboxIfPrimitive(valueTypeRef), (TypeArgument)expectedTypeRef);
                boolean _failed_1 = result_1.failed();
                if (_failed_1) {
                    String _xifexpression_5 = null;
                    if (isPositional) {
                        String _xifexpression_6 = null;
                        _xifexpression_6 = parentNode != null ? "Nested array" : "Array";
                        _xifexpression_5 = _xifexpression_6;
                    } else {
                        String _xifexpression_7 = null;
                        _xifexpression_7 = parentNode != null ? "Nested object" : "Object";
                        _xifexpression_5 = _xifexpression_7;
                    }
                    String patternKind = _xifexpression_5;
                    String _xifexpression_8 = null;
                    if (parentNode != null) {
                        String _xifexpression_9 = null;
                        boolean _isPositional_1 = node.isPositional();
                        if (_isPositional_1) {
                            int _indexOf_1 = ((List)Conversions.doWrapArray((Object)parentNode.getNestedNodes())).indexOf(node);
                            _xifexpression_9 = "destructured value at index " + Integer.valueOf(_indexOf_1);
                        } else {
                            String _propName_1 = node.getPropName();
                            String _plus_1 = "destructured value of property '" + _propName_1;
                            _xifexpression_9 = String.valueOf(_plus_1) + "'";
                        }
                        _xifexpression_8 = _xifexpression_9;
                    } else {
                        String _typeRefAsString = valueTypeRef.getTypeRefAsString();
                        String _plus_2 = "a value of type '" + _typeRefAsString;
                        _xifexpression_8 = String.valueOf(_plus_2) + "'";
                    }
                    String elemDesc_1 = _xifexpression_8;
                    String tsMsg_1 = UtilN4.trimSuffix((String)UtilN4.trimPrefix((String)result_1.getRuleFailedException().getMessage(), (String[])new String[]{"failed: "}), (String[])new String[]{"."});
                    String msg_1 = IssueCodes.getMessageForDESTRUCT_TYPE_ERROR_PATTERN(patternKind, elemDesc_1, tsMsg_1);
                    EObject astElem = node.getAstElement();
                    boolean _matched = false;
                    if (astElem instanceof PropertyNameValuePair && !(astElem instanceof PropertyNameValuePairSingleName)) {
                        _matched = true;
                        this.addIssue(msg_1, astElem, (EStructuralFeature)N4JSPackage.eINSTANCE.getPropertyNameValuePair_Expression(), "DESTRUCT_TYPE_ERROR_PATTERN", new String[0]);
                    }
                    if (!_matched && astElem instanceof BindingProperty) {
                        _matched = true;
                        this.addIssue(msg_1, astElem, (EStructuralFeature)N4JSPackage.eINSTANCE.getBindingProperty_Value(), "DESTRUCT_TYPE_ERROR_PATTERN", new String[0]);
                    }
                    if (!_matched) {
                        this.addIssue(msg_1, astElem, "DESTRUCT_TYPE_ERROR_PATTERN");
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private IScope createMemberScope(DestructNode node, TypeRef valueTypeRef, EObject contextObject) {
        IScope _xifexpression = null;
        _xifexpression = !((List)Conversions.doWrapArray((Object)node.getNestedNodes())).isEmpty() && !DestructNode.arePositional((DestructNode[])node.getNestedNodes()) ? this.destructureHelper.createMemberScopeForPropertyAccess(valueTypeRef, contextObject, true) : null;
        return _xifexpression;
    }

    private TypeRef autoboxIfPrimitive(TypeRef typeRef) {
        Type declType = typeRef.getDeclaredType();
        if (declType instanceof PrimitiveType) {
            boolean _tripleNotEquals;
            TClassifier _autoboxedType = ((PrimitiveType)declType).getAutoboxedType();
            boolean bl = _tripleNotEquals = _autoboxedType != null;
            if (_tripleNotEquals) {
                return TypeUtils.createTypeRef((Type)((PrimitiveType)declType).getAutoboxedType(), (TypeArgument[])new TypeArgument[0]);
            }
        }
        return typeRef;
    }
}

