/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.NullType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.UndefinedType;
import org.eclipse.n4js.ts.types.util.AllSuperTypesCollector;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.validators.N4JSDependencyInjectionValidator;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class N4JSInjectorCallsitesValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private ResourceNameComputer resourceNameComputer;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkCallExpression(ParameterizedCallExpression callExpression) {
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        if (callExpression == null) {
            return;
        }
        Expression _target = callExpression.getTarget();
        boolean bl = _not = !(_target instanceof ParameterizedPropertyAccessExpression);
        if (_not) {
            return;
        }
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)callExpression.getArguments());
        if (_isNullOrEmpty) {
            return;
        }
        Expression _target_1 = callExpression.getTarget();
        ParameterizedPropertyAccessExpression propAccess = (ParameterizedPropertyAccessExpression)_target_1;
        if (propAccess == null) {
            return;
        }
        IdentifiableElement _property = propAccess.getProperty();
        boolean bl2 = _not_1 = !(_property instanceof TMethod);
        if (_not_1) {
            return;
        }
        IdentifiableElement _property_1 = propAccess.getProperty();
        TMethod property = (TMethod)_property_1;
        EObject _eContainer = property.eContainer();
        boolean bl3 = _not_2 = !(_eContainer instanceof TClass);
        if (_not_2) {
            return;
        }
        EObject _eContainer_1 = property.eContainer();
        TClass tclassOfReceiver = (TClass)_eContainer_1;
        boolean _isInjectorType = this.isInjectorType((Type)tclassOfReceiver);
        if (_isInjectorType) {
            String _name = property.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)"of");
            if (_equals) {
                this.internalCheckInjectorOfCallsite(callExpression);
            } else {
                String _name_1 = property.getName();
                boolean _equals_1 = Objects.equal((Object)_name_1, (Object)"create");
                if (_equals_1) {
                    this.internalCheckInjectorCreateCallsite(callExpression);
                }
            }
        }
    }

    private void internalCheckInjectorOfCallsite(ParameterizedCallExpression callExpression) {
        boolean _equals_1;
        boolean _equals;
        Functions.Function1 _function = it -> it.getExpression();
        List args = ListExtensions.map((List)callExpression.getArguments(), (Functions.Function1)_function);
        Expression ctorOfDICArg = null;
        Expression _get = (Expression)args.get(0);
        if (_get instanceof CastExpression) {
            Expression _get_1 = (Expression)args.get(0);
            ctorOfDICArg = ((CastExpression)_get_1).getExpression();
        } else {
            ctorOfDICArg = (Expression)args.get(0);
        }
        TClass dicTClass = this.holdsDenotesDICConstructor(ctorOfDICArg);
        if (dicTClass == null) {
            return;
        }
        Iterable<TClass> usedBinders = N4JSDependencyInjectionValidator.usedBindersOf(dicTClass);
        Functions.Function1 _function_1 = binder -> N4JSDependencyInjectionValidator.requiresInjection(binder) || N4JSInjectorCallsitesValidator.hasNonEmptyCtor(binder);
        Iterable bindersForWhichInstancesAreNeeded = IterableExtensions.filter(usedBinders, (Functions.Function1)_function_1);
        int _size = args.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            this.holdsNoProvidedBindersNeeded(callExpression, bindersForWhichInstancesAreNeeded);
            return;
        }
        Expression parentDIC = (Expression)args.get(1);
        this.holdsDenotesInjector(parentDIC);
        int _size_1 = args.size();
        boolean bl2 = _equals_1 = _size_1 == 2;
        if (_equals_1) {
            this.holdsNoProvidedBindersNeeded(callExpression, bindersForWhichInstancesAreNeeded);
            return;
        }
        List<Expression> providedBinders = args.subList(2, args.size());
        this.holdsAllNeededBinderInstancesAreProvided(callExpression, providedBinders, bindersForWhichInstancesAreNeeded);
    }

    private static boolean hasNonEmptyCtor(TClass tClass) {
        Functions.Function1 _function = t -> {
            Functions.Function1 _function_1 = ctor -> ctor.isConstructor() && N4JSInjectorCallsitesValidator.lacksParams((TMethod)ctor);
            return IterableExtensions.exists((Iterable)t.getOwnedMembers(), (Functions.Function1)_function_1);
        };
        return IterableExtensions.exists((Iterable)AllSuperTypesCollector.collect((ContainerType)tClass), (Functions.Function1)_function);
    }

    private static boolean lacksParams(TMethod m) {
        return m.getFpars().isEmpty();
    }

    private void holdsNoProvidedBindersNeeded(ParameterizedCallExpression callExpression, Iterable<TClass> bindersForWhichInstancesAreNeeded) {
        boolean _isEmpty = IterableExtensions.isEmpty(bindersForWhichInstancesAreNeeded);
        if (_isEmpty) {
            return;
        }
        Functions.Function1 _function = binder -> binder.getTypeAsString();
        String missing = IterableExtensions.join((Iterable)IterableExtensions.map(bindersForWhichInstancesAreNeeded, (Functions.Function1)_function), (CharSequence)", ");
        String msg = IssueCodes.getMessageForDI_ANN_MISSING_PROVIDED_BINDERS(missing);
        this.addIssue(msg, (EObject)callExpression, "DI_ANN_MISSING_PROVIDED_BINDERS");
    }

    private TClass holdsDenotesDICConstructor(Expression ctorOfDICArg) {
        TypeArgument _typeArg_1;
        TClass dicTClass;
        TypeArgument _typeArg;
        TypeRef ctorOfDICTypeRef = this.ts.tau((TypableElement)ctorOfDICArg);
        if (ctorOfDICTypeRef instanceof TypeTypeRef && (_typeArg = ((TypeTypeRef)ctorOfDICTypeRef).getTypeArg()) instanceof TypeRef && (dicTClass = N4JSInjectorCallsitesValidator.dicTClassOf((TypeRef)(_typeArg_1 = ((TypeTypeRef)ctorOfDICTypeRef).getTypeArg()))) != null) {
            return dicTClass;
        }
        this.addIssue(IssueCodes.getMessageForDI_ANN_INJECTOR_REQUIRED(), (EObject)ctorOfDICArg, "DI_ANN_INJECTOR_REQUIRED");
        return null;
    }

    private static TClass dicTClassOf(TypeRef ref) {
        TClass injtorClassDecl = N4JSDependencyInjectionValidator.tClassOf(ref);
        if (injtorClassDecl != null && AnnotationDefinition.GENERATE_INJECTOR.hasAnnotation((TAnnotableElement)injtorClassDecl)) {
            return injtorClassDecl;
        }
        return null;
    }

    private void internalCheckInjectorCreateCallsite(ParameterizedCallExpression callExpression) {
        boolean _isInjectableType;
        Expression ctorArg;
        TypeRef ctorArgTypeRef;
        Argument _head = (Argument)IterableExtensions.head((Iterable)callExpression.getArguments());
        Expression _expression = null;
        if (_head != null) {
            _expression = _head.getExpression();
        }
        if ((ctorArgTypeRef = this.ts.tau((TypableElement)(ctorArg = _expression))) instanceof TypeTypeRef && (_isInjectableType = N4JSDependencyInjectionValidator.isInjectableType(((TypeTypeRef)ctorArgTypeRef).getTypeArg()))) {
            return;
        }
        this.addIssue(IssueCodes.getMessageForDI_NOT_INJECTABLE(ctorArgTypeRef.getTypeRefAsString(), ""), (EObject)ctorArg, "DI_NOT_INJECTABLE");
    }

    private boolean isAllowedAsInjectorInstance(Type type) {
        return N4JSInjectorCallsitesValidator.isNullOrUndefinedType(type) || this.isInjectorType(type);
    }

    private boolean isInjectorType(Type type) {
        boolean _not;
        if (!(type instanceof TClass)) {
            return false;
        }
        String _name = type.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)"N4Injector");
        boolean bl = _not = !_equals;
        if (_not) {
            return false;
        }
        String fqn = this.resourceNameComputer.getFullyQualifiedTypeName(type);
        return Objects.equal((Object)fqn, (Object)"runtime.n4.N4Injector.N4Injector");
    }

    private static boolean isNullOrUndefinedType(Type type) {
        return type instanceof NullType || type instanceof UndefinedType;
    }

    private void holdsDenotesInjector(Expression expr) {
        TypeRef tr = this.ts.tau((TypableElement)expr);
        boolean _isAllowedAsInjectorInstance = this.isAllowedAsInjectorInstance(tr.getDeclaredType());
        if (_isAllowedAsInjectorInstance) {
            return;
        }
        this.addIssue(IssueCodes.getMessageForDI_ANN_INJECTOR_MISSING(), (EObject)expr, "DI_ANN_INJECTOR_MISSING");
    }

    private void holdsAllNeededBinderInstancesAreProvided(ParameterizedCallExpression callExpression, List<Expression> providedBinders, Iterable<TClass> bindersForWhichInstancesAreNeeded) {
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)providedBinders.get(0));
        Functions.Function1 _function = expr -> this.ts.tau((TypableElement)expr);
        Functions.Function1 _function_1 = tr -> {
            boolean _isNullOrUndefinedType = N4JSInjectorCallsitesValidator.isNullOrUndefinedType(tr.getDeclaredType());
            return !_isNullOrUndefinedType;
        };
        Iterable availableTypeRefs = IterableExtensions.filter((Iterable)ListExtensions.map(providedBinders, (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = requirement -> {
            boolean _someBinderSatisfies = this.someBinderSatisfies(G, availableTypeRefs, (TClass)requirement);
            return !_someBinderSatisfies;
        };
        Iterable missingBinders = IterableExtensions.filter(bindersForWhichInstancesAreNeeded, (Functions.Function1)_function_2);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)missingBinders);
        if (_isEmpty) {
            return;
        }
        Functions.Function1 _function_3 = binder -> binder.getTypeAsString();
        String missing = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)missingBinders, (Functions.Function1)_function_3), (CharSequence)", ");
        String msg = IssueCodes.getMessageForDI_ANN_MISSING_NEEDED_BINDERS(missing);
        this.addIssue(msg, (EObject)callExpression, "DI_ANN_MISSING_NEEDED_BINDERS");
    }

    private boolean someBinderSatisfies(RuleEnvironment G, Iterable<? extends TypeRef> availableTypeRefs, TClass requirement) {
        Functions.Function1 _function = availableTR -> this.ts.subtypeSucceeded(G, (TypeArgument)availableTR, (TypeArgument)TypeUtils.createTypeRef((Type)requirement, (TypeArgument[])new TypeArgument[0]));
        return IterableExtensions.exists(availableTypeRefs, (Functions.Function1)_function);
    }
}

