/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.n4js.ui.internal.CompositeValidationIssueProcessor;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.editor.validation.MarkerIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class OwnResourceValidatorAwareValidatingEditorCallback
extends IXtextEditorCallback.NullImpl {
    public void afterCreatePartControl(XtextEditor editor) {
        super.afterCreatePartControl(editor);
        if (editor.isEditable()) {
            this.newValidationJob(editor).schedule();
        }
    }

    public void afterSave(XtextEditor editor) {
        super.afterSave(editor);
        if (editor.isEditable()) {
            this.newValidationJob(editor).schedule();
        }
    }

    private ValidationJob newValidationJob(XtextEditor editor) {
        IXtextDocument document = editor.getDocument();
        IAnnotationModel annotationModel = editor.getInternalSourceViewer().getAnnotationModel();
        IssueResolutionProvider issueResolutionProvider = this.getService(editor, IssueResolutionProvider.class);
        MarkerTypeProvider markerTypeProvider = this.getService(editor, MarkerTypeProvider.class);
        MarkerCreator markerCreator = this.getService(editor, MarkerCreator.class);
        CompositeValidationIssueProcessor issueProcessor = new CompositeValidationIssueProcessor((IValidationIssueProcessor)new AnnotationIssueProcessor(document, annotationModel, issueResolutionProvider), new IValidationIssueProcessor[]{new MarkerIssueProcessor(editor.getResource(), markerCreator, markerTypeProvider)});
        return (ValidationJob)editor.getDocument().modify(resource -> {
            IResourceServiceProvider serviceProvider = resource.getResourceServiceProvider();
            IResourceValidator resourceValidator = serviceProvider.getResourceValidator();
            return new ValidationJob(resourceValidator, (IReadAccess)editor.getDocument(), issueProcessor, CheckMode.ALL);
        });
    }

    private <T> T getService(XtextEditor editor, Class<T> clazz) {
        return (T)editor.getDocument().modify(resource -> {
            IResourceServiceProvider serviceProvider = resource.getResourceServiceProvider();
            return serviceProvider.get(clazz);
        });
    }
}

