/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.labeling;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.n4js.jsdoc.JSDoc2HoverSerializer;
import org.eclipse.n4js.jsdoc.N4JSDocletParser;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.ui.labeling.TypesHoverProvider;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public class N4JSHoverProvider
extends DefaultEObjectHoverProvider {
    @Inject
    @Extension
    private N4JSTypeSystem _n4JSTypeSystem;
    @Inject
    @Extension
    private N4JSElementKeywordProvider _n4JSElementKeywordProvider;
    @Inject
    private TypesHoverProvider typesHoverProvider;
    @Inject
    private OperationCanceledManager cancelManager;
    @Inject
    private N4JSDocletParser docletParser;

    protected String getFirstLine(EObject o) {
        if (o instanceof LiteralOrComputedPropertyName) {
            return this.getFirstLine(((LiteralOrComputedPropertyName)o).eContainer());
        }
        return TypesHoverProvider.composeFirstLine((String)this._n4JSElementKeywordProvider.keyword((Object)o), (String)this.getLabel(o));
    }

    protected String getLabel(EObject o) {
        return UtilN4.sanitizeForHTML((String)this.doGetLabel(o));
    }

    protected String getDocumentation(EObject o) {
        String jsdocString;
        block4: {
            try {
                jsdocString = super.getDocumentation(o);
                if (jsdocString != null) break block4;
                return null;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    return "Error generating documentation:  " + ex;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        Doclet doclet = this.docletParser.parse(jsdocString);
        String hoverHTML = JSDoc2HoverSerializer.toJSDocString((EObject)doclet);
        return hoverHTML;
    }

    private String _doGetLabel(EObject o) {
        EObject tElem = N4JSASTUtils.getCorrespondingTypeModelElement((EObject)o);
        String _xifexpression = null;
        _xifexpression = tElem == null ? super.getLabel(o) : this.typesHoverProvider.getLabel(tElem);
        return _xifexpression;
    }

    private String _doGetLabel(VariableDeclaration vd) {
        String _xifexpression = null;
        _xifexpression = vd instanceof ExportedVariableDeclaration ? this._doGetLabel((EObject)vd) : this.getLabelFromTypeSystem((TypableElement)vd);
        return _xifexpression;
    }

    private String _doGetLabel(PropertyNameValuePair nameValuePair) {
        return this.getLabelFromTypeSystem((TypableElement)nameValuePair);
    }

    private String _doGetLabel(FormalParameter fp) {
        String _xblockexpression = null;
        String _xifexpression = null;
        boolean _isHasInitializerAssignment = fp.isHasInitializerAssignment();
        _xifexpression = _isHasInitializerAssignment ? "=\u2026" : "";
        String optinonalMarker = _xifexpression;
        String _labelFromTypeSystem = this.getLabelFromTypeSystem((TypableElement)fp);
        _xblockexpression = String.valueOf(_labelFromTypeSystem) + optinonalMarker;
        return _xblockexpression;
    }

    private String _doGetLabel(FunctionExpression fe) {
        return this.getLabelFromTypeSystem((TypableElement)fe);
    }

    private String _doGetLabel(LiteralOrComputedPropertyName name) {
        EObject _eContainer = name.eContainer();
        if (_eContainer instanceof TypableElement) {
            EObject _eContainer_1 = name.eContainer();
            return this.getLabelFromTypeSystem((TypableElement)_eContainer_1);
        }
        return name.getName();
    }

    private String getLabelFromTypeSystem(TypableElement o) {
        if (o == null || o.eResource() == null) {
            return null;
        }
        TypeRef typeRef = (TypeRef)this._n4JSTypeSystem.type(RuleEnvironmentExtensions.newRuleEnvironment((EObject)o), o).getValue();
        String _xifexpression = null;
        if (typeRef == null) {
            _xifexpression = null;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _name = this.getName((EObject)o);
            _builder.append((Object)_name);
            _builder.append(": ");
            String _typeRefAsString = typeRef.getTypeRefAsString();
            _builder.append(_typeRefAsString);
            _xifexpression = _builder.toString();
        }
        return _xifexpression;
    }

    private CharSequence _getName(EObject o) {
        return "";
    }

    private CharSequence _getName(NamedElement nameValuePair) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        String _name = nameValuePair.getName();
        _builder.append(_name, " ");
        return _builder;
    }

    protected boolean hasHover(EObject o) {
        return this.doHasHover(o);
    }

    private boolean _doHasHover(EObject o) {
        EObject tElem = N4JSASTUtils.getCorrespondingTypeModelElement((EObject)o);
        boolean _xifexpression = false;
        _xifexpression = tElem == null ? super.hasHover(o) : this.typesHoverProvider.hasHover(tElem);
        return _xifexpression;
    }

    private boolean _doHasHover(VariableDeclaration vd) {
        return true;
    }

    private boolean _doHasHover(PropertyNameValuePair nameValuePair) {
        return true;
    }

    private boolean _doHasHover(FormalParameter fp) {
        return true;
    }

    private boolean _doHasHover(FunctionExpression fe) {
        return true;
    }

    private boolean _doHasHover(N4TypeDeclaration md) {
        return true;
    }

    private boolean _doHasHover(LiteralOrComputedPropertyName name) {
        EObject _eContainer = name.eContainer();
        return _eContainer instanceof N4MemberDeclaration;
    }

    protected XtextBrowserInformationControlInput getHoverInfo(EObject element, IRegion hoverRegion, XtextBrowserInformationControlInput previous) {
        Object _xtrycatchfinallyexpression = null;
        try {
            return super.getHoverInfo(element, hoverRegion, previous);
        }
        catch (Throwable _t) {
            Object _xifexpression;
            if (_t instanceof Throwable) {
                boolean _not;
                Throwable t = _t;
                _xifexpression = null;
                boolean _isOperationCanceledException = this.cancelManager.isOperationCanceledException(t);
                boolean bl = _not = !_isOperationCanceledException;
                if (_not) {
                    throw Exceptions.sneakyThrow((Throwable)t);
                }
            } else {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xtrycatchfinallyexpression = _xifexpression;
            return _xtrycatchfinallyexpression;
        }
    }

    private String doGetLabel(EObject nameValuePair) {
        if (nameValuePair instanceof PropertyNameValuePair) {
            return this._doGetLabel((PropertyNameValuePair)nameValuePair);
        }
        if (nameValuePair instanceof FormalParameter) {
            return this._doGetLabel((FormalParameter)nameValuePair);
        }
        if (nameValuePair instanceof FunctionExpression) {
            return this._doGetLabel((FunctionExpression)nameValuePair);
        }
        if (nameValuePair instanceof VariableDeclaration) {
            return this._doGetLabel((VariableDeclaration)nameValuePair);
        }
        if (nameValuePair instanceof LiteralOrComputedPropertyName) {
            return this._doGetLabel((LiteralOrComputedPropertyName)nameValuePair);
        }
        if (nameValuePair != null) {
            return this._doGetLabel(nameValuePair);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(nameValuePair).toString());
    }

    private CharSequence getName(EObject nameValuePair) {
        if (nameValuePair instanceof NamedElement) {
            return this._getName((NamedElement)nameValuePair);
        }
        if (nameValuePair != null) {
            return this._getName(nameValuePair);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(nameValuePair).toString());
    }

    private boolean doHasHover(EObject nameValuePair) {
        if (nameValuePair instanceof PropertyNameValuePair) {
            return this._doHasHover((PropertyNameValuePair)nameValuePair);
        }
        if (nameValuePair instanceof FormalParameter) {
            return this._doHasHover((FormalParameter)nameValuePair);
        }
        if (nameValuePair instanceof FunctionExpression) {
            return this._doHasHover((FunctionExpression)nameValuePair);
        }
        if (nameValuePair instanceof N4TypeDeclaration) {
            return this._doHasHover((N4TypeDeclaration)nameValuePair);
        }
        if (nameValuePair instanceof VariableDeclaration) {
            return this._doHasHover((VariableDeclaration)nameValuePair);
        }
        if (nameValuePair instanceof LiteralOrComputedPropertyName) {
            return this._doHasHover((LiteralOrComputedPropertyName)nameValuePair);
        }
        if (nameValuePair != null) {
            return this._doHasHover(nameValuePair);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(nameValuePair).toString());
    }
}

