/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.components;

import com.google.common.base.Predicate;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.n4js.ui.wizard.components.DotPathUtils;
import org.eclipse.n4js.ui.wizard.model.ClassifierReference;

public class WizardComponentDataConverters {
    public static UpdateValueStrategy strategyForPredicate(final Predicate<Object> predicate) {
        return new ConditionalConverter(){

            @Override
            public boolean validate(Object object) {
                return predicate.apply(object);
            }
        }.updatingValueStrategy();
    }

    public static class ClassifierReferenceToStringConverter
    extends StrategyProvidingConverter {
        public ClassifierReferenceToStringConverter() {
            super(ClassifierReference.class, String.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof ClassifierReference) {
                ClassifierReference ref = (ClassifierReference)fromObject;
                return ref.getFullSpecifier();
            }
            return null;
        }
    }

    public static abstract class ConditionalConverter
    extends StrategyProvidingConverter {
        public ConditionalConverter() {
            super(Object.class, Boolean.TYPE);
        }

        public Object convert(Object fromObject) {
            if (this.validate(fromObject)) {
                return true;
            }
            return false;
        }

        public abstract boolean validate(Object var1);
    }

    private static abstract class StrategyProvidingConverter
    extends Converter {
        public StrategyProvidingConverter(Object fromType, Object toType) {
            super(fromType, toType);
        }

        public UpdateValueStrategy updatingValueStrategy() {
            UpdateValueStrategy strat = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
            strat.setConverter((IConverter)this);
            return strat;
        }
    }

    public static class StringToClassifierReferenceConverter
    extends StrategyProvidingConverter {
        public StringToClassifierReferenceConverter() {
            super(String.class, ClassifierReference.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof String) {
                String str = (String)fromObject;
                return new ClassifierReference(DotPathUtils.frontDotSegments(str), DotPathUtils.lastDotSegment(str));
            }
            return null;
        }
    }

    public static class StringToPathConverter
    extends StrategyProvidingConverter {
        public StringToPathConverter() {
            super(String.class, IPath.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof String) {
                return new Path((String)fromObject);
            }
            return null;
        }
    }
}

