/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.generator;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.model.edit.IJSONDocumentModification;
import org.eclipse.n4js.packagejson.model.edit.PackageJsonModificationProvider;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.changes.ChangeManager;
import org.eclipse.n4js.ui.changes.IAtomicChange;
import org.eclipse.n4js.ui.organize.imports.Interaction;
import org.eclipse.n4js.ui.organize.imports.OrganizeImportsService;
import org.eclipse.n4js.ui.wizard.generator.ImportRequirement;
import org.eclipse.n4js.ui.wizard.generator.N4JSImportRequirementResolver;
import org.eclipse.n4js.ui.wizard.model.AccessModifier;
import org.eclipse.n4js.ui.wizard.model.ClassifierReference;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModel;
import org.eclipse.n4js.utils.Log;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Log
public class WizardGeneratorHelper {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ChangeManager changeManager;
    @Inject
    private XtextDocumentProvider docProvider;
    @Inject
    private N4JSImportRequirementResolver requirementResolver;
    public static final String LINEBREAK = "\n";
    private static final Logger logger = Logger.getLogger(WizardGeneratorHelper.class);

    public String lastCharacterInFile(IFile file) {
        try {
            String contents = this.readFileAsString(file);
            int _length = contents.length();
            int _minus = _length - 1;
            return Character.valueOf(contents.charAt(_minus)).toString();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception exc = (Exception)_t;
                return "";
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public String addLineBreak(String str) {
        String _xifexpression = null;
        boolean _isEmpty = str.isEmpty();
        _xifexpression = _isEmpty ? str : String.valueOf(str) + LINEBREAK;
        return _xifexpression;
    }

    public String addSpace(String str) {
        String _xifexpression = null;
        boolean _isEmpty = str.isEmpty();
        _xifexpression = _isEmpty ? str : String.valueOf(str) + " ";
        return _xifexpression;
    }

    public String exportStatement(AccessModifier modifier) {
        String _xifexpression = null;
        _xifexpression = Objects.equal((Object)((Object)modifier), (Object)((Object)AccessModifier.PROJECT)) || Objects.equal((Object)((Object)modifier), (Object)((Object)AccessModifier.PUBLIC)) ? "export" : "";
        return _xifexpression;
    }

    public String readFileAsString(IFile file) throws IOException, CoreException, UnsupportedEncodingException {
        return Files.readFileIntoString((String)file.getLocation().toString());
    }

    public void insertImportStatements(XtextResource moduleResource, List<ImportRequirement> importRequirements) {
        IAtomicChange importReplacement = this.requirementResolver.getImportStatementChanges(moduleResource, importRequirements);
        this.applyChanges(moduleResource, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IAtomicChange[]{importReplacement})));
    }

    public boolean exists(IPath path) {
        boolean _xblockexpression = false;
        if (path == null) {
            return false;
        }
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (member == null) {
            return false;
        }
        _xblockexpression = member.exists();
        return _xblockexpression;
    }

    public XtextResource getResource(URI moduleURI) {
        Object _xblockexpression = null;
        ResourceSet resourceSet = this.n4jsCore.createResourceSet(Optional.fromNullable(null));
        Resource moduleResource = resourceSet.getResource(moduleURI, true);
        if (moduleResource instanceof XtextResource) {
            return (XtextResource)moduleResource;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public boolean applyChanges(XtextResource resource, final Collection<? extends IAtomicChange> changes) {
        String _string = resource.getURI().toString();
        Path _path = new Path(_string);
        Path _path_1 = new Path("platform:/resource/");
        IPath resourcePath = _path.makeRelativeTo((IPath)_path_1);
        IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(resourcePath);
        boolean _exists = resourceFile.exists();
        if (_exists) {
            try {
                FileEditorInput fileInput = new FileEditorInput(resourceFile);
                this.docProvider.connect((Object)fileInput);
                IDocument _document = this.docProvider.getDocument((Object)fileInput);
                final IXtextDocument document = (IXtextDocument)_document;
                this.docProvider.aboutToChange((Object)fileInput);
                document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource state) throws Exception {
                        try {
                            Functions.Function1 _function = it -> it.getOffset();
                            WizardGeneratorHelper.this.changeManager.applyAllInSameDocument(ListExtensions.reverse((List)IterableExtensions.sortBy((Iterable)changes, (Functions.Function1)_function)), (IDocument)document);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) {
                                BadLocationException e = (BadLocationException)_t;
                                return;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                });
                this.docProvider.saveDocument(null, (Object)fileInput, (IDocument)document, true);
                this.docProvider.changed((Object)fileInput);
                this.docProvider.disconnect((Object)fileInput);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception all = (Exception)_t;
                    return false;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean applyJSONModifications(XtextResource resource, Collection<? extends IJSONDocumentModification> modifications) {
        String _string = resource.getURI().toString();
        Path _path = new Path(_string);
        Path _path_1 = new Path("platform:/resource/");
        IPath resourcePath = _path.makeRelativeTo((IPath)_path_1);
        IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(resourcePath);
        JSONDocument jsonDocument = JSONModelUtils.getDocument((Resource)resource);
        boolean _exists = resourceFile.exists();
        if (_exists) {
            try {
                for (IJSONDocumentModification iJSONDocumentModification : modifications) {
                    iJSONDocumentModification.apply(jsonDocument);
                }
                resource.save(SaveOptions.newBuilder().format().getOptions().toOptionsMap());
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    Exception all = (Exception)throwable;
                    return false;
                }
                throw Exceptions.sneakyThrow((Throwable)throwable);
            }
        } else {
            return false;
        }
        return true;
    }

    public void organizeImports(IFile file, IProgressMonitor mon) throws CoreException {
        OrganizeImportsService.organizeImportsInFile(file, Interaction.takeFirst, mon);
    }

    public IN4JSProject projectOfUri(URI uri) {
        Optional projectOptional = this.n4jsCore.findProject(uri);
        boolean _isPresent = projectOptional.isPresent();
        if (_isPresent) {
            return (IN4JSProject)projectOptional.get();
        }
        return null;
    }

    public String realOrAliasName(ClassifierReference reference, Map<URI, String> aliasBindings) {
        if (aliasBindings != null && aliasBindings.containsKey(reference.uri)) {
            return aliasBindings.get(reference.uri);
        }
        return reference.classifierName;
    }

    public Collection<IJSONDocumentModification> projectDescriptionModifications(Resource packageJson, WorkspaceWizardModel model, Collection<IN4JSProject> referencedProjects, URI moduleURI) {
        ArrayList<IJSONDocumentModification> modifications = new ArrayList<IJSONDocumentModification>();
        Functions.Function1 _function = it -> {
            boolean _equals = it.getProjectName().equals(model.getProject().lastSegment());
            return !_equals;
        };
        Iterable referencedProjectsExceptContainer = IterableExtensions.filter(referencedProjects, (Functions.Function1)_function);
        HashSet referencedProjectsSet = new HashSet();
        Iterables.addAll(referencedProjectsSet, (Iterable)referencedProjectsExceptContainer);
        Functions.Function1 _function_1 = it -> it.getProjectName();
        modifications.add(PackageJsonModificationProvider.insertProjectDependencies((Collection)IterableExtensions.toList((Iterable)IterableExtensions.map(referencedProjectsSet, (Functions.Function1)_function_1))));
        Functions.Function1 _function_2 = it -> {
            ProjectType _projectType = it.getProjectType();
            return Objects.equal((Object)_projectType, (Object)ProjectType.RUNTIME_LIBRARY);
        };
        Functions.Function1 _function_3 = it -> it.getProjectName();
        modifications.add(PackageJsonModificationProvider.insertRequiredRuntimeLibraries((Collection)IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(referencedProjectsSet, (Functions.Function1)_function_2), (Functions.Function1)_function_3))));
        return modifications;
    }
}

