/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.workingsets.MutableWorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetDiffBuilder;
import org.eclipse.n4js.ui.workingsets.WorkingSetEditWizard;
import org.eclipse.n4js.ui.workingsets.WorkingSetLabelProvider;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetNewWizard;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class WorkingSetConfigurationDialog
extends SelectionDialog {
    private final WorkingSetManager manager;
    private final WorkingSetDiffBuilder diffBuilder;
    private final AtomicReference<Diff<WorkingSet>> diff;
    private List<WorkingSet> allWorkingSets;
    private CheckboxTableViewer tableViewer;
    private Button newButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private int nextButtonId = 1025;

    public WorkingSetConfigurationDialog(WorkingSetManager manager) {
        super(UIUtils.getShell());
        this.manager = manager;
        this.setTitle("Configure Working Sets");
        this.setMessage("Select and sort &working sets visible in Project Explorer:");
        this.diffBuilder = new WorkingSetDiffBuilder(manager);
        this.diff = new AtomicReference<Diff<WorkingSet>>(WorkingSetDiffBuilder.EMPTY_DIFF);
        this.allWorkingSets = Lists.newArrayList((Object[])manager.getAllWorkingSets());
        this.setInitialSelections(this.manager.getWorkingSets());
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setInitialSelection();
        this.updateButtonAvailability();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createTableViewer(inner);
        this.createOrderButtons(inner);
        if (this.manager instanceof MutableWorkingSetManager) {
            this.createModifyButtons(composite);
        }
        this.tableViewer.setInput(this.allWorkingSets);
        WorkingSetConfigurationDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        Object[] newItems = (WorkingSet[])Arrays2.filter((Object[])this.tableViewer.getCheckedElements(), WorkingSet.class);
        Object[] newAllItems = (WorkingSet[])FluentIterable.from(Arrays.asList(this.tableViewer.getTable().getItems())).transform(item -> item.getData()).filter(WorkingSet.class).toArray(WorkingSet.class);
        this.diff.set((Diff<WorkingSet>)this.diffBuilder.build(newItems, newAllItems));
        this.manager.updateState(this.diff.get());
        this.manager.saveState((IProgressMonitor)new NullProgressMonitor());
        super.okPressed();
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2050);
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WorkingSetConfigurationDialog.this.syncSelectionAndButtonStates();
            }
        });
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(20);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.tableViewer.getTable().setLayoutData((Object)data);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)WorkingSetLabelProvider.INSTANCE));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkingSetConfigurationDialog.this.handleSelectionChanged();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (WorkingSetConfigurationDialog.this.editButton != null && WorkingSetConfigurationDialog.this.editButton.isEnabled()) {
                    WorkingSetConfigurationDialog.this.editSelectedWorkingSet();
                }
            }
        });
    }

    private void createModifyButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        this.newButton = this.createButton(buttonComposite, this.nextButtonId++, "New...", false);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.createWorkingSet();
            }
        });
        this.editButton = this.createButton(buttonComposite, this.nextButtonId++, "Edit...", false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.editSelectedWorkingSet();
            }
        });
        this.removeButton = this.createButton(buttonComposite, this.nextButtonId++, "Remove", false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.removeSelectedWorkingSets();
            }
        });
    }

    private void createOrderButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.upButton = new Button(buttons, 8);
        this.upButton.setText("Up");
        this.setButtonLayoutData(this.upButton);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.moveUp(((IStructuredSelection)WorkingSetConfigurationDialog.this.tableViewer.getSelection()).toList());
            }
        });
        this.downButton = new Button(buttons, 8);
        this.downButton.setText("Down");
        this.setButtonLayoutData(this.downButton);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.moveDown(((IStructuredSelection)WorkingSetConfigurationDialog.this.tableViewer.getSelection()).toList());
            }
        });
        this.selectAllButton = new Button(buttons, 8);
        this.selectAllButton.setText("Select All");
        this.setButtonLayoutData(this.selectAllButton);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.selectAll();
            }
        });
        this.deselectAllButton = new Button(buttons, 8);
        this.deselectAllButton.setText("Deselect All");
        this.setButtonLayoutData(this.deselectAllButton);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.deselectAll();
            }
        });
    }

    private void setInitialSelection() {
        List selections = this.getInitialElementSelections();
        if (!selections.isEmpty()) {
            this.tableViewer.setCheckedElements(selections.toArray());
        }
    }

    private void createWorkingSet() {
        if (this.manager instanceof MutableWorkingSetManager) {
            WorkingSet workingSet;
            WorkingSetNewWizard wizard = ((MutableWorkingSetManager)this.manager).createNewWizard();
            wizard.setAllWorkingSets(this.allWorkingSets);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0 && (workingSet = (WorkingSet)wizard.getWorkingSet().orNull()) != null) {
                this.diffBuilder.add(workingSet);
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkingSetConfigurationDialog.this.allWorkingSets.add(workingSet);
                        WorkingSetConfigurationDialog.this.tableViewer.add((Object)workingSet);
                        WorkingSetConfigurationDialog.this.tableViewer.setChecked((Object)workingSet, true);
                    }
                });
            }
        }
    }

    private void editSelectedWorkingSet() {
        WorkingSet oldState;
        IStructuredSelection selection;
        Object firstElement;
        if (this.manager instanceof MutableWorkingSetManager && (firstElement = (selection = this.tableViewer.getStructuredSelection()).getFirstElement()) instanceof WorkingSet && !"Other Projects".equals((oldState = (WorkingSet)firstElement).getId())) {
            WorkingSetEditWizard wizard = ((MutableWorkingSetManager)this.manager).createEditWizard();
            wizard.init(PlatformUI.getWorkbench(), selection);
            wizard.setAllWorkingSets(this.allWorkingSets);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                final WorkingSet newState = (WorkingSet)wizard.getWorkingSet().orNull();
                this.diffBuilder.edit(oldState, newState);
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int oldStateIndex = WorkingSetConfigurationDialog.this.allWorkingSets.indexOf(oldState);
                        if (-1 == oldStateIndex) {
                            return;
                        }
                        WorkingSetConfigurationDialog.this.allWorkingSets.remove(oldState);
                        WorkingSetConfigurationDialog.this.allWorkingSets.add(oldStateIndex, newState);
                        WorkingSetConfigurationDialog.this.tableViewer.replace((Object)newState, oldStateIndex);
                        WorkingSetConfigurationDialog.this.tableViewer.setChecked((Object)newState, true);
                        WorkingSetConfigurationDialog.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newState));
                    }
                });
            }
        }
    }

    private void handleSelectionChanged() {
        this.updateButtonAvailability();
    }

    private void removeSelectedWorkingSets() {
        if (this.manager instanceof MutableWorkingSetManager) {
            IStructuredSelection selection = this.tableViewer.getStructuredSelection();
            Object[] objects = selection.toArray();
            final ArrayList removedWorkingSets = Lists.newArrayList();
            int i = 0;
            int size = objects.length;
            while (i < size) {
                WorkingSet workingSet;
                Object object = objects[i];
                if (object instanceof WorkingSet && !"Other Projects".equals((workingSet = (WorkingSet)object).getName())) {
                    removedWorkingSets.add(workingSet);
                }
                ++i;
            }
            if (!removedWorkingSets.isEmpty()) {
                for (WorkingSet workingSet : removedWorkingSets) {
                    this.diffBuilder.delete(workingSet);
                }
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkingSetConfigurationDialog.this.tableViewer.remove(removedWorkingSets.toArray());
                        WorkingSetConfigurationDialog.this.allWorkingSets.removeAll(removedWorkingSets);
                    }
                });
            }
        }
    }

    private void updateButtonAvailability() {
        boolean hasSingleSelection;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        boolean hasSelection = !selection.isEmpty();
        boolean bl = hasSingleSelection = selection.size() == 1;
        if (this.manager instanceof MutableWorkingSetManager) {
            this.removeButton.setEnabled(hasSelection && this.containsNoBuiltInWorkingSets(selection));
            this.editButton.setEnabled(hasSingleSelection && this.containsNoBuiltInWorkingSets(selection));
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(this.canMoveUp());
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(this.canMoveDown());
        }
    }

    private boolean containsNoBuiltInWorkingSets(IStructuredSelection selection) {
        for (Object next : selection) {
            if (!(next instanceof WorkingSet) || !"Other Projects".equals(((WorkingSet)next).getId())) continue;
            return false;
        }
        return true;
    }

    private void moveUp(List<WorkingSet> toMoveUp) {
        if (toMoveUp.size() > 0) {
            this.setElements(this.moveUp(this.allWorkingSets, toMoveUp));
            this.tableViewer.reveal((Object)toMoveUp.get(0));
        }
    }

    private void moveDown(List<WorkingSet> toMoveDown) {
        if (toMoveDown.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.allWorkingSets), toMoveDown)));
            this.tableViewer.reveal((Object)toMoveDown.get(toMoveDown.size() - 1));
        }
    }

    private void setElements(List<WorkingSet> elements) {
        this.allWorkingSets = elements;
        this.tableViewer.setInput(this.allWorkingSets);
        this.updateButtonAvailability();
    }

    private List<WorkingSet> moveUp(List<WorkingSet> elements, List<WorkingSet> move) {
        int nElements = elements.size();
        ArrayList result = Lists.newArrayList();
        WorkingSet floating = null;
        int i = 0;
        while (i < nElements) {
            WorkingSet curr = elements.get(i);
            if (move.contains(curr)) {
                result.add(curr);
            } else {
                if (floating != null) {
                    result.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            result.add(floating);
        }
        return result;
    }

    private List<WorkingSet> reverse(List<WorkingSet> p) {
        ArrayList copy = Lists.newArrayList(p);
        Collections.reverse(copy);
        return copy;
    }

    private boolean canMoveUp() {
        int[] indices = this.tableViewer.getTable().getSelectionIndices();
        int i = 0;
        while (i < indices.length) {
            if (indices[i] != i) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean canMoveDown() {
        int[] indices = this.tableViewer.getTable().getSelectionIndices();
        int k = this.allWorkingSets.size() - 1;
        int i = indices.length - 1;
        while (i >= 0) {
            if (indices[i] != k) {
                return true;
            }
            --i;
            --k;
        }
        return false;
    }

    private void selectAll() {
        this.tableViewer.setAllChecked(true);
        this.syncSelectionAndButtonStates();
    }

    private void deselectAll() {
        this.tableViewer.setAllChecked(false);
        this.syncSelectionAndButtonStates();
    }

    private void syncSelectionAndButtonStates() {
        this.updateButtonAvailability();
        this.getButton(0).setEnabled(!Arrays2.isEmpty((Object[])this.tableViewer.getCheckedElements()));
    }
}

