/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.server;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.server.HelpServer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class JettyHelpServer
extends HelpServer {
    private String host;
    protected int port = -1;
    protected static final int AUTO_SELECT_JETTY_PORT = 0;

    @Override
    public void start(String webappName) throws Exception {
        StartServerThread startRunnable = new StartServerThread(webappName);
        this.execute(startRunnable);
        this.checkBundle();
    }

    protected void checkBundle() throws InvalidSyntaxException, BundleException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.http.registry");
        if (bundle == null) {
            throw new BundleException("org.eclipse.equinox.http.registry");
        }
        if (bundle.getState() == 4) {
            bundle.start(1);
        }
        if (this.port == -1) {
            ServiceReference[] reference = bundle.getBundleContext().getServiceReferences("org.osgi.service.http.HttpService", "(other.info=" + this.getOtherInfo() + ')');
            Object assignedPort = reference[0].getProperty("http.port");
            this.port = Integer.parseInt((String)assignedPort);
        }
    }

    @Override
    public void stop(String webappName) throws CoreException {
        try {
            StopServerThread stopRunnable = new StopServerThread(webappName);
            this.execute(stopRunnable);
        }
        catch (Exception e) {
            HelpBasePlugin.logError("An error occured while stopping the help server", e);
        }
    }

    private void execute(WorkerThread runnable) throws Exception {
        Throwable t;
        boolean interrupted = false;
        WorkerThread thread = runnable;
        thread.setDaemon(true);
        thread.start();
        while (true) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if ((t = runnable.getException()) != null) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    private void configurePort() {
        String portCommandLineOverride;
        if (this.port == -1 && (portCommandLineOverride = HelpBasePlugin.getBundleContext().getProperty("server_port")) != null && portCommandLineOverride.trim().length() > 0) {
            try {
                this.port = Integer.parseInt(portCommandLineOverride);
            }
            catch (NumberFormatException e) {
                String msg = "Help server port specified in VM arguments is invalid (" + portCommandLineOverride + ")";
                HelpBasePlugin.logError(msg, e);
            }
        }
    }

    protected int getPortParameter() {
        if (this.port == -1) {
            return 0;
        }
        return this.port;
    }

    @Override
    public String getHost() {
        if (this.host == null) {
            String hostCommandLineOverride = HelpBasePlugin.getBundleContext().getProperty("server_host");
            this.host = hostCommandLineOverride != null && hostCommandLineOverride.trim().length() > 0 ? hostCommandLineOverride : "127.0.0.1";
        }
        return this.host;
    }

    protected String getOtherInfo() {
        return "org.eclipse.help";
    }

    protected String getContextPath() {
        return "/help";
    }

    public boolean bindServerToHostname() {
        if (BaseHelpSystem.getMode() == 0) {
            return true;
        }
        String host = HelpBasePlugin.getBundleContext().getProperty("server_host");
        return host != null && host.trim().length() > 0;
    }

    private final class StartServerThread
    extends WorkerThread {
        private final String webappName;

        public StartServerThread(String webappName) {
            super("Start Help Server");
            this.webappName = webappName;
        }

        @Override
        public void run() {
            try {
                Hashtable<String, Object> d = new Hashtable<String, Object>();
                JettyHelpServer.this.configurePort();
                ((Dictionary)d).put("http.port", new Integer(JettyHelpServer.this.getPortParameter()));
                ((Dictionary)d).put("context.path", JettyHelpServer.this.getContextPath());
                ((Dictionary)d).put("other.info", JettyHelpServer.this.getOtherInfo());
                ((Dictionary)d).put("context.sessioninactiveinterval", new Integer(1800));
                Logger.getLogger("org.mortbay").setLevel(Level.WARNING);
                if (JettyHelpServer.this.bindServerToHostname()) {
                    ((Dictionary)d).put("http.host", JettyHelpServer.this.getHost());
                }
                JettyConfigurator.startServer((String)this.webappName, d);
            }
            catch (Throwable t) {
                this.setException(t);
            }
        }
    }

    private final class StopServerThread
    extends WorkerThread {
        private final String webappName;

        public StopServerThread(String webappName) {
            super("Stop Help Server");
            this.webappName = webappName;
        }

        @Override
        public void run() {
            try {
                JettyConfigurator.stopServer((String)this.webappName);
                JettyHelpServer.this.port = -1;
            }
            catch (Throwable t) {
                this.setException(t);
            }
        }
    }

    private abstract class WorkerThread
    extends Thread {
        private Throwable exception;

        public WorkerThread(String name) {
            super(name);
        }

        public synchronized void setException(Throwable status) {
            this.exception = status;
        }

        public synchronized Throwable getException() {
            return this.exception;
        }
    }
}

