/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.builder;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.external.TargetPlatformInstallLocationProvider;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.tests.util.ProjectTestsUtils;
import org.eclipse.n4js.tests.util.ShippedCodeInitializeTestHelper;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.eclipse.n4js.utils.io.FileUtils;
import org.junit.Assert;

public class ExternalLibrariesSetupHelper {
    @Inject
    private TargetPlatformInstallLocationProvider locationProvider;
    @Inject
    private ExternalLibraryPreferenceStore externalLibraryPreferenceStore;
    @Inject
    private ShippedCodeInitializeTestHelper shippedCodeInitializeTestHelper;

    public void setupExternalLibraries(boolean initShippedCode) throws Exception {
        URI nodeModulesLocation = this.getCleanModulesLocation();
        if (initShippedCode) {
            this.shippedCodeInitializeTestHelper.setupBuiltIns();
        } else {
            this.externalLibraryPreferenceStore.add(nodeModulesLocation);
            IStatus result = this.externalLibraryPreferenceStore.save((IProgressMonitor)new NullProgressMonitor());
            Assert.assertTrue((String)"Error while saving external library preference changes.", (boolean)result.isOK());
        }
        Injector n4jsInjector = N4JSActivator.getInstance().getInjector("org.eclipse.n4js.N4JS");
        LibraryManager libMan = (LibraryManager)n4jsInjector.getInstance(LibraryManager.class);
        libMan.registerAllExternalProjects((IProgressMonitor)new NullProgressMonitor());
        ProjectTestsUtils.waitForAutoBuild();
    }

    private URI getCleanModulesLocation() {
        URI nodeModulesLocation = this.locationProvider.getNodeModulesURI();
        URI targetPlatformFileLocation = this.locationProvider.getTargetPlatformFileLocation();
        File nodeModulesDir = new File(nodeModulesLocation);
        File targetPlatformFile = new File(targetPlatformFileLocation);
        FileUtils.deleteFileOrFolder((File)nodeModulesDir);
        FileUtils.deleteFileOrFolder((File)targetPlatformFile);
        this.locationProvider.repairNpmFolderState();
        Assert.assertTrue((String)"Provided location should be available.", (boolean)nodeModulesDir.isDirectory());
        Assert.assertTrue((String)"Provided location should be available.", (boolean)targetPlatformFile.isFile());
        return nodeModulesLocation;
    }

    public void tearDownExternalLibraries(boolean tearDownShippedCode) throws Exception {
        URI nodeModulesLocation = this.locationProvider.getNodeModulesURI();
        this.externalLibraryPreferenceStore.remove(nodeModulesLocation);
        IStatus result = this.externalLibraryPreferenceStore.save((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"Error while saving external library preference changes.", (boolean)result.isOK());
        if (tearDownShippedCode) {
            this.shippedCodeInitializeTestHelper.tearDownBuiltIns();
        }
        File nodeModuleLocationFile = new File(nodeModulesLocation);
        Assert.assertTrue((String)"Provided npm location does not exist.", (boolean)nodeModuleLocationFile.exists());
        Assert.assertTrue((String)"Provided npm location is not a folder.", (boolean)nodeModuleLocationFile.isDirectory());
        FileDeleter.delete((File)nodeModuleLocationFile);
        Assert.assertFalse((String)"Provided npm location should be deleted.", (boolean)nodeModuleLocationFile.exists());
        ProjectTestsUtils.waitForAutoBuild();
    }
}

