/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.binaries.IllegalBinaryStateException;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.external.LibraryChange;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.NpmCLI;
import org.eclipse.n4js.external.NpmLogger;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.SemverToStringable;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.semver.SemverMatcher;
import org.eclipse.n4js.semver.SemverUtils;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.utils.N4JSDataCollectors;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class LibraryManager {
    private static final Logger LOGGER = Logger.getLogger(LibraryManager.class);
    private static final NPMVersionRequirement NO_VERSION_REQUIREMENT = SemverUtils.createEmptyVersionRequirement();
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private StatusHelper statusHelper;
    @Inject
    private Provider<NpmBinary> npmBinaryProvider;
    @Inject
    private NpmLogger logger;
    @Inject
    private NpmCLI npmCli;
    @Inject
    private ExternalIndexSynchronizer indexSynchronizer;
    @Inject
    private SemverHelper semverHelper;

    public void synchronizeNpms(IProgressMonitor monitor) {
        this.indexSynchronizer.synchronizeNpms(monitor);
    }

    public IStatus installNPM(String packageName, IProgressMonitor monitor) {
        return this.installNPM(packageName, NO_VERSION_REQUIREMENT, monitor);
    }

    public IStatus installNPM(String packageName, String packageVersionStr, IProgressMonitor monitor) {
        NPMVersionRequirement packageVersion = this.semverHelper.parse(packageVersionStr);
        if (packageVersion == null) {
            throw new IllegalArgumentException("unable to parse version requirement: " + packageVersionStr);
        }
        return this.installNPM(packageName, packageVersion, monitor);
    }

    public IStatus installNPM(String packageName, NPMVersionRequirement packageVersion, IProgressMonitor monitor) {
        return this.installNPMs(Collections.singletonMap(packageName, packageVersion), false, monitor);
    }

    public IStatus installNPMs(Collection<String> unversionedPackages, IProgressMonitor monitor) {
        Map<String, NPMVersionRequirement> versionedPackages = unversionedPackages.stream().collect(Collectors.toMap(name -> name, name -> NO_VERSION_REQUIREMENT));
        return this.installNPMs(versionedPackages, false, monitor);
    }

    public IStatus installNPMs(Map<String, NPMVersionRequirement> versionedNPMs, boolean forceReloadAll, IProgressMonitor monitor) {
        return this.runWithWorkspaceLock(() -> this.installNPMsInternal(versionedNPMs, forceReloadAll, monitor));
    }

    /*
     * Unable to fully structure code
     */
    private IStatus installNPMsInternal(Map<String, NPMVersionRequirement> versionedNPMs, boolean forceReloadAll, IProgressMonitor monitor) {
        msg = this.getMessage(versionedNPMs);
        status = this.statusHelper.createMultiStatus(msg);
        this.logger.logInfo(msg);
        binaryStatus = this.checkNPM();
        if (!binaryStatus.isOK()) {
            status.merge(binaryStatus);
            return status;
        }
        try {
            var7_7 = null;
            var8_9 = null;
            try {
                mes = N4JSDataCollectors.dcLibMngr.getMeasurement("installDependenciesInternal");
                try {
                    steps = forceReloadAll != false ? 3 : 2;
                    subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(steps + 4));
                    npmsToInstall = new LinkedHashMap<String, NPMVersionRequirement>(versionedNPMs);
                    subMonitor1 = subMonitor.split(2);
                    subMonitor1.setTaskName("Installing packages... [step 1 of " + steps + "]");
                    actualChanges = this.installUninstallNPMs((IProgressMonitor)subMonitor1, status, npmsToInstall, Collections.emptyList());
                    if (!status.isOK()) {
                        var20_17 = status;
                        while (true) {
                            monitor.done();
                            return var20_17;
                        }
                    }
                    if (forceReloadAll) {
                        subMonitor2 = subMonitor.split(1);
                        subMonitor2.setTaskName("Clean all packages... [step 2 of 3]");
                        this.externalLibraryWorkspace.deregisterAllProjects((IProgressMonitor)subMonitor2);
                    }
                    var15_19 = null;
                    var16_21 = null;
                    try {
                        m = N4JSDataCollectors.dcIndexSynchronizer.getMeasurement("synchronizeNpms");
                        try {
                            subMonitor3 = subMonitor.split(4);
                            subMonitor3.setTaskName("Building installed packages... [step " + steps + " of " + steps + "]");
                            this.indexSynchronizer.synchronizeNpms((IProgressMonitor)subMonitor3, actualChanges);
                        }
                        finally {
                            if (m != null) {
                                m.close();
                            }
                        }
                    }
                    catch (Throwable var16_22) {
                        if (var15_19 == null) {
                            var15_19 = var16_22;
                        } else if (var15_19 != var16_22) {
                            var15_19.addSuppressed(var16_22);
                        }
                        throw var15_19;
                    }
                    var20_18 = status;
                    ** try [egrp 6[TRYBLOCK] [4 : 366->375)] { 
                }
lbl56:
                // 1 sources

                catch (Throwable var7_8) {
                    throw var7_8;
                }
                finally {
                    if (mes == null) ** continue;
                    mes.close();
                }
lbl-1000:
                // 1 sources

                {
                    monitor.done();
                    return var20_18;
                }
            }
            catch (Throwable var8_10) {
                if (var7_7 == null) {
                    var7_7 = var8_10;
                } else if (var7_7 != var8_10) {
                    var7_7.addSuppressed(var8_10);
                }
                throw var7_7;
            }
        }
        catch (Throwable var19_25) {
            monitor.done();
            throw var19_25;
        }
    }

    private String getMessage(Map<String, NPMVersionRequirement> versionedNPMs) {
        String msg = "Installing NPM(s): ";
        Iterator<Map.Entry<String, NPMVersionRequirement>> entryIter = versionedNPMs.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<String, NPMVersionRequirement> entry = entryIter.next();
            msg = String.valueOf(msg) + entry.getKey();
            NPMVersionRequirement versionRequirement = entry.getValue();
            if (versionRequirement != null && !SemverUtils.isEmptyVersionRequirement((NPMVersionRequirement)versionRequirement)) {
                msg = String.valueOf(msg) + "@" + versionRequirement;
            }
            if (!entryIter.hasNext()) continue;
            msg = String.valueOf(msg) + ", ";
        }
        return msg;
    }

    private List<LibraryChange> installUninstallNPMs(IProgressMonitor monitor, MultiStatus status, Map<String, NPMVersionRequirement> installRequested, Collection<String> removeRequested) {
        Measurement m;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Collection<LibraryChange> requestedChanges = this.getRequestedChanges(installRequested, removeRequested);
        LinkedList<LibraryChange> actualChanges = new LinkedList<LibraryChange>();
        Throwable throwable = null;
        Object var9_11 = null;
        try {
            m = N4JSDataCollectors.dcNpmUninstall.getMeasurement("batchUninstall");
            try {
                actualChanges.addAll(this.npmCli.batchUninstall((IProgressMonitor)subMonitor.split(1), status, requestedChanges));
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var9_11 = null;
        try {
            m = N4JSDataCollectors.dcNpmInstall.getMeasurement("batchInstall");
            try {
                actualChanges.addAll(this.npmCli.batchInstall((IProgressMonitor)subMonitor.split(1), status, requestedChanges));
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return actualChanges;
    }

    private Collection<LibraryChange> getRequestedChanges(Map<String, NPMVersionRequirement> installRequested, Collection<String> removeRequested) {
        VersionNumber version;
        LinkedList<LibraryChange> requestedChanges = new LinkedList<LibraryChange>();
        HashMap<String, Pair> installedNpms = new HashMap<String, Pair>();
        for (Pair<URI, ProjectDescription> pair : this.externalLibraryWorkspace.getProjectsIncludingUnnecessary()) {
            URI location = (URI)pair.getFirst();
            String nameFromURI = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI(location);
            installedNpms.put(nameFromURI, Tuples.pair((Object)location, (Object)((ProjectDescription)pair.getSecond())));
        }
        for (Map.Entry entry : installRequested.entrySet()) {
            String name = (String)entry.getKey();
            NPMVersionRequirement requestedVersion = (NPMVersionRequirement)entry.getValue();
            if (installedNpms.containsKey(name)) {
                version = ((ProjectDescription)((Pair)installedNpms.get(name)).getSecond()).getProjectVersion();
                URI location = (URI)((Pair)installedNpms.get(name)).getFirst();
                String installedVersionString = Strings.emptyIfNull((String)version.toString());
                if (this.installedMatchesRequestedVersion(installedVersionString, requestedVersion)) continue;
                requestedChanges.add(new LibraryChange(LibraryChange.LibraryChangeType.Uninstall, location, name, installedVersionString));
                String requestedVersionStr = SemverSerializer.serialize((SemverToStringable)requestedVersion);
                requestedChanges.add(new LibraryChange(LibraryChange.LibraryChangeType.Install, location, name, requestedVersionStr));
                continue;
            }
            String requestedVersionStr = SemverSerializer.serialize((SemverToStringable)requestedVersion);
            requestedChanges.add(new LibraryChange(LibraryChange.LibraryChangeType.Install, null, name, requestedVersionStr));
        }
        for (String string : removeRequested) {
            if (!installedNpms.containsKey(string)) continue;
            Pair pair = (Pair)installedNpms.get(string);
            URI location = (URI)pair.getFirst();
            version = ((ProjectDescription)pair.getSecond()).getProjectVersion();
            String versionStr = version != null ? version.toString() : "";
            requestedChanges.add(new LibraryChange(LibraryChange.LibraryChangeType.Uninstall, location, string, versionStr));
        }
        return requestedChanges;
    }

    public boolean installedMatchesRequestedVersion(String installedVersionString, NPMVersionRequirement requestedVersionRequirement) {
        VersionNumber installedVersion = this.semverHelper.parseVersionNumber(installedVersionString);
        return SemverMatcher.matchesStrict((VersionNumber)installedVersion, (NPMVersionRequirement)requestedVersionRequirement);
    }

    public IStatus uninstallNPM(String packageName, IProgressMonitor monitor) {
        return this.uninstallNPM(Arrays.asList(packageName), monitor);
    }

    public IStatus uninstallNPM(Collection<String> packageNames, IProgressMonitor monitor) {
        return this.runWithWorkspaceLock(() -> this.uninstallDependenciesInternal(packageNames, monitor));
    }

    /*
     * Unable to fully structure code
     */
    private IStatus uninstallDependenciesInternal(Collection<String> packageNames, IProgressMonitor monitor) {
        msg = "Uninstalling NPM(s): " + String.join((CharSequence)", ", packageNames);
        status = this.statusHelper.createMultiStatus(msg);
        this.logger.logInfo(msg);
        binaryStatus = this.checkNPM();
        if (!binaryStatus.isOK()) {
            status.merge(binaryStatus);
            return status;
        }
        try {
            var6_6 = null;
            var7_8 = null;
            try {
                mes = N4JSDataCollectors.dcLibMngr.getMeasurement("uninstallDependenciesInternal");
                try {
                    actualChanges = this.installUninstallNPMs(monitor, status, Collections.emptyMap(), packageNames);
                    var10_12 = null;
                    var11_14 = null;
                    try {
                        m = N4JSDataCollectors.dcIndexSynchronizer.getMeasurement("synchronizeNpms");
                        try {
                            this.indexSynchronizer.synchronizeNpms(monitor, actualChanges);
                        }
                        finally {
                            if (m != null) {
                                m.close();
                            }
                        }
                    }
                    catch (Throwable var11_15) {
                        if (var10_12 == null) {
                            var10_12 = var11_15;
                        } else if (var10_12 != var11_15) {
                            var10_12.addSuppressed(var11_15);
                        }
                        throw var10_12;
                    }
                    var14_17 = status;
                    ** try [egrp 5[TRYBLOCK] [3 : 204->213)] { 
                }
lbl38:
                // 1 sources

                catch (Throwable var6_7) {
                    throw var6_7;
                }
                finally {
                    if (mes != null) {
                        mes.close();
                    }
                }
lbl-1000:
                // 1 sources

                {
                    monitor.done();
                    return var14_17;
                }
            }
            catch (Throwable var7_9) {
                if (var6_6 == null) {
                    var6_6 = var7_9;
                } else if (var6_6 != var7_9) {
                    var6_6.addSuppressed(var7_9);
                }
                throw var6_6;
            }
        }
        catch (Throwable var13_18) {
            monitor.done();
            throw var13_18;
        }
    }

    public IStatus registerAllExternalProjects(IProgressMonitor monitor) {
        return this.runWithWorkspaceLock(() -> this.registerAllExternalProjectsInternal(monitor));
    }

    private IStatus registerAllExternalProjectsInternal(IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor, (Object)"monitor");
        MultiStatus refreshStatus = this.statusHelper.createMultiStatus("Refreshing npm type definitions.");
        Set<String> packageNames = this.getAllNpmProjectsMapping().keySet();
        if (packageNames.isEmpty()) {
            return this.statusHelper.OK();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            this.indexSynchronizer.reindexAllExternalProjects((IProgressMonitor)subMonitor.split(1));
            MultiStatus multiStatus = refreshStatus;
            return multiStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    public IStatus registerUnregisteredNpms(IProgressMonitor monitor) {
        return this.runWithWorkspaceLock(() -> this.registerUnregisteredNpmsInternal(monitor));
    }

    private IStatus registerUnregisteredNpmsInternal(IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor, (Object)"monitor");
        MultiStatus refreshStatus = this.statusHelper.createMultiStatus("Register not registered NPM(s).");
        LinkedList<N4JSExternalProject> unregisteredProjects = new LinkedList<N4JSExternalProject>();
        for (N4JSExternalProject p : this.externalLibraryWorkspace.getProjects()) {
            if (this.indexSynchronizer.isInIndex(p)) continue;
            unregisteredProjects.add(p);
        }
        this.indexSynchronizer.synchronizeNpms(monitor);
        Set<String> packageNames = this.getAllNpmProjectsMapping().keySet();
        if (packageNames.isEmpty()) {
            return this.statusHelper.OK();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            this.indexSynchronizer.reindexAllExternalProjects((IProgressMonitor)subMonitor.split(1));
            MultiStatus multiStatus = refreshStatus;
            return multiStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    public IStatus cleanCache(IProgressMonitor monitor) {
        return this.runWithWorkspaceLock(() -> this.npmCli.cleanCacheInternal(monitor));
    }

    private IStatus checkNPM() {
        NpmBinary npmBinary = (NpmBinary)this.npmBinaryProvider.get();
        IStatus npmBinaryStatus = npmBinary.validate();
        if (!npmBinaryStatus.isOK()) {
            return this.statusHelper.createError("npm binary invalid", (Throwable)((Object)new IllegalBinaryStateException(npmBinary, npmBinaryStatus)));
        }
        return this.statusHelper.OK();
    }

    private Map<String, java.net.URI> getAllNpmProjectsMapping() {
        HashMap mappings = Maps.newHashMap();
        for (IProject iProject : this.externalLibraryWorkspace.getProjects()) {
            if (!iProject.isAccessible() || !(iProject instanceof ExternalProject)) continue;
            java.net.URI location = ((ExternalProject)iProject).getExternalResource().toURI();
            mappings.put(iProject.getName(), location);
        }
        return ImmutableMap.copyOf((Map)mappings);
    }

    private IStatus runWithWorkspaceLock(Supplier<IStatus> operation) {
        if (Platform.isRunning()) {
            IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
            try {
                Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                IStatus iStatus = operation.get();
                return iStatus;
            }
            catch (OperationCanceledException e) {
                LOGGER.info((Object)"User cancelled operation.");
                IStatus iStatus = this.statusHelper.createCancel("User cancelled operation.");
                return iStatus;
            }
            finally {
                Job.getJobManager().endRule((ISchedulingRule)rule);
            }
        }
        return operation.get();
    }
}

