/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.compileTime.CompileTimeEvaluator;
import org.eclipse.n4js.compileTime.CompileTimeValue;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.ts.types.TConstableElement;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class CompileTimeExpressionProcessor {
    @Inject
    private CompileTimeEvaluator compileTimeEvaluator;

    public void evaluateCompileTimeExpression(RuleEnvironment G, Expression astNode, ASTMetaInfoCache cache, int indentLevel) {
        boolean _isProcessedAsCompileTimeExpression = N4JSLanguageUtils.isProcessedAsCompileTimeExpression(astNode);
        if (_isProcessedAsCompileTimeExpression) {
            CompileTimeValue value = this.compileTimeEvaluator.evaluateCompileTimeExpression(G, astNode);
            cache.storeCompileTimeValue(astNode, value);
            EObject parent = astNode.eContainer();
            if (parent instanceof ExportedVariableDeclaration) {
                this.storeValueInTModule(G, (TConstableElement)((ExportedVariableDeclaration)parent).getDefinedVariable(), value);
            } else if (parent instanceof N4FieldDeclaration) {
                this.storeValueInTModule(G, (TConstableElement)((N4FieldDeclaration)parent).getDefinedField(), value);
            }
        }
    }

    private void storeValueInTModule(RuleEnvironment G, TConstableElement elem, CompileTimeValue value) {
        if (elem != null && elem.isConst()) {
            String valueStr = CompileTimeValue.serialize(value);
            Procedures.Procedure0 _function = () -> elem.setCompileTimeValue(valueStr);
            EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{elem});
        }
    }
}

