// Generated by N4JS transpiler; for copyright see original N4JS source file.

(function(System) {
	'use strict';
	System.register([], function($n4Export) {
		var DispatchQueue, ListenerDS;
		DispatchQueue = function DispatchQueue() {
			this.listeners = undefined;
			this.lastIndex = 0;
			this.lastInsertionOrder = 0;
			this.shouldHalt = false;
			this.isDispatching = false;
			this.listeners = [
				null
			];
		};
		$n4Export('DispatchQueue', DispatchQueue);
		ListenerDS = function ListenerDS(spec) {
			this.listener = spec && 'listener' in spec ? spec.listener : undefined;
			this.context = spec && 'context' in spec ? spec.context : undefined;
			this.priority = spec && 'priority' in spec ? spec.priority : undefined;
			this.applyOnlyOnce = spec && 'applyOnlyOnce' in spec ? spec.applyOnlyOnce : undefined;
			this.insertionOrder = spec && 'insertionOrder' in spec ? spec.insertionOrder : undefined;
			if (spec) {}
		};
		return {
			setters: [],
			execute: function() {
				$makeClass(DispatchQueue, N4Object, [], {
					has: {
						value: function has___n4(listener, context) {
							for(var i = 1;i <= this.lastIndex;i++) {
								if ((this.listeners[i].listener == listener) && (this.listeners[i].context == context)) {
									return true;
								}
							}
							return false;
						}
					},
					isEmpty: {
						value: function isEmpty___n4() {
							return (this.lastIndex < 1);
						}
					},
					add: {
						value: function add___n4(listener, listenerContext, priority=0) {
							this.addListener(listener, listenerContext, priority, false);
						}
					},
					addOnce: {
						value: function addOnce___n4(listener, listenerContext, priority) {
							this.addListener(listener, listenerContext, priority, true);
						}
					},
					remove: {
						value: function remove___n4(listener, context) {
							var listenerIdx = this.listeners.findIndex((elem, index, array)=>{
								return ((elem !== null) && (elem.listener === listener) && (elem.context === context));
							});
							if (listenerIdx >= 0) {
								this.removeListenerAt(listenerIdx);
							}
						}
					},
					removeAll: {
						value: function removeAll___n4() {
							while(this.listeners.length > 1) {
								this.listeners.pop();
							}
							this.lastIndex = 0;
							this.lastInsertionOrder = 0;
							return this;
						}
					},
					getNumListeners: {
						value: function getNumListeners___n4() {
							return this.lastIndex;
						}
					},
					halt: {
						value: function halt___n4() {
							this.shouldHalt = true;
							return this;
						}
					},
					dispatch: {
						value: async function dispatch___n4(params) {
							this.isDispatching = true;
							var listeners = this.getListOfListeners();
							for(var i = 0;i < listeners.length;i++) {
								var current = listeners[i];
								if (!this.shouldHalt) {
									await Promise.resolve(current.listener.apply(current.listenerContext, params));
									if (current.applyOnlyOnce) {
										this.remove(current.listener, current.listenerContext);
									}
								}
							}
							this.isDispatching = false;
							this.shouldHalt = false;
						}
					},
					getListOfListeners: {
						value: function getListOfListeners___n4() {
							var oldListeners = this.listeners.slice();
							var oldLastIndex = this.lastIndex;
							var oldLastInsertionOrder = this.lastInsertionOrder;
							var result = new Array();
							for(var i = 1;i <= oldLastIndex;i++) {
								var current = this.removeListenerWithHighestPriority();
								result.push({
									listener: current.listener,
									listenerContext: current.context,
									priority: current.priority,
									insertionOrder: current.insertionOrder,
									applyOnlyOnce: current.applyOnlyOnce
								});
							}
							this.lastIndex = oldLastIndex;
							this.lastInsertionOrder = oldLastInsertionOrder;
							while(this.listeners.length > 1) {
								this.listeners.pop();
							}
							for(i = 1;i <= this.lastIndex;i++) {
								this.listeners.push(oldListeners[i]);
							}
							return result;
						}
					},
					dispose: {
						value: function dispose___n4() {
							while(this.listeners.length) {
								this.listeners.pop();
							}
							this.listeners = undefined;
							this.lastIndex = 0;
							this.lastInsertionOrder = 0;
						}
					},
					toString: {
						value: function toString___n4() {
							return this.getListOfListeners().toString();
						}
					},
					addListener: {
						value: function addListener___n4(listener, listenerContext, priority, applyOnlyOnce) {
							if (this.isDispatching) {
								throw "Adding a listener while dispatching is forbidden.";
							}
							this.lastInsertionOrder++;
							this.lastIndex++;
							this.listeners.push(new ListenerDS({
								listener: listener,
								context: listenerContext,
								priority: priority,
								applyOnlyOnce: applyOnlyOnce,
								insertionOrder: this.lastInsertionOrder
							}));
							this.shiftUp(this.lastIndex);
						}
					},
					removeListenerAt: {
						value: function removeListenerAt___n4(index) {
							var listenerToBeRemoved = this.listeners[index];
							this.listeners[index] = this.listeners[this.lastIndex];
							var parentIndex = Math.floor(index / 2);
							if ((parentIndex >= 1) && (this.listeners[index].compare(this.listeners[parentIndex]) > 0)) {
								this.shiftUp(index);
							} else {
								this.shiftDown(index);
							}
							this.listeners.pop();
							this.lastIndex--;
							return listenerToBeRemoved;
						}
					},
					removeListenerWithHighestPriority: {
						value: function removeListenerWithHighestPriority___n4() {
							if (this.isEmpty()) {
								return null;
							}
							return this.removeListenerAt(1);
						}
					},
					shiftDown: {
						value: function shiftDown___n4(index) {
							if (index >= this.lastIndex) {
								return;
							}
							var nextIndex = index;
							var leftChildIndex = 2 * index;
							var rightChildIndex = 2 * index + 1;
							if ((leftChildIndex < this.lastIndex) && (this.listeners[index].compare(this.listeners[leftChildIndex]) < 0)) {
								index = leftChildIndex;
							}
							if ((rightChildIndex < this.lastIndex) && (this.listeners[index].compare(this.listeners[rightChildIndex]) < 0)) {
								index = rightChildIndex;
							}
							if (nextIndex != index) {
								this.swap(index, nextIndex);
								this.shiftDown(nextIndex);
							}
						}
					},
					swap: {
						value: function swap___n4(index1, index2) {
							var tmp = this.listeners[index1];
							this.listeners[index1] = this.listeners[index2];
							this.listeners[index2] = tmp;
						}
					},
					shiftUp: {
						value: function shiftUp___n4(index) {
							if (index <= 1) {
								return;
							}
							var parentIndex = Math.floor(index / 2);
							if (this.listeners[index].compare(this.listeners[parentIndex]) > 0) {
								this.swap(index, parentIndex);
								this.shiftUp(parentIndex);
							}
						}
					},
					listeners: {
						value: undefined,
						writable: true
					},
					lastIndex: {
						value: undefined,
						writable: true
					},
					lastInsertionOrder: {
						value: undefined,
						writable: true
					},
					shouldHalt: {
						value: undefined,
						writable: true
					},
					isDispatching: {
						value: undefined,
						writable: true
					}
				}, {}, function(instanceProto, staticProto) {
					var metaClass = new N4Class({
						name: 'DispatchQueue',
						origin: 'org.eclipse.n4js.mangelhaft',
						fqn: 'org.eclipse.n4js.mangelhaft.types.DispatchQueue.DispatchQueue',
						n4superType: N4Object.n4type,
						allImplementedInterfaces: [],
						ownedMembers: [
							new N4DataField({
								name: 'listeners',
								isStatic: false,
								annotations: []
							}),
							new N4DataField({
								name: 'lastIndex',
								isStatic: false,
								annotations: []
							}),
							new N4DataField({
								name: 'lastInsertionOrder',
								isStatic: false,
								annotations: []
							}),
							new N4DataField({
								name: 'shouldHalt',
								isStatic: false,
								annotations: []
							}),
							new N4DataField({
								name: 'isDispatching',
								isStatic: false,
								annotations: []
							}),
							new N4Method({
								name: 'constructor',
								isStatic: false,
								jsFunction: instanceProto['constructor'],
								annotations: []
							}),
							new N4Method({
								name: 'has',
								isStatic: false,
								jsFunction: instanceProto['has'],
								annotations: []
							}),
							new N4Method({
								name: 'isEmpty',
								isStatic: false,
								jsFunction: instanceProto['isEmpty'],
								annotations: []
							}),
							new N4Method({
								name: 'add',
								isStatic: false,
								jsFunction: instanceProto['add'],
								annotations: []
							}),
							new N4Method({
								name: 'addOnce',
								isStatic: false,
								jsFunction: instanceProto['addOnce'],
								annotations: []
							}),
							new N4Method({
								name: 'remove',
								isStatic: false,
								jsFunction: instanceProto['remove'],
								annotations: []
							}),
							new N4Method({
								name: 'removeAll',
								isStatic: false,
								jsFunction: instanceProto['removeAll'],
								annotations: []
							}),
							new N4Method({
								name: 'getNumListeners',
								isStatic: false,
								jsFunction: instanceProto['getNumListeners'],
								annotations: []
							}),
							new N4Method({
								name: 'halt',
								isStatic: false,
								jsFunction: instanceProto['halt'],
								annotations: []
							}),
							new N4Method({
								name: 'dispatch',
								isStatic: false,
								jsFunction: instanceProto['dispatch'],
								annotations: []
							}),
							new N4Method({
								name: 'getListOfListeners',
								isStatic: false,
								jsFunction: instanceProto['getListOfListeners'],
								annotations: []
							}),
							new N4Method({
								name: 'dispose',
								isStatic: false,
								jsFunction: instanceProto['dispose'],
								annotations: []
							}),
							new N4Method({
								name: 'toString',
								isStatic: false,
								jsFunction: instanceProto['toString'],
								annotations: []
							}),
							new N4Method({
								name: 'addListener',
								isStatic: false,
								jsFunction: instanceProto['addListener'],
								annotations: []
							}),
							new N4Method({
								name: 'removeListenerAt',
								isStatic: false,
								jsFunction: instanceProto['removeListenerAt'],
								annotations: []
							}),
							new N4Method({
								name: 'removeListenerWithHighestPriority',
								isStatic: false,
								jsFunction: instanceProto['removeListenerWithHighestPriority'],
								annotations: []
							}),
							new N4Method({
								name: 'shiftDown',
								isStatic: false,
								jsFunction: instanceProto['shiftDown'],
								annotations: []
							}),
							new N4Method({
								name: 'swap',
								isStatic: false,
								jsFunction: instanceProto['swap'],
								annotations: []
							}),
							new N4Method({
								name: 'shiftUp',
								isStatic: false,
								jsFunction: instanceProto['shiftUp'],
								annotations: []
							})
						],
						consumedMembers: [],
						annotations: []
					});
					return metaClass;
				});
				$makeClass(ListenerDS, N4Object, [], {
					compare: {
						value: function compare___n4(otherListener) {
							if (this.priority == otherListener.priority) {
								if (this.insertionOrder < otherListener.insertionOrder) {
									return 1;
								} else {
									return -1;
								}
							} else if (this.priority > otherListener.priority) {
								return 1;
							} else {
								return -1;
							}
						}
					},
					listener: {
						value: undefined,
						writable: true
					},
					context: {
						value: undefined,
						writable: true
					},
					priority: {
						value: undefined,
						writable: true
					},
					applyOnlyOnce: {
						value: undefined,
						writable: true
					},
					insertionOrder: {
						value: undefined,
						writable: true
					}
				}, {}, function(instanceProto, staticProto) {
					var metaClass = new N4Class({
						name: 'ListenerDS',
						origin: 'org.eclipse.n4js.mangelhaft',
						fqn: 'org.eclipse.n4js.mangelhaft.types.DispatchQueue.ListenerDS',
						n4superType: N4Object.n4type,
						allImplementedInterfaces: [],
						ownedMembers: [
							new N4DataField({
								name: 'listener',
								isStatic: false,
								annotations: []
							}),
							new N4DataField({
								name: 'context',
								isStatic: false,
								annotations: []
							}),
							new N4DataField({
								name: 'priority',
								isStatic: false,
								annotations: []
							}),
							new N4DataField({
								name: 'applyOnlyOnce',
								isStatic: false,
								annotations: []
							}),
							new N4DataField({
								name: 'insertionOrder',
								isStatic: false,
								annotations: []
							}),
							new N4Method({
								name: 'constructor',
								isStatic: false,
								jsFunction: instanceProto['constructor'],
								annotations: []
							}),
							new N4Method({
								name: 'compare',
								isStatic: false,
								jsFunction: instanceProto['compare'],
								annotations: []
							})
						],
						consumedMembers: [],
						annotations: []
					});
					return metaClass;
				});
			}
		};
	});
})(typeof module !== 'undefined' && module.exports ? require('n4js-node').System(require, module) : System);
//# sourceMappingURL=DispatchQueue.map
