/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.utils;

import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeCompareLogic;

public class TypeCompareUtils {
    public boolean isEqualTypes(Iterable<Type> ts1, Iterable<Type> ts2) {
        return TypeCompareLogic.compareTypes(null, ts1, ts2) == 0;
    }

    public boolean isEqualTypeArguments(Iterable<TypeArgument> ts1, Iterable<TypeArgument> ts2) {
        return TypeCompareLogic.compareTypeArguments(null, ts1, ts2) == 0;
    }

    public static boolean isEqual(Type t1, Type t2) {
        return TypeCompareLogic.compare(null, t1, t2) == 0;
    }

    public static boolean isEqual(TypeArgument t1, TypeArgument t2) {
        return TypeCompareLogic.compare(null, t1, t2) == 0;
    }

    public static final class SemanticEqualsWrapper {
        private final TypeRef typeRef;
        private Integer hashCode = null;

        public SemanticEqualsWrapper(TypeRef typeRef) {
            this.typeRef = typeRef;
        }

        public boolean equals(Object other) {
            if (other instanceof SemanticEqualsWrapper) {
                return TypeCompareUtils.isEqual((TypeArgument)this.typeRef, (TypeArgument)((SemanticEqualsWrapper)other).typeRef);
            }
            return false;
        }

        public int hashCode() {
            if (this.typeRef == null) {
                return 0;
            }
            if (this.hashCode == null) {
                this.hashCode = this.typeRef.getTypeRefAsString().hashCode();
            }
            return this.hashCode;
        }

        public String toString() {
            return "@SemanticEqualsWrapper(" + (this.typeRef != null ? this.typeRef.getTypeRefAsString() : "") + ")";
        }
    }
}

