/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.eclipse.n4js.utils.resources.DelegatingWorkspace;
import org.eclipse.n4js.utils.resources.ExternalFile;
import org.eclipse.n4js.utils.resources.ExternalFolder;
import org.eclipse.n4js.utils.resources.IExternalResource;

public class ExternalProject
extends Project
implements IExternalResource {
    private final File file;
    private final java.net.URI uri;
    private final String eclipseProjectName;
    private final Collection<String> natureIds;
    private final Collection<String> builderIds;

    public ExternalProject(File file, String natureId, String builderId) {
        this(file, Collections.singleton(natureId), Collections.singleton(builderId));
    }

    public ExternalProject(File file, String[] natureIds, String[] builderIds) {
        this(file, Arrays.asList(natureIds), Arrays.asList(builderIds));
    }

    public ExternalProject(File file, Iterable<String> natureIds, Iterable<String> builderIds) {
        super((IPath)new Path(file.getAbsolutePath()), null);
        Preconditions.checkState((boolean)file.isDirectory(), (Object)("Resource '" + file + "' is not a directory but a file."));
        this.file = file;
        this.uri = file.toURI();
        this.natureIds = Sets.newHashSet(natureIds);
        this.builderIds = Sets.newHashSet(builderIds);
        URI emfURI = URIUtils.deriveProjectURIFromFileLocation((File)file);
        String n4jsName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI(emfURI);
        this.eclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName(n4jsName);
    }

    public File getExternalResource() {
        return this.file;
    }

    public String getName() {
        return this.eclipseProjectName;
    }

    public IProject getProject() {
        return this;
    }

    public IContainer getParent() {
        return this;
    }

    public boolean exists() {
        return true;
    }

    public boolean exists(int flags, boolean checkType) {
        return true;
    }

    public boolean isAccessible() {
        return this.exists();
    }

    public boolean isReadOnly() {
        return !this.file.canWrite();
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        if (depth == 0) {
            visitor.visit((IResource)this);
        } else if (visitor.visit((IResource)this)) {
            IResource[] iResourceArray = this.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                member.accept(visitor, 1 == depth ? 0 : 2, memberFlags);
                ++n2;
            }
        }
    }

    public java.net.URI getLocationURI() {
        return this.uri;
    }

    public IPath getLocation() {
        return new Path(this.file.toPath().toString());
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        try {
            FileDeleter.delete((java.nio.file.Path)this.file.toPath());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.n4js.utils", "Error while deleting resource: " + this.file, (Throwable)e));
        }
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.delete(force, monitor);
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.delete(true, monitor);
    }

    public void deleteResource(boolean convertToPhantom, MultiStatus status) throws CoreException {
        this.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public IMarker findMarker(long id) {
        return null;
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        return new IMarker[0];
    }

    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
    }

    public IWorkspace getWorkspace() {
        return new DelegatingWorkspace();
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
        if (this.exists()) {
            this.file.setLastModified(System.currentTimeMillis());
        }
    }

    public boolean contains(ISchedulingRule rule) {
        return this.getWorkspace().getRoot().contains(rule);
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this.getWorkspace().getRoot().isConflicting(rule);
    }

    public IResource[] members() throws CoreException {
        return this.members(0);
    }

    public IResource[] members(boolean phantom) throws CoreException {
        return this.members(0);
    }

    public IResource[] members(int memberFlags) throws CoreException {
        File[] subFiles = this.file.listFiles();
        IResource[] members = new IResource[subFiles.length];
        int i = 0;
        while (i < subFiles.length) {
            File subFile = subFiles[i];
            members[i] = subFile.isFile() ? new ExternalFile((IProject)this, (IContainer)this, subFile) : new ExternalFolder((IProject)this, (IContainer)this, subFile);
            ++i;
        }
        return members;
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
    }

    public IFolder getFolder(String name) {
        File folderCandidate = this.getFullPath().append(name).toFile();
        if (folderCandidate.isDirectory()) {
            return new ExternalFolder((IProject)this, (IContainer)this, folderCandidate);
        }
        IFolder resource = this.getResource(name, IFolder.class);
        if (resource != null) {
            return resource;
        }
        return new ExternalFolder((IProject)this, (IContainer)this, folderCandidate);
    }

    public IFile getFile(String name) {
        File fileCandidate = this.getFullPath().append(name).toFile();
        if (fileCandidate.isFile()) {
            return new ExternalFile((IProject)this, (IContainer)this, fileCandidate);
        }
        IFile resource = this.getResource(name, IFile.class);
        if (resource != null) {
            return resource;
        }
        return new ExternalFile((IProject)this, (IContainer)this, fileCandidate);
    }

    private <T extends IResource> T getResource(String name, Class<T> resourceClass) {
        File fileCandidate = this.getFullPath().append(name).toFile();
        AtomicReference actualRef = new AtomicReference();
        if (fileCandidate.exists()) {
            this.acceptUnsafe(resource -> {
                if (resource instanceof IExternalResource && resourceClass.isAssignableFrom(resource.getClass()) && fileCandidate.equals(((IExternalResource)resource).getExternalResource())) {
                    actualRef.set((IResource)resourceClass.cast(resource));
                    return false;
                }
                return true;
            });
        }
        return (T)((IResource)actualRef.get());
    }

    private void acceptUnsafe(IResourceVisitor visitor) {
        try {
            this.accept(visitor);
        }
        catch (CoreException e) {
            throw new RuntimeException("Error while visiting resource." + (Object)((Object)this), e);
        }
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isOpen(int flags) {
        return true;
    }

    public IBuildConfiguration getActiveBuildConfig() throws CoreException {
        return new BuildConfiguration((IProject)this);
    }

    public ResourceInfo getResourceInfo(boolean phantom, boolean mutable) {
        ProjectDescription description = new ProjectDescription();
        description.setName(this.getName());
        description.setNatureIds((String[])FluentIterable.from(this.natureIds).toArray(String.class));
        ICommand[] buildSpecs = new ICommand[this.builderIds.size()];
        int i = 0;
        for (String builderId : this.builderIds) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderId);
            buildSpecs[i++] = command;
        }
        description.setBuildSpec(buildSpecs);
        ProjectInfo info = new ProjectInfo();
        info.setModificationStamp(this.file.lastModified());
        info.setDescription(description);
        return info;
    }

    public boolean isNatureEnabled(String natureId) throws CoreException {
        return this.natureIds.contains(natureId);
    }

    public IBuildConfiguration unsafeGetActiveBuildConfig() {
        String configName = this.internalGetDescription().getActiveBuildConfig();
        try {
            if (configName != null) {
                return this.getBuildConfig(configName);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return this.internalGetBuildConfigs(false)[0];
    }

    public String toString() {
        return "E" + super.toString();
    }

    public int hashCode() {
        return this.file == null ? 0 : this.file.hashCode();
    }

    public boolean equals(Object target) {
        if (target instanceof ExternalProject) {
            return Objects.equal((Object)this.file, (Object)((ExternalProject)((Object)target)).file);
        }
        return false;
    }
}

