/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.typesearch;

import org.eclipse.n4js.ui.typesearch.StringOperation;

abstract class SearchPatternHelper {
    public static final int R_EXACT_MATCH = 0;
    public static final int R_PREFIX_MATCH = 1;
    public static final int R_PATTERN_MATCH = 2;
    public static final int R_REGEXP_MATCH = 4;
    public static final int R_CASE_SENSITIVE = 8;
    public static final int R_ERASURE_MATCH = 16;
    public static final int R_EQUIVALENT_MATCH = 32;
    public static final int R_FULL_MATCH = 64;
    public static final int R_CAMELCASE_MATCH = 128;
    public static final int R_CAMELCASE_SAME_PART_COUNT_MATCH = 256;

    SearchPatternHelper() {
    }

    public static final int[] getMatchingRegions(String pattern, String name, int matchRule) {
        if (name == null) {
            return null;
        }
        int nameLength = name.length();
        if (pattern == null) {
            int[] nArray = new int[2];
            nArray[1] = nameLength;
            return nArray;
        }
        int patternLength = pattern.length();
        boolean countMatch = false;
        switch (matchRule) {
            case 0: {
                if (patternLength != nameLength || !pattern.equalsIgnoreCase(name)) break;
                int[] nArray = new int[2];
                nArray[1] = patternLength;
                return nArray;
            }
            case 8: {
                if (patternLength != nameLength || !pattern.equals(name)) break;
                int[] nArray = new int[2];
                nArray[1] = patternLength;
                return nArray;
            }
            case 1: {
                if (patternLength > nameLength || !name.substring(0, patternLength).equalsIgnoreCase(pattern)) break;
                int[] nArray = new int[2];
                nArray[1] = patternLength;
                return nArray;
            }
            case 9: {
                if (!name.startsWith(pattern)) break;
                int[] nArray = new int[2];
                nArray[1] = patternLength;
                return nArray;
            }
            case 256: {
                countMatch = true;
            }
            case 128: {
                if (patternLength > nameLength) break;
                int[] regions = SearchPatternHelper.getCamelCaseMatchingRegions(pattern, 0, patternLength, name, 0, nameLength, countMatch);
                if (regions != null) {
                    return regions;
                }
                if (!name.substring(0, patternLength).equalsIgnoreCase(pattern)) break;
                int[] nArray = new int[2];
                nArray[1] = patternLength;
                return nArray;
            }
            case 264: {
                countMatch = true;
            }
            case 136: {
                if (patternLength > nameLength) break;
                return SearchPatternHelper.getCamelCaseMatchingRegions(pattern, 0, patternLength, name, 0, nameLength, countMatch);
            }
            case 2: {
                return StringOperation.getPatternMatchingRegions(pattern, 0, patternLength, name, 0, nameLength, false);
            }
            case 10: {
                return StringOperation.getPatternMatchingRegions(pattern, 0, patternLength, name, 0, nameLength, true);
            }
        }
        return null;
    }

    private static final int[] getCamelCaseMatchingRegions(String pattern, int patternStart, int patternEnd, String name, int nameStart, int nameEnd, boolean samePartCount) {
        if (name == null) {
            return null;
        }
        if (pattern == null) {
            return StringOperation.EMPTY_REGIONS;
        }
        if (patternEnd < 0) {
            patternEnd = pattern.length();
        }
        if (nameEnd < 0) {
            nameEnd = name.length();
        }
        if (patternEnd <= patternStart) {
            int[] nArray;
            if (nameEnd <= nameStart) {
                int[] nArray2 = new int[2];
                nArray2[0] = patternStart;
                nArray = nArray2;
                nArray2[1] = patternEnd - patternStart;
            } else {
                nArray = null;
            }
            return nArray;
        }
        if (nameEnd <= nameStart) {
            return null;
        }
        if (name.charAt(nameStart) != pattern.charAt(patternStart)) {
            return null;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        int parts = 1;
        int i = patternStart + 1;
        while (i < patternEnd) {
            char ch = pattern.charAt(i);
            if (ch < '\u0080') {
                if ((StringOperation.OBVIOUS_IDENT_CHAR_NATURES[ch] & 0x24) != 0) {
                    ++parts;
                }
            } else if (Character.isJavaIdentifierPart(ch) && (Character.isUpperCase(ch) || Character.isDigit(ch))) {
                ++parts;
            }
            ++i;
        }
        int[] segments = null;
        int count = 0;
        int segmentStart = iName;
        while (true) {
            int segmentEnd;
            block39: {
                char nameChar;
                ++iName;
                if (++iPattern == patternEnd) {
                    if (!samePartCount || iName == nameEnd) {
                        if (segments == null) {
                            segments = new int[2];
                        }
                        segments[count++] = segmentStart;
                        segments[count++] = iName - segmentStart;
                        if (count < segments.length) {
                            int[] nArray = segments;
                            segments = new int[count];
                            System.arraycopy(nArray, 0, segments, 0, count);
                        }
                        return segments;
                    }
                    segmentEnd = iName;
                    while (true) {
                        if (iName == nameEnd) {
                            if (segments == null) {
                                segments = new int[2];
                            }
                            segments[count++] = segmentStart;
                            segments[count++] = segmentEnd - segmentStart;
                            if (count < segments.length) {
                                int[] nArray = segments;
                                segments = new int[count];
                                System.arraycopy(nArray, 0, segments, 0, count);
                            }
                            return segments;
                        }
                        nameChar = name.charAt(iName);
                        if (nameChar < '\u0080' ? (StringOperation.OBVIOUS_IDENT_CHAR_NATURES[nameChar] & 0x20) != 0 : !Character.isJavaIdentifierPart(nameChar) || Character.isUpperCase(nameChar)) {
                            return null;
                        }
                        ++iName;
                    }
                }
                if (iName == nameEnd) {
                    return null;
                }
                char patternChar = pattern.charAt(iPattern);
                if (patternChar == name.charAt(iName)) continue;
                segmentEnd = iName;
                if (patternChar < '\u0080' ? (StringOperation.OBVIOUS_IDENT_CHAR_NATURES[patternChar] & 0x24) == 0 : Character.isJavaIdentifierPart(patternChar) && !Character.isUpperCase(patternChar) && !Character.isDigit(patternChar)) {
                    return null;
                }
                while (true) {
                    if (iName == nameEnd) {
                        return null;
                    }
                    nameChar = name.charAt(iName);
                    if (nameChar < '\u0080') {
                        int charNature = StringOperation.OBVIOUS_IDENT_CHAR_NATURES[nameChar];
                        if ((charNature & 0x90) != 0) {
                            ++iName;
                            continue;
                        }
                        if ((charNature & 4) != 0) {
                            if (patternChar != nameChar) {
                                ++iName;
                                continue;
                            }
                        } else if (patternChar != nameChar) {
                            return null;
                        }
                    } else {
                        if (Character.isJavaIdentifierPart(nameChar) && !Character.isUpperCase(nameChar)) {
                            ++iName;
                            continue;
                        }
                        if (!Character.isDigit(nameChar)) break;
                        if (patternChar != nameChar) {
                            ++iName;
                            continue;
                        }
                    }
                    break block39;
                    break;
                }
                if (patternChar != nameChar) {
                    return null;
                }
            }
            if (segments == null) {
                segments = new int[parts * 2];
            }
            segments[count++] = segmentStart;
            segments[count++] = segmentEnd - segmentStart;
            segmentStart = iName;
        }
    }
}

