/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.collections;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Arrays2 {
    public static <F, T> List<T> transform(F[] array, Function<F, T> f) {
        if (array == null || array.length == 0) {
            return Collections.emptyList();
        }
        Object[] result = (Object[])Array.newInstance(Object.class, array.length);
        int i = 0;
        while (i < array.length) {
            result[i] = f.apply(array[i]);
            ++i;
        }
        return Arrays.asList(result);
    }

    public static <F, T extends F> T[] filter(F[] array, Class<T> predicate) {
        Preconditions.checkNotNull(array, (Object)"array");
        Preconditions.checkNotNull(predicate, (Object)"clazz");
        int size = array.length;
        ArrayList result = Lists.newArrayListWithExpectedSize((int)size);
        int i = 0;
        while (i < size) {
            F actual = array[i];
            if (actual != null && predicate.isAssignableFrom(actual.getClass())) {
                result.add(predicate.cast(actual));
            }
            ++i;
        }
        return Iterables.toArray((Iterable)result, predicate);
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    @SafeVarargs
    public static <T> T[] add(T[] source, T ... othersToAdd) {
        Preconditions.checkNotNull(source, (Object)"source");
        if (Arrays2.isEmpty(othersToAdd)) {
            return source;
        }
        Object[] result = (Object[])Array.newInstance(Object.class, source.length + othersToAdd.length);
        System.arraycopy(source, 0, result, 0, source.length);
        System.arraycopy(othersToAdd, 0, result, source.length, othersToAdd.length);
        return result;
    }
}

