/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.compileTime.CompileTimeValue;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ComputedNameProcessor {
    public void processComputedPropertyName(RuleEnvironment G, LiteralOrComputedPropertyName nameDecl, ASTMetaInfoCache cache, int indentLevel) {
        boolean _hasComputedPropertyName = nameDecl.hasComputedPropertyName();
        if (_hasComputedPropertyName) {
            CompileTimeValue value = cache.getCompileTimeValue(nameDecl.getExpression());
            String name = N4JSLanguageUtils.derivePropertyNameFromCompileTimeValue(value);
            if (name != null) {
                Procedures.Procedure0 _function = () -> nameDecl.setComputedName(name);
                EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{nameDecl});
                EObject owner = nameDecl.eContainer();
                EObject typeElem = N4JSASTUtils.getCorrespondingTypeModelElement((EObject)owner);
                if (typeElem instanceof IdentifiableElement) {
                    Procedures.Procedure0 _function_1 = () -> ((IdentifiableElement)typeElem).setName(name);
                    EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function_1, (Object[])new Object[]{typeElem});
                }
            } else {
                EObject owner_1 = nameDecl.eContainer();
                this.discardTypeModelElement(owner_1);
            }
        }
    }

    private void discardTypeModelElement(EObject astNode) {
        EObject elem = N4JSASTUtils.getCorrespondingTypeModelElement((EObject)astNode);
        if (elem == null) {
            throw new IllegalArgumentException("given AST node does not have a corresponding type model element to discard");
        }
        if (elem instanceof SyntaxRelatedTElement) {
            ((SyntaxRelatedTElement)elem).setAstElement(null);
        }
        Procedures.Procedure0 _function = () -> {
            boolean _matched = false;
            if (astNode instanceof TypeDefiningElement) {
                _matched = true;
                ((TypeDefiningElement)astNode).setDefinedType(null);
            }
            if (!_matched && astNode instanceof N4FieldDeclaration) {
                _matched = true;
                ((N4FieldDeclaration)astNode).setDefinedField(null);
            }
            if (!_matched && astNode instanceof N4GetterDeclaration) {
                _matched = true;
                ((N4GetterDeclaration)astNode).setDefinedGetter(null);
            }
            if (!_matched && astNode instanceof N4SetterDeclaration) {
                _matched = true;
                ((N4SetterDeclaration)astNode).setDefinedSetter(null);
            }
            if (!_matched && astNode instanceof PropertyNameValuePair) {
                _matched = true;
                ((PropertyNameValuePair)astNode).setDefinedField(null);
            }
            if (!_matched && astNode instanceof PropertyGetterDeclaration) {
                _matched = true;
                ((PropertyGetterDeclaration)astNode).setDefinedGetter(null);
            }
            if (!_matched && astNode instanceof PropertySetterDeclaration) {
                _matched = true;
                ((PropertySetterDeclaration)astNode).setDefinedSetter(null);
            }
            if (!_matched) {
                throw new UnsupportedOperationException("switch case missing for: " + astNode);
            }
        };
        EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{astNode});
        Procedures.Procedure0 _function_1 = () -> EcoreUtil2.remove((EObject)elem);
        EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function_1, (Object[])new Object[]{elem.eContainer()});
    }
}

