/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.sourcemap;

import org.eclipse.n4js.transpiler.sourcemap.Base64VLQ;
import org.eclipse.n4js.transpiler.sourcemap.FilePosition;

public class MappingEntry
implements Comparable<MappingEntry> {
    public final int genLine;
    public final int genColumn;
    public final int srcIndex;
    public final int srcLine;
    public final int srcColumn;
    public final int nameIndex;

    public MappingEntry(FilePosition genPos) {
        this(genPos, -1, null, -1);
    }

    public MappingEntry(FilePosition genPos, int srcIndex, FilePosition srcPos, int nameIndex) {
        this.genLine = genPos.getLine();
        this.genColumn = genPos.getColumn();
        this.srcIndex = srcIndex;
        if (srcPos != null) {
            this.srcLine = srcPos.getLine();
            this.srcColumn = srcPos.getColumn();
        } else {
            this.srcLine = -1;
            this.srcColumn = -1;
        }
        this.nameIndex = nameIndex;
    }

    public MappingEntry(int genLine, int[] segmentValues, PreviousEntry prev) {
        this.genLine = genLine;
        if (segmentValues == null || segmentValues.length == 0) {
            this.genColumn = -1;
            this.srcIndex = -1;
            this.srcLine = -1;
            this.srcColumn = -1;
            this.nameIndex = -1;
            return;
        }
        if (segmentValues.length == 1) {
            this.genColumn = prev.genColumn + segmentValues[0];
            this.srcIndex = -1;
            this.srcLine = -1;
            this.srcColumn = -1;
            this.nameIndex = -1;
            prev.genColumn = this.genColumn;
            return;
        }
        if (segmentValues.length < 4 || segmentValues.length > 5) {
            throw new IllegalArgumentException();
        }
        this.genColumn = prev.genColumn + segmentValues[0];
        this.srcIndex = prev.srcIndex + segmentValues[1];
        this.srcLine = prev.srcLine + segmentValues[2];
        this.srcColumn = prev.srcColumn + segmentValues[3];
        this.nameIndex = segmentValues.length == 5 ? prev.nameIndex + segmentValues[4] : -1;
    }

    @Override
    public int compareTo(MappingEntry o) {
        return this.genColumn - o.genColumn;
    }

    public String toBase64VLQRelative(PreviousEntry prev) {
        if (this.srcIndex < 0) {
            return Base64VLQ.encode(this.genColumn - prev.genColumn);
        }
        if (this.nameIndex < 0) {
            return Base64VLQ.encode(this.genColumn - prev.genColumn, this.srcIndex - prev.srcIndex, this.srcLine - prev.srcLine, this.srcColumn - prev.srcColumn);
        }
        return Base64VLQ.encode(this.genColumn - prev.genColumn, this.srcIndex - prev.srcIndex, this.srcLine - prev.srcLine, this.srcColumn - prev.srcColumn, this.nameIndex - prev.nameIndex);
    }

    public void updatePrev(PreviousEntry prev) {
        prev.genColumn = this.genColumn;
        if (this.srcIndex >= 0) {
            prev.srcIndex = this.srcIndex;
            prev.srcLine = this.srcLine;
            prev.srcColumn = this.srcColumn;
            if (this.nameIndex >= 0) {
                prev.nameIndex = this.nameIndex;
            }
        }
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append(this.genColumn);
        if (this.srcLine >= 0) {
            strb.append("->");
            strb.append(this.srcLine);
            strb.append(":");
            strb.append(this.srcColumn);
            if (this.srcIndex > 0) {
                strb.append('@');
                strb.append(this.srcIndex);
            }
        }
        return strb.toString();
    }

    static class PreviousEntry {
        int genLine;
        int genColumn;
        int srcIndex;
        int srcLine;
        int srcColumn;
        int nameIndex;

        PreviousEntry() {
        }
    }
}

