/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jgit.errors.CorruptPackIndexException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.fsck.FsckError;
import org.eclipse.jgit.internal.fsck.FsckPackParser;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;

public class DfsFsck {
    private final DfsRepository repo;
    private final DfsObjDatabase objdb;
    private ObjectChecker objChecker = new ObjectChecker();
    private boolean connectivityOnly;

    public DfsFsck(DfsRepository repository) {
        this.repo = repository;
        this.objdb = this.repo.getObjectDatabase();
    }

    public FsckError check(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        FsckError errors = new FsckError();
        if (!this.connectivityOnly) {
            this.checkPacks(pm, errors);
        }
        this.checkConnectivity(pm, errors);
        return errors;
    }

    private void checkPacks(ProgressMonitor pm, FsckError errors) throws IOException, FileNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DfsReader ctx = this.objdb.newReader();){
            DfsPackFile[] dfsPackFileArray = this.objdb.getPacks();
            int n = dfsPackFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                DfsPackFile pack = dfsPackFileArray[n2];
                DfsPackDescription packDesc = pack.getPackDescription();
                if (packDesc.getPackSource() != DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) {
                    try {
                        Throwable throwable2 = null;
                        Object var12_17 = null;
                        try (ReadableChannel rc = this.objdb.openFile(packDesc, PackExt.PACK);){
                            this.verifyPack(pm, errors, ctx, pack, rc);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (MissingObjectException e) {
                        errors.getMissingObjects().add(e.getObjectId());
                    }
                    catch (CorruptPackIndexException e) {
                        errors.getCorruptIndices().add(new FsckError.CorruptIndex(pack.getPackDescription().getFileName(PackExt.INDEX), e.getErrorType()));
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void verifyPack(ProgressMonitor pm, FsckError errors, DfsReader ctx, DfsPackFile pack, ReadableChannel ch) throws IOException, CorruptPackIndexException {
        FsckPackParser fpp = new FsckPackParser((ObjectDatabase)this.objdb, ch);
        fpp.setObjectChecker(this.objChecker);
        fpp.overwriteObjectCount(pack.getPackDescription().getObjectCount());
        fpp.parse(pm);
        errors.getCorruptObjects().addAll(fpp.getCorruptObjects());
        fpp.verifyIndex(pack.getPackIndex(ctx));
    }

    private void checkConnectivity(ProgressMonitor pm, FsckError errors) throws IOException {
        pm.beginTask(JGitText.get().countingObjects, 0);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectWalk ow = new ObjectWalk(this.repo);){
            for (Ref r : this.repo.getRefDatabase().getRefs()) {
                ObjectId objectId = r.getObjectId();
                if (objectId == null) continue;
                try {
                    RevObject tip = ow.parseAny(objectId);
                    if (r.getLeaf().getName().startsWith("refs/heads/") && tip.getType() != 1) {
                        errors.getNonCommitHeads().add(r.getLeaf().getName());
                    }
                    ow.markStart(tip);
                }
                catch (MissingObjectException e) {
                    errors.getMissingObjects().add(e.getObjectId());
                }
            }
            try {
                ow.checkConnectivity();
            }
            catch (MissingObjectException e) {
                errors.getMissingObjects().add(e.getObjectId());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        pm.endTask();
    }

    public void setObjectChecker(ObjectChecker objChecker) {
        this.objChecker = objChecker;
    }

    public void setConnectivityOnly(boolean connectivityOnly) {
        this.connectivityOnly = connectivityOnly;
    }
}

