/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ModuleSpecifierAdjustment;
import org.eclipse.n4js.N4JSLanguageConstants;
import org.eclipse.n4js.n4JS.AdditiveOperator;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalOperator;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.EqualityOperator;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.PostfixOperator;
import org.eclipse.n4js.n4JS.PrimaryExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclarationOrBinding;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4idl.transpiler.utils.N4IDLTranspilerUtils;
import org.eclipse.n4js.projectDescription.ModuleLoader;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.es.assistants.DestructuringAssistant;
import org.eclipse.n4js.transpiler.es.transform.DestructuringTransformation;
import org.eclipse.n4js.transpiler.es.transform.internal.ImportAssignment;
import org.eclipse.n4js.transpiler.es.transform.internal.ImportEntry;
import org.eclipse.n4js.transpiler.es.transform.internal.NamedImportAssignment;
import org.eclipse.n4js.transpiler.es.transform.internal.NamespaceImportAssignment;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.Script_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.versions.VersionableUtils;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@TransformationDependency.ExcludesAfter(value={DestructuringTransformation.class})
public class ModuleWrappingTransformation
extends Transformation {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ResourceNameComputer resourceNameComputer;
    @Inject
    private DestructuringAssistant destructuringAssistant;
    private final Set<SymbolTableEntry> exportedSTEs = CollectionLiterals.newLinkedHashSet();

    public void analyze() {
    }

    public void assertPreConditions() {
        Functions.Function1 _function = it -> {
            TModule _importedModule = this.getState().info.getImportedModule(it);
            return _importedModule != null;
        };
        this.assertTrue("every import declaration should have an imported module", IteratorExtensions.forall((Iterator)Iterators.filter((Iterator)this.getState().im.eAllContents(), ImportDeclaration.class), (Functions.Function1)_function));
    }

    public void assertPostConditions() {
        int _size = this.getState().im.getScriptElements().size();
        boolean _equals = _size == 1;
        this.assertTrue("wrapped module has a single statement.", _equals);
    }

    public void transform() {
        Script_IM script_im = this.getState().im;
        EList content_im = script_im.getScriptElements();
        this.replaceExportStatementsAndExctractCalls((List<ScriptElement>)content_im);
        LinkedHashMap<String, ImportEntry> importSetterMap = this.processImports((List<ScriptElement>)content_im);
        ArrayList activeStatements = CollectionLiterals.newArrayList();
        ParameterizedCallExpression __CallExpr = TranspilerBuilderBlocks._CallExpr();
        Procedures.Procedure1 _function = arg_0 -> this.lambda$1(importSetterMap, (List)content_im, activeStatements, arg_0);
        ParameterizedCallExpression call_System_dot_register_Expr = (ParameterizedCallExpression)ObjectExtensions.operator_doubleArrow((Object)__CallExpr, (Procedures.Procedure1)_function);
        ExpressionStatement exprStatementSystem = TranspilerBuilderBlocks._ExprStmnt((Expression)call_System_dot_register_Expr);
        Statement exprStatement = this.doWrapInCJSpatch(exprStatementSystem);
        script_im.getScriptElements().clear();
        EList _scriptElements = script_im.getScriptElements();
        _scriptElements.add((Object)exprStatement);
        this.transFormExportExpressions(activeStatements);
    }

    private FunctionExpression importFE(ImportEntry entry) {
        FunctionExpression _xblockexpression = null;
        String fparName = "$exports";
        SymbolTableEntryInternal steFpar = this.getSymbolTableEntryInternal("$exports", true);
        FunctionExpression __FunExpr = TranspilerBuilderBlocks._FunExpr((boolean)false, (Statement[])new Statement[0]);
        Procedures.Procedure1 _function = it -> {
            EList _fpars = it.getFpars();
            FormalParameter __Fpar = TranspilerBuilderBlocks._Fpar();
            Procedures.Procedure1 _function_1 = it_1 -> it_1.setName("$exports");
            FormalParameter _doubleArrow = (FormalParameter)ObjectExtensions.operator_doubleArrow((Object)__Fpar, (Procedures.Procedure1)_function_1);
            _fpars.add((Object)_doubleArrow);
            Block __Block = TranspilerBuilderBlocks._Block((Statement[])new Statement[0]);
            Procedures.Procedure1 _function_2 = it_1 -> {
                EList _statements = it_1.getStatements();
                String _actualModuleSpecifier = entry.getActualModuleSpecifier();
                String _plus = "// " + _actualModuleSpecifier;
                ExpressionStatement __ExprStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._Snippet((String)_plus));
                _statements.add((Object)__ExprStmnt);
                for (ImportAssignment current : entry.getVariableSTE_actualName()) {
                    IdentifierRef_IM refToFPar = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)steFpar);
                    IdentifierRef_IM _xifexpression = null;
                    if (current instanceof NamespaceImportAssignment) {
                        _xifexpression = refToFPar;
                    } else {
                        ParameterizedPropertyAccessExpression_IM _xifexpression_1 = null;
                        if (!(current instanceof NamedImportAssignment)) {
                            String _simpleName = current.getClass().getSimpleName();
                            String _plus_1 = "unsupported subclass of ImportAssignment: " + _simpleName;
                            throw new IllegalStateException(_plus_1);
                        }
                        ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr = TranspilerBuilderBlocks._PropertyAccessExpr();
                        Procedures.Procedure1 _function_3 = it_2 -> {
                            it_2.setProperty_IM(this.getEntryForNamedImportedElement(((NamedImportAssignment)current).getSte()));
                            it_2.setTarget((Expression)refToFPar);
                        };
                        _xifexpression_1 = (ParameterizedPropertyAccessExpression_IM)ObjectExtensions.operator_doubleArrow((Object)__PropertyAccessExpr, (Procedures.Procedure1)_function_3);
                        _xifexpression = _xifexpression_1;
                    }
                    IdentifierRef_IM rhs = _xifexpression;
                    EList _statements_1 = it_1.getStatements();
                    ExpressionStatement __ExprStmnt_1 = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)current.getSte()), (Expression)rhs));
                    Procedures.Procedure1 _function_4 = it_2 -> this.getState().tracer.copyTrace((EObject)current.getToBeReplacedImportSpecifier(), new EObject[]{it_2});
                    ExpressionStatement _doubleArrow_1 = (ExpressionStatement)ObjectExtensions.operator_doubleArrow((Object)__ExprStmnt_1, (Procedures.Procedure1)_function_4);
                    _statements_1.add((Object)_doubleArrow_1);
                }
            };
            Block _doubleArrow_1 = (Block)ObjectExtensions.operator_doubleArrow((Object)__Block, (Procedures.Procedure1)_function_2);
            it.setBody(_doubleArrow_1);
            this.getState().tracer.copyTrace((EObject)entry.getToBeReplacedImportDeclaration(), new EObject[]{it});
        };
        _xblockexpression = (FunctionExpression)ObjectExtensions.operator_doubleArrow((Object)__FunExpr, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    private SymbolTableEntry getEntryForNamedImportedElement(SymbolTableEntryOriginal importedElementEntry) {
        IdentifiableElement originalTarget = importedElementEntry.getOriginalTarget();
        boolean _isTVersionable = VersionableUtils.isTVersionable((EObject)originalTarget);
        if (_isTVersionable) {
            return this.getSymbolTableEntryInternal(N4IDLTranspilerUtils.getVersionedInternalName((IdentifiableElement)originalTarget), true);
        }
        return this.getSymbolTableEntryInternal(importedElementEntry.exportedName(), true);
    }

    private LinkedHashMap<String, ImportEntry> processImports(List<ScriptElement> contents_im) {
        LinkedHashMap map = CollectionLiterals.newLinkedHashMap();
        for (ScriptElement elementIM : contents_im) {
            if (!(elementIM instanceof ImportDeclaration)) continue;
            TModule module = this.getState().info.getImportedModule((ImportDeclaration)elementIM);
            String actualModuleSpecifier = this.computeActualModuleSpecifier(module);
            ImportEntry moduleEntry = (ImportEntry)map.get(actualModuleSpecifier);
            if (moduleEntry == null) {
                ImportEntry _importEntry;
                ArrayList _newArrayList = CollectionLiterals.newArrayList();
                moduleEntry = _importEntry = new ImportEntry(actualModuleSpecifier, _newArrayList, (ImportDeclaration)elementIM);
                map.put(actualModuleSpecifier, moduleEntry);
            }
            ImportEntry finalModuleEntry = moduleEntry;
            Consumer<ImportSpecifier> _function = it -> {
                List<ImportAssignment> _variableSTE_actualName;
                boolean _matched = false;
                if (it instanceof NamespaceImportSpecifier) {
                    _matched = true;
                    SymbolTableEntryOriginal nisSTE = this.findSymbolTableEntryForNamespaceImport((NamespaceImportSpecifier)it);
                    _variableSTE_actualName = finalModuleEntry.getVariableSTE_actualName();
                    NamespaceImportAssignment _namespaceImportAssignment = new NamespaceImportAssignment(nisSTE, (NamespaceImportSpecifier)it);
                    _variableSTE_actualName.add(_namespaceImportAssignment);
                }
                if (!_matched && it instanceof NamedImportSpecifier) {
                    _matched = true;
                    SymbolTableEntryOriginal ste = this.findSymbolTableEntryForNamedImport((NamedImportSpecifier)it);
                    if (ste != null) {
                        _variableSTE_actualName = finalModuleEntry.getVariableSTE_actualName();
                        String _alias = ((NamedImportSpecifier)it).getAlias();
                        NamedImportAssignment _namedImportAssignment = new NamedImportAssignment(ste, _alias, (NamedImportSpecifier)it);
                        _variableSTE_actualName.add(_namedImportAssignment);
                    }
                }
            };
            ((ImportDeclaration)elementIM).getImportSpecifiers().forEach(_function);
        }
        return map;
    }

    private String computeActualModuleSpecifier(TModule module) {
        String completeModuleSpecifier = this.resourceNameComputer.getCompleteModuleSpecifier(module);
        ModuleSpecifierAdjustment moduleSpecifierAdjustment = this.getModuleSpecifierAdjustment(module);
        if (moduleSpecifierAdjustment != null && moduleSpecifierAdjustment.usePlainModuleSpecifier) {
            String _moduleSpecifier = module.getModuleSpecifier();
            return String.valueOf(moduleSpecifierAdjustment.prefix) + "/" + _moduleSpecifier;
        }
        String specifier = completeModuleSpecifier;
        IN4JSProject depProject = (IN4JSProject)this.n4jsCore.findProject(module.eResource().getURI()).orNull();
        if (depProject != null && depProject.getProjectType() == ProjectType.DEFINITION && depProject.getDefinesPackageName() != null) {
            depProject = (IN4JSProject)this.n4jsCore.findAllProjectMappings().get(depProject.getDefinesPackageName());
        }
        if (depProject != null) {
            String projectRelativeSegment = depProject.getOutputPath();
            Path depLocation = depProject.getLocationPath();
            if (depLocation != null) {
                String depLocationString = depLocation.toString();
                String depProjecOutputPath = depProject.getLocationPath().resolve(projectRelativeSegment).normalize().toString();
                int _length = depLocationString.length();
                int _length_1 = depProject.getProjectName().length();
                int _minus = _length - _length_1;
                String depRelativeSpecifier = depProjecOutputPath.substring(_minus);
                specifier = String.valueOf(depRelativeSpecifier) + "/" + completeModuleSpecifier;
            }
        }
        if (moduleSpecifierAdjustment != null) {
            return String.valueOf(moduleSpecifierAdjustment.prefix) + "/" + specifier;
        }
        return specifier;
    }

    private void replaceExportStatementsAndExctractCalls(List<ScriptElement> scriptContent_im) {
        int i = 0;
        while (i < scriptContent_im.size()) {
            ExportableElement _exportedElement;
            ExportedVariableStatement exportedVarStmt;
            ScriptElement orig = scriptContent_im.get(i);
            if (orig instanceof ExportDeclaration && (exportedVarStmt = (ExportedVariableStatement)(_exportedElement = ((ExportDeclaration)orig).getExportedElement())) != null) {
                VariableStatement bareVarStmt = this.removeExport(exportedVarStmt);
                Functions.Function1 _function = it -> this.findSymbolTableEntryForElement((NamedElement)it, true);
                Consumer<SymbolTableEntry> _function_1 = it -> this.exportedSTEs.add((SymbolTableEntry)it);
                ListExtensions.map((List)bareVarStmt.getVarDecl(), (Functions.Function1)_function).forEach(_function_1);
            }
            ++i;
        }
    }

    private Pair<VariableStatement, List<ExpressionStatement>> hoistedVariablesAndInits(List<ScriptElement> scriptContent) {
        LinkedHashMap mapVarStatement2replacer = CollectionLiterals.newLinkedHashMap();
        Functions.Function1 _function = scriptElement -> {
            Iterable _switchResult = null;
            boolean _matched = false;
            if (scriptElement instanceof VariableStatement) {
                boolean _not;
                Functions.Function1 _function_1;
                _matched = true;
                Iterable _xblockexpression = null;
                Iterable<Pair<List<VariableDeclaration>, ExpressionStatement>> pairsOfDeclarationAndInitialsers = this.toHoistDeclarations((List<VariableDeclarationOrBinding>)((VariableStatement)scriptElement).getVarDeclsOrBindings());
                List listOfInitExpressionStmts = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(pairsOfDeclarationAndInitialsers, (Functions.Function1)(_function_1 = it -> (ExpressionStatement)it.getValue()))));
                boolean _isEmpty = listOfInitExpressionStmts.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    mapVarStatement2replacer.put((VariableStatement)scriptElement, listOfInitExpressionStmts);
                }
                Functions.Function1 _function_2 = it -> (List)it.getKey();
                _switchResult = _xblockexpression = Iterables.concat((Iterable)IterableExtensions.map(pairsOfDeclarationAndInitialsers, (Functions.Function1)_function_2));
            }
            if (!_matched && scriptElement instanceof ImportDeclaration) {
                _matched = true;
                _switchResult = this.toHoistDeclaration((ImportDeclaration)scriptElement);
            }
            if (!_matched) {
                _switchResult = null;
            }
            Iterable ret = _switchResult;
            return ret;
        };
        List allHoisted = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(scriptContent, (Functions.Function1)_function))));
        VariableStatement __VariableStatement = TranspilerBuilderBlocks._VariableStatement((VariableDeclaration[])new VariableDeclaration[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _varDeclsOrBindings = it.getVarDeclsOrBindings();
            Iterables.addAll((Collection)_varDeclsOrBindings, (Iterable)allHoisted);
        };
        VariableStatement varStmtHoistedVariables = (VariableStatement)ObjectExtensions.operator_doubleArrow((Object)__VariableStatement, (Procedures.Procedure1)_function_1);
        int i = scriptContent.size() - 1;
        while (i >= 0) {
            ScriptElement scriptElement2 = scriptContent.get(i);
            if (scriptElement2 instanceof ImportDeclaration) {
                this.remove((EObject)scriptElement2);
            } else if (scriptElement2 instanceof VariableStatement) {
                boolean _not;
                boolean _containsKey = mapVarStatement2replacer.containsKey(scriptElement2);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    this.remove((EObject)scriptElement2);
                }
            }
            --i;
        }
        ArrayList hoistedInitializer = CollectionLiterals.newArrayList();
        Consumer<Map.Entry> _function_2 = it -> {
            this.replace((VariableStatement)it.getKey(), (Statement[])Conversions.unwrapArray(it.getValue(), Statement.class));
            Functions.Function1 _function_3 = it_1 -> this.getState().info.isInitializerOfHoistedVariable(it_1);
            Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)it.getValue()), (Functions.Function1)_function_3);
            Iterables.addAll((Collection)hoistedInitializer, (Iterable)_filter);
        };
        mapVarStatement2replacer.entrySet().forEach(_function_2);
        boolean _isEmpty = varStmtHoistedVariables.getVarDeclsOrBindings().isEmpty();
        if (_isEmpty) {
            return null;
        }
        return Pair.of((Object)varStmtHoistedVariables, (Object)hoistedInitializer);
    }

    private Iterable<Pair<List<VariableDeclaration>, ExpressionStatement>> toHoistDeclarations(List<VariableDeclarationOrBinding> varDeclsOrBindings) {
        Functions.Function1 _function = entry -> {
            Pair<List<VariableDeclaration>, ExpressionStatement> _switchResult = null;
            boolean _matched = false;
            if (entry instanceof VariableDeclaration) {
                _matched = true;
                _switchResult = this.hoistEntry((VariableDeclaration)entry);
            }
            if (!_matched && entry instanceof VariableBinding) {
                _matched = true;
                _switchResult = this.hoistEntry((VariableBinding)entry);
            }
            if (!_matched) {
                String _simpleName = VariableDeclarationOrBinding.class.getSimpleName();
                String _plus = "unknown subclass of " + _simpleName;
                String _plus_1 = String.valueOf(_plus) + ": ";
                String _simpleName_1 = entry.getClass().getSimpleName();
                String _plus_2 = String.valueOf(_plus_1) + _simpleName_1;
                throw new IllegalStateException(_plus_2);
            }
            return _switchResult;
        };
        return ListExtensions.map(varDeclsOrBindings, (Functions.Function1)_function);
    }

    private Pair<List<VariableDeclaration>, ExpressionStatement> hoistEntry(VariableDeclaration vDeclIM) {
        boolean _tripleNotEquals;
        ExpressionStatement _xifexpression = null;
        Expression _expression = vDeclIM.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            ExpressionStatement _xblockexpression = null;
            Expression initExpr = vDeclIM.getExpression();
            vDeclIM.setExpression(null);
            SymbolTableEntry ste = this.findSymbolTableEntryForElement((NamedElement)vDeclIM, true);
            ExpressionStatement stmt = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)ste), (Expression)initExpr));
            boolean _isToHoist = this.getState().info.isToHoist(vDeclIM);
            if (_isToHoist) {
                this.getState().info.markAsInitializerOfHoistedVariable(stmt);
            }
            this.getState().tracer.copyTrace((EObject)vDeclIM, new EObject[]{stmt});
            _xifexpression = _xblockexpression = stmt;
        }
        ExpressionStatement exprStmt = _xifexpression;
        return Pair.of(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new VariableDeclaration[]{vDeclIM})), exprStmt);
    }

    private Pair<List<VariableDeclaration>, ExpressionStatement> hoistEntry(VariableBinding binding) {
        EList _variableDeclarations = binding.getVariableDeclarations();
        ExpressionStatement _convertDestructBindingToDestructAssignment = this.convertDestructBindingToDestructAssignment(binding);
        return Pair.of((Object)_variableDeclarations, (Object)_convertDestructBindingToDestructAssignment);
    }

    private Iterable<VariableDeclaration> toHoistDeclaration(ImportDeclaration importDecl) {
        Functions.Function1 _function = it -> {
            VariableDeclaration _switchResult = null;
            boolean _matched = false;
            if (it instanceof NamespaceImportSpecifier) {
                _matched = true;
                _switchResult = this.namespaceToHoistDeclaration((NamespaceImportSpecifier)it);
            }
            if (!_matched && it instanceof NamedImportSpecifier) {
                _matched = true;
                _switchResult = this.namedImportsToHoistDeclaration((NamedImportSpecifier)it);
            }
            return _switchResult;
        };
        return ListExtensions.map((List)importDecl.getImportSpecifiers(), (Functions.Function1)_function);
    }

    private VariableDeclaration namedImportsToHoistDeclaration(NamedImportSpecifier nis) {
        VariableDeclaration __VariableDeclaration = TranspilerBuilderBlocks._VariableDeclaration((String)this.findSymbolTableEntryForNamedImport(nis).getName());
        Procedures.Procedure1 _function = it -> this.getState().tracer.copyTrace((EObject)nis, new EObject[]{it});
        return (VariableDeclaration)ObjectExtensions.operator_doubleArrow((Object)__VariableDeclaration, (Procedures.Procedure1)_function);
    }

    private VariableDeclaration namespaceToHoistDeclaration(NamespaceImportSpecifier nsImport) {
        VariableDeclaration __VariableDeclaration = TranspilerBuilderBlocks._VariableDeclaration((String)nsImport.getAlias());
        Procedures.Procedure1 _function = it -> this.getState().tracer.copyTrace((EObject)nsImport, new EObject[]{it});
        return (VariableDeclaration)ObjectExtensions.operator_doubleArrow((Object)__VariableDeclaration, (Procedures.Procedure1)_function);
    }

    private void transFormExportExpressions(List<Statement> list) {
        Iterable toProcess = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList()), list);
        Consumer<Statement> _function = it -> {
            Consumer<Expression> _function_1 = it_1 -> this.inferExportCall((Expression)it_1);
            this.collectNodes((EObject)it, Expression.class, true).forEach(_function_1);
        };
        toProcess.forEach(_function);
    }

    private void _inferExportCall(PostfixExpression expr) {
        SymbolTableEntry ste;
        boolean _isExported;
        Expression subExpr = expr.getExpression();
        if (subExpr instanceof IdentifierRef_IM && (_isExported = this.isExported(ste = ((IdentifierRef_IM)subExpr).getRewiredTarget()))) {
            EObject container = expr.eContainer();
            boolean _isAppendableStatement = ModuleWrappingTransformation.isAppendableStatement(container);
            if (_isAppendableStatement) {
                this.insertAfter(container, new EObject[]{TranspilerBuilderBlocks._ExprStmnt((Expression)this.createExportExpression(ste))});
            } else {
                PostfixOperator _op = expr.getOp();
                if (_op != null) {
                    switch (_op) {
                        case INC: {
                            this.postfixReplacement(expr, ste, AdditiveOperator.SUB);
                            break;
                        }
                        case DEC: {
                            this.postfixReplacement(expr, ste, AdditiveOperator.ADD);
                            break;
                        }
                    }
                }
            }
        }
    }

    private final void postfixReplacement(PostfixExpression expr, SymbolTableEntry ste, AdditiveOperator op) {
        Procedures.Procedure1 _function;
        ParenExpression replaceExp = TranspilerBuilderBlocks._Parenthesis((Expression)TranspilerBuilderBlocks._CommaExpression((Expression[])new Expression[]{TranspilerBuilderBlocks._N4ExportExpr((SymbolTableEntry)ste, (Expression)TranspilerBuilderBlocks._Parenthesis((Expression)TranspilerBuilderBlocks._CommaExpression((Expression[])new Expression[]{TranspilerBuilderBlocks._ObjLit(), this.__NSSafe_IdentRef(ste)})), (SymbolTableEntry)this.steFor_$n4Export()), TranspilerBuilderBlocks._AdditiveExpression((Expression)this.__NSSafe_IdentRef(ste), (AdditiveOperator)op, (Expression)TranspilerBuilderBlocks._IntLiteral((int)1))}));
        Procedures.Procedure1 initFunction = _function = pe -> {
            Expression _expression = replaceExp.getExpression();
            Expression _get = (Expression)((CommaExpression)_expression).getExprs().get(0);
            Expression _expression_1 = ((Argument)((ParameterizedCallExpression)_get).getArguments().get(1)).getExpression();
            Expression _expression_2 = ((ParenExpression)_expression_1).getExpression();
            Procedures.Procedure1 _function_1 = it -> it.getExprs().set(0, pe);
            ObjectExtensions.operator_doubleArrow((Object)((CommaExpression)_expression_2), (Procedures.Procedure1)_function_1);
        };
        this.wrapExistingExpression((Expression)expr, (Expression)replaceExp, initFunction);
    }

    private void _inferExportCall(UnaryExpression expr) {
        SymbolTableEntry ste;
        boolean _isExported;
        Expression subExpr = expr.getExpression();
        if (subExpr instanceof IdentifierRef_IM && (_isExported = this.isExported(ste = ((IdentifierRef_IM)subExpr).getRewiredTarget()))) {
            EObject container = expr.eContainer();
            boolean _isAppendableStatement = ModuleWrappingTransformation.isAppendableStatement(container);
            if (_isAppendableStatement) {
                this.insertAfter(container, new EObject[]{TranspilerBuilderBlocks._ExprStmnt((Expression)this.createExportExpression(ste))});
            } else {
                UnaryOperator _op = expr.getOp();
                if (_op != null) {
                    switch (_op) {
                        case INC: {
                            this.exprReplacement((Expression)expr, ste);
                            break;
                        }
                        case DEC: {
                            this.exprReplacement((Expression)expr, ste);
                            break;
                        }
                    }
                }
            }
        }
    }

    private void _inferExportCall(AssignmentExpression expr) {
        Expression lhs = expr.getLhs();
        boolean _matched = false;
        if (lhs instanceof IdentifierRef_IM) {
            _matched = true;
            SymbolTableEntry ste = ((IdentifierRef_IM)lhs).getRewiredTarget();
            boolean _isExported = this.isExported(ste);
            if (_isExported) {
                EObject container = expr.eContainer();
                boolean _isAppendableStatement = ModuleWrappingTransformation.isAppendableStatement(container);
                if (_isAppendableStatement) {
                    this.insertAfter(container, new EObject[]{TranspilerBuilderBlocks._ExprStmnt((Expression)this.createExportExpression(ste))});
                } else {
                    this.exprReplacement((Expression)expr, ste);
                }
            }
        }
    }

    private static boolean isAppendableStatement(EObject container) {
        return container instanceof Statement && !(container instanceof ReturnStatement) && !(container instanceof ThrowStatement);
    }

    private final void exprReplacement(Expression expr, SymbolTableEntry ste) {
        Procedures.Procedure1 _function;
        ParenExpression replaceExp = TranspilerBuilderBlocks._Parenthesis((Expression)TranspilerBuilderBlocks._CommaExpression((Expression[])new Expression[]{TranspilerBuilderBlocks._N4ExportExpr((SymbolTableEntry)ste, (Expression)TranspilerBuilderBlocks._ObjLit(), (SymbolTableEntry)this.steFor_$n4Export()), this.__NSSafe_IdentRef(ste)}));
        Procedures.Procedure1 initFunc = _function = ae -> {
            Expression _expression = replaceExp.getExpression();
            Expression _get = (Expression)((CommaExpression)_expression).getExprs().get(0);
            Procedures.Procedure1 _function_1 = it -> it.getArguments().set(1, (Object)TranspilerBuilderBlocks._Argument((Expression)ae));
            ObjectExtensions.operator_doubleArrow((Object)((ParameterizedCallExpression)_get), (Procedures.Procedure1)_function_1);
        };
        this.wrapExistingExpression(expr, (Expression)replaceExp, initFunc);
    }

    private void _inferExportCall(Expression expression) {
    }

    private boolean isExported(SymbolTableEntry ste) {
        return this.exportedSTEs.contains(ste);
    }

    private ModuleSpecifierAdjustment getModuleSpecifierAdjustment(TModule module) {
        boolean _not;
        URI resourceURI;
        Resource _eResource = null;
        if (module != null) {
            _eResource = module.eResource();
        }
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        if ((resourceURI = _uRI) == null) {
            return null;
        }
        Optional project = this.n4jsCore.findProject(resourceURI);
        boolean _isPresent = project.isPresent();
        boolean bl = _not = !_isPresent;
        if (_not) {
            return null;
        }
        ModuleLoader loader = ((IN4JSProject)project.get()).getModuleLoader();
        if (loader == null) {
            return null;
        }
        ModuleSpecifierAdjustment adjustment = (ModuleSpecifierAdjustment)N4JSLanguageConstants.MODULE_LOADER_PREFIXES.get(loader);
        return adjustment;
    }

    public static CharSequence wrapPlainJSCode(CharSequence cs) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(function(System) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("System.registerDynamic([], true, function(require, exports, module) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append((Object)cs, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("})(typeof module !== 'undefined' && module.exports ? require('n4js-node').System(require, module) : System);");
        _builder.newLine();
        return _builder;
    }

    private Statement doWrapInCJSpatch(ExpressionStatement statement) {
        FormalParameter __Fpar = TranspilerBuilderBlocks._Fpar((String)this.steFor_System().getName());
        ExpressionStatement ret = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._Parenthesis((Expression)TranspilerBuilderBlocks._FunExpr((boolean)false, null, (FormalParameter[])new FormalParameter[]{__Fpar}, (Statement[])new Statement[]{TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._StringLiteral((String)"use strict")), statement})), (Expression[])new Expression[]{TranspilerBuilderBlocks._ConditionalExpr((Expression)TranspilerBuilderBlocks._BinaryLogicalExpr((Expression)TranspilerBuilderBlocks._EqualityExpr((Expression)TranspilerBuilderBlocks._UnaryExpr((UnaryOperator)UnaryOperator.TYPEOF, (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_module())), (EqualityOperator)EqualityOperator.NSAME, (Expression)TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)this.steFor_undefined())), (BinaryLogicalOperator)BinaryLogicalOperator.AND, (Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)this.steFor_module(), (SymbolTableEntry[])new SymbolTableEntry[]{this.steFor_exports()})), (Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_require()), (Expression[])new Expression[]{TranspilerBuilderBlocks._StringLiteral((String)"n4js-node")}), (SymbolTableEntry[])new SymbolTableEntry[]{this.steFor_System()}), (Expression[])new Expression[]{TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_require()), TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_module())}), (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_System()))}));
        return ret;
    }

    private ExpressionStatement convertDestructBindingToDestructAssignment(VariableBinding binding) {
        PrimaryExpression patternConverted = this.destructuringAssistant.convertBindingPatternToArrayOrObjectLiteral(binding.getPattern());
        AssignmentExpression assignmentExpr = TranspilerBuilderBlocks._AssignmentExpr((Expression)patternConverted, (Expression)binding.getExpression());
        Object _xifexpression = null;
        _xifexpression = patternConverted instanceof ObjectLiteral ? TranspilerBuilderBlocks._Parenthesis((Expression)assignmentExpr) : assignmentExpr;
        ExpressionStatement assignmentStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)_xifexpression);
        Functions.Function1 _function = it -> this.getState().info.isToHoist(it);
        boolean _exists = IterableExtensions.exists((Iterable)binding.getVariableDeclarations(), (Functions.Function1)_function);
        if (_exists) {
            Consumer<VariableDeclaration> _function_1 = it -> this.getState().info.markAsToHoist(it);
            binding.getVariableDeclarations().forEach(_function_1);
            this.getState().info.markAsInitializerOfHoistedVariable(assignmentStmnt);
        }
        this.getState().tracer.copyTrace((EObject)binding, new EObject[]{assignmentStmnt});
        return assignmentStmnt;
    }

    protected ParameterizedCallExpression createExportExpression(SymbolTableEntry entry) {
        return TranspilerBuilderBlocks._N4ExportExpr((SymbolTableEntry)entry, (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)entry), (SymbolTableEntry)this.steFor_$n4Export());
    }

    private void inferExportCall(Expression expr) {
        if (expr instanceof AssignmentExpression) {
            this._inferExportCall((AssignmentExpression)expr);
            return;
        }
        if (expr instanceof PostfixExpression) {
            this._inferExportCall((PostfixExpression)expr);
            return;
        }
        if (expr instanceof UnaryExpression) {
            this._inferExportCall((UnaryExpression)expr);
            return;
        }
        if (expr != null) {
            this._inferExportCall(expr);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    private /* synthetic */ void lambda$1(LinkedHashMap linkedHashMap, List list, List list2, ParameterizedCallExpression it) {
        ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr = TranspilerBuilderBlocks._PropertyAccessExpr();
        Procedures.Procedure1 _function_1 = it_1 -> {
            it_1.setTarget((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_System()));
            it_1.setProperty_IM((SymbolTableEntry)this.steFor_register());
        };
        ParameterizedPropertyAccessExpression_IM _doubleArrow = (ParameterizedPropertyAccessExpression_IM)ObjectExtensions.operator_doubleArrow((Object)__PropertyAccessExpr, (Procedures.Procedure1)_function_1);
        it.setTarget((Expression)_doubleArrow);
        EList _arguments = it.getArguments();
        ArrayLiteral __ArrLit = TranspilerBuilderBlocks._ArrLit();
        Procedures.Procedure1 _function_2 = it_1 -> {
            EList _elements = it_1.getElements();
            Functions.Function1 _function_3 = itx -> {
                ArrayElement __ArrayElement = TranspilerBuilderBlocks._ArrayElement((Expression)TranspilerBuilderBlocks._StringLiteral((String)itx.getActualModuleSpecifier()));
                Procedures.Procedure1 _function_4 = it_2 -> this.getState().tracer.copyTrace((EObject)itx.getToBeReplacedImportDeclaration(), new EObject[]{it_2});
                return (ArrayElement)ObjectExtensions.operator_doubleArrow((Object)__ArrayElement, (Procedures.Procedure1)_function_4);
            };
            Iterable _map = IterableExtensions.map(linkedHashMap.values(), (Functions.Function1)_function_3);
            Iterables.addAll((Collection)_elements, (Iterable)_map);
        };
        ArrayLiteral _doubleArrow_1 = (ArrayLiteral)ObjectExtensions.operator_doubleArrow((Object)__ArrLit, (Procedures.Procedure1)_function_2);
        Argument __Argument = TranspilerBuilderBlocks._Argument((Expression)_doubleArrow_1);
        _arguments.add((Object)__Argument);
        EList _arguments_1 = it.getArguments();
        FunctionExpression __FunExpr = TranspilerBuilderBlocks._FunExpr((boolean)false, (Statement[])new Statement[0]);
        Procedures.Procedure1 _function_3 = it_1 -> {
            EList _fpars = it_1.getFpars();
            FormalParameter __Fpar = TranspilerBuilderBlocks._Fpar();
            Procedures.Procedure1 _function_4 = it_2 -> it_2.setName(this.steFor_$n4Export().getName());
            FormalParameter _doubleArrow_2 = (FormalParameter)ObjectExtensions.operator_doubleArrow((Object)__Fpar, (Procedures.Procedure1)_function_4);
            _fpars.add((Object)_doubleArrow_2);
            Block __Block = TranspilerBuilderBlocks._Block((Statement[])new Statement[0]);
            Procedures.Procedure1 _function_5 = it_2 -> {
                Pair<VariableStatement, List<ExpressionStatement>> hoist = this.hoistedVariablesAndInits(list);
                if (hoist != null) {
                    EList _statements = it_2.getStatements();
                    VariableStatement _key = (VariableStatement)hoist.getKey();
                    _statements.add((Object)_key);
                    EList _statements_1 = it_2.getStatements();
                    List _value = (List)hoist.getValue();
                    Iterables.addAll((Collection)_statements_1, (Iterable)_value);
                    List _value_1 = (List)hoist.getValue();
                    Iterables.addAll((Collection)list2, (Iterable)_value_1);
                }
                EList _statements_2 = it_2.getStatements();
                Functions.Function1 _function_6 = it_3 -> this.importFE((ImportEntry)it_3);
                Functions.Function1 _function_7 = it_3 -> TranspilerBuilderBlocks._ArrayElement((Expression)it_3);
                FunctionExpression __FunExpr_1 = TranspilerBuilderBlocks._FunExpr((boolean)false, (Statement[])new Statement[0]);
                Procedures.Procedure1 _function_8 = it_3 -> {
                    List intoExecute = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)list, Statement.class));
                    Iterables.addAll((Collection)list2, (Iterable)intoExecute);
                    EList _statements_3 = it_3.getBody().getStatements();
                    Iterables.addAll((Collection)_statements_3, (Iterable)intoExecute);
                };
                FunctionExpression _doubleArrow_3 = (FunctionExpression)ObjectExtensions.operator_doubleArrow((Object)__FunExpr_1, (Procedures.Procedure1)_function_8);
                ReturnStatement __ReturnStmnt = TranspilerBuilderBlocks._ReturnStmnt((Expression)TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])new PropertyAssignment[]{TranspilerBuilderBlocks._PropertyNameValuePair((String)"setters", (Expression)TranspilerBuilderBlocks._ArrLit((ArrayElement[])((ArrayElement[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.map(linkedHashMap.values(), (Functions.Function1)_function_6), (Functions.Function1)_function_7), ArrayElement.class)))), TranspilerBuilderBlocks._PropertyNameValuePair((String)"execute", (Expression)_doubleArrow_3)}));
                _statements_2.add((Object)__ReturnStmnt);
            };
            Block _doubleArrow_3 = (Block)ObjectExtensions.operator_doubleArrow((Object)__Block, (Procedures.Procedure1)_function_5);
            it_1.setBody(_doubleArrow_3);
        };
        FunctionExpression _doubleArrow_2 = (FunctionExpression)ObjectExtensions.operator_doubleArrow((Object)__FunExpr, (Procedures.Procedure1)_function_3);
        Argument __Argument_1 = TranspilerBuilderBlocks._Argument((Expression)_doubleArrow_2);
        _arguments_1.add((Object)__Argument_1);
    }
}

