/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.generator.IWorkspaceMarkerSupport;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.validation.Issue;

public class ExternalLibraryErrorMarkerManager {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private IWorkspaceMarkerSupport workspaceMarkerSupport;

    public void clearAllMarkers() {
        this.clearMarkers((String)null);
    }

    public void clearMarkers(N4JSExternalProject[] n4ExtPrjs) {
        N4JSExternalProject[] n4JSExternalProjectArray = n4ExtPrjs;
        int n = n4ExtPrjs.length;
        int n2 = 0;
        while (n2 < n) {
            N4JSExternalProject n4ExtPrj = n4JSExternalProjectArray[n2];
            this.clearMarkers(n4ExtPrj.getName());
            ++n2;
        }
    }

    public void clearMarkers(N4JSExternalProject n4ExtPrj) {
        this.clearMarkers(n4ExtPrj.getName());
    }

    public void clearMarkers(N4JSEclipseProject n4EclPrj) {
        this.clearMarkers(n4EclPrj.getProjectName());
    }

    public void clearMarkers(String projectName) {
        Iterable allProjects = this.n4jsCore.findAllProjects();
        for (IN4JSProject prj : allProjects) {
            if (prj.isExternal() || !prj.exists() || !(prj instanceof N4JSEclipseProject)) continue;
            IProject iProject = ((N4JSEclipseProject)prj).getProject();
            this.workspaceMarkerSupport.deleteMarkersWithUriKey((IResource)iProject, projectName, new String[]{"EXTERNAL_LIBRARY_ERRORS", "EXTERNAL_LIBRARY_WARNINGS"});
        }
    }

    public void setIssues(URI uri, Collection<Issue> issues) {
        N4JSEclipseProject oneWorkspaceProject = null;
        for (IN4JSProject prj : this.n4jsCore.findAllProjects()) {
            if (prj.isExternal() || !prj.exists() || !(prj instanceof N4JSEclipseProject)) continue;
            oneWorkspaceProject = (N4JSEclipseProject)prj;
        }
        if (oneWorkspaceProject == null) {
            return;
        }
        IN4JSProject extPrj = (IN4JSProject)this.n4jsCore.findProject(uri).orNull();
        N4JSExternalProject externalProject = this.externalLibraryWorkspace.getProject(extPrj.getLocation());
        if (externalProject == null) {
            return;
        }
        for (Issue issue : issues) {
            String prjFileLocation = extPrj.getLocation().toFileString();
            String resFileLocation = uri.toFileString();
            resFileLocation = resFileLocation.substring(prjFileLocation.length());
            String locationName = "Dependency: " + externalProject.getName();
            locationName = String.valueOf(locationName) + ", File: " + resFileLocation;
            locationName = String.valueOf(locationName) + ", Line: " + issue.getLineNumber();
            String uriKey = externalProject.getName();
            IProject resource = oneWorkspaceProject.getProject();
            String code = this.getCodeKey(issue);
            String msg = this.getMessage(issue);
            switch (issue.getSeverity()) {
                case ERROR: {
                    this.workspaceMarkerSupport.createError((IResource)resource, code, locationName, msg, uriKey, false);
                    break;
                }
                case WARNING: {
                    this.workspaceMarkerSupport.createWarning((IResource)resource, code, locationName, msg, uriKey, false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(issue.getSeverity()));
                }
            }
        }
    }

    private String getCodeKey(Issue issue) {
        switch (issue.getSeverity()) {
            case ERROR: {
                return "EXTERNAL_LIBRARY_ERRORS";
            }
            case WARNING: {
                return "EXTERNAL_LIBRARY_WARNINGS";
            }
        }
        throw new IllegalArgumentException(String.valueOf(issue.getSeverity()));
    }

    private String getMessage(Issue issue) {
        switch (issue.getSeverity()) {
            case ERROR: {
                return IssueCodes.getMessageForEXTERNAL_LIBRARY_ERRORS((Object)issue.getMessage());
            }
            case WARNING: {
                return IssueCodes.getMessageForEXTERNAL_LIBRARY_WARNINGS((Object)issue.getMessage());
            }
        }
        throw new IllegalArgumentException(String.valueOf(issue.getSeverity()));
    }
}

