/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.storage.WorkspaceFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitSubscriberMergeContext;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.synchronize.GitActionContributor;
import org.eclipse.egit.ui.internal.synchronize.GitChangeSetModelProvider;
import org.eclipse.egit.ui.internal.synchronize.GitTreeCompareNavigator;
import org.eclipse.egit.ui.internal.synchronize.SynchronizeFetchJob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.internal.ui.mapping.ResourceDiffCompareInput;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class GitModelSynchronizeParticipant
extends ModelSynchronizeParticipant {
    public static final String SYNCHRONIZATION_DATA = "GIT_SYNCHRONIZE_DATA_SET";
    public static final String ID = "org.eclipse.egit.ui.modelCompareParticipant";
    public static final String VIEWER_ID = "org.eclipse.egit.ui.compareSynchronization";
    private static final String P_NAVIGATOR = "org.eclipse.team.ui.P_NAVIGATOR";
    private static final String WORKSPACE_MODEL_PROVIDER_ID = "org.eclipse.core.resources.modelProvider";
    private static final String DATA_NODE_KEY = "gitSynchronizeData";
    private static final String INCLUDED_PATHS_NODE_KEY = "includedPaths";
    private static final String INCLUDED_PATH_KEY = "path";
    private static final String CONTAINER_PATH_KEY = "container";
    private static final String SRC_REV_KEY = "srcRev";
    private static final String DST_REV_KEY = "dstRev";
    private static final String INCLUDE_LOCAL_KEY = "inludeLocal";
    private static final String FORCE_FETCH_KEY = "forceFetch";
    private GitSynchronizeDataSet gsds;

    public GitModelSynchronizeParticipant() {
    }

    public GitModelSynchronizeParticipant(GitSubscriberMergeContext context) {
        super((SynchronizationContext)context);
        this.gsds = context.getSyncData();
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor(ID));
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
    }

    protected void initializeConfiguration(final ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_VIEWER_ID", (Object)VIEWER_ID);
        String modelProvider = WORKSPACE_MODEL_PROVIDER_ID;
        final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        if (!this.gsds.containsFolderLevelSynchronizationRequest()) {
            if (preferenceStore.getBoolean("sync_view_show_changeset_model")) {
                modelProvider = "org.eclipse.egit.ui.changeSetModel";
            } else {
                String lastSelectedModel = preferenceStore.getString("sync_view_last_selected_model");
                if (!"".equals(lastSelectedModel)) {
                    modelProvider = lastSelectedModel;
                }
            }
        }
        configuration.setProperty("org.eclipse.team.ui.activeModelProvider", (Object)modelProvider);
        configuration.setProperty(SYNCHRONIZATION_DATA, (Object)this.gsds);
        super.initializeConfiguration(configuration);
        configuration.addActionContribution((SynchronizePageActionGroup)new GitActionContributor());
        configuration.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object oldNavigator;
                String property = event.getProperty();
                if (property.equals("org.eclipse.team.ui.activeModelProvider")) {
                    String newValue = (String)event.getNewValue();
                    preferenceStore.setValue("sync_view_last_selected_model", newValue);
                } else if (property.equals(GitModelSynchronizeParticipant.P_NAVIGATOR) && !((oldNavigator = configuration.getProperty(GitModelSynchronizeParticipant.P_NAVIGATOR)) instanceof GitTreeCompareNavigator)) {
                    configuration.setProperty(GitModelSynchronizeParticipant.P_NAVIGATOR, (Object)new GitTreeCompareNavigator((CompareNavigator)oldNavigator));
                }
            }
        });
    }

    public ModelProvider[] getEnabledModelProviders() {
        ModelProvider[] avaliableProviders;
        ModelProvider[] modelProviderArray = avaliableProviders = super.getEnabledModelProviders();
        int n = avaliableProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProvider provider = modelProviderArray[n2];
            if (provider.getId().equals("org.eclipse.egit.ui.changeSetModel")) {
                return avaliableProviders;
            }
            ++n2;
        }
        int capacity = avaliableProviders.length + 1;
        ArrayList<GitChangeSetModelProvider> providers = new ArrayList<GitChangeSetModelProvider>(capacity);
        providers.add(GitChangeSetModelProvider.getProvider());
        return providers.toArray(new ModelProvider[0]);
    }

    public boolean hasCompareInputFor(Object object) {
        if (object instanceof GitModelBlob || object instanceof IFile) {
            return true;
        }
        IResource res = (IResource)AdapterUtils.adapt((Object)object, IResource.class);
        if (res != null && res.getType() == 1) {
            return true;
        }
        return super.hasCompareInputFor(object);
    }

    public ICompareInput asCompareInput(Object object) {
        ICompareInput input = super.asCompareInput(object);
        ISynchronizationContext ctx = this.getContext();
        if (input instanceof ResourceDiffCompareInput && ctx instanceof SubscriberMergeContext) {
            IResource resource = ((ResourceNode)input.getLeft()).getResource();
            Subscriber subscriber = ((SubscriberMergeContext)ctx).getSubscriber();
            if (resource instanceof IFile && subscriber instanceof GitResourceVariantTreeSubscriber) {
                try {
                    IFileRevision revision = ((GitResourceVariantTreeSubscriber)subscriber).getSourceFileRevision((IFile)resource);
                    if (revision == null) {
                        GitCompareFileRevisionEditorInput.EmptyTypedElement newSource = new GitCompareFileRevisionEditorInput.EmptyTypedElement(resource.getName());
                        ((ResourceDiffCompareInput)input).setLeft((ITypedElement)newSource);
                    } else if (!(revision instanceof WorkspaceFileRevision)) {
                        FileRevisionTypedElement newSource = new FileRevisionTypedElement(revision, GitModelSynchronizeParticipant.getLocalEncoding(resource));
                        ((ResourceDiffCompareInput)input).setLeft((ITypedElement)newSource);
                    }
                }
                catch (TeamException e) {
                    String error = NLS.bind((String)UIText.GitModelSynchronizeParticipant_noCachedSourceVariant, (Object)resource.getName());
                    Activator.logError(error, e);
                }
            }
        }
        return input;
    }

    private static String getLocalEncoding(IResource resource) {
        if (resource instanceof IEncodedStorage) {
            IEncodedStorage es = (IEncodedStorage)resource;
            try {
                return es.getCharset();
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        return null;
    }

    public void run(final IWorkbenchPart part) {
        boolean fetchPossible = false;
        for (GitSynchronizeData data : this.gsds) {
            if (data.getDstRemoteName() == null) continue;
            fetchPossible = true;
        }
        boolean launchFetch = Activator.getDefault().getPreferenceStore().getBoolean("sync_view_fetch_before_launch");
        if (fetchPossible && (launchFetch || this.gsds.forceFetch())) {
            SynchronizeFetchJob fetchJob = new SynchronizeFetchJob(this.gsds);
            fetchJob.setUser(true);
            fetchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    GitModelSynchronizeParticipant.super.run(part);
                }
            });
            fetchJob.schedule();
        } else {
            super.run(part);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        for (GitSynchronizeData gsd : this.gsds) {
            Repository repo = gsd.getRepository();
            RepositoryMapping mapping = RepositoryMapping.findRepositoryMapping((Repository)repo);
            if (mapping == null) continue;
            IMemento child = memento.createChild(DATA_NODE_KEY);
            child.putString(CONTAINER_PATH_KEY, this.getPathForResource((IResource)mapping.getContainer()));
            child.putString(SRC_REV_KEY, gsd.getSrcRev());
            child.putString(DST_REV_KEY, gsd.getDstRev());
            child.putBoolean(INCLUDE_LOCAL_KEY, gsd.shouldIncludeLocal());
            Set includedResources = gsd.getIncludedResources();
            if (includedResources == null || includedResources.isEmpty()) continue;
            IMemento paths = child.createChild(INCLUDED_PATHS_NODE_KEY);
            for (IResource resource : includedResources) {
                String path = this.getPathForResource(resource);
                paths.createChild(INCLUDED_PATH_KEY).putString(INCLUDED_PATH_KEY, path);
            }
        }
        memento.putBoolean(FORCE_FETCH_KEY, this.gsds.forceFetch());
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        try {
            boolean forceFetchPref = Activator.getDefault().getPreferenceStore().getBoolean("sync_view_fetch_before_launch");
            boolean forceFetch = this.getBoolean(memento.getBoolean(FORCE_FETCH_KEY), forceFetchPref);
            this.gsds = new GitSynchronizeDataSet(forceFetch);
            IMemento[] children = memento.getChildren(DATA_NODE_KEY);
            if (children != null) {
                this.restoreSynchronizationData(children);
            }
        }
        finally {
            super.init(secondaryId, memento);
        }
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) throws CoreException {
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(this.gsds);
        subscriber.init((IProgressMonitor)new NullProgressMonitor());
        return new GitSubscriberMergeContext(subscriber, manager, this.gsds);
    }

    protected ISynchronizationScopeManager createScopeManager(ResourceMapping[] mappings) {
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(this.gsds);
        subscriber.init((IProgressMonitor)new NullProgressMonitor());
        GitSubscriberResourceMappingContext context = new GitSubscriberResourceMappingContext(subscriber, this.gsds);
        return new SynchronizationScopeManager(UIText.GitModelSynchronizeParticipant_initialScopeName, mappings, (ResourceMappingContext)context, true);
    }

    private void restoreSynchronizationData(IMemento[] children) {
        IMemento[] iMementoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            String containerPath = child.getString(CONTAINER_PATH_KEY);
            Repository repo = this.getRepositoryForPath(containerPath);
            if (repo != null) {
                String srcRev = child.getString(SRC_REV_KEY);
                String dstRev = child.getString(DST_REV_KEY);
                boolean includeLocal = this.getBoolean(child.getBoolean(INCLUDE_LOCAL_KEY), true);
                Set<IResource> includedResources = this.getIncludedResources(child);
                try {
                    GitSynchronizeData data = new GitSynchronizeData(repo, srcRev, dstRev, includeLocal);
                    if (includedResources != null) {
                        data.setIncludedResources(includedResources);
                    }
                    this.gsds.add(data);
                }
                catch (IOException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
            ++n2;
        }
    }

    private Repository getRepositoryForPath(String containerPath) {
        IPath path = Path.fromPortableString((String)containerPath);
        IContainer mappedContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
        if (mappedContainer == null) {
            return null;
        }
        GitProjectData projectData = GitProjectData.get((IProject)mappedContainer.getProject());
        if (projectData == null) {
            return null;
        }
        RepositoryMapping mapping = projectData.getRepositoryMapping((IResource)mappedContainer);
        if (mapping != null) {
            return mapping.getRepository();
        }
        return null;
    }

    private boolean getBoolean(Boolean value, boolean defaultValue) {
        return value != null ? value : defaultValue;
    }

    @Nullable
    private String getPathForResource(IResource resource) {
        return resource.getLocation() != null ? resource.getLocation().toPortableString() : null;
    }

    private Set<IResource> getIncludedResources(IMemento memento) {
        IMemento[] pathNode;
        IMemento child = memento.getChild(INCLUDED_PATHS_NODE_KEY);
        HashSet<IResource> result = new HashSet<IResource>();
        if (child != null && (pathNode = child.getChildren(INCLUDED_PATH_KEY)) != null) {
            IMemento[] iMementoArray = pathNode;
            int n = pathNode.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento path = iMementoArray[n2];
                String includedPath = path.getString(INCLUDED_PATH_KEY);
                IResource resource = ResourceUtil.getResourceForLocation((IPath)new Path(includedPath), (boolean)false);
                if (resource != null) {
                    result.add(resource);
                }
                ++n2;
            }
            return result;
        }
        return null;
    }
}

