/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.internal;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.n4js.tester.domain.TestCase;
import org.eclipse.n4js.tester.domain.TestResult;
import org.eclipse.n4js.tester.domain.TestTree;
import org.eclipse.n4js.tester.fsm.TestFsmRegistry;
import org.eclipse.n4js.tester.internal.InternalTestTreeRegistry;

@Singleton
public class TestTreeRegistryImpl
implements InternalTestTreeRegistry {
    private static final Logger LOGGER = Logger.getLogger(TestTreeRegistryImpl.class);
    private static final boolean debugEnabled = LOGGER.isDebugEnabled();
    private final TestFsmRegistry fsmRegistry;
    private final Map<String, TestTree> cache;
    private final Map<String, Object> mutex;
    private final long timeout;
    private final LoadingCache<String, ExecutorService> executors = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<String, ExecutorService>(){

        public void onRemoval(RemovalNotification<String, ExecutorService> notification) {
            if (!((ExecutorService)notification.getValue()).isShutdown()) {
                ((ExecutorService)notification.getValue()).shutdown();
            }
        }
    }).build((CacheLoader)new CacheLoader<String, ExecutorService>(){

        public ExecutorService load(String sessionId) throws Exception {
            int threads = Runtime.getRuntime().availableProcessors() / 2;
            return Executors.newFixedThreadPool(Ints.max((int[])new int[]{threads, 1}));
        }
    });

    @Inject
    TestTreeRegistryImpl(TestFsmRegistry fsmRegistry, @Named(value="testTreeTimeoutKey") long timeout) {
        this.fsmRegistry = fsmRegistry;
        this.timeout = timeout;
        this.cache = Collections.synchronizedMap(Maps.newHashMap());
        this.mutex = Collections.synchronizedMap(Maps.newHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTestTree(TestTree tree) {
        String sessionId = tree.getSessionId().getValue();
        if (!this.fsmRegistry.isSessionExist(sessionId)) {
            throw new IllegalStateException("Test session does not exist with ID: '" + sessionId + "'.");
        }
        if (!Strings.nullToEmpty((String)sessionId).equals(tree.getSessionId().getValue())) {
            throw new IllegalArgumentException("Session ID mismatch. Session ID was: " + sessionId + " and the session ID of the test tree was: " + tree.getSessionId().getValue());
        }
        TestTreeRegistryImpl testTreeRegistryImpl = this;
        synchronized (testTreeRegistryImpl) {
            this.mutex.put(sessionId, new Object());
            if (this.getTree(sessionId) != null) {
                this.mutex.remove(sessionId);
                throw new IllegalStateException("Test tree already registered for session. Session ID: '" + sessionId + "'.");
            }
            try {
                this.cache.put(sessionId, tree.clone());
                this.executors.get((Object)sessionId);
            }
            catch (CloneNotSupportedException e) {
                this.mutex.remove(sessionId);
                throw new RuntimeException("Cloning the test tree for session failed. Session ID: '" + sessionId + "'.", e);
            }
            catch (ExecutionException e) {
                this.mutex.remove(sessionId);
                throw new RuntimeException("Error while registering executor service for session: '" + sessionId + "'.");
            }
        }
    }

    @Override
    public TestTree getTestTree(String sessionId) {
        TestTree copy = this.getTreeCopy(sessionId);
        if (copy == null) {
            throw new IllegalStateException("Test tree does not exist for session. Session ID: '" + sessionId + "'.");
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateTestTree(String sessionId) {
        TestTree copy = this.getTree(sessionId);
        if (copy == null) {
            throw new IllegalStateException("Test tree does not exist for session. Session ID: '" + sessionId + "'.");
        }
        TestTreeRegistryImpl testTreeRegistryImpl = this;
        synchronized (testTreeRegistryImpl) {
            ExecutorService executorService = this.getExecutorService(sessionId);
            if (debugEnabled) {
                LOGGER.debug((Object)("Validating test tree for session: '" + sessionId + "'."));
            }
            if (!executorService.isShutdown()) {
                if (debugEnabled) {
                    LOGGER.debug((Object)"Test tree is incomplete. Waiting for executors to finish the tree state update...");
                }
                try {
                    executorService.shutdown();
                    executorService.awaitTermination(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (debugEnabled) {
                    LOGGER.debug((Object)"Test tree is in complete state.");
                }
            }
            return this.validate(this.getTree(sessionId));
        }
    }

    @Override
    public void putTestResult(String sessionId, String testId, TestResult result) {
        TestTree t = this.getTree(sessionId);
        if (t == null) {
            throw new IllegalStateException("Test tree does not exist for session. Session ID: '" + sessionId + "'.");
        }
        if (t.getTestCase(testId) == null) {
            throw new IllegalStateException("Test case cannot be found in test tree. Session ID: '" + sessionId + "'. Test ID: " + testId);
        }
        this.getExecutorService(sessionId).submit(() -> {
            Object object = this.mutex.get(sessionId);
            synchronized (object) {
                TestTree tree = this.getTree(sessionId);
                if (tree == null) {
                    throw new IllegalStateException("Test tree does not exist for session. Session ID: '" + sessionId + "'.");
                }
                TestTree updatedTree = this.updateWithResult(tree, testId, result);
                this.cache.put(sessionId, updatedTree);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeTestTree(String sessionId) {
        if (!this.mutex.containsKey(sessionId)) {
            throw new IllegalStateException("Error while purging tree for session: '" + sessionId + "'.");
        }
        Object object = this.mutex.get(sessionId);
        synchronized (object) {
            if (this.getTreeCopy(sessionId) == null) {
                throw new IllegalStateException("Test tree does not exist for session. Session ID: '" + sessionId + "'.");
            }
            this.cache.remove(sessionId);
            this.executors.invalidate((Object)sessionId);
            this.mutex.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Class<TestTreeRegistryImpl> clazz = TestTreeRegistryImpl.class;
        synchronized (TestTreeRegistryImpl.class) {
            this.cache.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ExecutorService getExecutorService(String sessionId) {
        ExecutorService executorService = (ExecutorService)this.executors.getIfPresent((Object)sessionId);
        if (executorService == null) {
            throw new IllegalStateException("Executor service does not exist for test session: '" + sessionId + "'.");
        }
        return executorService;
    }

    private boolean validate(TestTree tree) {
        boolean valid = true;
        Iterator<TestCase> itr = tree.iterator();
        while (itr.hasNext()) {
            valid &= itr.next().getResult() != null;
        }
        return valid;
    }

    private TestTree updateWithResult(TestTree tree, String testId, TestResult result) {
        TestCase testCase = tree.getTestCase(testId);
        if (testCase == null) {
            throw new IllegalStateException("Test case cannot be found in test tree. Test ID: " + testId);
        }
        testCase.setResult(result);
        return tree;
    }

    private TestTree getTree(String sessionId) {
        return this.cache.get(sessionId);
    }

    private TestTree getTreeCopy(String sessionId) {
        if (!this.mutex.containsKey(sessionId)) {
            throw new IllegalStateException("Error while getting tree for session: '" + sessionId + "'.");
        }
        Object object = this.mutex.get(sessionId);
        synchronized (object) {
            TestTree tree = this.cache.get(sessionId);
            try {
                return tree != null ? tree.clone() : null;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Cloning the test tree for session failed. Session ID: '" + sessionId + "'.", e);
            }
        }
    }
}

