/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;

@Singleton
public final class EObjectDescriptionHelper {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public boolean isDescriptionOfModuleWith(IEObjectDescription eoDescription, EObject eObject) {
        IN4JSProject currentProject;
        String eobjectModuleName = ((Script)EcoreUtil2.getContainerOfType((EObject)eObject, Script.class)).getModule().getQualifiedName();
        if (!eobjectModuleName.equals(this.qualifiedNameConverter.toString(eoDescription.getQualifiedName()))) {
            return false;
        }
        if (!this.isMainModule(eoDescription)) {
            return true;
        }
        IN4JSProject targetProject = (IN4JSProject)this.n4jsCore.findProject(eoDescription.getEObjectURI()).orNull();
        return targetProject == (currentProject = (IN4JSProject)this.n4jsCore.findProject(eObject.eResource().getURI()).orNull());
    }

    private boolean isMainModule(IEObjectDescription eoDescription) {
        return this.isMainModuleFromObject(eoDescription) || this.isMainModuleFromUserData(eoDescription);
    }

    private boolean isMainModuleFromObject(IEObjectDescription eoDescription) {
        TModule moduleOrProxy = (TModule)eoDescription.getEObjectOrProxy();
        return !moduleOrProxy.eIsProxy() && moduleOrProxy.isMainModule();
    }

    private boolean isMainModuleFromUserData(IEObjectDescription eoDescription) {
        return N4JSResourceDescriptionStrategy.getMainModule(eoDescription);
    }
}

