/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.containers;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.MultiCleartriggerCache;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.ui.containers.AbstractStorage2UriMapperClient;

@Singleton
public class N4JSProjectsStateHelper
extends AbstractStorage2UriMapperClient {
    private static final Logger LOGGER = Logger.getLogger(N4JSProjectsStateHelper.class);
    private static final String SOURCE_CONTAINER_PREFIX = "n4jssc:";
    private static final String PROJECT_CONTAINER_PREFIX = "n4jsproj:";
    @Inject
    private IN4JSEclipseCore core;
    @Inject
    private N4JSModel model;
    @Inject
    private MultiCleartriggerCache cache;

    public String initHandle(URI uri) {
        String handle = null;
        Optional containerOpt = this.core.findN4JSSourceContainer(uri);
        if (containerOpt.isPresent()) {
            handle = SOURCE_CONTAINER_PREFIX + ((IN4JSSourceContainer)containerOpt.get()).getLocation();
        } else {
            Optional<? extends IN4JSEclipseProject> projectOpt = this.core.findProject(uri);
            if (projectOpt.isPresent()) {
                handle = PROJECT_CONTAINER_PREFIX + ((IN4JSEclipseProject)projectOpt.get()).getLocation();
            }
        }
        return handle;
    }

    public List<String> initVisibleHandles(String handle) {
        if (handle.startsWith(PROJECT_CONTAINER_PREFIX)) {
            URI uri = URI.createURI((String)handle.substring(PROJECT_CONTAINER_PREFIX.length()));
            ArrayList result = Lists.newArrayList();
            Optional<? extends IN4JSEclipseProject> containerProjectOpt = this.core.findProject(uri);
            if (containerProjectOpt.isPresent()) {
                this.fullCollectLocationHandles(result, (IN4JSProject)containerProjectOpt.get());
            }
            return result;
        }
        URI uri = URI.createURI((String)handle.substring(SOURCE_CONTAINER_PREFIX.length()));
        Optional containerOpt = this.core.findN4JSSourceContainer(uri);
        ArrayList result = Lists.newArrayList();
        if (containerOpt.isPresent()) {
            IN4JSSourceContainer container = (IN4JSSourceContainer)containerOpt.get();
            IN4JSProject project = container.getProject();
            this.fullCollectLocationHandles(result, project);
            return result;
        }
        return Collections.emptyList();
    }

    private void fullCollectLocationHandles(List<String> result, IN4JSProject project) {
        this.collectLocationHandles(project, result);
        for (IN4JSProject dependency : this.model.getSortedDependencies(project)) {
            this.collectLocationHandles(dependency, result);
        }
    }

    private void collectLocationHandles(IN4JSProject project, List<String> result) {
        for (IN4JSSourceContainer container : project.getSourceContainers()) {
            result.add(SOURCE_CONTAINER_PREFIX + container.getLocation());
        }
    }

    public Collection<URI> initContainedURIs(String handle) {
        if (handle.startsWith(PROJECT_CONTAINER_PREFIX)) {
            return Collections.emptyList();
        }
        URI uri = URI.createURI((String)handle.substring(SOURCE_CONTAINER_PREFIX.length()));
        Optional containerOpt = this.core.findN4JSSourceContainer(uri);
        ArrayList<URI> uris = new ArrayList<URI>();
        if (containerOpt.isPresent()) {
            Iterator iter = ((IN4JSSourceContainer)containerOpt.get()).iterator();
            while (iter.hasNext()) {
                uris.add((URI)iter.next());
            }
        }
        return uris;
    }

    public void clearProjectCache() {
        LOGGER.info((Object)"Clearing cache.");
        this.cache.clear();
    }

    public void clearProjectCache(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        this.clearProjectCache(project);
    }

    public void clearProjectCache(IProject project) {
        LOGGER.info((Object)("Clearing cache for " + project.getProject().getName() + "."));
        this.cache.clear("PROJECT_DESCRIPTIONS", URIUtils.convert((IResource)project));
        this.cache.clear("SORTED_DEPENDENCIES", URIUtils.convert((IResource)project));
        this.cache.clear("API_IMPL_MAPPING");
    }
}

