/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.methods.contentassist;

import org.eclipse.n4js.xpect.ui.methods.contentassist.CursorMarkerHelper;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.parameter.DerivedRegion;
import org.eclipse.xpect.parameter.IStatementRelatedRegion;
import org.eclipse.xpect.parameter.StringRegion;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;

@XpectImport(value={Provider.class})
public class RegionWithCursor
extends DerivedRegion {
    private final int globalCursorOffset;

    public RegionWithCursor(IStatementRelatedRegion origin, int offset, int lenght, int globalCursorOffset) {
        super(origin, offset, lenght);
        this.globalCursorOffset = globalCursorOffset;
    }

    public RegionWithCursor(IStatementRelatedRegion origin, int globalCursorOffset2) {
        this(origin, globalCursorOffset2, 0, globalCursorOffset2);
    }

    public int getGlobalCursorOffset() {
        return this.globalCursorOffset;
    }

    public boolean hasSelection() {
        return this.getLength() > 0;
    }

    public String toString() {
        return "Region[" + (this.hasSelection() ? this.getOffset() + " + " + this.getLength() : "empty") + "]withCursorAt<" + this.getGlobalCursorOffset() + ">\t" + ";";
    }

    @XpectSetupFactory
    public static class Provider {
        private final StringRegion delegate;

        public Provider(StringRegion delegate) {
            this.delegate = delegate;
        }

        @Creates
        public RegionWithCursor createRegionWithCursor() {
            String val = this.delegate.getRegionText();
            StringBuffer sb = new StringBuffer(val);
            boolean hasCursor = CursorMarkerHelper.exists(val, "<|>");
            boolean hasEndSelection = CursorMarkerHelper.exists(val, "<]>");
            boolean hasStartSelection = CursorMarkerHelper.exists(val, "<[>");
            int cursorOffset = CursorMarkerHelper.deleteMarker(sb, "<|>");
            int selStartOffset = CursorMarkerHelper.deleteMarker(sb, "<[>");
            int selEndOffset = CursorMarkerHelper.deleteMarker(sb, "<]>");
            val = sb.toString();
            if (hasStartSelection && selStartOffset < cursorOffset) {
                cursorOffset -= "<[>".length();
            }
            if (hasEndSelection && selEndOffset < cursorOffset) {
                cursorOffset -= "<]>".length();
            }
            XpectInvocation invocation = this.delegate.getStatement();
            IStatementRelatedRegion extendedRegion = invocation.getExtendedRegion();
            int offset = extendedRegion.getOffset() + extendedRegion.getLength();
            String text = invocation.getFile().getDocument();
            int result = text.indexOf(val, offset);
            if (result < 0) {
                throw new RuntimeException("OFFSET '" + val + "' not found");
            }
            int globalCursorOffset = result + cursorOffset;
            if (hasEndSelection) {
                if (hasStartSelection) {
                    return new RegionWithCursor((IStatementRelatedRegion)this.delegate, result + selStartOffset, selEndOffset - selStartOffset, globalCursorOffset);
                }
                if (selEndOffset < cursorOffset) {
                    throw new RuntimeException("OFFSET '" + this.delegate + " has no selection start(" + "<[>" + ").");
                }
                return new RegionWithCursor((IStatementRelatedRegion)this.delegate, globalCursorOffset, selEndOffset - cursorOffset, globalCursorOffset);
            }
            if (!hasStartSelection) {
                return new RegionWithCursor((IStatementRelatedRegion)this.delegate, globalCursorOffset);
            }
            throw new RuntimeException("OFFSET '" + this.delegate + " has no end selection marker (" + "<]>" + ").");
        }
    }
}

