/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.CMGroupNode;
import org.eclipse.wst.dtd.core.internal.CMNode;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.NamedTopLevelNode;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.w3c.dom.Node;

public class Element
extends NamedTopLevelNode {
    List attListList = new ArrayList();
    List attributes = new ArrayList();
    protected CMNode fContentModel;

    public Element(DTDFile dtdFile, IStructuredDocumentRegion flatNode) {
        super(dtdFile, flatNode, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ELEMENT_TAG");
    }

    public void addAttribute(String name) {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_ELEMENT_ADD_ATTR);
        List attLists = this.getAttributeLists();
        if (attLists.size() == 0) {
            this.getDTDFile().createAttributeList(this, this.getName(), true);
            attLists = this.getAttributeLists();
        }
        if (attLists.size() > 0) {
            AttributeList attList = (AttributeList)((Object)attLists.get(attLists.size() - 1));
            attList.addAttribute(name);
        }
        this.endRecording((Object)this);
    }

    public void addChild() {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_ELEMENT_ADD_CHILD);
        this.addContent((Object)this, " EMPTY");
        this.endRecording((Object)this);
    }

    protected void addContent(Object requestor, String content) {
        ITextRegion whitespace = this.getWhitespaceAfterName();
        int startOffset = 0;
        int length = 0;
        if (whitespace != null) {
            startOffset = this.getStructuredDTDDocumentRegion().getStartOffset(whitespace);
            length = whitespace.getLength() >= 2 ? 1 : 0;
        } else {
            ITextRegion nameRegion = this.getNameRegion();
            if (nameRegion != null) {
                startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(nameRegion);
            } else {
                ITextRegion elementTag = this.getNextRegion(this.iterator(), "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ELEMENT_TAG");
                startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(elementTag);
            }
        }
        this.replaceText(requestor, startOffset, length, content);
    }

    public void addGroup() {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_ELEMENT_ADD_GRP);
        this.addContent((Object)this, " ()");
        this.endRecording((Object)this);
    }

    public Node cloneNode(boolean deep) {
        return new Element(this.dtdFile, this.flatNode);
    }

    public List getAttributeLists() {
        this.attListList.clear();
        String elementName = this.getName();
        Iterator iter = this.dtdFile.getNodes().iterator();
        while (iter.hasNext()) {
            DTDNode node = (DTDNode)((Object)iter.next());
            if (!(node instanceof AttributeList) || !node.getName().equals(elementName)) continue;
            this.attListList.add(node);
        }
        return this.attListList;
    }

    public CMNode getContentModel() {
        return (CMNode)((Object)this.getFirstChild());
    }

    public List getElementAttributes() {
        this.attributes.clear();
        Iterator attLists = this.getAttributeLists().iterator();
        while (attLists.hasNext()) {
            AttributeList attList = (AttributeList)((Object)attLists.next());
            Object[] children = attList.getChildren();
            int i = 0;
            while (i < children.length) {
                this.attributes.add(children[i]);
                ++i;
            }
        }
        return this.attributes;
    }

    public String getImagePath() {
        return "icons/full/obj16/element.gif";
    }

    public short getNodeType() {
        return 1;
    }

    public void replaceContentModel(Object requestor, CMNode node) {
        this.replaceContentModel(requestor, node.getNodeText());
    }

    public void replaceContentModel(Object requestor, String nodeText) {
        int offset = 0;
        int length = 0;
        CMNode contentModel = this.getContentModel();
        if (contentModel != null) {
            offset = contentModel.getStartOffset();
            length = contentModel.getWhitespaceEndOffset() - offset;
            this.replaceText(requestor, offset, length, nodeText);
        } else {
            this.addContent(requestor, nodeText);
        }
    }

    public void resolveRegions() {
        this.fContentModel = null;
        this.removeChildNodes();
        RegionIterator iter = this.iterator();
        if (this.getNameRegion() != null) {
            this.skipPastName(iter);
        }
        while (iter.hasNext()) {
            ITextRegion currentRegion = iter.next();
            if (this.fContentModel == null) {
                if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NAME")) {
                    this.fContentModel = new CMBasicNode(this.getDTDFile(), this.getStructuredDTDDocumentRegion());
                } else if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.CONTENT_PCDATA")) {
                    this.fContentModel = new CMBasicNode(this.getDTDFile(), this.getStructuredDTDDocumentRegion());
                } else if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.LEFT_PAREN")) {
                    this.fContentModel = new CMGroupNode(this.getDTDFile(), this.getStructuredDTDDocumentRegion());
                }
            }
            if (this.fContentModel == null) continue;
            if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.END_TAG")) break;
            this.fContentModel.addRegion(currentRegion);
        }
        if (this.fContentModel != null) {
            this.appendChild((Node)((Object)this.fContentModel));
            this.fContentModel.setRootElementContent(true);
            this.fContentModel.resolveRegions();
        }
    }

    public void setContentModel(CMNode contentModel) {
        this.fContentModel = contentModel;
    }
}

