/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.lib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.expectation.IExpectationRegion;
import org.eclipse.xpect.expectation.IStringDiffExpectation;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringDiffExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.runner.XpectFileRunner;
import org.eclipse.xpect.runner.XpectRunner;
import org.eclipse.xpect.runner.XpectTestRunner;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.StateContainer;
import org.eclipse.xpect.text.IRegion;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

@RunWith(value=XpectRunner.class)
@XpectImport(value={ReflectiveXpectFileRunner.class})
public class XpectTestResultTest {
    protected IRegion getExpectationRegion(XpectTestRunner runner) {
        return runner.getInvocation().getRelatedRegion(IExpectationRegion.class);
    }

    protected Failure run(XpectTestRunner inspected) {
        if (inspected == null) {
            Assert.fail((String)"This test needs to be followed by another XPECT statement.");
        }
        FailureListener failureListener = new FailureListener();
        RunNotifier notifier = new RunNotifier();
        notifier.addListener((RunListener)failureListener);
        inspected.run(notifier);
        Failure failure = failureListener.getFailure();
        if (failure == null) {
            Assert.fail((String)("The test didn't fail: " + inspected.getDescription().getDisplayName()));
        }
        return failure;
    }

    @Xpect
    public void testFailureDiff(@StringDiffExpectation IStringDiffExpectation expectation, XpectTestRunner runner) {
        ReflectiveXpectFileRunner fileRunner = (ReflectiveXpectFileRunner)runner.getFileRunner();
        XpectTestRunner inspected = fileRunner.getReflectiveToInspected().get((Object)runner);
        Failure failure = this.run(inspected);
        Throwable exception = failure.getException();
        if (!(exception instanceof ComparisonFailure)) {
            throw new AssertionError("The exception is not a " + ComparisonFailure.class.getName(), exception);
        }
        IRegion region = this.getExpectationRegion(inspected);
        ComparisonFailure comparisonFailure = (ComparisonFailure)exception;
        String expected = comparisonFailure.getExpected();
        String actual = comparisonFailure.getActual();
        String trimmedExpected = this.trim(expected, expected, region);
        String trimmedActual = this.trim(actual, expected, region);
        expectation.assertDiffEquals(trimmedExpected, trimmedActual);
    }

    @Xpect
    public void testFailureMessage(@StringExpectation IStringExpectation expectation, XpectTestRunner runner) {
        ReflectiveXpectFileRunner fileRunner = (ReflectiveXpectFileRunner)runner.getFileRunner();
        XpectTestRunner inspected = fileRunner.getReflectiveToInspected().get((Object)runner);
        Failure failure = this.run(inspected);
        expectation.assertEquals(failure.getMessage());
    }

    protected String trim(String string, String ref, IRegion region) {
        if (region == null) {
            return string;
        }
        int offsetFromEnd = ref.length() - (region.getOffset() + region.getLength());
        return string.substring(region.getOffset(), string.length() - offsetFromEnd);
    }

    public static class FailureListener
    extends RunListener {
        private Failure failure;

        public Failure getFailure() {
            return this.failure;
        }

        public void testAssumptionFailure(Failure failure) {
            this.failure = failure;
        }

        public void testFailure(Failure failure) throws Exception {
            this.failure = failure;
        }
    }

    @XpectSetupFactory
    public static final class ReflectiveXpectFileRunner
    extends XpectFileRunner {
        private final Map<XpectTestRunner, XpectTestRunner> reflectiveToInspected = Maps.newHashMap();

        public ReflectiveXpectFileRunner(StateContainer state, XpectFile file) {
            super(state, file);
        }

        @Override
        protected List<Runner> createChildren() {
            ArrayList filtered = Lists.newArrayList();
            ArrayList lastReflectives = Lists.newArrayList();
            List<Runner> allChildren = super.createChildren();
            for (Runner runner : allChildren) {
                if (runner instanceof XpectTestRunner) {
                    XpectTestRunner testRunner = (XpectTestRunner)runner;
                    if (this.isReflectiveTest(testRunner.getInvocation())) {
                        lastReflectives.add(testRunner);
                        filtered.add(runner);
                        continue;
                    }
                    if (!lastReflectives.isEmpty()) {
                        for (XpectTestRunner reflective : lastReflectives) {
                            this.reflectiveToInspected.put(reflective, testRunner);
                        }
                        lastReflectives.clear();
                        continue;
                    }
                    filtered.add(runner);
                    continue;
                }
                filtered.add(runner);
            }
            return filtered;
        }

        public Map<XpectTestRunner, XpectTestRunner> getReflectiveToInspected() {
            return this.reflectiveToInspected;
        }

        protected boolean isReflectiveTest(XpectInvocation invocation) {
            return XpectTestResultTest.class.isAssignableFrom(invocation.getMethod().getTest().getJavaClass());
        }
    }
}

