/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.util.LinkUtil;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.util.FontUtils;
import org.eclipse.help.ui.internal.views.AllTopicsPart;
import org.eclipse.help.ui.internal.views.HelpviewProtocol;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.prefs.BackingStoreException;

public class BrowserPart
extends AbstractFormPart
implements IHelpPart {
    private static final String QUERY = "BrowserPartQuery:";
    private static final String HIGHLIGHT_ON = "highlight-on";
    private static final String HELP_VIEW_SCALE = "help_view_scale";
    private static final String EMPTY_PAGE = "<html><head></head><body></body></html>";
    private ReusableHelpPart parent;
    private Browser browser;
    private String id;
    private int lastProgress = -1;
    private static final int SCALE_MAX = 250;
    private static final int SCALE_MIN = 50;
    private static final int SCALE_INCREMENT = 10;
    private int fontScalePercentage = 100;
    private String url;
    private Action showExternalAction;
    private Action syncTocAction;
    private Action highlightAction;
    private Action bookmarkAction;
    private Action printAction;
    private Action magnifyAction;
    private Action reduceAction;
    private String statusURL;
    private String title;

    public BrowserPart(Composite parent, FormToolkit toolkit, IToolBarManager tbm, IMenuManager menuManager) {
        this.browser = new Browser(parent, 0);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                if (BrowserPart.this.redirectLink(event.location)) {
                    event.doit = false;
                }
                if (!event.doit && event.location != null && event.location.startsWith("https://")) {
                    try {
                        BaseHelpSystem.getHelpBrowser((boolean)true).displayURL(event.location);
                    }
                    catch (Exception exception) {}
                }
            }

            public void changed(LocationEvent event) {
                String url = event.location;
                boolean isResult = url.indexOf("resultof") != -1;
                BrowserPart.this.parent.browserChanged(url);
                BrowserPart.this.url = url;
                BrowserPart.this.updateSyncTocAction();
                BrowserPart.this.highlightAction.setEnabled(isResult);
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent e) {
                IProgressMonitor monitor;
                if (e.current == e.total) {
                    return;
                }
                IStatusLineManager slm = BrowserPart.this.parent.getStatusLineManager();
                IProgressMonitor iProgressMonitor = monitor = slm != null ? slm.getProgressMonitor() : null;
                if (BrowserPart.this.lastProgress == -1) {
                    BrowserPart.this.lastProgress = 0;
                    if (monitor != null) {
                        monitor.beginTask("", e.total);
                        slm.setCancelEnabled(true);
                    }
                } else if (monitor != null && monitor.isCanceled()) {
                    BrowserPart.this.browser.stop();
                    return;
                }
                if (monitor != null) {
                    monitor.worked(e.current - BrowserPart.this.lastProgress);
                }
                BrowserPart.this.lastProgress = e.current;
            }

            public void completed(ProgressEvent e) {
                String value;
                IProgressMonitor monitor;
                IStatusLineManager slm = BrowserPart.this.parent.getStatusLineManager();
                IProgressMonitor iProgressMonitor = monitor = slm != null ? slm.getProgressMonitor() : null;
                if (monitor != null) {
                    slm.setCancelEnabled(false);
                    monitor.done();
                }
                BrowserPart.this.lastProgress = -1;
                if (BrowserPart.this.fontScalePercentage != 100) {
                    BrowserPart.this.rescale();
                }
                BrowserPart.this.title = (value = BrowserPart.this.executeQuery("document.title")) != null ? value : "N/A";
            }
        });
        this.browser.addStatusTextListener(event -> {
            if (this.processQuery(event.text)) {
                return;
            }
            IStatusLineManager statusLine = this.parent.getStatusLineManager();
            if (statusLine != null) {
                statusLine.setMessage(event.text);
            }
            if (event.text.indexOf("://") != -1) {
                this.statusURL = event.text;
            }
        });
        this.browser.addOpenWindowListener(event -> {
            if (this.statusURL != null) {
                try {
                    String relativeURL = BaseHelpSystem.unresolve((URL)new URL(this.statusURL));
                    if (this.parent.isHelpResource(relativeURL)) {
                        this.parent.showExternalURL(relativeURL);
                        event.required = true;
                    }
                }
                catch (MalformedURLException e) {
                    HelpUIPlugin.logError("Malformed URL: " + this.statusURL, e);
                }
            }
        });
        this.contributeToToolBar(tbm);
        this.contributeToMenu(menuManager);
    }

    private String executeQuery(String domValue) {
        return (String)this.browser.evaluate("return " + domValue + ';');
    }

    private boolean processQuery(String text) {
        if (text.startsWith(QUERY)) {
            this.browser.setData("query", (Object)text.substring(QUERY.length()));
            return true;
        }
        return false;
    }

    private void contributeToToolBar(IToolBarManager tbm) {
        boolean highlight = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", HIGHLIGHT_ON, true, null);
        this.showExternalAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)BrowserPart.this.browser.getDisplay(), () -> {
                    try {
                        BrowserPart.this.parent.showExternalURL(BaseHelpSystem.unresolve((URL)new URL(BrowserPart.this.url)));
                    }
                    catch (MalformedURLException e) {
                        HelpUIPlugin.logError("Malformed URL: " + BrowserPart.this.statusURL, e);
                    }
                });
            }
        };
        this.showExternalAction.setToolTipText(Messages.BrowserPart_showExternalTooltip);
        this.showExternalAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/openseparate_co.gif"));
        this.syncTocAction = new Action(){

            public void run() {
                BrowserPart.this.doSyncToc();
            }
        };
        this.syncTocAction.setToolTipText(Messages.BrowserPart_syncTocTooltip);
        this.syncTocAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/synch_toc_nav.gif"));
        this.syncTocAction.setEnabled(false);
        this.bookmarkAction = new Action(){

            public void run() {
                String href = LinkUtil.stripParams((String)BaseHelpSystem.unresolve((String)BrowserPart.this.url));
                BaseHelpSystem.getBookmarkManager().addBookmark(href, BrowserPart.this.title);
            }
        };
        this.bookmarkAction.setToolTipText(Messages.BrowserPart_bookmarkTooltip);
        this.bookmarkAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/addbkmrk_co.gif"));
        this.highlightAction = new Action(){

            public void run() {
                IScopeContext instanceScope = InstanceScope.INSTANCE;
                IEclipsePreferences prefs = instanceScope.getNode("org.eclipse.help.base");
                prefs.putBoolean(BrowserPart.HIGHLIGHT_ON, BrowserPart.this.highlightAction.isChecked());
                if (BrowserPart.this.browser.getUrl().indexOf("resultof") != -1) {
                    BrowserPart.this.browser.execute("setHighlight(" + BrowserPart.this.highlightAction.isChecked() + ");");
                }
            }
        };
        this.highlightAction.setChecked(highlight);
        this.highlightAction.setToolTipText(Messages.BrowserPart_highlightTooltip);
        this.highlightAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/highlight.gif"));
        this.printAction = new Action(ActionFactory.PRINT.getId()){

            public void run() {
                BrowserPart.this.doPrint();
            }
        };
        this.printAction.setImageDescriptor(HelpUIResources.getImageDescriptor("etool16/print_topic.gif"));
        this.printAction.setToolTipText(Messages.BrowserPart_printTooltip);
        tbm.insertBefore("back", (IAction)this.showExternalAction);
        tbm.insertBefore("back", (IAction)this.syncTocAction);
        tbm.insertBefore("back", (IAction)this.printAction);
        tbm.insertBefore("back", (IAction)this.bookmarkAction);
        tbm.insertBefore("back", (IAction)this.highlightAction);
        tbm.insertBefore("back", (IContributionItem)new Separator());
        this.enableButtons();
    }

    private void contributeToMenu(IMenuManager menuManager) {
        if (FontUtils.canRescaleHelpView()) {
            this.fontScalePercentage = Platform.getPreferencesService().getInt("org.eclipse.help.base", HELP_VIEW_SCALE, 100, null);
            if (menuManager != null) {
                this.addMenuActions(menuManager);
            }
        }
    }

    private void addMenuActions(IMenuManager menuManager) {
        this.magnifyAction = new Action(){

            public void run() {
                BrowserPart.this.doMagnify(10);
            }
        };
        this.magnifyAction.setToolTipText(Messages.BrowserPart_magnifyTooltip);
        this.magnifyAction.setText(Messages.BrowserPart_magnifyTooltip);
        this.magnifyAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/magnify_font.gif"));
        this.magnifyAction.setDisabledImageDescriptor(HelpUIResources.getImageDescriptor("dlcl16/magnify_font.gif"));
        this.reduceAction = new Action(){

            public void run() {
                BrowserPart.this.doMagnify(-10);
            }
        };
        this.reduceAction.setToolTipText(Messages.BrowserPart_reduceTooltip);
        this.reduceAction.setText(Messages.BrowserPart_reduceTooltip);
        this.reduceAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/reduce_font.gif"));
        this.reduceAction.setDisabledImageDescriptor(HelpUIResources.getImageDescriptor("dlcl16/reduce_font.gif"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.reduceAction);
        menuManager.add((IAction)this.magnifyAction);
    }

    @Override
    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        String href;
        this.parent = parent;
        this.id = id;
        if (memento != null && (href = memento.getString("BrowserPart.url")) != null) {
            this.showURL(BaseHelpSystem.resolve((String)href, (String)"/help/ntopic").toString());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Control getControl() {
        return this.browser;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.browser != null) {
            this.browser.setVisible(visible);
        }
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public void showURL(String url) {
        if (this.browser != null && url != null) {
            this.browser.setUrl(url);
        }
    }

    public void clearBrowser() {
        if (this.browser != null) {
            this.browser.setText(EMPTY_PAGE);
        }
    }

    @Override
    public void stop() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.stop();
        }
    }

    private void doPrint() {
        this.browser.execute("window.print();");
    }

    private void doSyncToc() {
        String href = BaseHelpSystem.unresolve((String)this.url);
        int ix = href.indexOf("?resultof=");
        if (ix >= 0) {
            href = href.substring(0, ix);
        }
        this.parent.showPage("all-topics-page");
        AllTopicsPart part = (AllTopicsPart)this.parent.findPart("topic-tree");
        if (part != null) {
            part.selectReveal(href);
        }
    }

    private void updateSyncTocAction() {
        String href = BaseHelpSystem.unresolve((String)this.url);
        this.syncTocAction.setEnabled(this.parent.isHelpResource(href));
    }

    private boolean redirectLink(String url) {
        if (url.indexOf("/topic/") != -1) {
            if (url.indexOf("noframes") == -1) {
                return true;
            }
        } else {
            if (url.indexOf("livehelp/?pluginID=") > 0) {
                this.processLiveAction(url);
                return true;
            }
            if (url.indexOf("helpview:") == 0) {
                HelpviewProtocol.handleProtocolCall(url, this.parent);
                return true;
            }
        }
        return false;
    }

    private void processLiveAction(String url) {
        if (!Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "activeHelp", false, null)) {
            return;
        }
        String query = null;
        try {
            URL u = new URL(url);
            query = u.getQuery();
        }
        catch (MalformedURLException malformedURLException) {}
        if (query == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(query, "=&");
        if (st.countTokens() < 6) {
            return;
        }
        st.nextToken();
        String pluginId = URLCoder.decode((String)st.nextToken());
        st.nextToken();
        String className = URLCoder.decode((String)st.nextToken());
        st.nextToken();
        String arg = URLCoder.decode((String)st.nextToken());
        if (pluginId == null || className == null || arg == null) {
            return;
        }
        BaseHelpSystem.runLiveHelp((String)pluginId, (String)className, (String)arg);
    }

    @Override
    public boolean fillContextMenu(IMenuManager manager) {
        return false;
    }

    @Override
    public boolean hasFocusControl(Control control) {
        return this.browser.equals(control);
    }

    @Override
    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.PRINT.getId())) {
            return this.printAction;
        }
        return null;
    }

    private void enableButtons() {
        if (this.magnifyAction != null) {
            this.magnifyAction.setEnabled(this.fontScalePercentage < 250);
            this.reduceAction.setEnabled(this.fontScalePercentage > 50);
        }
    }

    private void doMagnify(int percent) {
        this.fontScalePercentage += percent;
        IScopeContext instanceScope = InstanceScope.INSTANCE;
        IEclipsePreferences prefs = instanceScope.getNode("org.eclipse.help.base");
        prefs.putInt(HELP_VIEW_SCALE, this.fontScalePercentage);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        this.rescale();
    }

    public void rescale() {
        this.browser.execute(FontUtils.getRescaleScript(this.fontScalePercentage));
        this.enableButtons();
    }

    @Override
    public void toggleRoleFilter() {
    }

    @Override
    public void refilter() {
        this.showURL(this.url);
    }

    @Override
    public void saveState(IMemento memento) {
        if (this.url != null) {
            String href = BaseHelpSystem.unresolve((String)this.url);
            memento.putString("BrowserPart.url", href);
        }
    }
}

