/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import com.google.common.collect.FluentIterable;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.NpmCLI;
import org.eclipse.n4js.external.ShadowingInfoHelper;
import org.eclipse.n4js.external.TargetPlatformInstallLocationProvider;
import org.eclipse.n4js.external.libraries.ExternalLibrariesActivator;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.VersionComparator;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.Semver.VersionRangeSetRequirement;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.semver.SemverUtils;
import org.eclipse.n4js.ui.external.ExternalLibrariesActionsHelper;
import org.eclipse.n4js.ui.preferences.external.BuiltInLibrariesLabelProvider;
import org.eclipse.n4js.ui.preferences.external.ButtonFactoryUtil;
import org.eclipse.n4js.ui.preferences.external.ExternalLibraryTreeContentProvider;
import org.eclipse.n4js.ui.preferences.external.InstallNpmDependencyButtonListener;
import org.eclipse.n4js.ui.preferences.external.MaintenanceActionsButtonListener;
import org.eclipse.n4js.ui.preferences.external.MaintenanceActionsChoice;
import org.eclipse.n4js.ui.preferences.external.UninstallNpmDependencyButtonListener;
import org.eclipse.n4js.ui.utils.DelegatingSelectionAdapter;
import org.eclipse.n4js.ui.utils.InputComposedValidator;
import org.eclipse.n4js.ui.utils.InputFunctionalValidator;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.viewer.TreeViewerBuilder;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;

public class ExternalLibraryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = ExternalLibraryPreferencePage.class.getName();
    static final Map<java.net.URI, String> BUILT_IN_LIBS = (Map)ExternalLibrariesActivator.EXTERNAL_LIBRARIES_SUPPLIER.get();
    @Inject
    private ExternalLibraryPreferenceStore store;
    @Inject
    private Provider<ExternalLibraryTreeContentProvider> contentProvider;
    @Inject
    private LibraryManager libManager;
    @Inject
    private NpmCLI npmCli;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private TargetPlatformInstallLocationProvider locationProvider;
    @Inject
    private StatusHelper statusHelper;
    @Inject
    private SemverHelper semverHelper;
    @Inject
    private ExternalLibrariesActionsHelper externalLibrariesActionsHelper;
    @Inject
    private ExternalIndexSynchronizer indexSynchronizer;
    @Inject
    private ShadowingInfoHelper shadowingInfoHelper;
    private TreeViewer viewer;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.setSize(new Point(600, 600));
        BuiltInLibrariesLabelProvider labelProvider = new BuiltInLibrariesLabelProvider(this.indexSynchronizer, this.shadowingInfoHelper, this.externalLibraryWorkspace);
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).create());
        control.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).create());
        this.viewer = (TreeViewer)new TreeViewerBuilder(Collections.singletonList(""), (IContentProvider)this.contentProvider.get()).setVirtual(true).setHeaderVisible(false).setUseHashlookup(true).setHasBorder(true).setColumnWeights(Ints.asList((int[])new int[]{1})).setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider)).build(control);
        this.setViewerInput();
        Composite subComposite = new Composite(control, 0);
        subComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        subComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 128).create());
        ButtonFactoryUtil.createEnabledPushButton(subComposite, "Add...", (SelectionListener)DelegatingSelectionAdapter.createSelectionListener(this::handleAddButtonSelectionListener));
        final Button remove = ButtonFactoryUtil.createDisabledPushButton(subComposite, "Remove", (SelectionListener)DelegatingSelectionAdapter.createSelectionListener(this::handleRemoveButtonSelection));
        this.createPlaceHolderLabel(subComposite);
        final Button moveUp = ButtonFactoryUtil.createDisabledPushButton(subComposite, "Up", (SelectionListener)DelegatingSelectionAdapter.createSelectionListener(this::handleMoveUpButtonSelection));
        final Button moveDown = ButtonFactoryUtil.createDisabledPushButton(subComposite, "Down", (SelectionListener)DelegatingSelectionAdapter.createSelectionListener(this::handleMoveDownButtonSelection));
        this.createPlaceHolderLabel(subComposite);
        this.createPlaceHolderLabel(subComposite);
        ButtonFactoryUtil.createEnabledPushButton(subComposite, "Install npm...", (SelectionListener)new InstallNpmDependencyButtonListener(this::installAndUpdate, () -> this.getPackageNameToInstallValidator(), () -> this.getPackageVersionValidator(), this.semverHelper, this.statusHelper));
        ButtonFactoryUtil.createEnabledPushButton(subComposite, "Uninstall npm...", (SelectionListener)new UninstallNpmDependencyButtonListener(this::uninstallAndUpdate, () -> this.getPackageNameToUninstallValidator(), this.statusHelper, this::getSelectedNpm));
        ButtonFactoryUtil.createEnabledPushButton(subComposite, "Run maintenance actions...", (SelectionListener)new MaintenanceActionsButtonListener(this::runMaintananceActions, this.statusHelper));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Tree tree = ExternalLibraryPreferencePage.this.viewer.getTree();
                Object[] selection = tree.getSelection();
                if (!Arrays2.isEmpty((Object[])selection) && 1 == selection.length && selection[0].getData() instanceof java.net.URI) {
                    java.net.URI uri = (java.net.URI)selection[0].getData();
                    if (BUILT_IN_LIBS.containsKey(uri)) {
                        remove.setEnabled(false);
                        moveUp.setEnabled(false);
                        moveDown.setEnabled(false);
                    } else {
                        int selectionIndex = tree.indexOf((TreeItem)selection[0]);
                        int itemCount = tree.getItemCount();
                        remove.setEnabled(true);
                        if (selectionIndex > 0) {
                            moveUp.setEnabled(!BUILT_IN_LIBS.containsKey(tree.getItem(selectionIndex - 1).getData()));
                        } else {
                            moveUp.setEnabled(selectionIndex != 0);
                        }
                        moveDown.setEnabled(selectionIndex != itemCount - 1);
                    }
                } else {
                    remove.setEnabled(false);
                    moveUp.setEnabled(false);
                    moveDown.setEnabled(false);
                }
            }
        });
        control.requestLayout();
        return control;
    }

    public void createControl(Composite parent) {
        this.noDefaultAndApplyButton();
        super.createControl(parent);
    }

    public boolean performCancel() {
        this.store.invalidate();
        return true;
    }

    public boolean performOk() {
        MultiStatus multistatus = this.statusHelper.createMultiStatus("Status of importing target platform.");
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, monitor -> {
                IStatus status = this.store.save(monitor);
                if (!status.isOK()) {
                    this.setMessage(status.getMessage(), 3);
                    multistatus.merge(status);
                } else {
                    ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exc) {
            multistatus.merge(this.statusHelper.createError("Error while building external libraries.", (Throwable)exc));
        }
        if (multistatus.isOK()) {
            return super.performOk();
        }
        return false;
    }

    private void setViewerInput() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            UIUtils.getDisplay().asyncExec(() -> ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations()));
        }
    }

    private Control createPlaceHolderLabel(Composite parent) {
        return new Label(parent, 0);
    }

    private IInputValidator getPackageNameToInstallValidator() {
        return InputComposedValidator.compose(this.getBasicPackageValidator(), InputFunctionalValidator.from(name -> !this.isNpmWithNameInstalled((String)name) ? null : "The npm package '" + name + "' is already available."));
    }

    private IInputValidator getPackageNameToUninstallValidator() {
        return InputComposedValidator.compose(this.getBasicPackageValidator(), InputFunctionalValidator.from(name -> this.isNpmWithNameInstalled((String)name) ? null : "The npm package '" + name + "' is not installed."));
    }

    private IInputValidator getBasicPackageValidator() {
        return InputFunctionalValidator.from(name -> {
            if (this.npmCli.invalidPackageName(name)) {
                return "The npm package name should be specified.";
            }
            int i = 0;
            while (i < name.length()) {
                if (Character.isWhitespace(name.charAt(i))) {
                    return "The npm package name must not contain any whitespaces.";
                }
                if (Character.isUpperCase(name.charAt(i))) {
                    return "The npm package name must not contain any upper case letter.";
                }
                ++i;
            }
            return null;
        });
    }

    private IInputValidator getPackageVersionValidator() {
        return InputFunctionalValidator.from(version -> this.parsingVersionValidator((String)version));
    }

    private String parsingVersionValidator(String data) {
        String result = null;
        IParseResult parseResult = this.semverHelper.getParseResult(data);
        if (parseResult == null) {
            result = "Could not create version from string :" + data + ":\n";
        } else if (parseResult.hasSyntaxErrors()) {
            INode firstErrorNode = (INode)parseResult.getSyntaxErrors().iterator().next();
            result = "Parsing error: " + firstErrorNode.getSyntaxErrorMessage().getMessage();
        }
        return result;
    }

    private boolean isNpmWithNameInstalled(String packageName) {
        File root = new File(this.locationProvider.getNodeModulesURI());
        return FluentIterable.from((Iterable)this.externalLibraryWorkspace.getProjectsIn(root.toURI())).transform(p -> p.getName()).anyMatch(name -> name.equals(packageName));
    }

    private Map<String, NPMVersionRequirement> getInstalledNpms() {
        java.net.URI root = this.locationProvider.getNodeModulesURI();
        Collection projects = this.externalLibraryWorkspace.getProjectsIn(root);
        HashMap<String, NPMVersionRequirement> versionedNpms = new HashMap<String, NPMVersionRequirement>();
        for (N4JSExternalProject prj : projects) {
            URI location = prj.getIProject().getLocation();
            ProjectDescription pd = this.externalLibraryWorkspace.getProjectDescription(location);
            String name = pd.getProjectName();
            VersionNumber version = pd.getProjectVersion();
            VersionRangeSetRequirement vr = SemverUtils.createVersionRangeSet((VersionComparator)VersionComparator.EQUALS, (VersionNumber)version);
            versionedNpms.put(name, (NPMVersionRequirement)vr);
        }
        return versionedNpms;
    }

    private MultiStatus runMaintananceActions(MaintenanceActionsChoice userChoice, IProgressMonitor monitor) {
        MultiStatus multistatus = this.statusHelper.createMultiStatus("Executing maintenance actions.");
        HashMap<String, NPMVersionRequirement> oldPackages = new HashMap<String, NPMVersionRequirement>();
        if (userChoice.decisionReinstall) {
            oldPackages.putAll(this.getInstalledNpms());
        }
        this.maintenanceCleanNpmCache(userChoice, multistatus, monitor);
        this.maintenanceDeleteNpms(userChoice, multistatus);
        this.reinstallNpms(userChoice, multistatus, monitor, oldPackages);
        this.upateState(userChoice, multistatus, monitor);
        return multistatus;
    }

    private void maintenanceCleanNpmCache(MaintenanceActionsChoice userChoice, MultiStatus multistatus, IProgressMonitor monitor) {
        if (userChoice.decisionCleanCache) {
            this.externalLibrariesActionsHelper.maintenanceCleanNpmCache(multistatus, monitor);
        }
    }

    private void upateState(MaintenanceActionsChoice userChoice, MultiStatus multistatus, IProgressMonitor monitor) {
        if (userChoice.decisionReload || userChoice.decisionReinstall || userChoice.decisionPurgeNpm) {
            try {
                this.libManager.registerAllExternalProjects(monitor);
            }
            catch (Exception e) {
                String msg = "Error when reloading external libraries.";
                multistatus.merge(this.statusHelper.createError(msg, (Throwable)e));
            }
            ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
        }
    }

    private void reinstallNpms(MaintenanceActionsChoice userChoice, MultiStatus multistatus, IProgressMonitor monitor, Map<String, NPMVersionRequirement> packageNames) {
        if (userChoice.decisionReinstall) {
            IStatus installStatus;
            IStatus uninstallStatus;
            if (!userChoice.decisionPurgeNpm && !(uninstallStatus = this.uninstallAndUpdate(packageNames.keySet(), monitor)).isOK()) {
                multistatus.merge(uninstallStatus);
            }
            if (!(installStatus = this.installAndUpdate(packageNames, monitor)).isOK()) {
                multistatus.merge(installStatus);
            }
        }
    }

    private void maintenanceDeleteNpms(MaintenanceActionsChoice userChoice, MultiStatus multistatus) {
        if (userChoice.decisionPurgeNpm) {
            this.externalLibrariesActionsHelper.maintenanceDeleteNpms(multistatus);
        }
    }

    private void handleAddButtonSelectionListener(SelectionEvent e) {
        File file;
        String directoryPath = new DirectoryDialog(this.viewer.getControl().getShell(), 4096).open();
        if (directoryPath != null && (file = new File(directoryPath)).isDirectory()) {
            this.store.add(file.toURI());
            ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
        }
    }

    private void handleRemoveButtonSelection(SelectionEvent e) {
        Object element;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof java.net.URI) {
            this.store.remove((java.net.URI)element);
            ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
        }
    }

    private void handleMoveUpButtonSelection(SelectionEvent e) {
        Object element;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof java.net.URI) {
            this.store.moveUp((java.net.URI)element);
            ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
        }
    }

    private void handleMoveDownButtonSelection(SelectionEvent e) {
        Object element;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof java.net.URI) {
            this.store.moveDown((java.net.URI)element);
            ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
        }
    }

    private IStatus installAndUpdate(Map<String, NPMVersionRequirement> versionedPackages, IProgressMonitor monitor) {
        IStatus status = this.libManager.installNPMs(versionedPackages, false, monitor);
        if (status.isOK()) {
            ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
        }
        return status;
    }

    private IStatus uninstallAndUpdate(Collection<String> packageNames, IProgressMonitor monitor) {
        IStatus status = this.libManager.uninstallNPM(packageNames, monitor);
        if (status.isOK()) {
            ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
        }
        return status;
    }

    private String getSelectedNpm() {
        Object element;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IN4JSProject) {
            IN4JSProject project = (IN4JSProject)element;
            return project.getProjectName();
        }
        return null;
    }

    private static void updateInput(TreeViewer viewer, Object input) {
        UIUtils.getDisplay().asyncExec(() -> {
            Object[] expandedElements = viewer.getExpandedElements();
            Object[] expandedTreePaths = viewer.getExpandedTreePaths();
            viewer.setInput(input);
            viewer.getControl().notifyListeners(13, null);
            if (!Arrays2.isEmpty((Object[])expandedElements)) {
                viewer.setExpandedElements(expandedElements);
            }
            if (!Arrays2.isEmpty((Object[])expandedTreePaths)) {
                viewer.setExpandedTreePaths((TreePath[])expandedTreePaths);
            }
        });
    }
}

