/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;

public final class DependencyCycle<T> {
    private static final DependencyCycle<Object> NO_CYCLE = new DependencyCycle<Object>(Collections.emptyList(), null);
    private final Collection<T> nodesWithCycle;
    private final Optional<T> cycleNodeEntryRef;

    DependencyCycle(Collection<T> nodesWithCycle, T cycleNodeEntryRef) {
        Preconditions.checkNotNull(nodesWithCycle, (Object)"nodesWithCycle");
        Preconditions.checkArgument((nodesWithCycle.isEmpty() == (cycleNodeEntryRef == null) ? 1 : 0) != 0, (Object)"Cyclic nodes and entry point mismatch.");
        this.nodesWithCycle = Collections.unmodifiableCollection(nodesWithCycle);
        this.cycleNodeEntryRef = Optional.fromNullable(cycleNodeEntryRef);
    }

    public static <T> DependencyCycle<T> noCycle() {
        return NO_CYCLE;
    }

    public boolean hasCycle() {
        return !this.nodesWithCycle.isEmpty() && this.cycleNodeEntryRef.isPresent();
    }

    public String prettyPrint() {
        return this.prettyPrint(node -> String.valueOf(node));
    }

    public String prettyPrint(Function<? super T, String> toStringFunc) {
        if (!this.hasCycle()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (T node : this.nodesWithCycle) {
            if (sb.length() > 0) {
                sb.append(" -> ");
            }
            sb.append(this.prettyPrintNode(toStringFunc, node));
        }
        sb.append(" -> ");
        sb.append(this.prettyPrintNode(toStringFunc, this.cycleNodeEntryRef.get()));
        return sb.toString();
    }

    private String prettyPrintNode(Function<? super T, String> toStringFunc, T node) {
        StringBuilder sb = new StringBuilder();
        if (node.equals(this.cycleNodeEntryRef.get())) {
            sb.append("[");
        }
        sb.append((String)toStringFunc.apply(node));
        if (node.equals(this.cycleNodeEntryRef.get())) {
            sb.append("]");
        }
        return sb.toString();
    }
}

