/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import com.google.common.base.Joiner;
import java.util.List;
import org.eclipse.n4js.scoping.members.ComposedMemberDescriptionWithError;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class UnionMemberDescriptionWithError
extends ComposedMemberDescriptionWithError {
    public UnionMemberDescriptionWithError(IEObjectDescription delegate, ComposedTypeRef composedTypeRef, IScope[] subScopes, boolean writeAccess) {
        super(delegate, composedTypeRef, subScopes, writeAccess);
    }

    @Override
    protected boolean initMessageAndCode(List<String> missingFrom, ComposedMemberDescriptionWithError.MapOfIndexes<String> indexesPerMemberType, QualifiedName name, boolean readOnlyField, IEObjectDescription[] descriptions, ComposedMemberDescriptionWithError.MapOfIndexes<String> indexesPerCode) {
        return this.initMissingFrom(missingFrom) || this.initDifferentMemberTypes(indexesPerMemberType, name, readOnlyField) || this.initSubMessages(descriptions, indexesPerCode) || this.initDefault();
    }

    private boolean initDifferentMemberTypes(ComposedMemberDescriptionWithError.MapOfIndexes<String> indexesPerMemberType, QualifiedName name, boolean readOnlyField) {
        if (indexesPerMemberType.size() > 1) {
            int numberOfFields = indexesPerMemberType.numberOf("field");
            if (numberOfFields + indexesPerMemberType.numberOf("getter") == this.max) {
                if (this.writeAccess) {
                    this.message = IssueCodes.getMessageForUNI_INVALID_COMBINATION("getters", name, "read-only");
                    this.code = "UNI_INVALID_COMBINATION";
                    return true;
                }
                return false;
            }
            if (numberOfFields + indexesPerMemberType.numberOf("setter") == this.max) {
                if (this.writeAccess) {
                    if (readOnlyField) {
                        this.message = IssueCodes.getMessageForUNI_INVALID_COMBINATION_SETTER_VS_READ_ONLY_FIELD(name);
                        this.code = "UNI_INVALID_COMBINATION_SETTER_VS_READ_ONLY_FIELD";
                    } else {
                        this.message = IssueCodes.getMessageForUNI_INVALID_COMBINATION("setters", name, "write-only");
                        this.code = "UNI_INVALID_COMBINATION";
                    }
                    return true;
                }
                return false;
            }
            StringBuilder strb = new StringBuilder();
            for (String memberTypeName : indexesPerMemberType.keySet()) {
                String foundScopes = indexesPerMemberType.getScopeNamesForKey(memberTypeName);
                if (strb.length() != 0) {
                    strb.append("; ");
                }
                strb.append(String.valueOf(memberTypeName) + " in " + foundScopes);
            }
            this.message = IssueCodes.getMessageForUNI_MULTIPLE_KINDS(name, strb.toString());
            this.code = "UNI_MULTIPLE_KINDS";
            return true;
        }
        return false;
    }

    private boolean initMissingFrom(List<String> missingFrom) {
        if (!missingFrom.isEmpty()) {
            this.message = IssueCodes.getMessageForUNI_MISSING(this.getName().getLastSegment(), Joiner.on((String)", ").join(missingFrom));
            this.code = "UNI_MISSING";
            return true;
        }
        return false;
    }

    private boolean initDefault() {
        String memberName = this.getName().getLastSegment();
        this.message = IssueCodes.getMessageForUNI_UNCOMMON(memberName);
        this.code = "UNI_UNCOMMON";
        return true;
    }
}

