/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.ui;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.n4js.compare.ApiImplMapping;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ChooseImplementationDialog
extends ListDialog {
    protected final ApiImplMapping apiImplMapping;
    protected final List<String> availableImplIds;

    public ChooseImplementationDialog(Shell parent, ApiImplMapping apiImplMapping) {
        super(parent);
        this.apiImplMapping = apiImplMapping;
        this.availableImplIds = apiImplMapping.getAllImplIds();
        this.setTitle("Choose Implementation");
        this.setMessage(this.computeMessage());
        this.setAddCancelButton(true);
        this.setHelpAvailable(false);
        this.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ChooseImplementationDialog.this.availableImplIds.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.setLabelProvider((ILabelProvider)new LabelProvider());
        this.setInput(new Object());
    }

    protected Control createDialogArea(Composite container) {
        Control control = super.createDialogArea(container);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChooseImplementationDialog.this.getOkButton().setEnabled(!ChooseImplementationDialog.this.getTableViewer().getSelection().isEmpty());
            }
        });
        return control;
    }

    protected String computeMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Project dependencies contain the following API projects:\n");
        for (String apiId : this.apiImplMapping.getApiIds()) {
            sb.append("- " + apiId + " (" + this.apiImplMapping.getImplIds(apiId).stream().collect(Collectors.joining(", ")) + ")\n");
        }
        sb.append('\n');
        sb.append("Please choose an implementation below:");
        return sb.toString();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setEnabled(false);
    }
}

